/*
 * Decompiled with CFR 0.152.
 */
package bboss.org.apache.velocity;

import bboss.org.apache.velocity.VelocityContext;
import bboss.org.apache.velocity.context.Context;
import bboss.org.apache.velocity.context.InternalContextAdapterImpl;
import bboss.org.apache.velocity.exception.MethodInvocationException;
import bboss.org.apache.velocity.exception.ParseErrorException;
import bboss.org.apache.velocity.exception.ResourceNotFoundException;
import bboss.org.apache.velocity.exception.TemplateInitException;
import bboss.org.apache.velocity.exception.VelocityException;
import bboss.org.apache.velocity.runtime.directive.Scope;
import bboss.org.apache.velocity.runtime.directive.StopCommand;
import bboss.org.apache.velocity.runtime.parser.ParseException;
import bboss.org.apache.velocity.runtime.parser.node.SimpleNode;
import bboss.org.apache.velocity.runtime.resource.Resource;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;

public class Template
extends Resource
implements Cloneable {
    protected String scopeName = "template";
    protected boolean provideScope = false;
    protected Map<String, Object> macros = new ConcurrentHashMap<String, Object>(17, 0.7f);
    protected VelocityException errorCondition = null;

    public Template() {
        this.setType(1);
    }

    public Map<String, Object> getMacros() {
        return this.macros;
    }

    @Override
    public boolean process() throws ResourceNotFoundException, ParseErrorException {
        this.data = null;
        Reader reader = null;
        this.errorCondition = null;
        try {
            reader = this.resourceLoader.getResourceReader(this.name, this.getEncoding());
        }
        catch (ResourceNotFoundException rnfe) {
            this.errorCondition = rnfe;
            throw rnfe;
        }
        if (reader != null) {
            BufferedReader br = null;
            try {
                br = new BufferedReader(reader);
                this.data = this.rsvc.parse(br, this);
                this.initDocument();
                boolean bl = true;
                return bl;
            }
            catch (ParseException pex) {
                this.errorCondition = new ParseErrorException(pex, this.name);
                throw this.errorCondition;
            }
            catch (TemplateInitException pex) {
                this.errorCondition = new ParseErrorException(pex, this.name);
                throw this.errorCondition;
            }
            catch (RuntimeException e) {
                this.errorCondition = new VelocityException("Exception thrown processing Template " + this.getName(), e, this.rsvc.getLogContext().getStackTrace());
                throw this.errorCondition;
            }
            finally {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
                try {
                    if (br != null) {
                        br.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        this.errorCondition = new ResourceNotFoundException("Unknown resource error for resource " + this.name, null, this.rsvc.getLogContext().getStackTrace());
        throw this.errorCondition;
    }

    public void initDocument() throws TemplateInitException {
        InternalContextAdapterImpl ica = new InternalContextAdapterImpl(new VelocityContext());
        try {
            ica.pushCurrentTemplateName(this.name);
            ica.setCurrentResource(this);
            ((SimpleNode)this.data).init(ica, this.rsvc);
            this.provideScope = this.rsvc.isScopeControlEnabled(this.scopeName);
        }
        finally {
            ica.popCurrentTemplateName();
            ica.setCurrentResource(null);
        }
    }

    @Override
    public void merge(Context context, Writer writer) throws ResourceNotFoundException, ParseErrorException, MethodInvocationException {
        this.merge(context, writer, null);
    }

    public void merge(Context context, Writer writer, List<String> macroLibraries) throws ResourceNotFoundException, ParseErrorException, MethodInvocationException {
        block26: {
            try {
                if (this.errorCondition != null) {
                    throw this.errorCondition;
                }
                if (this.data != null) {
                    InternalContextAdapterImpl ica = new InternalContextAdapterImpl(context);
                    ArrayList<Template> libTemplates = new ArrayList<Template>();
                    ica.setMacroLibraries(libTemplates);
                    if (macroLibraries != null) {
                        for (String macroLibrary : macroLibraries) {
                            try {
                                Template t = this.rsvc.getTemplate(macroLibrary);
                                libTemplates.add(t);
                            }
                            catch (ResourceNotFoundException re) {
                                this.log.error("cannot find template {}", (Object)macroLibrary);
                                throw re;
                            }
                            catch (ParseErrorException pe) {
                                this.rsvc.getLog("parser").error("syntax error in template {}: {}", new Object[]{macroLibrary, pe.getMessage(), pe});
                                throw pe;
                            }
                            catch (Exception e) {
                                throw new RuntimeException("parse failed in template  " + macroLibrary + ".", e);
                            }
                        }
                    }
                    if (this.provideScope) {
                        ica.put(this.scopeName, new Scope(this, ica.get(this.scopeName)));
                    }
                    try {
                        ica.pushCurrentTemplateName(this.name);
                        ica.setCurrentResource(this);
                        ((SimpleNode)this.data).render(ica, writer);
                        break block26;
                    }
                    catch (StopCommand stop) {
                        if (!stop.isFor(this)) {
                            throw stop;
                        }
                        Logger renderingLog = this.rsvc.getLog("rendering");
                        renderingLog.debug(stop.getMessage());
                        break block26;
                    }
                    catch (IOException e) {
                        throw new VelocityException("IO Error rendering template '" + this.name + "'", e, this.rsvc.getLogContext().getStackTrace());
                    }
                    finally {
                        Object obj;
                        ica.popCurrentTemplateName();
                        ica.setCurrentResource(null);
                        if (this.provideScope && (obj = ica.get(this.scopeName)) instanceof Scope) {
                            Scope scope = (Scope)obj;
                            if (scope.getParent() != null) {
                                ica.put(this.scopeName, scope.getParent());
                            } else if (scope.getReplaced() != null) {
                                ica.put(this.scopeName, scope.getReplaced());
                            } else {
                                ica.remove(this.scopeName);
                            }
                        }
                    }
                }
                String msg = "Template merging failed. The document is null, most likely due to a parsing error.";
                throw new RuntimeException(msg);
            }
            catch (VelocityException ve) {
                String[] vtlStacktrace = ve.getVtlStackTrace();
                if (vtlStacktrace != null) {
                    Logger renderingLog = this.rsvc.getLog("rendering");
                    renderingLog.error(ve.getMessage());
                    renderingLog.error("VTL stacktrace:");
                    for (String level : vtlStacktrace) {
                        renderingLog.error(level);
                    }
                }
                throw ve;
            }
        }
    }

    @Override
    protected void deepCloneData() throws CloneNotSupportedException {
        this.setData(((SimpleNode)this.data).clone(this));
    }
}

