/*
 * Decompiled with CFR 0.152.
 */
package bboss.org.apache.velocity.script;

import bboss.org.apache.velocity.Template;
import bboss.org.apache.velocity.VelocityContext;
import bboss.org.apache.velocity.context.Context;
import bboss.org.apache.velocity.exception.ResourceNotFoundException;
import bboss.org.apache.velocity.runtime.RuntimeInstance;
import bboss.org.apache.velocity.runtime.resource.loader.StringResourceLoader;
import bboss.org.apache.velocity.script.VelocityCompiledScript;
import bboss.org.apache.velocity.script.VelocityScriptEngineFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Properties;
import javax.script.AbstractScriptEngine;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptContext;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptException;
import javax.script.SimpleBindings;

public class VelocityScriptEngine
extends AbstractScriptEngine
implements Compilable {
    public static final String VELOCITY_PROPERTIES_KEY = "bboss.org.apache.velocity.script.properties";
    private volatile ScriptEngineFactory factory;
    private volatile RuntimeInstance velocityEngine;

    public VelocityScriptEngine(ScriptEngineFactory factory) {
        this.factory = factory;
    }

    public VelocityScriptEngine() {
        this((ScriptEngineFactory)null);
    }

    protected RuntimeInstance getVelocityEngine() {
        return this.velocityEngine;
    }

    @Override
    public Object eval(String str, ScriptContext ctx) throws ScriptException {
        return this.eval((Reader)new StringReader(str), ctx);
    }

    @Override
    public Object eval(Reader reader, ScriptContext ctx) throws ScriptException {
        this.initVelocityEngine(ctx);
        String fileName = VelocityScriptEngine.getFilename(ctx);
        VelocityContext vctx = VelocityScriptEngine.getVelocityContext(ctx);
        Writer out = ctx.getWriter();
        if (out == null) {
            out = new StringWriter();
            ctx.setWriter(out);
        }
        try {
            this.velocityEngine.evaluate((Context)vctx, out, fileName, reader);
            out.flush();
        }
        catch (Exception exp) {
            throw new ScriptException(exp);
        }
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ScriptEngineFactory getFactory() {
        if (this.factory == null) {
            VelocityScriptEngine velocityScriptEngine = this;
            synchronized (velocityScriptEngine) {
                if (this.factory == null) {
                    this.factory = new VelocityScriptEngineFactory();
                }
            }
        }
        return this.factory;
    }

    @Override
    public Bindings createBindings() {
        return new SimpleBindings();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initVelocityEngine(ScriptContext ctx) {
        if (ctx == null) {
            ctx = this.getContext();
        }
        if (this.velocityEngine == null) {
            VelocityScriptEngine velocityScriptEngine = this;
            synchronized (velocityScriptEngine) {
                if (this.velocityEngine != null) {
                    return;
                }
                Properties props = VelocityScriptEngine.getVelocityProperties(ctx);
                RuntimeInstance tmpEngine = new RuntimeInstance();
                try {
                    if (props != null) {
                        tmpEngine.init(props);
                    } else {
                        tmpEngine.init();
                    }
                }
                catch (RuntimeException rexp) {
                    throw rexp;
                }
                catch (Exception exp) {
                    throw new RuntimeException(exp);
                }
                this.velocityEngine = tmpEngine;
            }
        }
    }

    protected static VelocityContext getVelocityContext(ScriptContext ctx) {
        ctx.setAttribute("context", ctx, 100);
        Bindings globalScope = ctx.getBindings(200);
        Bindings engineScope = ctx.getBindings(100);
        if (globalScope != null) {
            return new VelocityContext(engineScope, new VelocityContext(globalScope));
        }
        return new VelocityContext(engineScope);
    }

    protected static String getFilename(ScriptContext ctx) {
        Object fileName = ctx.getAttribute("javax.script.filename");
        return fileName != null ? fileName.toString() : "<unknown>";
    }

    protected static Properties getVelocityProperties(ScriptContext ctx) {
        try {
            File propsFile;
            Object props = ctx.getAttribute(VELOCITY_PROPERTIES_KEY);
            if (props instanceof Properties) {
                return (Properties)props;
            }
            String propsName = System.getProperty(VELOCITY_PROPERTIES_KEY);
            if (propsName != null && (propsFile = new File(propsName)).exists() && propsFile.canRead()) {
                Properties p = new Properties();
                p.load(new FileInputStream(propsFile));
                return p;
            }
        }
        catch (Exception exp) {
            System.err.println(exp);
        }
        return null;
    }

    @Override
    public CompiledScript compile(String script) throws ScriptException {
        return this.compile(new StringReader(script));
    }

    @Override
    public CompiledScript compile(Reader script) throws ScriptException {
        this.initVelocityEngine(null);
        SingleResourceReader resourceLoader = new SingleResourceReader(script);
        Template template = new Template();
        template.setRuntimeServices(this.velocityEngine);
        template.setResourceLoader(resourceLoader);
        try {
            template.process();
        }
        catch (Exception e) {
            throw new ScriptException(e);
        }
        return new VelocityCompiledScript(this, template);
    }

    protected static class SingleResourceReader
    extends StringResourceLoader {
        private Reader reader;

        public SingleResourceReader(Reader r) {
            this.reader = r;
        }

        @Override
        public Reader getResourceReader(String source, String encoding) throws ResourceNotFoundException {
            return this.reader;
        }
    }
}

