/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.tran.jobflow;

import java.util.Collection;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.TimeoutException;
import org.apache.commons.collections.CollectionUtils;
import org.frameworkset.tran.jobflow.JobFlowCyclicBarrier;
import org.frameworkset.tran.jobflow.JobFlowException;
import org.frameworkset.tran.jobflow.JobFlowNode;
import org.frameworkset.tran.jobflow.JobFlowNodeFunction;
import org.frameworkset.tran.jobflow.JobFlowNodeStatus;
import org.frameworkset.tran.jobflow.NodeTrigger;
import org.frameworkset.tran.jobflow.context.AssertResult;
import org.frameworkset.tran.jobflow.context.DefaultJobFlowNodeExecuteContext;
import org.frameworkset.tran.jobflow.context.JobFlowContext;
import org.frameworkset.tran.jobflow.context.SimpleJobFlowNodeContext;
import org.frameworkset.tran.jobflow.listener.JobFlowNodeListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleJobFlowNode
extends JobFlowNode {
    private static Logger logger = LoggerFactory.getLogger(SimpleJobFlowNode.class);
    private SimpleJobFlowNodeContext simpleJobFlowNodeContext;
    protected boolean autoNodeComplete;
    private JobFlowNodeFunction jobFlowNodeFunction;

    public SimpleJobFlowNode(JobFlowNodeFunction jobFlowNodeFunction, NodeTrigger nodeTrigger) {
        this.jobFlowNodeFunction = jobFlowNodeFunction;
        if (jobFlowNodeFunction == null) {
            throw new JobFlowException("jobFlowNodeFunction is null.");
        }
        jobFlowNodeFunction.init(this);
        this.nodeTrigger = nodeTrigger;
        this.simpleJobFlowNodeContext = new SimpleJobFlowNodeContext(this);
        this.jobFlowNodeContext = this.simpleJobFlowNodeContext;
    }

    public SimpleJobFlowNode(JobFlowNodeFunction jobFlowNodeFunction) {
        this(jobFlowNodeFunction, null);
    }

    public void setAutoNodeComplete(boolean autoNodeComplete) {
        this.autoNodeComplete = autoNodeComplete;
    }

    public boolean isAutoNodeComplete() {
        return this.autoNodeComplete;
    }

    @Override
    public void reset() {
        this.jobFlowNodeFunction.reset();
        super.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean start(JobFlowCyclicBarrier barrier) {
        this.simpleJobFlowNodeContext.updateJobFlowNodeStatus(JobFlowNodeStatus.STARTED);
        this.nodeStart();
        if (barrier != null) {
            try {
                barrier.await();
            }
            catch (InterruptedException interruptedException) {
            }
            catch (BrokenBarrierException brokenBarrierException) {
            }
            catch (TimeoutException timeoutException) {
                // empty catch block
            }
        }
        this.jobFlow.getJobFlowContext().pauseAwait(this);
        JobFlowContext jobFlowContext = this.jobFlow.getJobFlowContext();
        AssertResult assertResult = jobFlowContext.assertStopped();
        if (assertResult.isTrue()) {
            logger.info("AssertStopped: true,ignore execute {}.", (Object)this.getJobFlowNodeInfo());
            return false;
        }
        if (this.assertTrigger()) {
            this.jobFlowNodeExecuteContext = new DefaultJobFlowNodeExecuteContext(this);
            if (CollectionUtils.isNotEmpty((Collection)this.jobFlowNodeListeners)) {
                for (JobFlowNodeListener jobFlowNodeListener : this.jobFlowNodeListeners) {
                    jobFlowNodeListener.beforeExecute(this.jobFlowNodeExecuteContext);
                }
            }
            logger.info("Start {} begin.", (Object)this.getJobFlowNodeInfo());
            JobFlowException throwable = null;
            try {
                this.jobFlowNodeFunction.call(this.jobFlowNodeExecuteContext);
            }
            catch (JobFlowException e) {
                throwable = e;
            }
            catch (Exception e) {
                throwable = new JobFlowException(this.getJobFlowNodeInfo(), e);
            }
            catch (Throwable e) {
                throwable = new JobFlowException(this.getJobFlowNodeInfo(), e);
            }
            finally {
                if (throwable != null || this.autoNodeComplete) {
                    this.nodeComplete(throwable);
                }
            }
            return true;
        }
        this.jobFlowNodeExecuteContext = new DefaultJobFlowNodeExecuteContext(this);
        if (CollectionUtils.isNotEmpty((Collection)this.jobFlowNodeListeners)) {
            for (JobFlowNodeListener jobFlowNodeListener : this.jobFlowNodeListeners) {
                jobFlowNodeListener.beforeExecute(this.jobFlowNodeExecuteContext);
            }
        }
        logger.info("AssertTrigger: false,ignore execute {}.", (Object)this.getJobFlowNodeInfo());
        this.nodeComplete(null, true);
        return false;
    }

    @Override
    protected void release() {
        this.jobFlowNodeFunction.release();
        super.release();
    }

    @Override
    public void stop() {
        if (this.simpleJobFlowNodeContext.assertStoped()) {
            return;
        }
        logger.info("Stop {} begin.", (Object)this.getJobFlowNodeInfo());
        this.simpleJobFlowNodeContext.updateJobFlowNodeStatus(JobFlowNodeStatus.STOPPING);
        this.jobFlowNodeFunction.stop();
        this.simpleJobFlowNodeContext.updateJobFlowNodeStatus(JobFlowNodeStatus.STOPED);
        logger.info("Stop {} complete.", (Object)this.getJobFlowNodeInfo());
        if (CollectionUtils.isNotEmpty((Collection)this.jobFlowNodeListeners)) {
            for (JobFlowNodeListener jobFlowNodeListener : this.jobFlowNodeListeners) {
                jobFlowNodeListener.afterEnd(this);
            }
        }
        if (this.nextJobFlowNode != null) {
            this.nextJobFlowNode.stop();
        }
    }

    @Override
    public void pause() {
        if (this.jobFlowNodeFunction != null) {
            this.jobFlowNodeFunction.pauseSchedule();
            this.simpleJobFlowNodeContext.updateJobFlowNodeStatus(JobFlowNodeStatus.PAUSE);
        }
    }

    @Override
    public void consume() {
        this.simpleJobFlowNodeContext.updateJobFlowNodeStatus(JobFlowNodeStatus.RUNNING);
        if (this.jobFlowNodeFunction != null) {
            this.jobFlowNodeFunction.resumeSchedule();
        }
    }
}

