/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.tran.jobflow.context;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.frameworkset.tran.jobflow.JobFlow;
import org.frameworkset.tran.jobflow.JobFlowException;
import org.frameworkset.tran.jobflow.JobFlowNode;
import org.frameworkset.tran.jobflow.context.AssertResult;
import org.frameworkset.tran.jobflow.context.JobFlowExecuteContext;
import org.frameworkset.tran.jobflow.context.JobFlowNodeExecuteContext;
import org.frameworkset.tran.jobflow.context.StaticContext;

public class DefaultJobFlowNodeExecuteContext
implements JobFlowNodeExecuteContext {
    private Map<String, Object> contextDatas = new LinkedHashMap<String, Object>();
    private JobFlowNode jobFlowNode;
    private JobFlow jobFlow;
    private AtomicBoolean nodeCompleteExecuted = new AtomicBoolean(false);

    public DefaultJobFlowNodeExecuteContext(JobFlowNode jobFlowNode) {
        this.jobFlowNode = jobFlowNode;
        this.jobFlow = jobFlowNode.getJobFlow();
    }

    @Override
    public boolean nodeCompleteUnExecuted() {
        return this.nodeCompleteExecuted.compareAndSet(false, true);
    }

    @Override
    public synchronized Object getContextData(String name) {
        return this.contextDatas.get(name);
    }

    @Override
    public synchronized Object getContextData(String name, Object defaultValue) {
        Object value = this.contextDatas.get(name);
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    @Override
    public Object getJobFlowContextData(String name) {
        return this.getJobFlowExecuteContext().getContextData(name);
    }

    @Override
    public Object getJobFlowContextData(String name, Object defaultValue) {
        return this.getJobFlowExecuteContext().getContextData(name, defaultValue);
    }

    @Override
    public Object getContainerJobFlowNodeContextData(String name) {
        if (this.getContainerJobFlowNodeExecuteContext() != null) {
            return this.getContainerJobFlowNodeExecuteContext().getContextData(name);
        }
        throw new JobFlowException("getContainerJobFlowNodeContextData failed:ContainerJobFlowNodeExecuteContext is null.");
    }

    @Override
    public Object getContainerJobFlowNodeContextData(String name, Object defaultValue) {
        if (this.getContainerJobFlowNodeExecuteContext() != null) {
            return this.getContainerJobFlowNodeExecuteContext().getContextData(name, defaultValue);
        }
        throw new JobFlowException("getContainerJobFlowNodeContextData failed:ContainerJobFlowNodeExecuteContext is null.");
    }

    @Override
    public synchronized void putAll(Map<String, Object> contextDatas) {
        this.contextDatas.putAll(contextDatas);
    }

    @Override
    public synchronized void addContextData(String name, Object data) {
        this.contextDatas.put(name, data);
    }

    @Override
    public void addJobFlowContextData(String name, Object data) {
        this.getJobFlowExecuteContext().addContextData(name, data);
    }

    @Override
    public void addContainerJobFlowNodeContextData(String name, Object data) {
        if (this.getContainerJobFlowNodeExecuteContext() != null) {
            this.getContainerJobFlowNodeExecuteContext().addContainerJobFlowNodeContextData(name, data);
        }
        throw new JobFlowException("addContainerJobFlowNodeContextData failed:ContainerJobFlowNodeExecuteContext is null.");
    }

    @Override
    public synchronized void clear() {
        this.contextDatas.clear();
    }

    @Override
    public JobFlowExecuteContext getJobFlowExecuteContext() {
        return this.jobFlow.getJobFlowExecuteContext();
    }

    @Override
    public JobFlowNodeExecuteContext getContainerJobFlowNodeExecuteContext() {
        return this.jobFlowNode.getContainerJobFlowNodeExecuteContext();
    }

    @Override
    public void pauseAwait() {
        this.jobFlow.getJobFlowContext().pauseAwait(this.jobFlowNode);
    }

    @Override
    public AssertResult assertStopped() {
        return this.jobFlow.getJobFlowContext().assertStopped();
    }

    @Override
    public StaticContext getJobFlowNodeStaticContext() {
        return this.jobFlowNode.getJobFlowNodeContext().copy();
    }

    @Override
    public String getNodeId() {
        return this.jobFlowNode.getNodeId();
    }

    @Override
    public String getNodeName() {
        return this.jobFlowNode.getNodeName();
    }
}

