/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.tran.jobflow.schedule;

import org.frameworkset.tran.jobflow.JobFlow;
import org.frameworkset.tran.jobflow.context.JobFlowExecuteContext;
import org.frameworkset.tran.jobflow.schedule.JobFlowScheduleConfig;
import org.frameworkset.tran.schedule.timer.TimeUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobFlowScheduleTimer
implements Runnable {
    private JobFlowScheduleConfig jobFlowScheduleConfig;
    private JobFlow jobFlow;
    private JobFlowExecuteContext jobFlowExecuteContext;
    private static Logger logger = LoggerFactory.getLogger(JobFlowScheduleTimer.class);
    private Thread thread = null;
    protected volatile boolean running = false;
    private Object runLock = new Object();

    public JobFlowScheduleTimer(JobFlowScheduleConfig jobFlowScheduleConfig, JobFlow jobFlow) {
        this.jobFlowScheduleConfig = jobFlowScheduleConfig;
        this.jobFlow = jobFlow;
        this.jobFlowExecuteContext = jobFlow.getJobFlowExecuteContext();
    }

    public synchronized void start() throws IllegalStateException {
        if (this.running) {
            throw new IllegalStateException("BBossJobScheduleTimer is already running");
        }
        this.running = true;
        logger.info("Start JobFlow BBossJobScheduleTimer,JobFlowScheduleConfig[{}].", (Object)this.jobFlowScheduleConfig.toString());
        this.thread = new Thread((Runnable)this, "BBossJobScheduleTimer-" + this.jobFlow.getJobFlowName());
        this.thread.setDaemon(false);
        this.thread.start();
    }

    public synchronized void stop() throws Exception {
        this.stop(this.jobFlowScheduleConfig.getPeriod());
    }

    public synchronized void stop(long stopInterval) throws Exception {
        if (!this.running) {
            throw new IllegalStateException("Monitor is not running");
        }
        this.running = false;
        try {
            this.thread.interrupt();
            this.thread.join(stopInterval);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Long interval = this.jobFlowScheduleConfig.getPeriod();
        if (interval == null) {
            interval = 100000L;
        }
        JobFlow.delay(this.jobFlow.getJobInfo(), this.jobFlowScheduleConfig);
        while (this.running) {
            Exception exception = null;
            while (true) {
                if (TimeUtil.evalateNeedScan(this.jobFlowScheduleConfig)) {
                    if (this.jobFlow.isSchedulePaused(this.jobFlow.isEnableAutoPauseScheduled())) {
                        if (!logger.isInfoEnabled()) break;
                        logger.info("Ignore  paused schedule job,waiting for next resume schedule sign to continue.");
                        break;
                    }
                    Object object = this.runLock;
                    synchronized (object) {
                        try {
                            this.jobFlow.execute();
                        }
                        catch (Exception e) {
                            exception = e;
                        }
                        break;
                    }
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ignored) {
                    // empty catch block
                    break;
                }
            }
            if (!this.running) {
                logger.warn("running=false and end JobFlowScheduleTimer.");
                break;
            }
            if (exception != null) {
                if (!this.jobFlowScheduleConfig.isContinueOnError()) {
                    logger.warn("Exception occur and continueOnError is false,so end JobFlowScheduleTimer.", exception);
                    break;
                }
                logger.warn("Exception occur and continueOnError is true,so continue JobFlowScheduleTimer.", exception);
            }
            try {
                Thread.sleep(interval);
            }
            catch (InterruptedException interruptedException) {}
        }
    }
}

