/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.tran.schedule.timer;

import com.frameworkset.util.SimpleStringUtil;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.SignStyle;
import java.time.temporal.ChronoField;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.frameworkset.tran.schedule.timer.TimeException;
import org.frameworkset.tran.schedule.timer.TimeRange;
import org.frameworkset.tran.schedule.timer.TimerScheduleConfig;

public class TimeUtil {
    private static DateTimeFormatter dateTimeFormatter;
    private static DateTimeFormatter dateTimeFormatterDefault;
    private static Map<String, DateTimeFormatter> dateTimeFormatterMap;
    private static Object lock;

    public static void main(String[] args) {
        String time = "12:08";
        int[] itime = TimeUtil.parserTime(time);
        System.out.println(itime);
        Date currentTime = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(currentTime);
        int hour = calendar.get(11);
        int min = calendar.get(12);
        System.out.println(itime);
        TimerScheduleConfig timerScheduleConfig = new TimerScheduleConfig();
        timerScheduleConfig.addScanNewFileTimeRange("17:29-18:30");
        boolean result = TimeUtil.evalateNeedScan(timerScheduleConfig);
        System.out.println(result);
        timerScheduleConfig = new TimerScheduleConfig();
        timerScheduleConfig.addScanNewFileTimeRange("18:29-18:30");
        result = TimeUtil.evalateNeedScan(timerScheduleConfig);
        System.out.println(result);
        timerScheduleConfig = new TimerScheduleConfig();
        timerScheduleConfig.addScanNewFileTimeRange("18:29-");
        result = TimeUtil.evalateNeedScan(timerScheduleConfig);
        System.out.println(result);
        timerScheduleConfig = new TimerScheduleConfig();
        timerScheduleConfig.addScanNewFileTimeRange("-18:29");
        result = TimeUtil.evalateNeedScan(timerScheduleConfig);
        System.out.println(result);
        timerScheduleConfig = new TimerScheduleConfig();
        timerScheduleConfig.addSkipScanNewFileTimeRange("-18:29");
        result = TimeUtil.evalateNeedScan(timerScheduleConfig);
        System.out.println(result);
        timerScheduleConfig = new TimerScheduleConfig();
        timerScheduleConfig.addSkipScanNewFileTimeRange("-14:29");
        result = TimeUtil.evalateNeedScan(timerScheduleConfig);
        System.out.println(result);
    }

    public static TimeRange parserTimeRange(String timeRange) {
        TimeRange _timeRange = null;
        if (timeRange != null && !timeRange.equals("")) {
            String[] times = timeRange.split("-");
            _timeRange = new TimeRange();
            if (times.length == 2) {
                if (times[0].equals("")) {
                    _timeRange.setStartTime("00:00");
                } else {
                    _timeRange.setStartTime(times[0]);
                }
                _timeRange.setEndTime(times[1]);
            } else if (timeRange.endsWith("-")) {
                _timeRange.setEndTime("23:59");
                _timeRange.setStartTime(timeRange.substring(0, timeRange.length() - 1));
            } else {
                StringBuilder msg = new StringBuilder();
                msg.append("timeRange:").append(timeRange).append("timeRange\u5fc5\u987b\u662f\u4ee5\u4e0b\u4e09\u79cd\u7c7b\u578b\u683c\u5f0f\r\n").append(" 11:30-12:30  \u6bcf\u5929\u572811:30\u548c12:30\u4e4b\u95f4\u8fd0\u884c\r\n").append(" 11:30-    \u6bcf\u592911:30\u5f00\u59cb\u6267\u884c,\u523023:59\u7ed3\u675f\r\n").append(" -12:30    \u6bcf\u5929\u4ece00:00\u5f00\u59cb\u523012:30\r\n");
                throw new IllegalArgumentException(msg.toString());
            }
            _timeRange.parser();
        }
        return _timeRange;
    }

    public static int[] parserTime(String time) {
        if (time != null && !time.equals("")) {
            int[] itime = new int[2];
            String[] starts = time.split(":");
            if (starts.length == 1) {
                itime[0] = Integer.parseInt(starts[0]);
                itime[1] = 0;
            } else {
                itime[0] = Integer.parseInt(starts[0]);
                itime[1] = Integer.parseInt(starts[1]);
            }
            return itime;
        }
        return null;
    }

    private static boolean inTimeRange(TimeRange timeRange, int hour, int min) {
        boolean result = false;
        if (hour == timeRange.getStartHour() && hour == timeRange.getEndHour()) {
            if (min >= timeRange.getStartMin() && min <= timeRange.getEndMin()) {
                result = true;
            }
        } else if (hour >= timeRange.getStartHour() && hour < timeRange.getEndHour()) {
            result = true;
        } else if (hour == timeRange.getEndHour() && min <= timeRange.getEndMin()) {
            result = true;
        }
        return result;
    }

    public static boolean evalateNeedScan(TimerScheduleConfig timerScheduleConfig) {
        if (timerScheduleConfig == null) {
            return true;
        }
        Date currentTime = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(currentTime);
        int hour = calendar.get(11);
        int min = calendar.get(12);
        List<TimeRange> includeTimeRanges = timerScheduleConfig.getScanNewFileTimeRanges();
        List<TimeRange> skipTimeRanges = timerScheduleConfig.getSkipScanNewFileTimeRanges();
        boolean result = false;
        if (includeTimeRanges != null && includeTimeRanges.size() > 0) {
            for (TimeRange timeRange : includeTimeRanges) {
                if (!TimeUtil.inTimeRange(timeRange, hour, min)) continue;
                result = true;
                break;
            }
        } else if (skipTimeRanges != null && skipTimeRanges.size() > 0) {
            result = true;
            for (TimeRange timeRange : skipTimeRanges) {
                if (!TimeUtil.inTimeRange(timeRange, hour, min)) continue;
                result = false;
                break;
            }
        } else {
            result = true;
        }
        return result;
    }

    public static Date convertLocalDatetime(LocalDateTime localDateTime) {
        if (null == localDateTime) {
            return null;
        }
        ZoneId zoneId = ZoneId.systemDefault();
        ZonedDateTime zonedDateTime = localDateTime.atZone(zoneId);
        Instant instant = zonedDateTime.toInstant();
        Date date = Date.from(instant);
        return date;
    }

    public static LocalDateTime localDateTime(String localDateTime) {
        DateTimeFormatter dateTimeFormatter = TimeUtil.getDateTimeFormatter();
        LocalDateTime date = LocalDateTime.parse(localDateTime, dateTimeFormatter);
        return date;
    }

    public static LocalDateTime date2LocalDateTime(Date date) {
        Instant instant = date.toInstant();
        ZoneId zoneId = ZoneId.systemDefault();
        LocalDateTime localDateTime = instant.atZone(zoneId).toLocalDateTime();
        return localDateTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DateTimeFormatter getDateTimeFormatter() {
        if (dateTimeFormatter != null) {
            return dateTimeFormatter;
        }
        Object object = lock;
        synchronized (object) {
            DateTimeFormatter dateTimeFormatter_;
            if (dateTimeFormatter != null) {
                return dateTimeFormatter;
            }
            DateTimeFormatter ISO_LOCAL_DATE = new DateTimeFormatterBuilder().appendValue(ChronoField.YEAR, 4, 10, SignStyle.EXCEEDS_PAD).optionalStart().appendLiteral('/').optionalEnd().optionalStart().appendLiteral('-').optionalEnd().optionalStart().appendValue(ChronoField.MONTH_OF_YEAR, 2).optionalStart().appendLiteral('/').optionalEnd().optionalStart().appendLiteral('-').optionalEnd().optionalStart().appendValue(ChronoField.DAY_OF_MONTH, 2).toFormatter();
            DateTimeFormatter ISO_LOCAL_TIME = new DateTimeFormatterBuilder().appendValue(ChronoField.HOUR_OF_DAY, 2).optionalStart().appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 2).optionalStart().appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2).optionalStart().appendFraction(ChronoField.NANO_OF_SECOND, 0, 9, true).optionalStart().appendZoneId().toFormatter();
            dateTimeFormatter = dateTimeFormatter_ = new DateTimeFormatterBuilder().append(ISO_LOCAL_DATE).optionalStart().appendLiteral(' ').optionalEnd().optionalStart().appendLiteral('T').optionalEnd().optionalStart().appendOptional(ISO_LOCAL_TIME).optionalEnd().parseDefaulting(ChronoField.HOUR_OF_DAY, 0L).parseDefaulting(ChronoField.MINUTE_OF_HOUR, 0L).parseDefaulting(ChronoField.SECOND_OF_MINUTE, 0L).toFormatter(Locale.SIMPLIFIED_CHINESE);
            return dateTimeFormatter;
        }
    }

    public static String changeLocalDateTime2String(LocalDateTime localDateTime) {
        return localDateTime.format(dateTimeFormatterDefault);
    }

    public static String changeLocalDate2String(LocalDate localDateTime) {
        return localDateTime.format(dateTimeFormatterDefault);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DateTimeFormatter getDateTimeFormatter(String dateFormat) {
        DateTimeFormatter dateTimeFormatter = dateTimeFormatterMap.get(dateFormat);
        if (dateTimeFormatter != null) {
            return dateTimeFormatter;
        }
        Map<String, DateTimeFormatter> map = dateTimeFormatterMap;
        synchronized (map) {
            dateTimeFormatter = dateTimeFormatterMap.get(dateFormat);
            if (dateTimeFormatter != null) {
                return dateTimeFormatter;
            }
            dateTimeFormatter = DateTimeFormatter.ofPattern(dateFormat);
            dateTimeFormatterMap.put(dateFormat, dateTimeFormatter);
            return dateTimeFormatter;
        }
    }

    public static String changeLocalDateTime2String(LocalDateTime localDateTime, String dateFormat) {
        if (SimpleStringUtil.isNotEmpty((String)dateFormat)) {
            return localDateTime.format(TimeUtil.getDateTimeFormatter(dateFormat));
        }
        return localDateTime.format(dateTimeFormatterDefault);
    }

    public static Date convertLocalDate(LocalDate localDate) {
        if (null == localDate) {
            return null;
        }
        ZonedDateTime zonedDateTime = localDate.atStartOfDay(ZoneId.systemDefault());
        return Date.from(zonedDateTime.toInstant());
    }

    public static Object convertLocalDate(Object localDate) {
        return localDate;
    }

    public static Object convertLocalDate2Date(Object localDate) {
        if (null == localDate) {
            return null;
        }
        if (localDate instanceof LocalDateTime) {
            return TimeUtil.convertLocalDatetime((LocalDateTime)localDate);
        }
        if (localDate instanceof LocalDate) {
            return TimeUtil.convertLocalDate((LocalDate)localDate);
        }
        return localDate;
    }

    public static Date parserDate(String pattern, String date) throws TimeException {
        SimpleDateFormat dateFormat = new SimpleDateFormat(pattern);
        try {
            return dateFormat.parse(date);
        }
        catch (ParseException e) {
            throw new TimeException("ParserDate(pattern=" + pattern + ",date=" + date + ") failed:", e);
        }
    }

    static {
        dateTimeFormatterDefault = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSSSSSSS'Z'");
        dateTimeFormatterMap = new ConcurrentHashMap<String, DateTimeFormatter>();
        lock = new Object();
    }
}

