/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.tran.metrics.job;

import java.util.concurrent.Future;
import org.frameworkset.tran.metrics.job.KeyMetricsContainer;
import org.frameworkset.tran.metrics.job.KeyMetricsPersistent;
import org.frameworkset.tran.metrics.job.MetricsLogAPI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseKeyMetrics {
    private static Logger logger = LoggerFactory.getLogger(BaseKeyMetrics.class);
    protected KeyMetricsPersistent metricsPersistent;
    protected MetricsLogAPI metricsLogAPI;
    protected int segmentBoundSize = 100000;
    protected KeyMetricsContainer keyMetricsContainerS0;
    protected KeyMetricsContainer keyMetricsContainerS1;

    public void setMetricsPersistent(KeyMetricsPersistent metricsPersistent) {
        this.metricsPersistent = metricsPersistent;
    }

    public void setMetricsLogAPI(MetricsLogAPI metricsLogAPI) {
        this.metricsLogAPI = metricsLogAPI;
    }

    public MetricsLogAPI getMetricsLogAPI() {
        return this.metricsLogAPI;
    }

    public int getSegmentBoundSize() {
        return this.segmentBoundSize;
    }

    public void setSegmentBoundSize(int segmentBoundSize) {
        this.segmentBoundSize = segmentBoundSize;
    }

    protected KeyMetricsContainer buildKeyMetricsContainer() {
        KeyMetricsContainer keyMetricsContainer = new KeyMetricsContainer();
        keyMetricsContainer.setSegmentBoundSize(this.segmentBoundSize);
        return keyMetricsContainer;
    }

    public void init() {
        this.keyMetricsContainerS0 = this.buildKeyMetricsContainer();
        this.keyMetricsContainerS1 = this.buildKeyMetricsContainer();
        this.initMetrics();
    }

    protected abstract void initMetrics();

    protected Future persistent(KeyMetricsContainer keyMetricsContainer) {
        return this.metricsPersistent.persistent(keyMetricsContainer.getKeyMetric().values());
    }
}

