/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.tran.metrics.job;

import org.frameworkset.tran.metrics.job.MetricsConfig;
import org.frameworkset.tran.metrics.job.TimeKeyMetrics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeMetricsScanTask
extends Thread {
    private static Logger logger = LoggerFactory.getLogger(TimeMetricsScanTask.class);
    private MetricsConfig metricsConfig;
    private TimeKeyMetrics metrics;
    private boolean stoped;
    private boolean started;
    private Object stopScanLock = new Object();

    public TimeMetricsScanTask(String tname) {
        super(tname);
    }

    @Override
    public void start() {
        super.start();
        this.started = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopScan() {
        if (!this.started || this.stoped) {
            return;
        }
        Object object = this.stopScanLock;
        synchronized (object) {
            if (this.stoped) {
                return;
            }
            this.stoped = true;
        }
        this.interrupt();
        try {
            this.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public void run() {
        while (!this.stoped) {
            try {
                TimeMetricsScanTask.sleep(this.metricsConfig.getScanInterval());
            }
            catch (InterruptedException e) {
                break;
            }
            if (this.stoped) break;
            this.metrics.scanPersistentMetrics();
        }
    }

    public void setMetricsConfig(MetricsConfig metricsConfig) {
        this.metricsConfig = metricsConfig;
    }

    public void setMetrics(TimeKeyMetrics metrics) {
        this.metrics = metrics;
    }
}

