/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.nosql.hbase;

import java.io.IOException;
import java.util.concurrent.ExecutorService;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.frameworkset.nosql.hbase.HbaseSystemException;
import org.frameworkset.nosql.hbase.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionFactoryBean {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Connection connection;

    public ConnectionFactoryBean(Configuration configuration) {
        Objects.requireNonNull(configuration, " must not be null");
        try {
            this.connection = ConnectionFactory.createConnection((Configuration)configuration);
        }
        catch (IOException e) {
            throw new HbaseSystemException(e);
        }
    }

    public ConnectionFactoryBean(Configuration configuration, ExecutorService executorService) {
        Objects.requireNonNull(configuration, "configuration must not be null");
        Objects.requireNonNull(executorService, "executorService must not be null");
        try {
            this.connection = ConnectionFactory.createConnection((Configuration)configuration, (ExecutorService)executorService);
        }
        catch (IOException e) {
            throw new HbaseSystemException(e);
        }
    }

    public Connection getConnection() throws Exception {
        return this.connection;
    }

    public void destroy() throws Exception {
        this.logger.info("Hbase Connection destroy()");
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (IOException e) {
                this.logger.warn("Hbase Connection.close() error: " + e.getMessage(), (Throwable)e);
            }
        }
    }
}

