/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.nosql.hbase;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.client.Connection;
import org.frameworkset.nosql.hbase.DisabledHBaseAsyncOperation;
import org.frameworkset.nosql.hbase.HBaseAsyncOperation;
import org.frameworkset.nosql.hbase.HBaseAsyncTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HBaseAsyncOperationFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(HBaseAsyncOperationFactory.class);
    public static final String ENABLE_ASYNC_METHOD = "hbase.client.async.enable";
    public static final boolean DEFAULT_ENABLE_ASYNC_METHOD = false;
    public static final String ASYNC_IN_QUEUE_SIZE = "hbase.client.async.in.queuesize";
    public static final int DEFAULT_ASYNC_IN_QUEUE_SIZE = 10000;
    public static final String ASYNC_PERIODIC_FLUSH_TIME = "hbase.tablemultiplexer.flush.period.ms";
    public static final int DEFAULT_ASYNC_PERIODIC_FLUSH_TIME = 100;
    public static final String ASYNC_MAX_RETRIES_IN_QUEUE = "hbase.client.max.retries.in.queue";
    public static final int DEFAULT_ASYNC_RETRY_COUNT = 10000;

    public static HBaseAsyncOperation create(Configuration configuration) throws IOException {
        boolean enableAsyncMethod = configuration.getBoolean(ENABLE_ASYNC_METHOD, false);
        if (!enableAsyncMethod) {
            return DisabledHBaseAsyncOperation.INSTANCE;
        }
        int queueSize = configuration.getInt(ASYNC_IN_QUEUE_SIZE, 10000);
        if (configuration.get(ASYNC_PERIODIC_FLUSH_TIME, null) == null) {
            configuration.setInt(ASYNC_PERIODIC_FLUSH_TIME, 100);
        }
        if (configuration.get(ASYNC_MAX_RETRIES_IN_QUEUE, null) == null) {
            configuration.setInt(ASYNC_MAX_RETRIES_IN_QUEUE, 10000);
        }
        return new HBaseAsyncTemplate(configuration, queueSize);
    }

    public static HBaseAsyncOperation create(Connection connection, Configuration configuration) throws IOException {
        boolean enableAsyncMethod = configuration.getBoolean(ENABLE_ASYNC_METHOD, false);
        if (!enableAsyncMethod) {
            return DisabledHBaseAsyncOperation.INSTANCE;
        }
        int queueSize = configuration.getInt(ASYNC_IN_QUEUE_SIZE, 10000);
        if (configuration.get(ASYNC_PERIODIC_FLUSH_TIME, null) == null) {
            configuration.setInt(ASYNC_PERIODIC_FLUSH_TIME, 100);
        }
        if (configuration.get(ASYNC_MAX_RETRIES_IN_QUEUE, null) == null) {
            configuration.setInt(ASYNC_MAX_RETRIES_IN_QUEUE, 10000);
        }
        return new HBaseAsyncTemplate(connection, configuration, queueSize);
    }
}

