/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.nosql.hbase;

import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.ShutdownHookManagerProxy;
import org.frameworkset.nosql.hbase.ConnectionFactoryBean;
import org.frameworkset.nosql.hbase.HBaseAsyncOperation;
import org.frameworkset.nosql.hbase.HBaseAsyncOperationFactory;
import org.frameworkset.nosql.hbase.HbaseConfigurationFactoryBean;
import org.frameworkset.nosql.hbase.HbaseTableFactory;
import org.frameworkset.nosql.hbase.HbaseTemplate2;
import org.frameworkset.nosql.hbase.TableFactory;
import org.frameworkset.nosql.hbase.metrics.CollectorMetric;
import org.frameworkset.spi.BaseApplicationContext;
import org.frameworkset.tran.hbase.HBaseTranException;
import org.frameworkset.util.concurrent.ThreadPoolFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HBaseHelper {
    private static Logger logger = LoggerFactory.getLogger(HBaseHelper.class);
    private static ConnectionFactoryBean connectionFactoryBean;
    private static ExecutorService executorService;
    private static HbaseTemplate2 hbaseTemplate2;
    private static TableFactory tableFactory;
    private static CollectorMetric collectorMetric;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void buildHBaseClient(Map<String, String> properties, int threadCount, int threadQueue, long keepAliveTime, long blockedWaitTimeout, int warnMultsRejects, boolean preStartAllCoreThreads, Boolean daemon, Boolean enableMetrics) {
        if (connectionFactoryBean != null) return;
        if (connectionFactoryBean != null) {
            return;
        }
        Class<HBaseHelper> clazz = HBaseHelper.class;
        synchronized (HBaseHelper.class) {
            Object tableFactory;
            HbaseConfigurationFactoryBean hbaseConfigurationFactoryBean = new HbaseConfigurationFactoryBean();
            hbaseConfigurationFactoryBean.setProperties(properties);
            hbaseConfigurationFactoryBean.afterPropertiesSet();
            Configuration configuration = hbaseConfigurationFactoryBean.getConfiguration();
            executorService = ThreadPoolFactory.buildThreadPool((String)"HBase-Input", (String)"HBase tran", (int)threadCount, (int)threadQueue, (long)keepAliveTime, (long)blockedWaitTimeout, (int)warnMultsRejects, (boolean)preStartAllCoreThreads, (Boolean)daemon);
            connectionFactoryBean = new ConnectionFactoryBean(configuration, executorService);
            try {
                tableFactory = new HbaseTableFactory(connectionFactoryBean.getConnection());
                HBaseAsyncOperation hBaseAsyncOperation = HBaseAsyncOperationFactory.create(connectionFactoryBean.getConnection(), configuration);
                HbaseTemplate2 hbaseTemplate2 = new HbaseTemplate2();
                hbaseTemplate2.setConfiguration(configuration);
                hbaseTemplate2.setAsyncOperation(hBaseAsyncOperation);
                hbaseTemplate2.setTableFactory((TableFactory)tableFactory);
                hbaseTemplate2.afterPropertiesSet();
                HBaseHelper.hbaseTemplate2 = hbaseTemplate2;
                HBaseHelper.tableFactory = tableFactory;
                if (enableMetrics != null && enableMetrics.booleanValue()) {
                    collectorMetric = new CollectorMetric();
                    collectorMetric.start(hBaseAsyncOperation);
                }
            }
            catch (Exception e) {
                try {
                    throw new HBaseTranException(e);
                }
                catch (Throwable throwable) {
                    try {
                        ShutdownHookManagerProxy shutdownHookManagerProxy = new ShutdownHookManagerProxy();
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                    }
                    BaseApplicationContext.addShutdownHook((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            HBaseHelper.destroy();
                        }
                    });
                    throw throwable;
                }
            }
            try {
                tableFactory = new ShutdownHookManagerProxy();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            BaseApplicationContext.addShutdownHook((Runnable)new /* invalid duplicate definition of identical inner class */);
            // ** MonitorExit[clazz] (shouldn't be in output)
            return;
        }
    }

    public static TableFactory getTableFactory() {
        return tableFactory;
    }

    public static HbaseTemplate2 getHbaseTemplate2() {
        return hbaseTemplate2;
    }

    public static void destroy() {
        try {
            if (hbaseTemplate2 != null) {
                hbaseTemplate2.destroy();
                hbaseTemplate2 = null;
            }
        }
        catch (Throwable e) {
            logger.warn("", e);
        }
        try {
            if (connectionFactoryBean != null) {
                connectionFactoryBean.destroy();
                connectionFactoryBean = null;
            }
        }
        catch (Throwable e) {
            logger.warn("", e);
        }
        try {
            if (executorService != null) {
                executorService.shutdown();
                executorService = null;
            }
        }
        catch (Throwable e) {
            logger.warn("", e);
        }
        if (collectorMetric != null) {
            collectorMetric.shutdown();
            collectorMetric = null;
        }
        tableFactory = null;
    }
}

