/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.nosql.hbase;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Table;
import org.frameworkset.nosql.hbase.DisabledHBaseAsyncOperation;
import org.frameworkset.nosql.hbase.HBaseAccessException;
import org.frameworkset.nosql.hbase.HBaseAsyncOperation;
import org.frameworkset.nosql.hbase.HbaseAccessor;
import org.frameworkset.nosql.hbase.HbaseSystemException;
import org.frameworkset.nosql.hbase.StopWatch;
import org.frameworkset.nosql.hbase.TableCallback;
import org.frameworkset.spi.DisposableBean;
import org.frameworkset.spi.InitializingBean;
import org.frameworkset.util.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HbaseTemplate2
extends HbaseAccessor
implements InitializingBean,
DisposableBean {
    private static final int DEFAULT_MAX_THREADS_FOR_PARALLEL_SCANNER = 128;
    private static final int DEFAULT_MAX_THREADS_PER_PARALLEL_SCAN = 1;
    private static final long DEFAULT_DESTORY_TIMEOUT = 2000L;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final boolean debugEnabled = this.logger.isDebugEnabled();
    private final AtomicBoolean isClose = new AtomicBoolean(false);
    private ExecutorService executor;
    private boolean enableParallelScan = false;
    private int maxThreads = 128;
    private int maxThreadsPerParallelScan = 1;
    private HBaseAsyncOperation asyncOperation = DisabledHBaseAsyncOperation.INSTANCE;

    private Table getTable(TableName tableName) {
        return this.getTableFactory().getTable(tableName);
    }

    public void setEnableParallelScan(boolean enableParallelScan) {
        this.enableParallelScan = enableParallelScan;
    }

    public void setMaxThreads(int maxThreads) {
        this.maxThreads = maxThreads;
    }

    public void setMaxThreadsPerParallelScan(int maxThreadsPerParallelScan) {
        this.maxThreadsPerParallelScan = maxThreadsPerParallelScan;
    }

    public void setAsyncOperation(HBaseAsyncOperation asyncOperation) {
        if (asyncOperation == null) {
            throw new NullPointerException("asyncOperation");
        }
        this.asyncOperation = asyncOperation;
    }

    public void afterPropertiesSet() {
        Configuration configuration = this.getConfiguration();
        Assert.notNull((Object)configuration, (String)"configuration is required");
        Assert.notNull((Object)this.getTableFactory(), (String)"tableFactory is required");
    }

    public void destroy() throws Exception {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        if (this.isClose.compareAndSet(false, true)) {
            this.logger.info("HBaseTemplate2.destroy()");
            ExecutorService executor = this.executor;
            if (executor != null) {
                executor.shutdown();
                try {
                    executor.awaitTermination(2000L, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
            long remainingTime = Math.max(2000L - stopWatch.stop(), 100L);
            this.awaitAsyncPutOpsCleared(remainingTime, 50L);
        }
    }

    private boolean awaitAsyncPutOpsCleared(long waitTimeout, long checkUnitTime) {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        while (true) {
            Long currentPutOpsCount = this.asyncOperation.getCurrentOpsCount();
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("count {}", (Object)currentPutOpsCount);
            }
            if (currentPutOpsCount <= 0L) {
                return true;
            }
            if (stopWatch.stop() > waitTimeout) {
                return false;
            }
            try {
                Thread.sleep(checkUnitTime);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    private void assertAccessAvailable() {
        if (this.isClose.get()) {
            throw new HBaseAccessException("Already closed.");
        }
    }

    public void put(TableName tableName, byte[] rowName, byte[] familyName, byte[] qualifier, byte[] value) {
        this.put(tableName, rowName, familyName, qualifier, null, value);
    }

    public void put(TableName tableName, final byte[] rowName, final byte[] familyName, final byte[] qualifier, final Long timestamp, final byte[] value) {
        this.assertAccessAvailable();
        this.execute(tableName, new TableCallback(){

            public Object doInTable(Table table) throws Throwable {
                Put put = HbaseTemplate2.this.createPut(rowName, familyName, timestamp, qualifier, value);
                table.put(put);
                return null;
            }
        });
    }

    public void put(TableName tableName, final Put put) {
        this.assertAccessAvailable();
        this.execute(tableName, new TableCallback(){

            public Object doInTable(Table table) throws Throwable {
                table.put(put);
                return null;
            }
        });
    }

    public void put(TableName tableName, final List<Put> puts) {
        this.assertAccessAvailable();
        this.execute(tableName, new TableCallback(){

            public Object doInTable(Table table) throws Throwable {
                table.put(puts);
                return null;
            }
        });
    }

    public boolean asyncPut(TableName tableName, byte[] rowName, byte[] familyName, byte[] qualifier, byte[] value) {
        return this.asyncPut(tableName, rowName, familyName, qualifier, null, value);
    }

    public boolean asyncPut(TableName tableName, byte[] rowName, byte[] familyName, byte[] qualifier, Long timestamp, byte[] value) {
        Put put = this.createPut(rowName, familyName, timestamp, qualifier, value);
        return this.asyncPut(tableName, put);
    }

    public boolean asyncPut(TableName tableName, Put put) {
        this.assertAccessAvailable();
        if (this.asyncOperation.isAvailable()) {
            return this.asyncOperation.put(tableName, put);
        }
        this.put(tableName, put);
        return true;
    }

    public List<Put> asyncPut(TableName tableName, List<Put> puts) {
        this.assertAccessAvailable();
        if (this.asyncOperation.isAvailable()) {
            return this.asyncOperation.put(tableName, puts);
        }
        this.put(tableName, puts);
        return Collections.emptyList();
    }

    private Put createPut(byte[] rowName, byte[] familyName, Long timestamp, byte[] qualifier, byte[] value) {
        Put put = new Put(rowName);
        if (familyName != null) {
            if (timestamp == null) {
                put.addColumn(familyName, qualifier, value);
            } else {
                put.addColumn(familyName, qualifier, timestamp.longValue(), value);
            }
        }
        return put;
    }

    public void delete(TableName tableName, final Delete delete) {
        this.assertAccessAvailable();
        this.execute(tableName, new TableCallback(){

            public Object doInTable(Table table) throws Throwable {
                table.delete(delete);
                return null;
            }
        });
    }

    public void delete(TableName tableName, final List<Delete> deletes) {
        this.assertAccessAvailable();
        this.execute(tableName, new TableCallback(){

            public Object doInTable(Table table) throws Throwable {
                table.delete(deletes);
                return null;
            }
        });
    }

    public Result increment(TableName tableName, final Increment increment) {
        this.assertAccessAvailable();
        return this.execute(tableName, new TableCallback<Result>(){

            @Override
            public Result doInTable(Table table) throws Throwable {
                return table.increment(increment);
            }
        });
    }

    public List<Result> increment(final TableName tableName, final List<Increment> incrementList) {
        this.assertAccessAvailable();
        return this.execute(tableName, new TableCallback<List<Result>>(){

            @Override
            public List<Result> doInTable(Table table) throws Throwable {
                ArrayList<Result> resultList = new ArrayList<Result>(incrementList.size());
                IOException lastException = null;
                for (Increment increment : incrementList) {
                    try {
                        Result result = table.increment(increment);
                        resultList.add(result);
                    }
                    catch (IOException e) {
                        HbaseTemplate2.this.logger.warn("{} increment error Caused:{}", new Object[]{tableName, e.getMessage(), e});
                        lastException = e;
                    }
                }
                if (lastException != null) {
                    throw lastException;
                }
                return resultList;
            }
        });
    }

    public long incrementColumnValue(TableName tableName, final byte[] rowName, final byte[] familyName, final byte[] qualifier, final long amount) {
        this.assertAccessAvailable();
        return this.execute(tableName, new TableCallback<Long>(){

            @Override
            public Long doInTable(Table table) throws Throwable {
                return table.incrementColumnValue(rowName, familyName, qualifier, amount);
            }
        });
    }

    public long incrementColumnValue(TableName tableName, final byte[] rowName, final byte[] familyName, final byte[] qualifier, final long amount, final boolean writeToWAL) {
        this.assertAccessAvailable();
        return this.execute(tableName, new TableCallback<Long>(){

            @Override
            public Long doInTable(Table table) throws Throwable {
                return table.incrementColumnValue(rowName, familyName, qualifier, amount, writeToWAL ? Durability.SKIP_WAL : Durability.USE_DEFAULT);
            }
        });
    }

    public <T> T execute(TableName tableName, TableCallback<T> action) {
        Assert.notNull(action, (String)"Callback object must not be null");
        Assert.notNull((Object)tableName, (String)"No table specified");
        this.assertAccessAvailable();
        Table table = this.getTable(tableName);
        try {
            T result;
            T t = result = action.doInTable(table);
            return t;
        }
        catch (Throwable e) {
            if (e instanceof Error) {
                throw (Error)e;
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new HbaseSystemException((Exception)e);
        }
        finally {
            this.releaseTable(table);
        }
    }

    private void releaseTable(Table table) {
        this.getTableFactory().releaseTable(table);
    }
}

