/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.tran.hbase;

import com.frameworkset.orm.annotation.BatchContext;
import java.text.DateFormat;
import java.util.Date;
import java.util.Map;
import org.apache.hadoop.hbase.util.Bytes;
import org.frameworkset.spi.geoip.IpInfo;
import org.frameworkset.tran.TranResultSet;
import org.frameworkset.tran.config.BaseImportConfig;
import org.frameworkset.tran.context.ContextImpl;
import org.frameworkset.tran.context.ImportContext;
import org.frameworkset.tran.schedule.TaskContext;

public class HBaseRecordContextImpl
extends ContextImpl {
    public HBaseRecordContextImpl(TaskContext taskContext, ImportContext importContext, ImportContext targetImportContext, TranResultSet jdbcResultSet, BatchContext batchContext) {
        super(taskContext, importContext, targetImportContext, jdbcResultSet, batchContext);
    }

    public long getLongValue(String fieldName) throws Exception {
        Object value = this.getValue(fieldName);
        if (value == null) {
            return 0L;
        }
        return Bytes.toLong((byte[])((byte[])value));
    }

    public String getStringValue(String fieldName) throws Exception {
        Object value = this.getValue(fieldName);
        if (value == null) {
            return null;
        }
        return Bytes.toString((byte[])((byte[])value));
    }

    public String getStringValue(String fieldName, String defaultValue) throws Exception {
        Object value = this.getValue(fieldName);
        if (value == null) {
            return defaultValue;
        }
        return Bytes.toString((byte[])((byte[])value));
    }

    public boolean getBooleanValue(String fieldName) throws Exception {
        Object value = this.getValue(fieldName);
        if (value == null) {
            return false;
        }
        return Bytes.toBoolean((byte[])((byte[])value));
    }

    public boolean getBooleanValue(String fieldName, boolean defaultValue) throws Exception {
        Object value = this.getValue(fieldName);
        if (value == null) {
            return defaultValue;
        }
        return Bytes.toBoolean((byte[])((byte[])value));
    }

    public double getDoubleValue(String fieldName) throws Exception {
        Object value = this.getValue(fieldName);
        if (value == null) {
            return 0.0;
        }
        return Bytes.toDouble((byte[])((byte[])value));
    }

    public float getFloatValue(String fieldName) throws Exception {
        Object value = this.getValue(fieldName);
        if (value == null) {
            return 0.0f;
        }
        return Bytes.toFloat((byte[])((byte[])value));
    }

    public int getIntegerValue(String fieldName) throws Exception {
        Object value = this.getValue(fieldName);
        if (value == null) {
            return 0;
        }
        return Bytes.toInt((byte[])((byte[])value));
    }

    public Date getDateValue(String fieldName) throws Exception {
        Object value = this.getValue(fieldName);
        if (value == null) {
            return null;
        }
        if (value instanceof Date) {
            return (Date)value;
        }
        long time = Bytes.toLong((byte[])((byte[])value));
        return new Date(time);
    }

    public Date getDateValue(String fieldName, DateFormat dateFormat) throws Exception {
        Object value = this.getValue(fieldName);
        if (value == null) {
            return null;
        }
        if (value instanceof Date) {
            return (Date)value;
        }
        long time = Bytes.toLong((byte[])((byte[])value));
        return new Date(time);
    }

    public IpInfo getIpInfo(String fieldName) throws Exception {
        Object _ip = this.jdbcResultSet.getValue(fieldName);
        if (_ip == null) {
            return null;
        }
        String ip = Bytes.toString((byte[])((byte[])_ip));
        if (BaseImportConfig.getGeoIPUtil((Map)this.getGeoipConfig()) != null) {
            return BaseImportConfig.getGeoIPUtil((Map)this.getGeoipConfig()).getAddressMapResult(ip);
        }
        return null;
    }
}

