/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.elasticsearch.client;

import com.frameworkset.util.ColumnEditorInf;
import com.frameworkset.util.FieldToColumnEditor;
import com.frameworkset.util.NoSupportTypeCastException;
import com.frameworkset.util.ValueObjectUtil;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.frameworkset.elasticsearch.ElasticSearchException;
import org.frameworkset.elasticsearch.entity.AggHit;
import org.frameworkset.elasticsearch.entity.BaseSearchHit;
import org.frameworkset.elasticsearch.entity.DoubleAggHit;
import org.frameworkset.elasticsearch.entity.DoubleAggRangeHit;
import org.frameworkset.elasticsearch.entity.ESAggDatas;
import org.frameworkset.elasticsearch.entity.ESBaseData;
import org.frameworkset.elasticsearch.entity.ESDatas;
import org.frameworkset.elasticsearch.entity.ESId;
import org.frameworkset.elasticsearch.entity.FloatAggHit;
import org.frameworkset.elasticsearch.entity.FloatAggRangeHit;
import org.frameworkset.elasticsearch.entity.InnerSearchHit;
import org.frameworkset.elasticsearch.entity.InnerSearchHits;
import org.frameworkset.elasticsearch.entity.LongAggHit;
import org.frameworkset.elasticsearch.entity.LongAggRangeHit;
import org.frameworkset.elasticsearch.entity.MGetDocs;
import org.frameworkset.elasticsearch.entity.RestResponse;
import org.frameworkset.elasticsearch.entity.SearchHit;
import org.frameworkset.elasticsearch.entity.SingleDoubleAggHit;
import org.frameworkset.elasticsearch.entity.SingleFloatAggHit;
import org.frameworkset.elasticsearch.entity.SingleIntegerAggHit;
import org.frameworkset.elasticsearch.entity.SingleLongAggHit;
import org.frameworkset.elasticsearch.entity.SingleObjectAggHit;
import org.frameworkset.elasticsearch.entity.sql.ColumnMeta;
import org.frameworkset.elasticsearch.entity.sql.SQLRestResponse;
import org.frameworkset.elasticsearch.entity.sql.SQLResult;
import org.frameworkset.elasticsearch.handler.ESAggBucketHandle;
import org.frameworkset.elasticsearch.serial.ESTypeReference;
import org.frameworkset.elasticsearch.serial.SerialUtil;
import org.frameworkset.spi.remote.http.HttpRuntimeException;
import org.frameworkset.util.BigFile;
import org.frameworkset.util.ClassUtil;
import org.frameworkset.util.annotations.DateFormateMeta;
import org.frameworkset.util.annotations.wraper.ColumnWraper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ResultUtil {
    private static Logger logger = LoggerFactory.getLogger(ResultUtil.class);
    public static final int OPERTYPE_getDocument = 0;
    public static final int OPERTYPE_updateDocument = 1;
    public static final int OPERTYPE_deleteDocument = 2;
    public static final int OPERTYPE_getTemplate = 3;
    public static final int OPERTYPE_getIndice = 4;
    public static final int OPERTYPE_existIndice = 5;
    public static final int OPERTYPE_existIndiceType = 6;
    public static final int OPERTYPE_dropIndice = 7;
    public static final int OPERTYPE_deleteTempate = 8;
    public static final int OPERTYPE_updateIndiceMapping = 8;
    public static final Boolean exist = new Boolean(false);

    public static <T> List<T> getInnerHits(Map<String, Map<String, InnerSearchHits>> innerHits, String indexType, Class<T> type) {
        InnerSearchHits ihits;
        if (innerHits == null || innerHits.size() == 0) {
            return null;
        }
        Map<String, InnerSearchHits> hits = innerHits.get(indexType);
        if (hits != null && (ihits = hits.get("hits")) != null) {
            List<InnerSearchHit> temp = ihits.getHits();
            if (temp.size() == 0) {
                return null;
            }
            if (InnerSearchHit.class.isAssignableFrom(type)) {
                return temp;
            }
            ArrayList<Object> ts = new ArrayList<Object>(temp.size());
            for (int i = 0; i < temp.size(); ++i) {
                ts.add(temp.get(i).getSource());
            }
            return ts;
        }
        return null;
    }

    public static List getInnerHits(Map<String, Map<String, InnerSearchHits>> innerHits, String indexType) {
        InnerSearchHits ihits;
        if (innerHits == null || innerHits.size() == 0) {
            return null;
        }
        Map<String, InnerSearchHits> hits = innerHits.get(indexType);
        if (hits != null && (ihits = hits.get("hits")) != null) {
            List<InnerSearchHit> temp = ihits.getHits();
            if (temp.size() == 0) {
                return null;
            }
            ArrayList<Object> ts = new ArrayList<Object>(temp.size());
            for (int i = 0; i < temp.size(); ++i) {
                ts.add(temp.get(i).getSource());
            }
            return ts;
        }
        return null;
    }

    public static Integer integerValue(Object num, Integer defaultValue) {
        return ResultUtil.intValue(num, defaultValue);
    }

    public static Long longValue(Object num, Long defaultValue) {
        if (num == null) {
            return defaultValue;
        }
        if (num instanceof Long) {
            return (Long)num;
        }
        if (num instanceof BigDecimal) {
            return ((BigDecimal)num).longValue();
        }
        if (num instanceof Double) {
            return ((Double)num).longValue();
        }
        if (num instanceof Integer) {
            return ((Integer)num).longValue();
        }
        if (num instanceof Float) {
            return ((Float)num).longValue();
        }
        if (num instanceof Short) {
            return ((Short)num).longValue();
        }
        return Long.parseLong(num.toString());
    }

    public static Integer intValue(Object num, Integer defaultValue) {
        if (num == null) {
            return defaultValue;
        }
        if (num instanceof Integer) {
            return (Integer)num;
        }
        if (num instanceof Long) {
            return ((Long)num).intValue();
        }
        if (num instanceof BigDecimal) {
            return ((BigDecimal)num).intValue();
        }
        if (num instanceof Double) {
            return ((Double)num).intValue();
        }
        if (num instanceof Float) {
            return ((Float)num).intValue();
        }
        if (num instanceof Short) {
            return ((Short)num).intValue();
        }
        return Integer.parseInt(num.toString());
    }

    public static Float floatValue(Object num, Float defaultValue) {
        if (num == null) {
            return defaultValue;
        }
        if (num instanceof Float) {
            return (Float)num;
        }
        if (num instanceof BigDecimal) {
            return Float.valueOf(((BigDecimal)num).floatValue());
        }
        if (num instanceof Double) {
            return Float.valueOf(((Double)num).floatValue());
        }
        if (num instanceof Integer) {
            return Float.valueOf(((Integer)num).floatValue());
        }
        if (num instanceof Long) {
            return Float.valueOf(((Long)num).floatValue());
        }
        if (num instanceof Short) {
            return Float.valueOf(((Short)num).floatValue());
        }
        return Float.valueOf(Float.parseFloat(num.toString()));
    }

    public static Double doubleValue(Object num, Double defaultValue) {
        if (num == null) {
            return defaultValue;
        }
        if (num instanceof Double) {
            return (Double)num;
        }
        if (num instanceof BigDecimal) {
            return ((BigDecimal)num).doubleValue();
        }
        if (num instanceof Float) {
            return ((Float)num).doubleValue();
        }
        if (num instanceof Integer) {
            return ((Integer)num).doubleValue();
        }
        if (num instanceof Long) {
            return ((Long)num).doubleValue();
        }
        if (num instanceof Short) {
            return ((Short)num).doubleValue();
        }
        return Double.parseDouble(num.toString());
    }

    public static String handleLuceneSpecialChars(String condition) {
        if (condition == null || condition.equals("")) {
            return condition;
        }
        condition = condition.replace(":", "/:");
        condition = condition.replace("-", "/-");
        condition = condition.replace("+", "/+");
        condition = condition.replace("&", "/&");
        condition = condition.replace("!", "/!");
        condition = condition.replace("{", "/{");
        condition = condition.replace("}", "/}");
        condition = condition.replace("(", "/(");
        condition = condition.replace(")", "/)");
        condition = condition.replace("|", "/|");
        condition = condition.replace("~", "/~");
        condition = condition.replace("*", "/*");
        condition = condition.replace("?", "/?");
        condition = condition.replace("/", "//");
        return condition;
    }

    public static String handleElasticSearchSpecialChars(String condition) {
        if (condition == null || condition.equals("")) {
            return condition;
        }
        condition = condition.replace(":", "\\:");
        condition = condition.replace("-", "\\-");
        condition = condition.replace("+", "\\+");
        condition = condition.replace("&", "\\&");
        condition = condition.replace("!", "\\!");
        condition = condition.replace("{", "\\{");
        condition = condition.replace("}", "\\}");
        condition = condition.replace("(", "\\(");
        condition = condition.replace(")", "\\)");
        condition = condition.replace("|", "\\|");
        condition = condition.replace("~", "\\~");
        condition = condition.replace("*", "\\*");
        condition = condition.replace("?", "\\?");
        condition = condition.replace("/", "\\/");
        return condition;
    }

    public static void buildLongAggHit(LongAggHit longRangeHit, Map<String, Object> bucket, String stats) {
        longRangeHit.setKey((String)bucket.get("key"));
        longRangeHit.setDocCount(ResultUtil.longValue(bucket.get("doc_count"), 0L));
        if (stats == null) {
            return;
        }
        Map stats_ = (Map)bucket.get(stats);
        longRangeHit.setMax(ResultUtil.longValue(stats_.get("max"), 0L));
        longRangeHit.setMin(ResultUtil.longValue(stats_.get("min"), 0L));
        longRangeHit.setAvg(ResultUtil.floatValue(stats_.get("avg"), Float.valueOf(0.0f)));
        longRangeHit.setSum(ResultUtil.longValue(stats_.get("sum"), 0L));
    }

    public static void buildFloatAggHit(FloatAggHit floatRangeHit, Map<String, Object> bucket, String stats) {
        floatRangeHit.setKey((String)bucket.get("key"));
        floatRangeHit.setDocCount(ResultUtil.longValue(bucket.get("doc_count"), 0L));
        if (stats == null) {
            return;
        }
        Map stats_ = (Map)bucket.get(stats);
        floatRangeHit.setMax(ResultUtil.floatValue(stats_.get("max"), Float.valueOf(0.0f)));
        floatRangeHit.setMin(ResultUtil.floatValue(stats_.get("min"), Float.valueOf(0.0f)));
        floatRangeHit.setAvg(ResultUtil.floatValue(stats_.get("avg"), Float.valueOf(0.0f)));
        floatRangeHit.setSum(ResultUtil.floatValue(stats_.get("sum"), Float.valueOf(0.0f)));
    }

    public static void buildDoubleAggHit(DoubleAggHit doubleAggHit, Map<String, Object> bucket, String stats) {
        doubleAggHit.setKey((String)bucket.get("key"));
        doubleAggHit.setDocCount(ResultUtil.longValue(bucket.get("doc_count"), 0L));
        if (stats == null) {
            return;
        }
        Map stats_ = (Map)bucket.get(stats);
        doubleAggHit.setMax(ResultUtil.doubleValue(stats_.get("max"), 0.0));
        doubleAggHit.setMin(ResultUtil.doubleValue(stats_.get("min"), 0.0));
        doubleAggHit.setAvg(ResultUtil.doubleValue(stats_.get("avg"), 0.0));
        doubleAggHit.setSum(ResultUtil.doubleValue(stats_.get("sum"), 0.0));
    }

    public static void buildLongAggRangeHit(LongAggRangeHit longRangeHit, Map<String, Object> bucket, String stats, String key) {
        longRangeHit.setKey(key);
        longRangeHit.setFrom(ResultUtil.longValue(bucket.get("from"), null));
        longRangeHit.setTo(ResultUtil.longValue(bucket.get("to"), null));
        longRangeHit.setDocCount(ResultUtil.longValue(bucket.get("doc_count"), 0L));
        if (stats == null) {
            return;
        }
        Map stats_ = (Map)bucket.get(stats);
        longRangeHit.setMax(ResultUtil.longValue(stats_.get("max"), 0L));
        longRangeHit.setMin(ResultUtil.longValue(stats_.get("min"), 0L));
        longRangeHit.setAvg(ResultUtil.floatValue(stats_.get("avg"), Float.valueOf(0.0f)));
        longRangeHit.setSum(ResultUtil.longValue(stats_.get("sum"), 0L));
    }

    public static void buildFloatAggRangeHit(FloatAggRangeHit floatRangeHit, Map<String, Object> bucket, String stats, String key) {
        floatRangeHit.setKey(key);
        floatRangeHit.setFrom(ResultUtil.floatValue(bucket.get("from"), null));
        floatRangeHit.setTo(ResultUtil.floatValue(bucket.get("to"), null));
        floatRangeHit.setDocCount(ResultUtil.longValue(bucket.get("doc_count"), 0L));
        if (stats == null) {
            return;
        }
        Map stats_ = (Map)bucket.get(stats);
        floatRangeHit.setMax(ResultUtil.floatValue(stats_.get("max"), Float.valueOf(0.0f)));
        floatRangeHit.setMin(ResultUtil.floatValue(stats_.get("min"), Float.valueOf(0.0f)));
        floatRangeHit.setAvg(ResultUtil.floatValue(stats_.get("avg"), Float.valueOf(0.0f)));
        floatRangeHit.setSum(ResultUtil.floatValue(stats_.get("sum"), Float.valueOf(0.0f)));
    }

    public static void buildDoubleAggRangeHit(DoubleAggRangeHit doubleRangeHit, Map<String, Object> bucket, String stats, String key) {
        doubleRangeHit.setKey(key);
        doubleRangeHit.setFrom(ResultUtil.doubleValue(bucket.get("from"), null));
        doubleRangeHit.setTo(ResultUtil.doubleValue(bucket.get("to"), null));
        doubleRangeHit.setDocCount(ResultUtil.longValue(bucket.get("doc_count"), 0L));
        if (stats == null) {
            return;
        }
        Map stats_ = (Map)bucket.get(stats);
        doubleRangeHit.setMax(ResultUtil.doubleValue(stats_.get("max"), 0.0));
        doubleRangeHit.setMin(ResultUtil.doubleValue(stats_.get("min"), 0.0));
        doubleRangeHit.setAvg(ResultUtil.doubleValue(stats_.get("avg"), 0.0));
        doubleRangeHit.setSum(ResultUtil.doubleValue(stats_.get("sum"), 0.0));
    }

    public static void buildSingleIntegerAggHit(SingleIntegerAggHit integerAggHit, Object bucket) {
        integerAggHit.setValue(ResultUtil.integerValue(bucket, 0));
    }

    public static void buildSingleLongAggHit(SingleLongAggHit longRangeHit, Object bucket) {
        longRangeHit.setValue(ResultUtil.longValue(bucket, 0L));
    }

    public static void buildSingleObjectAggHit(SingleObjectAggHit objectgRangeHit, Object bucket) {
        objectgRangeHit.setValue(bucket);
    }

    public static void buildSingleFloatAggHit(SingleFloatAggHit floatRangeHit, Object bucket) {
        floatRangeHit.setValue(ResultUtil.floatValue(bucket, Float.valueOf(0.0f)));
    }

    public static void buildSingleDoubleAggHit(SingleDoubleAggHit doubleAggHit, Object bucket) {
        doubleAggHit.setValue(ResultUtil.doubleValue(bucket, 0.0));
    }

    public static <T extends AggHit> ESAggDatas<T> buildESAggDatas(RestResponse searchResult, Class<T> type, String aggs, String stats, ESAggBucketHandle<T> aggBucketHandle) {
        Map<String, Map<String, Object>> aggregations = searchResult.getAggregations();
        if (aggregations != null) {
            Map<String, Object> traces = aggregations.get(aggs);
            Object _buckets = traces.get("buckets");
            if (_buckets == null) {
                Object value = traces.get("value");
                return ResultUtil.singleValueAgg(searchResult, aggregations, value, type);
            }
            return ResultUtil.bulkAgg(searchResult, aggregations, _buckets, type, aggs, stats, aggBucketHandle);
        }
        return null;
    }

    private static <T extends AggHit> ESAggDatas<T> singleValueAgg(RestResponse searchResult, Map<String, Map<String, Object>> aggregations, Object value, Class<T> type) {
        ESAggDatas<AggHit> ret = new ESAggDatas<AggHit>();
        ret.setAggregations(aggregations);
        ret.setTotalSize(searchResult.getSearchHits().getTotal());
        if (value == null) {
            return ret;
        }
        try {
            AggHit obj = (AggHit)type.newInstance();
            if (obj instanceof SingleLongAggHit) {
                ResultUtil.buildSingleLongAggHit((SingleLongAggHit)obj, value);
            } else if (obj instanceof SingleIntegerAggHit) {
                ResultUtil.buildSingleIntegerAggHit((SingleIntegerAggHit)obj, value);
            } else if (obj instanceof SingleFloatAggHit) {
                ResultUtil.buildSingleFloatAggHit((SingleFloatAggHit)obj, value);
            } else if (obj instanceof SingleDoubleAggHit) {
                ResultUtil.buildSingleDoubleAggHit((SingleDoubleAggHit)obj, value);
            } else if (obj instanceof SingleObjectAggHit) {
                ResultUtil.buildSingleObjectAggHit((SingleObjectAggHit)obj, value);
            }
            ret.setSingleAggData(obj);
        }
        catch (InstantiationException e) {
            throw new ElasticSearchException(e);
        }
        catch (IllegalAccessException e) {
            throw new ElasticSearchException(e);
        }
        return ret;
    }

    private static <T extends AggHit> ESAggDatas<T> bulkAgg(RestResponse searchResult, Map<String, Map<String, Object>> aggregations, Object _buckets, Class<T> type, String aggs, String stats, ESAggBucketHandle<T> aggBucketHandle) {
        ESAggDatas ret = new ESAggDatas();
        ret.setAggregations(aggregations);
        ret.setTotalSize(searchResult.getSearchHits().getTotal());
        if (_buckets instanceof List) {
            List buckets = (List)_buckets;
            ArrayList<AggHit> datas = new ArrayList<AggHit>(buckets.size());
            ret.setAggDatas(datas);
            for (Map bucket : buckets) {
                try {
                    AggHit obj = (AggHit)type.newInstance();
                    if (obj instanceof LongAggRangeHit) {
                        ResultUtil.buildLongAggRangeHit((LongAggRangeHit)obj, bucket, stats, null);
                    } else if (obj instanceof FloatAggRangeHit) {
                        ResultUtil.buildFloatAggRangeHit((FloatAggRangeHit)obj, bucket, stats, null);
                    } else if (obj instanceof DoubleAggRangeHit) {
                        ResultUtil.buildDoubleAggRangeHit((DoubleAggRangeHit)obj, bucket, stats, null);
                    } else if (obj instanceof LongAggHit) {
                        ResultUtil.buildLongAggHit((LongAggHit)obj, bucket, stats);
                    } else if (obj instanceof FloatAggHit) {
                        ResultUtil.buildFloatAggHit((FloatAggHit)obj, bucket, stats);
                    } else if (obj instanceof DoubleAggHit) {
                        ResultUtil.buildDoubleAggHit((DoubleAggHit)obj, bucket, stats);
                    }
                    if (aggBucketHandle != null) {
                        aggBucketHandle.bucketHandle(searchResult, bucket, obj, null);
                    }
                    datas.add(obj);
                }
                catch (InstantiationException e) {
                    throw new ElasticSearchException(e);
                }
                catch (IllegalAccessException e) {
                    throw new ElasticSearchException(e);
                }
            }
        } else {
            Map buckets = (Map)_buckets;
            ArrayList<AggHit> datas = new ArrayList<AggHit>(buckets.size());
            ret.setAggDatas(datas);
            Iterator iterable = buckets.entrySet().iterator();
            Map bucket = null;
            Map.Entry entry = null;
            String key = null;
            AggHit obj = null;
            while (iterable.hasNext()) {
                entry = iterable.next();
                key = (String)entry.getKey();
                bucket = (Map)entry.getValue();
                try {
                    obj = (AggHit)type.newInstance();
                    if (obj instanceof LongAggRangeHit) {
                        ResultUtil.buildLongAggRangeHit((LongAggRangeHit)obj, bucket, stats, key);
                    } else if (obj instanceof DoubleAggRangeHit) {
                        ResultUtil.buildDoubleAggRangeHit((DoubleAggRangeHit)obj, bucket, stats, key);
                    } else if (obj instanceof FloatAggRangeHit) {
                        ResultUtil.buildFloatAggRangeHit((FloatAggRangeHit)obj, bucket, stats, key);
                    }
                    if (aggBucketHandle != null) {
                        aggBucketHandle.bucketHandle(searchResult, bucket, obj, key);
                    }
                    datas.add(obj);
                }
                catch (InstantiationException e) {
                    throw new ElasticSearchException(e);
                }
                catch (IllegalAccessException e) {
                    throw new ElasticSearchException(e);
                }
            }
        }
        return ret;
    }

    public static <T> T getAggBuckets(Map<String, ?> map, String metrics, ESTypeReference<T> typeReference) {
        Map metrics_;
        if (map != null && (metrics_ = (Map)map.get(metrics)) != null) {
            return (T)metrics_.get("buckets");
        }
        return null;
    }

    public static Map<String, Object> getAggregationMetrics(Map<String, ?> map, String metrics) {
        if (map != null) {
            return (Map)map.get(metrics);
        }
        return null;
    }

    public static <T> T getAggBuckets(Map<String, ?> map, String metrics, Class<T> typeReference) {
        Map metrics_;
        if (map != null && (metrics_ = (Map)map.get(metrics)) != null) {
            return (T)metrics_.get("buckets");
        }
        return null;
    }

    public static Object getAggBuckets(Map<String, ?> map, String metrics) {
        Map metrics_;
        if (map != null && (metrics_ = (Map)map.get(metrics)) != null) {
            return metrics_.get("buckets");
        }
        return null;
    }

    public static <T> T getAggAttribute(Map<String, ?> map, String metrics, String attribute, ESTypeReference<T> typeReference) {
        Map metrics_;
        if (map != null && (metrics_ = (Map)map.get(metrics)) != null) {
            return (T)metrics_.get(attribute);
        }
        return null;
    }

    public static <T> T getAggAttribute(Map<String, ?> map, String metrics, String attribute, Class<T> typeReference) {
        Map metrics_;
        if (map != null && (metrics_ = (Map)map.get(metrics)) != null) {
            return (T)metrics_.get(attribute);
        }
        return null;
    }

    public static Object getAggAttribute(Map<String, ?> map, String metrics, String attribute) {
        Map metrics_;
        if (map != null && (metrics_ = (Map)map.get(metrics)) != null) {
            return metrics_.get(attribute);
        }
        return null;
    }

    public static void buildESBaseData(BaseSearchHit hit, ESBaseData esBaseData) {
        esBaseData.setFields(hit.getFields());
        esBaseData.setHighlight(hit.getHighlight());
        esBaseData.setId(hit.getId());
        esBaseData.setScore(hit.getScore());
        esBaseData.setSort(hit.getSort());
        esBaseData.setType(hit.getType());
        esBaseData.setVersion(hit.getVersion());
        esBaseData.setIndex(hit.getIndex());
        esBaseData.setParent(hit.getParent());
        esBaseData.setRouting(hit.getRouting());
        esBaseData.setFound(hit.isFound());
        esBaseData.setNested(hit.getNested());
        esBaseData.setInnerHits(hit.getInnerHits());
    }

    public static void buildESId(BaseSearchHit hit, ESId esBaseData) {
        esBaseData.setId(hit.getId());
    }

    public static void injectBaseData(Object data, BaseSearchHit hit, boolean isESBaseData, boolean isESId) {
        if (isESBaseData) {
            ResultUtil.buildESBaseData(hit, (ESBaseData)data);
        } else if (isESId) {
            ResultUtil.buildESId(hit, (ESId)data);
        }
    }

    public static void injectInnerHitBaseData(Map<String, Map<String, InnerSearchHits>> innerHits) {
        Iterator<Map.Entry<String, Map<String, InnerSearchHits>>> iterator = innerHits.entrySet().iterator();
        ClassUtil.ClassInfo classInfo = null;
        ClassUtil.PropertieDescription injectAnnotationESId = null;
        ClassUtil.PropertieDescription injectAnnotationESParentId = null;
        while (iterator.hasNext()) {
            List<InnerSearchHit> innerSearchHits;
            Map.Entry<String, Map<String, InnerSearchHits>> entry = iterator.next();
            Map<String, InnerSearchHits> value = entry.getValue();
            InnerSearchHits hitsEntryValue = value.get("hits");
            if (hitsEntryValue == null || (innerSearchHits = hitsEntryValue.getHits()) == null || innerSearchHits.size() <= 0) continue;
            Object source = innerSearchHits.get(0).getSource();
            classInfo = ClassUtil.getClassInfo(source.getClass());
            injectAnnotationESId = classInfo.getEsIdProperty();
            injectAnnotationESParentId = classInfo.getEsParentProperty();
            boolean isESBaseData = ESBaseData.class.isAssignableFrom(classInfo.getClazz());
            boolean isESId = false;
            if (!isESBaseData) {
                isESId = ESId.class.isAssignableFrom(source.getClass());
            }
            if (!isESBaseData && !isESId && (injectAnnotationESId == null || !injectAnnotationESId.isEsIdReadSet()) && (injectAnnotationESParentId == null || !injectAnnotationESParentId.isEsIdReadSet())) continue;
            for (int i = 0; i < innerSearchHits.size(); ++i) {
                InnerSearchHit innerSearchHit = innerSearchHits.get(i);
                source = innerSearchHit.getSource();
                if (source == null) continue;
                if (injectAnnotationESId != null && injectAnnotationESId.isEsIdReadSet()) {
                    ResultUtil.injectAnnotationESId(injectAnnotationESId, source, innerSearchHit);
                }
                if (injectAnnotationESParentId != null && injectAnnotationESParentId.isEsIdReadSet()) {
                    ResultUtil.injectAnnotationESParentId(injectAnnotationESParentId, source, innerSearchHit);
                }
                if (!isESBaseData && !isESId) continue;
                ResultUtil.injectBaseData(source, innerSearchHit, isESBaseData, isESId);
            }
        }
    }

    private static void injectAnnotationESId(ClassUtil.PropertieDescription injectAnnotationESId, Object data, BaseSearchHit hit) {
        if (data == null) {
            return;
        }
        String id = hit.getId();
        ResultUtil._injectAnnotationES(injectAnnotationESId, data, hit, id);
    }

    private static void injectAnnotationESParentId(ClassUtil.PropertieDescription injectAnnotationESParentId, Object data, BaseSearchHit hit) {
        if (data == null) {
            return;
        }
        Object id = hit.getParent();
        ResultUtil._injectAnnotationES(injectAnnotationESParentId, data, hit, id);
    }

    private static void _injectAnnotationES(ClassUtil.PropertieDescription propertieDescription, Object data, BaseSearchHit hit, Object id) {
        if (propertieDescription != null && propertieDescription.isEsIdReadSet()) {
            try {
                propertieDescription.setValue(data, ValueObjectUtil.typeCast((Object)id, (Class)propertieDescription.getPropertyType()));
            }
            catch (IllegalAccessException e) {
                logger.warn("\u8bbe\u7f6e\u5c5e\u6027\u5931\u8d25\uff1a" + propertieDescription.toString(), (Throwable)e);
            }
            catch (InvocationTargetException e) {
                logger.warn("\u8bbe\u7f6e\u5c5e\u6027\u5931\u8d25\uff1a" + propertieDescription.toString(), e.getTargetException());
            }
        }
    }

    public static <T> T buildObject(RestResponse result, Class<T> type) {
        if (result == null) {
            return null;
        }
        RestResponse restResponse = result;
        List<SearchHit> searchHits = restResponse.getSearchHits().getHits();
        if (searchHits != null && searchHits.size() > 0) {
            SearchHit hit = searchHits.get(0);
            if (SearchHit.class.isAssignableFrom(type)) {
                Map<String, Map<String, InnerSearchHits>> innerHits;
                Object data = hit.getSource();
                if (data != null) {
                    ClassUtil.ClassInfo classInfo = ClassUtil.getClassInfo(data.getClass());
                    ClassUtil.PropertieDescription injectAnnotationESId = classInfo.getEsIdProperty();
                    ClassUtil.PropertieDescription injectAnnotationESParentId = classInfo.getEsParentProperty();
                    if (injectAnnotationESId != null && injectAnnotationESId.isEsIdReadSet()) {
                        ResultUtil.injectAnnotationESId(injectAnnotationESId, data, hit);
                    }
                    if (injectAnnotationESParentId != null && injectAnnotationESParentId.isEsIdReadSet()) {
                        ResultUtil.injectAnnotationESParentId(injectAnnotationESParentId, data, hit);
                    }
                    boolean isESBaseData = ESBaseData.class.isAssignableFrom(classInfo.getClazz());
                    boolean isESId = false;
                    if (!isESBaseData) {
                        isESId = ESId.class.isAssignableFrom(classInfo.getClazz());
                    }
                    ResultUtil.injectBaseData(data, hit, isESBaseData, isESId);
                }
                if ((innerHits = hit.getInnerHits()) != null && innerHits.size() > 0) {
                    ResultUtil.injectInnerHitBaseData(innerHits);
                }
                return (T)hit;
            }
            ClassUtil.ClassInfo classInfo = ClassUtil.getClassInfo(type);
            ClassUtil.PropertieDescription injectAnnotationESId = classInfo.getEsIdProperty();
            ClassUtil.PropertieDescription injectAnnotationESParentId = classInfo.getEsParentProperty();
            boolean isESBaseData = ESBaseData.class.isAssignableFrom(type);
            boolean isESId = false;
            if (!isESBaseData) {
                isESId = ESId.class.isAssignableFrom(type);
            }
            Object data = hit.getSource();
            if (injectAnnotationESId != null && injectAnnotationESId.isEsIdReadSet()) {
                ResultUtil.injectAnnotationESId(injectAnnotationESId, data, hit);
            }
            if (injectAnnotationESParentId != null && injectAnnotationESParentId.isEsIdReadSet()) {
                ResultUtil.injectAnnotationESParentId(injectAnnotationESParentId, data, hit);
            }
            if (isESBaseData) {
                ResultUtil.buildESBaseData(hit, (ESBaseData)data);
            } else if (isESId) {
                ResultUtil.buildESId(hit, (ESId)data);
            }
            return (T)data;
        }
        return null;
    }

    public static <T> List<T> buildObjects(MGetDocs results, Class<T> type) {
        if (results == null) {
            return null;
        }
        List<SearchHit> hits = results.getDocs();
        if (hits == null) {
            return null;
        }
        ArrayList<T> docs = new ArrayList<T>(hits.size());
        for (SearchHit result : hits) {
            docs.add(ResultUtil.buildObject(result, type));
        }
        return docs;
    }

    public static <T> T buildObject(SearchHit result, Class<T> type) {
        SearchHit hit;
        if (result == null) {
            return null;
        }
        if (SearchHit.class.isAssignableFrom(type)) {
            Map<String, Map<String, InnerSearchHits>> innerHits;
            Object data = result.getSource();
            if (data != null) {
                ClassUtil.ClassInfo classInfo = ClassUtil.getClassInfo(data.getClass());
                ClassUtil.PropertieDescription injectAnnotationESId = classInfo.getEsIdProperty();
                ClassUtil.PropertieDescription injectAnnotationESParentId = classInfo.getEsParentProperty();
                if (injectAnnotationESId != null && injectAnnotationESId.isEsIdReadSet()) {
                    ResultUtil.injectAnnotationESId(injectAnnotationESId, data, result);
                }
                if (injectAnnotationESParentId != null && injectAnnotationESParentId.isEsIdReadSet()) {
                    ResultUtil.injectAnnotationESParentId(injectAnnotationESParentId, data, result);
                }
                boolean isESBaseData = ESBaseData.class.isAssignableFrom(classInfo.getClazz());
                boolean isESId = false;
                if (!isESBaseData) {
                    isESId = ESId.class.isAssignableFrom(classInfo.getClazz());
                }
                ResultUtil.injectBaseData(data, result, isESBaseData, isESId);
            }
            if ((innerHits = result.getInnerHits()) != null && innerHits.size() > 0) {
                ResultUtil.injectInnerHitBaseData(innerHits);
            }
            return (T)result;
        }
        boolean isESBaseData = ESBaseData.class.isAssignableFrom(type);
        boolean isESId = false;
        if (!isESBaseData) {
            isESId = ESId.class.isAssignableFrom(type);
        }
        if ((hit = result).isFound()) {
            Object data = hit.getSource();
            ClassUtil.ClassInfo classInfo = ClassUtil.getClassInfo(type);
            ClassUtil.PropertieDescription injectAnnotationESId = classInfo.getEsIdProperty();
            ClassUtil.PropertieDescription injectAnnotationESParentId = classInfo.getEsParentProperty();
            if (injectAnnotationESId != null && injectAnnotationESId.isEsIdReadSet()) {
                ResultUtil.injectAnnotationESId(injectAnnotationESId, data, hit);
            }
            if (injectAnnotationESParentId != null && injectAnnotationESParentId.isEsIdReadSet()) {
                ResultUtil.injectAnnotationESParentId(injectAnnotationESParentId, data, hit);
            }
            if (isESBaseData) {
                ResultUtil.buildESBaseData(hit, (ESBaseData)data);
            } else if (isESId) {
                ResultUtil.buildESId(hit, (ESId)data);
            }
            return (T)data;
        }
        return null;
    }

    public static <T> SQLResult<T> buildFetchSQLResult(SQLRestResponse result, Class<T> beanType, SQLResult<T> oldPage) {
        if (oldPage != null) {
            result.setColumns(oldPage.getColumns());
        }
        List<T> datas = ResultUtil.buildSQLResult(result, beanType);
        SQLResult<T> _result = new SQLResult<T>();
        _result.setColumns(result.getColumns());
        _result.setRows(result.getRows());
        _result.setCursor(result.getCursor());
        _result.setDatas(datas);
        _result.setBeanType(beanType);
        return _result;
    }

    public static <T> SQLResult<T> buildFetchSQLResult(SQLRestResponse result, Class<T> beanType, ColumnMeta[] metas) {
        result.setColumns(metas);
        List<T> datas = ResultUtil.buildSQLResult(result, beanType);
        SQLResult<T> _result = new SQLResult<T>();
        _result.setColumns(result.getColumns());
        _result.setRows(result.getRows());
        _result.setCursor(result.getCursor());
        _result.setDatas(datas);
        _result.setBeanType(beanType);
        return _result;
    }

    public static <T> List<T> buildSQLResult(SQLRestResponse result, Class<T> type) {
        if (result == null || result.getRows() == null || result.getRows().size() == 0) {
            return null;
        }
        if (result.getRows() != null && result.getRows().size() > 0) {
            List<Object[]> rows = result.getRows();
            ArrayList datas = new ArrayList(rows.size());
            ColumnMeta[] metas = result.getColumns();
            if (Map.class.isAssignableFrom(type)) {
                HashMap<String, Object> data = null;
                for (int i = 0; i < rows.size(); ++i) {
                    Object[] row = rows.get(i);
                    data = new HashMap<String, Object>(metas.length);
                    for (int j = 0; j < metas.length; ++j) {
                        data.put(metas[j].getName(), row[j]);
                    }
                    datas.add(data);
                }
            } else {
                DateFormat defaultDateFormat = SerialUtil.getDateFormateMeta().toDateFormat();
                Object valueObject = null;
                for (int i = 0; i < rows.size(); ++i) {
                    Object[] row = rows.get(i);
                    valueObject = ResultUtil.buildObject(type, metas, row, defaultDateFormat);
                    datas.add(valueObject);
                }
            }
            return datas;
        }
        return null;
    }

    public static <T> T buildSQLObject(SQLRestResponse result, Class<T> type) {
        if (result == null) {
            return null;
        }
        if (result.getRows() != null && result.getRows().size() > 0) {
            List<Object[]> rows = result.getRows();
            ColumnMeta[] metas = result.getColumns();
            if (Map.class.isAssignableFrom(type)) {
                HashMap<String, Object> data = null;
                Object[] row = rows.get(0);
                data = new HashMap<String, Object>(metas.length);
                for (int j = 0; j < metas.length; ++j) {
                    data.put(metas[j].getName(), row[j]);
                }
                return (T)data;
            }
            T valueObject = null;
            Object[] row = rows.get(0);
            DateFormat defaultDateFormat = SerialUtil.getDateFormateMeta().toDateFormat();
            valueObject = ResultUtil.buildObject(type, metas, row, defaultDateFormat);
            return valueObject;
        }
        return null;
    }

    private static <T> T buildObject(Class<T> valueObjectType, ColumnMeta[] meta, Object[] row, DateFormat defaultDateFormat) {
        ClassUtil.ClassInfo beanInfo = ClassUtil.getClassInfo(valueObjectType);
        Object valueObject = null;
        if (!beanInfo.isPrimary()) {
            try {
                valueObject = valueObjectType.newInstance();
            }
            catch (InstantiationException e1) {
                throw new ElasticSearchException(e1);
            }
            catch (IllegalAccessException e1) {
                throw new ElasticSearchException(e1);
            }
            List attributes = beanInfo.getPropertyDescriptors();
            block9: for (int n = 0; attributes != null && n < attributes.size(); ++n) {
                ClassUtil.PropertieDescription attribute = (ClassUtil.PropertieDescription)attributes.get(n);
                ColumnWraper cl = attribute.getColumn();
                if (attribute.getIgnoreORMapping() != null || cl != null && cl.ignorebind()) continue;
                String attrName = attribute.getName();
                String annotationName = null;
                if (BigFile.class.isAssignableFrom(attribute.getPropertyType())) continue;
                ColumnEditorInf editor = null;
                try {
                    if (cl != null) {
                        editor = cl.editor();
                        annotationName = cl.name();
                        if (annotationName != null && !annotationName.equals("")) {
                            attrName = annotationName;
                        }
                    }
                }
                catch (Exception e1) {
                    logger.info(attribute.getName() + " is not a field of bean[" + valueObjectType.getClass().getCanonicalName() + "].");
                }
                for (int i = 0; i < meta.length; ++i) {
                    StringBuilder err;
                    ColumnMeta columnMeta = meta[i];
                    String columnName = columnMeta.getName();
                    if (!attrName.equals(columnName)) continue;
                    Class type = attribute.getPropertyType();
                    Object propsVal = null;
                    Object rowValue = row[i];
                    try {
                        propsVal = ResultUtil.getValueFromRow(rowValue, type, editor, cl, columnMeta, defaultDateFormat);
                    }
                    catch (Exception e) {
                        err = new StringBuilder("Build ValueObject for ResultSet Get Column[").append(columnName).append("] from  ResultSet to ").append(valueObjectType.getClass().getCanonicalName()).append(".").append(attrName).append("[").append(type.getName()).append("] failed:").append(e.getMessage());
                        logger.error(err.toString(), (Throwable)e);
                        continue block9;
                    }
                    try {
                        if (!attribute.canwrite()) continue block9;
                        attribute.setValue(valueObject, propsVal);
                    }
                    catch (Exception e) {
                        err = new StringBuilder("Build ValueObject for ResultSet Get Column[").append(columnName).append("] from  ResultSet to ").append(valueObject).append(".").append(attrName).append("[").append(type.getName()).append("] failed:").append(e.getMessage());
                        logger.error(err.toString(), (Throwable)e);
                    }
                    continue block9;
                }
            }
        } else {
            valueObject = ResultUtil.getValueFromRow(row[0], valueObjectType, null, null, meta[0], defaultDateFormat);
        }
        return (T)valueObject;
    }

    public static Object getValueFromRow(Object value, Class javaType, ColumnEditorInf editor, ColumnWraper columnWraper, ColumnMeta columnMeta, DateFormat defaultDateFormat) {
        if (editor == null || editor instanceof FieldToColumnEditor) {
            if (value == null) {
                return ValueObjectUtil.getDefaultValue((Class)javaType);
            }
            return ResultUtil.convert(value, value.getClass(), javaType, columnWraper, columnMeta, defaultDateFormat);
        }
        return editor.getValueFromObject(columnWraper, value);
    }

    public static boolean isDateType(ColumnMeta columnMeta) {
        return columnMeta.getType().equals("date");
    }

    private static Object convert(Object value, Class type, Class javaType, ColumnWraper columnWraper, ColumnMeta columnMeta, DateFormat defaultDateFormat) {
        try {
            if (javaType == null || value == null) {
                return ValueObjectUtil.getDefaultValue((Class)javaType);
            }
            if (columnWraper == null) {
                if (!ResultUtil.isDateType(columnMeta)) {
                    return ValueObjectUtil.typeCast((Object)value, value.getClass(), (Class)javaType);
                }
                return ValueObjectUtil.typeCastWithDateformat((Object)value, value.getClass(), (Class)javaType, (DateFormat)defaultDateFormat);
            }
            if (!ResultUtil.isDateType(columnMeta)) {
                return ValueObjectUtil.typeCast((Object)value, value.getClass(), (Class)javaType);
            }
            if (columnWraper.getDateFormateMeta() == null) {
                return ValueObjectUtil.typeCastWithDateformat((Object)value, value.getClass(), (Class)javaType, (DateFormat)defaultDateFormat);
            }
            DateFormateMeta dateFormateMeta = columnWraper.getDateFormateMeta();
            return ValueObjectUtil.typeCastWithDateformat((Object)value, value.getClass(), (Class)javaType, (DateFormat)dateFormateMeta.toDateFormat());
        }
        catch (NumberFormatException e) {
            throw new ElasticSearchException(e);
        }
        catch (IllegalArgumentException e) {
            throw new ElasticSearchException(e);
        }
        catch (NoSupportTypeCastException e) {
            throw new ElasticSearchException(e);
        }
        catch (Exception e) {
            throw new ElasticSearchException(e);
        }
    }

    public static <T> ESDatas<T> buildESDatas(RestResponse result, Class<T> type) {
        ESDatas<SearchHit> datas = new ESDatas<SearchHit>();
        RestResponse restResponse = result;
        datas.setRestResponse(restResponse);
        List<SearchHit> searchHits = null;
        if (restResponse.getSearchHits() != null) {
            datas.setTotalSize(restResponse.getSearchHits().getTotal());
            searchHits = restResponse.getSearchHits().getHits();
        }
        datas.setScrollId(restResponse.getScrollId());
        if (SearchHit.class.isAssignableFrom(type)) {
            datas.setAggregations(restResponse.getAggregations());
            if (searchHits != null && searchHits.size() > 0) {
                Object obj = searchHits.get(0).getSource();
                ClassUtil.ClassInfo classInfo = ClassUtil.getClassInfo(obj.getClass());
                ClassUtil.PropertieDescription injectAnnotationESId = classInfo.getEsIdProperty();
                ClassUtil.PropertieDescription injectAnnotationESParentId = classInfo.getEsParentProperty();
                boolean isESBaseData = ESBaseData.class.isAssignableFrom(classInfo.getClazz());
                boolean isESId = false;
                if (!isESBaseData) {
                    isESId = ESId.class.isAssignableFrom(classInfo.getClazz());
                }
                for (int i = 0; i < searchHits.size(); ++i) {
                    Map<String, Map<String, InnerSearchHits>> innerHits;
                    SearchHit hit = searchHits.get(i);
                    Object data = hit.getSource();
                    if (data != null) {
                        if (injectAnnotationESId != null && injectAnnotationESId.isEsIdReadSet()) {
                            ResultUtil.injectAnnotationESId(injectAnnotationESId, data, hit);
                        }
                        if (injectAnnotationESParentId != null && injectAnnotationESParentId.isEsIdReadSet()) {
                            ResultUtil.injectAnnotationESParentId(injectAnnotationESParentId, data, hit);
                        }
                        ResultUtil.injectBaseData(data, hit, isESBaseData, isESId);
                    }
                    if ((innerHits = hit.getInnerHits()) == null || innerHits.size() <= 0) continue;
                    ResultUtil.injectInnerHitBaseData(innerHits);
                }
            }
            datas.setDatas(searchHits);
        } else {
            if (searchHits != null && searchHits.size() > 0) {
                ArrayList<Object> hits = new ArrayList<Object>(searchHits.size());
                boolean isESBaseData = ESBaseData.class.isAssignableFrom(type);
                ClassUtil.ClassInfo classInfo = ClassUtil.getClassInfo(type);
                ClassUtil.PropertieDescription injectAnnotationESId = classInfo.getEsIdProperty();
                ClassUtil.PropertieDescription injectAnnotationESParentId = classInfo.getEsParentProperty();
                boolean isESId = false;
                if (!isESBaseData) {
                    isESId = ESId.class.isAssignableFrom(type);
                }
                Object data = null;
                for (SearchHit hit : searchHits) {
                    Map<String, Map<String, InnerSearchHits>> innerHits;
                    data = hit.getSource();
                    hits.add(data);
                    if (data != null) {
                        if (injectAnnotationESId != null && injectAnnotationESId.isEsIdReadSet()) {
                            ResultUtil.injectAnnotationESId(injectAnnotationESId, data, hit);
                        }
                        if (injectAnnotationESParentId != null && injectAnnotationESParentId.isEsIdReadSet()) {
                            ResultUtil.injectAnnotationESParentId(injectAnnotationESParentId, data, hit);
                        }
                        ResultUtil.injectBaseData(data, hit, isESBaseData, isESId);
                    }
                    if ((innerHits = hit.getInnerHits()) == null || innerHits.size() <= 0) continue;
                    ResultUtil.injectInnerHitBaseData(innerHits);
                }
                datas.setDatas(hits);
            }
            datas.setAggregations(restResponse.getAggregations());
        }
        return datas;
    }

    public static <T> T hand404HttpRuntimeException(ElasticSearchException e, Class<T> type, int operType) {
        Throwable throwable = e.getCause();
        if (throwable == null || !(throwable instanceof HttpRuntimeException)) {
            if (e.getHttpStatusCode() == 404) {
                String errorInfo = e.getMessage();
                if (operType == 0) {
                    return null;
                }
                if (operType == 3) {
                    return null;
                }
                if (operType == 4) {
                    return null;
                }
                if (operType == 5) {
                    return (T)exist;
                }
                if (operType == 6) {
                    return (T)exist;
                }
                if (operType != 7 && operType != 8 && String.class.isAssignableFrom(type)) {
                    return (T)errorInfo;
                }
            }
        } else {
            HttpRuntimeException httpRuntimeException = (HttpRuntimeException)throwable;
            if (httpRuntimeException.getHttpStatusCode() == 404) {
                String errorInfo = httpRuntimeException.getMessage();
                if (operType == 0) {
                    return null;
                }
                if (operType == 3) {
                    return null;
                }
                if (operType == 4) {
                    return null;
                }
                if (operType == 5) {
                    return (T)exist;
                }
                if (operType == 6) {
                    return (T)exist;
                }
                if (operType != 7 && operType != 8 && String.class.isAssignableFrom(type)) {
                    return (T)errorInfo;
                }
            }
        }
        throw e;
    }
}

