/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.elasticsearch.scroll;

import org.frameworkset.elasticsearch.entity.ESDatas;
import org.frameworkset.elasticsearch.scroll.DefualtScrollHandler;
import org.frameworkset.elasticsearch.scroll.DefualtSliceScrollHandler;
import org.frameworkset.elasticsearch.scroll.ScrollHandler;
import org.frameworkset.elasticsearch.scroll.SliceScrollResultInf;

public class SliceScrollResult<T>
implements SliceScrollResultInf<T> {
    private volatile long realTotalSize = 0L;
    private ESDatas<T> sliceResponse;
    private ScrollHandler<T> scrollHandler;
    private boolean useDefaultScrollHandler = false;

    @Override
    public void incrementSize(int size) {
        this.realTotalSize += (long)size;
    }

    @Override
    public ESDatas<T> getSliceResponse() {
        return this.sliceResponse;
    }

    @Override
    public void complete() {
        if (this.sliceResponse == null) {
            return;
        }
        this.sliceResponse.setTotalSize(this.realTotalSize);
        if (!this.useDefaultScrollHandler) {
            this.sliceResponse.setDatas(null);
        }
    }

    @Override
    public void setSliceResponse(ESDatas<T> sliceResponse) {
        if (this.sliceResponse != null) {
            return;
        }
        this.sliceResponse = sliceResponse;
    }

    @Override
    public long getRealTotalSize() {
        return this.realTotalSize;
    }

    @Override
    public ScrollHandler<T> getScrollHandler() {
        return this.scrollHandler;
    }

    @Override
    public ScrollHandler<T> setScrollHandler(ScrollHandler<T> scrollHandler) {
        this.scrollHandler = scrollHandler;
        if (scrollHandler instanceof DefualtScrollHandler) {
            this.useDefaultScrollHandler = true;
        }
        return this.scrollHandler;
    }

    @Override
    public ScrollHandler<T> setScrollHandler(ESDatas<T> sliceResponse) {
        if (this.scrollHandler != null) {
            return this.scrollHandler;
        }
        this.useDefaultScrollHandler = true;
        this.scrollHandler = new DefualtSliceScrollHandler<T>(sliceResponse);
        this.sliceResponse = sliceResponse;
        return this.scrollHandler;
    }
}

