/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.elasticsearch.scroll.thread;

import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlockedTaskRejectedExecutionHandler
implements RejectedExecutionHandler {
    private static Logger logger = LoggerFactory.getLogger(BlockedTaskRejectedExecutionHandler.class);
    private AtomicInteger rejectCounts = new AtomicInteger();
    private long sliceScrollBlockedWaitTimeout;

    public BlockedTaskRejectedExecutionHandler(long sliceScrollBlockedWaitTimeout) {
        this.sliceScrollBlockedWaitTimeout = sliceScrollBlockedWaitTimeout;
    }

    @Override
    public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
        int t;
        int counts = this.rejectCounts.incrementAndGet();
        if (logger.isWarnEnabled() && (t = counts % 100) == 0) {
            logger.warn("Task[Slice Scroll Query] blocked " + counts + " times.");
        }
        try {
            if (this.sliceScrollBlockedWaitTimeout <= 0L) {
                executor.getQueue().put(r);
            } else {
                boolean result = executor.getQueue().offer(r, this.sliceScrollBlockedWaitTimeout, TimeUnit.MILLISECONDS);
                if (!result) {
                    throw new RejectedExecutionException("Task[Slice Scroll Query] rejected: wait timeout after " + this.sliceScrollBlockedWaitTimeout + " MILLISECONDS.");
                }
            }
        }
        catch (InterruptedException e1) {
            throw new RejectedExecutionException(e1);
        }
    }
}

