/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.elasticsearch.template;

import com.frameworkset.util.SimpleStringUtil;
import com.frameworkset.util.VariableHandler;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.frameworkset.cache.EdenConcurrentCache;
import org.frameworkset.cache.MissingStaticCache;
import org.frameworkset.elasticsearch.template.ESInfo;
import org.frameworkset.util.annotations.DateFormateMeta;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ESTemplateCache {
    private static Logger logger = LoggerFactory.getLogger(ESTemplateCache.class);
    private Lock lock = new ReentrantLock();
    private Lock vtplLock = new ReentrantLock();
    private Map<String, VariableHandler.URLStruction> parserTempateStructions = new HashMap<String, VariableHandler.URLStruction>();
    private Map<String, EdenConcurrentCache<String, VariableHandler.URLStruction>> parserVTPLTempateStructions;
    private Map<String, MissingStaticCache<String, VariableHandler.URLStruction>> parserVTPLTempateStructionsMissingCache;
    private static TempateStructionBuiler tempateStructionBuiler = new TempateStructionBuiler();
    private int perKeyDSLStructionCacheSize;
    private boolean alwaysCacheDslStruction = false;

    public ESTemplateCache(int perKeyDSLStructionCacheSize, boolean alwaysCacheDslStruction) {
        this.perKeyDSLStructionCacheSize = perKeyDSLStructionCacheSize;
        this.alwaysCacheDslStruction = alwaysCacheDslStruction;
        if (this.alwaysCacheDslStruction) {
            this.parserVTPLTempateStructions = new HashMap<String, EdenConcurrentCache<String, VariableHandler.URLStruction>>();
        } else {
            this.parserVTPLTempateStructionsMissingCache = new HashMap<String, MissingStaticCache<String, VariableHandler.URLStruction>>();
        }
    }

    public void clear() {
        this.parserTempateStructions.clear();
        if (this.parserVTPLTempateStructions != null) {
            this.parserVTPLTempateStructions.clear();
        }
        if (this.parserVTPLTempateStructionsMissingCache != null) {
            this.parserVTPLTempateStructionsMissingCache.clear();
        }
    }

    public VariableHandler.URLStruction getTemplateStruction(ESInfo sqlinfo, String template) {
        if (sqlinfo.isTpl()) {
            if (this.alwaysCacheDslStruction) {
                return this._getVTPLTemplateStructionAlwaysCache(sqlinfo, template);
            }
            return this._getVTPLTemplateStructionStopCache(sqlinfo, template);
        }
        return this._getTemplateStruction(sqlinfo, template);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VariableHandler.URLStruction _getTemplateStruction(ESInfo sqlinfo, String template) {
        String key = sqlinfo.getTemplateName();
        VariableHandler.URLStruction sqlstruction = this.parserTempateStructions.get(key);
        if (sqlstruction == null) {
            try {
                this.lock.lock();
                sqlstruction = this.parserTempateStructions.get(key);
                if (sqlstruction == null) {
                    sqlstruction = VariableHandler.parserStruction((String)template, (VariableHandler.StructionBuiler)tempateStructionBuiler);
                    this.parserTempateStructions.put(key, sqlstruction);
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return sqlstruction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VariableHandler.URLStruction _getVTPLTemplateStructionStopCache(ESInfo dslinfo, String dsl) {
        String ikey = dsl;
        String okey = dslinfo.getTemplateName();
        MissingStaticCache sqlstructionMap = this.parserVTPLTempateStructionsMissingCache.get(okey);
        if (sqlstructionMap == null) {
            try {
                this.vtplLock.lock();
                sqlstructionMap = this.parserVTPLTempateStructionsMissingCache.get(okey);
                if (sqlstructionMap == null) {
                    sqlstructionMap = new MissingStaticCache(this.perKeyDSLStructionCacheSize);
                    this.parserVTPLTempateStructionsMissingCache.put(okey, (MissingStaticCache<String, VariableHandler.URLStruction>)sqlstructionMap);
                }
            }
            finally {
                this.vtplLock.unlock();
            }
        }
        if (sqlstructionMap.stopCache()) {
            if (logger.isWarnEnabled()) {
                this.logDslStructionWarn(dslinfo, dsl, okey, sqlstructionMap.getMissesMax());
            }
            return VariableHandler.parserStruction((String)dsl, (VariableHandler.StructionBuiler)tempateStructionBuiler);
        }
        VariableHandler.URLStruction urlStruction = (VariableHandler.URLStruction)sqlstructionMap.get((Object)ikey);
        if (urlStruction == null) {
            try {
                this.vtplLock.lock();
                urlStruction = (VariableHandler.URLStruction)sqlstructionMap.get((Object)ikey);
                if (urlStruction == null) {
                    sqlstructionMap.increamentMissing();
                    urlStruction = VariableHandler.parserStruction((String)dsl, (VariableHandler.StructionBuiler)tempateStructionBuiler);
                    if (!sqlstructionMap.stopCache()) {
                        sqlstructionMap.put((Object)ikey, (Object)urlStruction);
                    } else if (logger.isWarnEnabled()) {
                        this.logDslStructionWarn(dslinfo, dsl, okey, sqlstructionMap.getMissesMax());
                    }
                }
            }
            finally {
                this.vtplLock.unlock();
            }
        }
        return urlStruction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VariableHandler.URLStruction _getVTPLTemplateStructionAlwaysCache(ESInfo dslinfo, String dsl) {
        String ikey = dsl;
        String okey = dslinfo.getTemplateName();
        EdenConcurrentCache sqlstructionMap = this.parserVTPLTempateStructions.get(okey);
        if (sqlstructionMap == null) {
            try {
                this.vtplLock.lock();
                sqlstructionMap = this.parserVTPLTempateStructions.get(okey);
                if (sqlstructionMap == null) {
                    sqlstructionMap = new EdenConcurrentCache(this.perKeyDSLStructionCacheSize);
                    this.parserVTPLTempateStructions.put(okey, (EdenConcurrentCache<String, VariableHandler.URLStruction>)sqlstructionMap);
                }
            }
            finally {
                this.vtplLock.unlock();
            }
        }
        VariableHandler.URLStruction urlStruction = (VariableHandler.URLStruction)sqlstructionMap.get((Object)ikey);
        boolean outOfSize = false;
        if (urlStruction == null) {
            try {
                this.vtplLock.lock();
                urlStruction = (VariableHandler.URLStruction)sqlstructionMap.get((Object)ikey);
                if (urlStruction == null) {
                    urlStruction = VariableHandler.parserStruction((String)dsl, (VariableHandler.StructionBuiler)tempateStructionBuiler);
                    outOfSize = sqlstructionMap.put((Object)ikey, (Object)urlStruction);
                }
            }
            finally {
                this.vtplLock.unlock();
            }
            if (outOfSize && logger.isWarnEnabled()) {
                this.logDslStructionWarn(dslinfo, dsl, okey, sqlstructionMap.getMaxSize());
            }
        }
        return urlStruction;
    }

    private void logDslStructionWarn(ESInfo dslinfo, String dsl, String okey, int maxSize) {
        StringBuilder info = new StringBuilder();
        info.append("\n\r**********************************************************************\r\n").append("*********************************WARNING:DSL [").append(okey).append("@").append(dslinfo.getDslFile()).append("]*********************************\r\n").append(dslinfo.getTemplate()).append("\r\n**********************************************************************\r\n").append("When calling method _getVTPLTemplateStruction to obtain [").append(dsl).append("]'s DSL structure information from DSL construction cache, ").append("it was detected that the number of real dsl cache records exceeded the maximum cache size ").append(maxSize).append(" allowed by DSL structure cache.").append("\r\nCause analysis of WARNING:").append("\r\n1.Frequently varying value parameters may exist in this DSL;").append("\r\n2.Variables of the $var pattern that may exist in this DSL and the value of $var changes frequently;").append("\r\nOptimization suggestion\uff1a\r\nIn order to improve the system performance, we can convert the value parameters that may change frequently in this DSL into #[variable] variables or the variables that may exist in the $var mode in DSL into #[varibale] mode variables.").append("\r\nIf you need to convert an array or a list, use the variable #[variable] first and set the serialJson attribute: #[variable, serialJson = true] to improve system performance!").append("\r\nHow to use of #[varibale] pattern variables in foreach loops refers to the section [5.3.3 Logical Judgment and Foreach Loop Example] in the document: https://my.oschina.net/bboss/blog/1556866.").append("\n\r**********************************************************************").append("\n\r**********************************************************************");
        logger.warn(info.toString());
    }

    static class TempateStructionBuiler
    extends VariableHandler.URLStructionBuiler {
        TempateStructionBuiler() {
        }

        public VariableHandler.Variable buildVariable() {
            return new TempateVariable();
        }
    }

    public static class TempateVariable
    extends VariableHandler.Variable {
        protected boolean quoted = true;
        protected String dateFormat;
        protected String locale;
        protected String timeZone;
        private Boolean escape;
        private Boolean serialJson;
        protected DateFormateMeta dateFormateMeta;
        protected String lpad;
        protected String rpad;
        private int escapeCount = 1;

        private String handlePad(String pad_) {
            int idx = pad_.indexOf("|");
            String pad = null;
            if (idx > 0) {
                String value = pad_.substring(0, idx);
                int count = Integer.parseInt(pad_.substring(idx + 1));
                pad = value;
                if (count > 0) {
                    for (int j = 1; j < count; ++j) {
                        pad = pad + value;
                    }
                }
            } else {
                pad = pad_;
            }
            return pad;
        }

        public void after() {
            super.after();
            if (this.attributes != null) {
                String[] ts = this.attributes.split(",");
                for (int i = 0; i < ts.length; ++i) {
                    String escapeCount_;
                    String t = ts[i];
                    if (t.startsWith("quoted=")) {
                        String q = t.substring("quoted=".length()).trim();
                        if (!q.equals("false")) continue;
                        this.quoted = false;
                        continue;
                    }
                    if (t.startsWith("dateformat=")) {
                        this.dateFormat = t.substring("dateformat=".length()).trim();
                        continue;
                    }
                    if (t.startsWith("locale=")) {
                        this.locale = t.substring("locale=".length()).trim();
                        continue;
                    }
                    if (t.startsWith("timezone=")) {
                        this.timeZone = t.substring("timezone=".length()).trim();
                        continue;
                    }
                    if (t.startsWith("lpad=")) {
                        String lpad_ = t.substring("lpad=".length()).trim();
                        this.lpad = this.handlePad(lpad_);
                        continue;
                    }
                    if (t.startsWith("rpad=")) {
                        String rpad_ = t.substring("rpad=".length()).trim();
                        this.rpad = this.handlePad(rpad_);
                        continue;
                    }
                    if (t.startsWith("escape=")) {
                        String escape_ = t.substring("escape=".length()).trim();
                        if (escape_.equals("false")) {
                            this.escape = new Boolean(false);
                            continue;
                        }
                        if (!escape_.equals("true")) continue;
                        this.escape = new Boolean(true);
                        continue;
                    }
                    if (t.startsWith("serialJson=")) {
                        String serialJson_ = t.substring("serialJson=".length()).trim();
                        if (serialJson_.equals("false")) {
                            this.serialJson = new Boolean(false);
                            continue;
                        }
                        if (!serialJson_.equals("true")) continue;
                        this.serialJson = new Boolean(true);
                        continue;
                    }
                    if (!t.startsWith("escapeCount=") || !SimpleStringUtil.isNotEmpty((String)(escapeCount_ = t.substring("escapeCount=".length()).trim()))) continue;
                    try {
                        this.escapeCount = Integer.parseInt(escapeCount_);
                        continue;
                    }
                    catch (Exception e) {
                        logger.error("escapeCount must be a nummber:" + escapeCount_, (Throwable)e);
                    }
                }
                if (this.dateFormat != null) {
                    this.dateFormateMeta = DateFormateMeta.buildDateFormateMeta((String)this.dateFormat, (String)this.locale);
                }
            }
        }

        public boolean isQuoted() {
            return this.quoted;
        }

        public String getDateFormat() {
            return this.dateFormat;
        }

        public String getLocale() {
            return this.locale;
        }

        public DateFormateMeta getDateFormateMeta() {
            return this.dateFormateMeta;
        }

        public String getTimeZone() {
            return this.timeZone;
        }

        public String getLpad() {
            return this.lpad;
        }

        public String getRpad() {
            return this.rpad;
        }

        public Boolean getEscape() {
            return this.escape;
        }

        public void setEscape(Boolean escape) {
            this.escape = escape;
        }

        public int getEscapeCount() {
            return this.escapeCount;
        }

        public void setEscapeCount(int escapeCount) {
            this.escapeCount = escapeCount;
        }

        public Boolean getSerialJson() {
            return this.serialJson;
        }

        public void setSerialJson(Boolean serialJson) {
            this.serialJson = serialJson;
        }
    }
}

