/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.elasticsearch;

import com.frameworkset.util.SimpleStringUtil;
import java.util.Date;
import java.util.Properties;
import java.util.TimeZone;
import org.frameworkset.elasticsearch.IndexNameBuilder;
import org.frameworkset.util.FastDateFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeBasedIndexNameBuilder
implements IndexNameBuilder {
    private static final Logger logger = LoggerFactory.getLogger(TimeBasedIndexNameBuilder.class);
    public static final String DATE_FORMAT = "elasticsearch.dateFormat";
    public static final String TIME_ZONE = "elasticsearch.timeZone";
    public static final String DEFAULT_DATE_FORMAT = "yyyy.MM.dd";
    public static final String DEFAULT_TIME_ZONE = "";
    protected FastDateFormat fastDateFormat = FastDateFormat.getInstance((String)"yyyy.MM.dd", (TimeZone)TimeZone.getTimeZone("Etc/UTC"));
    protected String indexPrefix;

    @Override
    public FastDateFormat getFastDateFormat() {
        return this.fastDateFormat;
    }

    @Override
    public String getCurrentDateString() {
        return this.fastDateFormat.format(new Date());
    }

    @Override
    public String getIndexName(String index) {
        String indexName = index + '-' + this.getCurrentDateString();
        return indexName;
    }

    @Override
    public void configure(Properties elasticsearchPropes) {
        String dateFormatString = elasticsearchPropes.getProperty(DATE_FORMAT);
        String timeZoneString = elasticsearchPropes.getProperty(TIME_ZONE);
        this.indexPrefix = elasticsearchPropes.getProperty("elasticsearch.indexName");
        logger.info("dateFormatString = " + dateFormatString + ",timeZoneString=" + timeZoneString + ",indexPrefix=" + this.indexPrefix);
        if (SimpleStringUtil.isEmpty((String)dateFormatString) || dateFormatString.startsWith("${")) {
            dateFormatString = DEFAULT_DATE_FORMAT;
        }
        if (SimpleStringUtil.isEmpty((String)timeZoneString) || timeZoneString.startsWith("${")) {
            timeZoneString = DEFAULT_TIME_ZONE;
        }
        try {
            this.fastDateFormat = FastDateFormat.getInstance((String)dateFormatString, (TimeZone)TimeZone.getTimeZone(timeZoneString));
        }
        catch (Exception e) {
            logger.warn("\u89e3\u6790\u65f6\u95f4\u683c\u5f0f\u5f02\u5e38[dateFormatString = " + dateFormatString + ",timeZoneString=" + timeZoneString + "],\u5c06\u91c7\u7528\u9ed8\u8ba4\u7684\u65f6\u95f4\u683c\u5f0f\u548c\u65f6\u533a[yyyy.MM.dd Etc/UTC]", (Throwable)e);
        }
    }
}

