/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.elasticsearch.client;

import java.io.IOException;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.frameworkset.elasticsearch.client.ClientOptions;
import org.frameworkset.elasticsearch.client.ResultUtil;
import org.frameworkset.elasticsearch.entity.ESIndice;
import org.frameworkset.elasticsearch.entity.IndexField;
import org.frameworkset.elasticsearch.entity.IndiceHeader;
import org.frameworkset.elasticsearch.serial.CharEscapeUtil;
import org.frameworkset.elasticsearch.serial.SerialUtil;
import org.frameworkset.soa.BBossStringWriter;
import org.frameworkset.util.ClassUtil;

public abstract class BuildTool {
    public static Map<Integer, IndiceHeader> buildIndiceHeaders(String lineHeader) {
        if (lineHeader == null) {
            return null;
        }
        lineHeader = lineHeader.trim();
        HashMap<Integer, IndiceHeader> indiceHeaders = new HashMap<Integer, IndiceHeader>();
        int k = 0;
        IndiceHeader indiceHeader = null;
        StringBuilder token = new StringBuilder();
        for (int j = 0; j < lineHeader.length(); ++j) {
            char c = lineHeader.charAt(j);
            if (c != ' ') {
                token.append(c);
                continue;
            }
            if (token.length() == 0) continue;
            indiceHeader = new IndiceHeader();
            indiceHeader.setHeaderName(token.toString());
            indiceHeader.setPosition(k);
            indiceHeaders.put(k, indiceHeader);
            token.setLength(0);
            ++k;
        }
        if (token.length() > 0) {
            indiceHeader = new IndiceHeader();
            indiceHeader.setHeaderName(token.toString());
            indiceHeader.setPosition(k);
            indiceHeaders.put(k, indiceHeader);
            token.setLength(0);
        }
        return indiceHeaders;
    }

    private static void putField(ESIndice esIndice, Map<Integer, IndiceHeader> indiceHeaders, int position, StringBuilder token, SimpleDateFormat format) {
        IndiceHeader indiceHeader = indiceHeaders.get(position);
        if (indiceHeader.getHeaderName().equals("health")) {
            esIndice.setHealth(token.toString());
            token.setLength(0);
        } else if (indiceHeader.getHeaderName().equals("status")) {
            esIndice.setStatus(token.toString());
            token.setLength(0);
        } else if (indiceHeader.getHeaderName().equals("index")) {
            esIndice.setIndex(token.toString());
            BuildTool.putGendate(esIndice, format);
            token.setLength(0);
        } else if (indiceHeader.getHeaderName().equals("uuid")) {
            esIndice.setUuid(token.toString());
            token.setLength(0);
        } else if (indiceHeader.getHeaderName().equals("pri")) {
            esIndice.setPri(Integer.parseInt(token.toString()));
            token.setLength(0);
        } else if (indiceHeader.getHeaderName().equals("rep")) {
            esIndice.setRep(Integer.parseInt(token.toString()));
            token.setLength(0);
        } else if (indiceHeader.getHeaderName().equals("docs.count")) {
            esIndice.setDocsCcount(Long.parseLong(token.toString()));
            token.setLength(0);
        } else if (indiceHeader.getHeaderName().equals("docs.deleted")) {
            esIndice.setDocsDeleted(Long.parseLong(token.toString()));
            token.setLength(0);
        } else if (indiceHeader.getHeaderName().equals("store.size")) {
            esIndice.setStoreSize(token.toString());
            token.setLength(0);
        } else if (indiceHeader.getHeaderName().equals("pri.store.size")) {
            esIndice.setPriStoreSize(token.toString());
            token.setLength(0);
        } else {
            esIndice.addOtherData(indiceHeader.getHeaderName(), token.toString());
            token.setLength(0);
        }
    }

    public static ESIndice buildESIndice(String line, SimpleDateFormat format, Map<Integer, IndiceHeader> indiceHeaders) {
        StringBuilder token = new StringBuilder();
        ESIndice esIndice = new ESIndice();
        int k = 0;
        for (int j = 0; j < line.length(); ++j) {
            char c = line.charAt(j);
            if (c != ' ') {
                token.append(c);
                continue;
            }
            if (token.length() == 0) continue;
            BuildTool.putField(esIndice, indiceHeaders, k, token, format);
            ++k;
        }
        if (token.length() > 0) {
            BuildTool.putField(esIndice, indiceHeaders, k, token, format);
        }
        return esIndice;
    }

    public static void putGendate(ESIndice esIndice, SimpleDateFormat format) {
        int dsplit = esIndice.getIndex().lastIndexOf(45);
        try {
            if (dsplit > 0) {
                String date = esIndice.getIndex().substring(dsplit + 1);
                esIndice.setGenDate((Date)format.parseObject(date));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String buildGetDocumentRequest(String indexName, String indexType, String documentId, Map<String, Object> options) {
        StringBuilder builder = new StringBuilder();
        builder.append("/").append(indexName).append("/").append(indexType).append("/");
        CharEscapeUtil charEscapeUtil = new CharEscapeUtil((Writer)new BBossStringWriter(builder));
        charEscapeUtil.writeString(documentId, true);
        if (options != null) {
            builder.append("?");
            Iterator<Map.Entry<String, Object>> iterable = options.entrySet().iterator();
            boolean first = true;
            while (iterable.hasNext()) {
                Map.Entry<String, Object> entry = iterable.next();
                if (first) {
                    builder.append(entry.getKey()).append("=").append(entry.getValue());
                    first = false;
                    continue;
                }
                builder.append("&").append(entry.getKey()).append("=").append(entry.getValue());
            }
        }
        return builder.toString();
    }

    public static void buildId(Object id, StringBuilder builder, boolean escape) {
        if (id instanceof String) {
            if (!escape) {
                builder.append("\"").append(id).append("\"");
            } else {
                builder.append("\"");
                CharEscapeUtil charEscapeUtil = new CharEscapeUtil((Writer)new BBossStringWriter(builder));
                charEscapeUtil.writeString((String)id, true);
                builder.append("\"");
            }
        } else {
            builder.append(id);
        }
    }

    public static void buildId(Object id, Writer writer, boolean escape) throws IOException {
        if (id instanceof String) {
            writer.write("\"");
            if (!escape) {
                writer.write((String)id);
            } else {
                CharEscapeUtil charEscapeUtil = new CharEscapeUtil(writer);
                charEscapeUtil.writeString((String)id, true);
            }
            writer.write("\"");
        } else {
            writer.write(String.valueOf(id));
        }
    }

    public static void buildMeta(Writer writer, String indexType, String indexName, Object params, String action, boolean upper7) throws IOException {
        ClassUtil.ClassInfo beanInfo = ClassUtil.getClassInfo(params.getClass());
        Object id = BuildTool.getId(params, beanInfo);
        Object parentId = BuildTool.getParentId(params, beanInfo);
        Object routing = BuildTool.getRouting(params, beanInfo);
        Object esRetryOnConflict = BuildTool.getEsRetryOnConflict(params, beanInfo);
        BuildTool.buildMeta(writer, indexType, indexName, params, action, id, parentId, routing, esRetryOnConflict, upper7);
    }

    public static void buildMetaWithDocIdKey(Writer writer, String indexType, String indexName, Map params, String action, String docIdKey, String parentIdKey, boolean upper7) throws IOException {
        BuildTool.buildMetaWithDocIdKey(writer, indexType, indexName, params, action, docIdKey, parentIdKey, null, upper7);
    }

    public static void buildMetaWithDocIdField(Writer writer, String indexType, String indexName, Object params, String action, String docIdField, String parentIdField, boolean upper7) throws IOException {
        ClientOptions clientOption = new ClientOptions();
        clientOption.setIdField(docIdField);
        clientOption.setParentIdField(parentIdField);
        BuildTool.buildMeta(writer, indexType, indexName, params, action, clientOption, upper7);
    }

    public static void buildMetaWithDocIdKey(Writer writer, String indexType, String indexName, Map params, String action, String docIdKey, String parentIdKey, String routingKey, boolean upper7) throws IOException {
        Object id = docIdKey != null ? params.get(docIdKey) : null;
        Object parentId = parentIdKey != null ? params.get(parentIdKey) : null;
        Object routing = routingKey != null ? params.get(routingKey) : null;
        BuildTool.buildMeta(writer, indexType, indexName, params, action, id, parentId, routing, upper7);
    }

    public static void buildMapMeta(Writer writer, String indexType, String indexName, Map params, String action, ClientOptions clientOptions, boolean upper7) throws IOException {
        Object id = null;
        Object parentId = null;
        Object routing = null;
        Object esRetryOnConflict = null;
        if (clientOptions != null) {
            id = clientOptions.getIdField() != null ? params.get(clientOptions.getIdField()) : null;
            parentId = clientOptions.getParentIdField() != null ? params.get(clientOptions.getParentIdField()) : null;
            routing = clientOptions.getRountField() != null ? params.get(clientOptions.getRountField()) : null;
            esRetryOnConflict = clientOptions.getEsRetryOnConflictField() != null ? params.get(clientOptions.getEsRetryOnConflictField()) : null;
        }
        BuildTool.buildMeta(writer, indexType, indexName, params, action, id, parentId, routing, esRetryOnConflict, upper7);
    }

    public static void buildMeta(Writer writer, String indexType, String indexName, Object params, String action, ClientOptions clientOption, boolean upper7) throws IOException {
        if (params instanceof Map) {
            BuildTool.buildMapMeta(writer, indexType, indexName, (Map)params, action, clientOption, upper7);
            return;
        }
        Object id = null;
        Object parentId = null;
        Object routing = null;
        Object esRetryOnConflict = null;
        Object version = null;
        Object versionType = null;
        if (clientOption != null) {
            ClassUtil.ClassInfo beanClassInfo = ClassUtil.getClassInfo(params.getClass());
            id = clientOption.getIdField() != null ? BuildTool.getId(params, beanClassInfo, clientOption.getIdField()) : null;
            parentId = clientOption.getParentIdField() != null ? BuildTool.getParentId(params, beanClassInfo, clientOption.getParentIdField()) : null;
            routing = clientOption.getRountField() != null ? BuildTool.getRouting(params, beanClassInfo, clientOption.getRountField()) : null;
            esRetryOnConflict = clientOption.getEsRetryOnConflictField() != null ? BuildTool.getEsRetryOnConflict(params, beanClassInfo, clientOption.getEsRetryOnConflictField()) : null;
            version = clientOption.getVersionField() != null ? BuildTool.getEsRetryOnConflict(params, beanClassInfo, clientOption.getVersionField()) : null;
            versionType = clientOption.getVersionTypeField() != null ? BuildTool.getEsRetryOnConflict(params, beanClassInfo, clientOption.getVersionTypeField()) : null;
        }
        BuildTool.buildMeta(writer, indexType, indexName, params, action, id, parentId, routing, esRetryOnConflict, version, versionType, upper7);
    }

    public static void buildMeta(Writer writer, String indexType, String indexName, Object params, String action, Object id, Object parentId, Object routing, boolean upper7) throws IOException {
        BuildTool.buildMeta(writer, indexType, indexName, params, action, id, parentId, routing, null, upper7);
    }

    public static void buildMeta(Writer writer, String indexType, String indexName, Object params, String action, Object id, Object parentId, Object routing, Object esRetryOnConflict, boolean upper7) throws IOException {
        ClassUtil.ClassInfo classInfo = ClassUtil.getClassInfo(params.getClass());
        ClassUtil.PropertieDescription esVersionProperty = classInfo.getEsVersionProperty();
        Object version = null;
        if (esVersionProperty != null) {
            version = classInfo.getPropertyValue(params, esVersionProperty.getName());
        }
        ClassUtil.PropertieDescription esVersionTypeProperty = classInfo.getEsVersionTypeProperty();
        Object versionType = null;
        if (esVersionTypeProperty != null) {
            versionType = classInfo.getPropertyValue(params, esVersionTypeProperty.getName());
        }
        BuildTool.buildMeta(writer, indexType, indexName, params, action, id, parentId, routing, esRetryOnConflict, version, versionType, upper7);
    }

    public static void buildMeta(Writer writer, String indexType, String indexName, Object params, String action, Object id, Object parentId, Object routing, Object esRetryOnConflict, Object version, Object versionType, boolean upper7) throws IOException {
        if (id != null) {
            writer.write("{ \"");
            writer.write(action);
            writer.write("\" : { \"_index\" : \"");
            writer.write(indexName);
            if (!upper7) {
                writer.write("\", \"_type\" : \"");
                writer.write(indexType);
            }
            writer.write("\", \"_id\" : ");
            BuildTool.buildId(id, writer, true);
            if (parentId != null) {
                writer.write(", \"parent\" : ");
                BuildTool.buildId(parentId, writer, true);
            }
            if (routing != null) {
                if (!upper7) {
                    writer.write(", \"_routing\" : ");
                } else {
                    writer.write(", \"routing\" : ");
                }
                BuildTool.buildId(routing, writer, true);
            }
            if (esRetryOnConflict != null) {
                writer.write(",\"_retry_on_conflict\":");
                writer.write(String.valueOf(esRetryOnConflict));
            }
            if (version != null) {
                writer.write(",\"_version\":");
                writer.write(String.valueOf(version));
            }
            if (versionType != null) {
                writer.write(",\"_version_type\":\"");
                writer.write(String.valueOf(versionType));
                writer.write("\"");
            }
            writer.write(" } }\n");
        } else {
            writer.write("{ \"");
            writer.write(action);
            writer.write("\" : { \"_index\" : \"");
            writer.write(indexName);
            if (!upper7) {
                writer.write("\", \"_type\" : \"");
                writer.write(indexType);
            }
            writer.write("\"");
            if (parentId != null) {
                writer.write(", \"parent\" : ");
                BuildTool.buildId(parentId, writer, true);
            }
            if (routing != null) {
                if (!upper7) {
                    writer.write(", \"_routing\" : ");
                } else {
                    writer.write(", \"routing\" : ");
                }
                BuildTool.buildId(routing, writer, true);
            }
            if (esRetryOnConflict != null) {
                writer.write(",\"_retry_on_conflict\":");
                writer.write(String.valueOf(esRetryOnConflict));
            }
            if (version != null) {
                writer.write(",\"_version\":");
                writer.write(String.valueOf(version));
            }
            if (versionType != null) {
                writer.write(",\"_version_type\":\"");
                writer.write(String.valueOf(versionType));
                writer.write("\"");
            }
            writer.write(" } }\n");
        }
    }

    public static void evalBuilk(Writer writer, String indexName, String indexType, Object param, String action, boolean upper7) throws IOException {
        if (param != null) {
            BuildTool.buildMeta(writer, indexType, indexName, param, action, upper7);
            if (!action.equals("update")) {
                SerialUtil.object2json(param, writer);
                writer.write("\n");
            } else {
                Object returnSource;
                Object esDocAsUpsert;
                ClassUtil.ClassInfo classInfo = ClassUtil.getClassInfo(param.getClass());
                ClassUtil.PropertieDescription esDocAsUpsertProperty = classInfo.getEsDocAsUpsertProperty();
                ClassUtil.PropertieDescription esReturnSourceProperty = classInfo.getEsReturnSourceProperty();
                writer.write("{\"doc\":");
                SerialUtil.object2json(param, writer);
                if (esDocAsUpsertProperty != null && (esDocAsUpsert = classInfo.getPropertyValue(param, esDocAsUpsertProperty.getName())) != null) {
                    writer.write(",\"doc_as_upsert\":");
                    writer.write(String.valueOf(esDocAsUpsert));
                }
                if (esReturnSourceProperty != null && (returnSource = classInfo.getPropertyValue(param, esReturnSourceProperty.getName())) != null) {
                    writer.write(",\"_source\":");
                    writer.write(String.valueOf(returnSource));
                }
                writer.write("}\n");
            }
        }
    }

    public static void buildMeta(StringBuilder builder, String indexType, String indexName, Object params, String action) {
        ClassUtil.ClassInfo beanInfo = ClassUtil.getClassInfo(params.getClass());
        Object id = BuildTool.getId(params, beanInfo);
        Object parentId = BuildTool.getParentId(params, beanInfo);
        if (id != null) {
            builder.append("{ \"").append(action).append("\" : { \"_index\" : \"").append(indexName).append("\", \"_type\" : \"").append(indexType).append("\", \"_id\" : ");
            BuildTool.buildId(id, builder, true);
            if (parentId != null) {
                builder.append(",\"parent\":");
                BuildTool.buildId(parentId, builder, true);
            }
            builder.append(" } }\n");
        } else if (parentId == null) {
            builder.append("{ \"").append(action).append("\" : { \"_index\" : \"").append(indexName).append("\", \"_type\" : \"").append(indexType).append("\" } }\n");
        } else {
            builder.append("{ \"").append(action).append("\" : { \"_index\" : \"").append(indexName).append("\", \"_type\" : \"").append(indexType).append("\"");
            builder.append(",\"parent\":");
            BuildTool.buildId(parentId, builder, true);
            builder.append(" } }\n");
        }
    }

    public static void evalBuilk(Writer writer, String indexName, String indexType, Map param, String action, String docIdKey, String parentIdKey, boolean upper7) throws IOException {
        if (param != null) {
            BuildTool.buildMetaWithDocIdKey(writer, indexType, indexName, param, action, docIdKey, parentIdKey, upper7);
            if (!action.equals("update")) {
                SerialUtil.object2json(param, writer);
                writer.write("\n");
            } else {
                writer.write("{\"doc\":");
                SerialUtil.object2json(param, writer);
                writer.write("}\n");
            }
        }
    }

    public static void evalBuilk(Writer writer, String indexName, String indexType, Map param, String action, ClientOptions ClientOptions2, boolean upper7) throws IOException {
        if (param != null) {
            BuildTool.buildMeta(writer, indexType, indexName, param, action, ClientOptions2, upper7);
            if (!action.equals("update")) {
                SerialUtil.object2json(param, writer);
                writer.write("\n");
            } else {
                writer.write("{\"doc\":");
                SerialUtil.object2json(param, writer);
                writer.write("}\n");
            }
        }
    }

    public static void evalBuilk(Writer writer, String indexName, String indexType, Object param, String action, String docIdField, String parentIdField, boolean upper7) throws IOException {
        if (param != null) {
            BuildTool.buildMetaWithDocIdField(writer, indexType, indexName, param, action, docIdField, parentIdField, upper7);
            if (!action.equals("update")) {
                SerialUtil.object2json(param, writer);
                writer.write("\n");
            } else {
                writer.write("{\"doc\":");
                SerialUtil.object2json(param, writer);
                writer.write("}\n");
            }
        }
    }

    public static void evalBuilk(Writer writer, String indexName, String indexType, Object param, String action, ClientOptions clientOptions, boolean upper7) throws IOException {
        if (param != null) {
            BuildTool.buildMeta(writer, indexType, indexName, param, action, clientOptions, upper7);
            if (!action.equals("update")) {
                SerialUtil.object2json(param, writer);
                writer.write("\n");
            } else {
                writer.write("{\"doc\":");
                SerialUtil.object2json(param, writer);
                writer.write("}\n");
            }
        }
    }

    public static void handleFields(Map<String, Object> subFileds, String fieldName, List<IndexField> fields) {
        if (subFileds == null || subFileds.size() == 0) {
            return;
        }
        for (Map.Entry<String, Object> entry : subFileds.entrySet()) {
            IndexField indexField = BuildTool.buildIndexField(entry, fields, fieldName);
        }
    }

    public static Boolean parseBoolean(Object norms) {
        if (norms == null) {
            return null;
        }
        if (norms instanceof Boolean) {
            return (Boolean)norms;
        }
        if (norms instanceof Map) {
            return (Boolean)((Map)norms).get("enabled");
        }
        return null;
    }

    public static IndexField buildIndexField(Map.Entry<String, Object> field, List<IndexField> fields, String parentFieldName) {
        IndexField indexField = new IndexField();
        String fieldName = null;
        fieldName = parentFieldName != null ? parentFieldName + "." + field.getKey() : field.getKey();
        indexField.setFieldName(fieldName);
        Map fieldInfo = (Map)field.getValue();
        indexField.setType((String)fieldInfo.get("type"));
        indexField.setIgnoreAbove(ResultUtil.intValue(fieldInfo.get("ignore_above"), null));
        indexField.setAnalyzer((String)fieldInfo.get("analyzer"));
        indexField.setNormalizer((String)fieldInfo.get("normalizer"));
        indexField.setBoost((Integer)fieldInfo.get("boost"));
        indexField.setCoerce(BuildTool.parseBoolean(fieldInfo.get("coerce")));
        indexField.setCopyTo((String)fieldInfo.get("copy_to"));
        indexField.setDocValues(BuildTool.parseBoolean(fieldInfo.get("doc_values")));
        indexField.setDynamic(BuildTool.parseBoolean(fieldInfo.get("doc_values")));
        indexField.setEnabled(BuildTool.parseBoolean(fieldInfo.get("enabled")));
        indexField.setFielddata(BuildTool.parseBoolean(fieldInfo.get("fielddata")));
        indexField.setFormat((String)fieldInfo.get("format"));
        indexField.setIgnoreMalformed(BuildTool.parseBoolean(fieldInfo.get("ignore_malformed")));
        indexField.setIncludeInAll(BuildTool.parseBoolean(fieldInfo.get("include_in_all")));
        indexField.setIndexOptions((String)fieldInfo.get("index_options"));
        indexField.setIndex(BuildTool.parseBoolean(fieldInfo.get("index")));
        indexField.setFields((Map)fieldInfo.get("fields"));
        indexField.setNorms(BuildTool.parseBoolean(fieldInfo.get("norms")));
        indexField.setNullValue(fieldInfo.get("null_value"));
        indexField.setPositionIncrementGap((Integer)fieldInfo.get("position_increment_gap"));
        indexField.setProperties((Map)fieldInfo.get("properties"));
        indexField.setSearchAnalyzer((String)fieldInfo.get("search_analyzer"));
        indexField.setSimilarity((String)fieldInfo.get("similarity"));
        indexField.setStore(BuildTool.parseBoolean(fieldInfo.get("store")));
        indexField.setTermVector((String)fieldInfo.get("term_vector"));
        fields.add(indexField);
        BuildTool.handleFields(indexField.getFields(), fieldName, fields);
        return indexField;
    }

    public static Object getId(Object bean, ClassUtil.ClassInfo beanInfo) {
        ClassUtil.PropertieDescription pkProperty = beanInfo.getEsIdProperty();
        if (pkProperty == null) {
            return null;
        }
        return beanInfo.getPropertyValue(bean, pkProperty.getName());
    }

    public static Object getId(Object bean, ClassUtil.ClassInfo beanInfo, String docIdField) {
        if (docIdField == null) {
            return null;
        }
        return beanInfo.getPropertyValue(bean, docIdField);
    }

    public static Object getEsRetryOnConflict(Object bean, ClassUtil.ClassInfo beanInfo) {
        ClassUtil.PropertieDescription esRetryOnConflictProperty = beanInfo.getEsRetryOnConflictProperty();
        if (esRetryOnConflictProperty == null) {
            return null;
        }
        return beanInfo.getPropertyValue(bean, esRetryOnConflictProperty.getName());
    }

    public static Object getEsRetryOnConflict(Object bean, ClassUtil.ClassInfo beanInfo, String esRetryOnConflictField) {
        if (esRetryOnConflictField == null) {
            return null;
        }
        return beanInfo.getPropertyValue(bean, esRetryOnConflictField);
    }

    public static Object getRouting(Object bean, ClassUtil.ClassInfo beanInfo) {
        ClassUtil.PropertieDescription routingProperty = beanInfo.getEsRoutingProperty();
        if (routingProperty == null) {
            return null;
        }
        return beanInfo.getPropertyValue(bean, routingProperty.getName());
    }

    public static Object getRouting(Object bean, ClassUtil.ClassInfo beanInfo, String routingField) {
        if (routingField == null) {
            return null;
        }
        return beanInfo.getPropertyValue(bean, routingField);
    }

    public static Object getParentId(Object bean, ClassUtil.ClassInfo beanInfo) {
        ClassUtil.PropertieDescription pkProperty = beanInfo.getEsParentProperty();
        if (pkProperty == null) {
            return null;
        }
        return beanInfo.getPropertyValue(bean, pkProperty.getName());
    }

    public static Object getParentId(Object bean, ClassUtil.ClassInfo beanInfo, String parentIdField) {
        if (parentIdField == null) {
            return null;
        }
        return beanInfo.getPropertyValue(bean, parentIdField);
    }
}

