/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.elasticsearch.template;

import bboss.org.apache.velocity.VelocityContext;
import bboss.org.apache.velocity.context.Context;
import com.frameworkset.util.VariableHandler;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import org.frameworkset.elasticsearch.ElasticSearchException;
import org.frameworkset.elasticsearch.serial.SerialUtil;
import org.frameworkset.elasticsearch.template.ESInfo;
import org.frameworkset.elasticsearch.template.ESTemplate;
import org.frameworkset.elasticsearch.template.ESUtil;
import org.frameworkset.soa.BBossStringWriter;
import org.frameworkset.util.ClassUtil;

public class ESTemplateHelper {
    private static String evalNullParamsTemplate(ESUtil esUtil, String templateName, ESInfo esInfo) {
        if (!esInfo.isTpl()) {
            return esInfo.getTemplate();
        }
        ESTemplate esTemplate = esInfo.getEstpl();
        esTemplate.process();
        if (esInfo.isTpl()) {
            VelocityContext vcontext = esUtil.buildVelocityContext();
            BBossStringWriter sw = new BBossStringWriter();
            esTemplate.merge((Context)vcontext, (Writer)sw);
            return sw.toString();
        }
        return esInfo.getTemplate();
    }

    public static String evalTemplate(ESUtil esUtil, String templateName, Map params) {
        ESInfo esInfo = esUtil.getESInfo(templateName);
        if (esInfo == null) {
            throw new ElasticSearchException("ElasticSearch Template [" + templateName + "]@" + esUtil.getRealTemplateFile() + " \u672a\u5b9a\u4e49.");
        }
        if (params == null || params.size() == 0) {
            return ESTemplateHelper.evalNullParamsTemplate(esUtil, templateName, esInfo);
        }
        String template = null;
        if (esInfo.isTpl()) {
            ESTemplate esTemplate = esInfo.getEstpl();
            esTemplate.process();
            if (esInfo.isTpl()) {
                VelocityContext vcontext = esUtil.buildVelocityContext(params);
                BBossStringWriter sw = new BBossStringWriter();
                esTemplate.merge((Context)vcontext, (Writer)sw);
                StringBuilder builder = new StringBuilder();
                VariableHandler.URLStruction struction = esInfo.getTemplateStruction(sw.toString());
                template = ESTemplateHelper.evalDocumentStruction(esUtil, builder, struction, params, templateName, null);
            } else {
                StringBuilder builder = new StringBuilder();
                VariableHandler.URLStruction struction = esInfo.getTemplateStruction(esInfo.getTemplate());
                template = ESTemplateHelper.evalDocumentStruction(esUtil, builder, struction, params, templateName, null);
            }
        } else {
            StringBuilder builder = new StringBuilder();
            VariableHandler.URLStruction struction = esInfo.getTemplateStruction(esInfo.getTemplate());
            template = ESTemplateHelper.evalDocumentStruction(esUtil, builder, struction, params, templateName, null);
        }
        return template;
    }

    public static Object getId(Object bean) {
        ClassUtil.ClassInfo beanInfo = ClassUtil.getClassInfo(bean.getClass());
        ClassUtil.PropertieDescription pkProperty = beanInfo.getPkProperty();
        if (pkProperty == null) {
            return null;
        }
        return beanInfo.getPropertyValue(bean, pkProperty.getName());
    }

    public static String evalTemplate(ESUtil esUtil, String templateName, Object params) {
        if (params != null && params instanceof Map) {
            return ESTemplateHelper.evalTemplate(esUtil, templateName, (Map)params);
        }
        ESInfo esInfo = esUtil.getESInfo(templateName);
        if (esInfo == null) {
            throw new ElasticSearchException("ElasticSearch Template [" + templateName + "]@" + esUtil.getRealTemplateFile() + " \u672a\u5b9a\u4e49.");
        }
        if (params == null) {
            return ESTemplateHelper.evalNullParamsTemplate(esUtil, templateName, esInfo);
        }
        String template = null;
        if (esInfo.isTpl()) {
            esInfo.getEstpl().process();
            if (esInfo.isTpl()) {
                VelocityContext vcontext = esUtil.buildVelocityContext(params);
                BBossStringWriter sw = new BBossStringWriter();
                esInfo.getEstpl().merge((Context)vcontext, (Writer)sw);
                VariableHandler.URLStruction struction = esInfo.getTemplateStruction(sw.toString());
                StringBuilder builder = new StringBuilder();
                template = ESTemplateHelper.evalDocumentStruction(esUtil, builder, struction, params, templateName, null);
            } else {
                VariableHandler.URLStruction struction = esInfo.getTemplateStruction(esInfo.getTemplate());
                StringBuilder builder = new StringBuilder();
                template = ESTemplateHelper.evalDocumentStruction(esUtil, builder, struction, params, templateName, null);
            }
        } else {
            VariableHandler.URLStruction struction = esInfo.getTemplateStruction(esInfo.getTemplate());
            StringBuilder builder = new StringBuilder();
            template = ESTemplateHelper.evalDocumentStruction(esUtil, builder, struction, params, templateName, null);
        }
        return template;
    }

    public static void buildMeta(StringBuilder builder, String indexType, String indexName, Object params, String action, boolean upper7) {
        Object id = ESTemplateHelper.getId(params);
        if (!upper7) {
            if (id != null) {
                builder.append("{ \"").append(action).append("\" : { \"_index\" : \"").append(indexName).append("\", \"_type\" : \"").append(indexType).append("\", \"_id\" : \"").append(id).append("\" } }\n");
            } else {
                builder.append("{ \"").append(action).append("\" : { \"_index\" : \"").append(indexName).append("\", \"_type\" : \"").append(indexType).append("\" } }\n");
            }
        } else if (id != null) {
            builder.append("{ \"").append(action).append("\" : { \"_index\" : \"").append(indexName).append("\", \"_id\" : \"").append(id).append("\" } }\n");
        } else {
            builder.append("{ \"").append(action).append("\" : { \"_index\" : \"").append(indexName).append("\" } }\n");
        }
    }

    public static void buildMeta(Writer writer, String indexType, String indexName, Object params, String action, boolean upper7) throws IOException {
        Object id = ESTemplateHelper.getId(params);
        if (id != null) {
            writer.write("{ \"");
            writer.write(action);
            writer.write("\" : { \"_index\" : \"");
            writer.write(indexName);
            if (!upper7) {
                writer.write("\", \"_type\" : \"");
                writer.write(indexType);
            }
            writer.write("\", \"_id\" : \"");
            writer.write(String.valueOf(id));
            writer.write("\" } }\n");
        } else {
            writer.write("{ \"");
            writer.write(action);
            writer.write("\" : { \"_index\" : \"");
            writer.write(indexName);
            if (!upper7) {
                writer.write("\", \"_type\" : \"");
                writer.write(indexType);
            }
            writer.write("\" } }\n");
        }
    }

    public static void evalBuilk(Writer writer, String indexName, String indexType, Object param, String action, boolean upper7) throws IOException {
        if (param != null) {
            ESTemplateHelper.buildMeta(writer, indexType, indexName, param, action, upper7);
            if (!action.equals("update")) {
                SerialUtil.object2json(param, writer);
                writer.write("\n");
            } else {
                writer.write("{\"doc\":");
                SerialUtil.object2json(param, writer);
                writer.write("}\n");
            }
        }
    }

    public static void evalBuilkTemplate(ESUtil esUtil, StringBuilder builder, String indexName, String indexType, String templateName, Object params, String action, boolean upper7) {
        ESInfo esInfo = esUtil.getESInfo(templateName);
        if (esInfo == null) {
            throw new ElasticSearchException("ElasticSearch Template [" + templateName + "]@" + esUtil.getRealTemplateFile() + " \u672a\u5b9a\u4e49.");
        }
        if (params == null) {
            ESTemplateHelper.buildMeta(builder, indexType, indexName, params, action, upper7);
            String template = ESTemplateHelper.evalNullParamsTemplate(esUtil, templateName, esInfo);
            if (!action.equals("update")) {
                builder.append(template).append("\n");
            } else {
                builder.append("{\"doc\":").append(template).append("}\n");
            }
            return;
        }
        if (esInfo.isTpl()) {
            esInfo.getEstpl().process();
            if (esInfo.isTpl()) {
                ESTemplateHelper.buildMeta(builder, indexType, indexName, params, action, upper7);
                VelocityContext vcontext = esUtil.buildVelocityContext(params);
                BBossStringWriter sw = new BBossStringWriter();
                esInfo.getEstpl().merge((Context)vcontext, (Writer)sw);
                VariableHandler.URLStruction struction = esInfo.getTemplateStruction(sw.toString());
                ESTemplateHelper.evalStruction(esUtil, builder, struction, params, templateName, action);
            } else {
                ESTemplateHelper.buildMeta(builder, indexType, indexName, params, action, upper7);
                VariableHandler.URLStruction struction = esInfo.getTemplateStruction(esInfo.getTemplate());
                ESTemplateHelper.evalStruction(esUtil, builder, struction, params, templateName, action);
            }
        } else {
            ESTemplateHelper.buildMeta(builder, indexType, indexName, params, action, upper7);
            VariableHandler.URLStruction struction = esInfo.getTemplateStruction(esInfo.getTemplate());
            ESTemplateHelper.evalStruction(esUtil, builder, struction, params, templateName, action);
        }
    }

    public static String evalDocumentTemplate(ESUtil esUtil, StringBuilder builder, String indexType, String indexName, String templateName, Object params, String action) {
        ESInfo esInfo = esUtil.getESInfo(templateName);
        if (esInfo == null) {
            throw new ElasticSearchException("ElasticSearch Template [" + templateName + "]@" + esUtil.getRealTemplateFile() + " \u672a\u5b9a\u4e49.");
        }
        if (params == null) {
            String template = ESTemplateHelper.evalNullParamsTemplate(esUtil, templateName, esInfo);
            return template;
        }
        if (esInfo.isTpl()) {
            esInfo.getEstpl().process();
            if (esInfo.isTpl()) {
                VelocityContext vcontext = esUtil.buildVelocityContext(params);
                BBossStringWriter sw = new BBossStringWriter(builder);
                esInfo.getEstpl().merge((Context)vcontext, (Writer)sw);
                VariableHandler.URLStruction struction = esInfo.getTemplateStruction(sw.toString());
                builder.setLength(0);
                return ESTemplateHelper.evalDocumentStruction(esUtil, builder, struction, params, templateName, action);
            }
            VariableHandler.URLStruction struction = esInfo.getTemplateStruction(esInfo.getTemplate());
            return ESTemplateHelper.evalDocumentStruction(esUtil, builder, struction, params, templateName, action);
        }
        VariableHandler.URLStruction struction = esInfo.getTemplateStruction(esInfo.getTemplate());
        return ESTemplateHelper.evalDocumentStruction(esUtil, builder, struction, params, templateName, action);
    }

    public static void evalStruction(ESUtil esUtil, StringBuilder builder, VariableHandler.URLStruction struction, Object params, String templateName, String action) {
        if (!struction.hasVars()) {
            if (!action.equals("update")) {
                builder.append(struction.getUrl()).append("\n");
            } else {
                builder.append("{\"doc\":").append(struction.getUrl()).append("}\n");
            }
        } else if (!action.equals("update")) {
            esUtil.evalStruction(builder, struction, params, templateName);
            builder.append("\n");
        } else {
            builder.append("{\"doc\":");
            esUtil.evalStruction(builder, struction, params, templateName);
            builder.append("}\n");
        }
    }

    public static void evalStruction(ESUtil esUtil, StringBuilder builder, VariableHandler.URLStruction struction, Map params, String templateName, String action) {
        if (!struction.hasVars()) {
            if (!action.equals("update")) {
                builder.append(struction.getUrl()).append("\n");
            } else {
                builder.append("{\"doc\":").append(struction.getUrl()).append("}\n");
            }
        } else if (!action.equals("update")) {
            esUtil.evalStruction(builder, struction, params, templateName);
            builder.append("\n");
        } else {
            builder.append("{\"doc\":");
            esUtil.evalStruction(builder, struction, params, templateName);
            builder.append("}\n");
        }
    }

    public static String evalDocumentStruction(ESUtil esUtil, StringBuilder builder, VariableHandler.URLStruction struction, Map params, String templateName, String action) {
        if (!struction.hasVars()) {
            return struction.getUrl();
        }
        esUtil.evalStruction(builder, struction, params, templateName);
        return builder.toString();
    }

    public static String evalDocumentStruction(ESUtil esUtil, StringBuilder builder, VariableHandler.URLStruction struction, Object params, String templateName, String action) {
        if (!struction.hasVars()) {
            return struction.getUrl();
        }
        esUtil.evalStruction(builder, struction, params, templateName);
        return builder.toString();
    }
}

