/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.elasticsearch.client;

import java.util.Iterator;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.frameworkset.elasticsearch.client.ESAddress;
import org.frameworkset.elasticsearch.client.NoServerElasticSearchException;

public class RoundRobinList {
    private final List<ESAddress> elements;
    private Iterator<ESAddress> iterator;
    private String message;
    private final Lock lock = new ReentrantLock();

    public RoundRobinList(List<ESAddress> elements) {
        this.elements = elements;
        this.message = "All elasticsearch server " + elements.toString() + " can't been connected.";
        this.iterator = this.elements.iterator();
    }

    public void addAddresses(List<ESAddress> address) {
        try {
            this.lock.lock();
            this.elements.addAll(address);
            this.message = "All elasticsearch server " + this.elements.toString() + " can't been connected.";
            this.iterator = this.elements.iterator();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ESAddress _get() {
        try {
            this.lock.lock();
            ESAddress address2 = null;
            ESAddress temp = null;
            while (this.iterator.hasNext()) {
                address2 = this.iterator.next();
                if (!address2.ok()) continue;
                temp = address2;
                break;
            }
            if (temp != null) {
                ESAddress eSAddress = temp;
                return eSAddress;
            }
            for (ESAddress address2 : this.elements) {
                if (!address2.ok()) continue;
                temp = address2;
                break;
            }
            if (temp == null) {
                throw new NoServerElasticSearchException(this.message);
            }
            ESAddress eSAddress = temp;
            return eSAddress;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ESAddress _getOkOrFailed() {
        try {
            this.lock.lock();
            ESAddress address2 = null;
            ESAddress temp = null;
            while (this.iterator.hasNext()) {
                address2 = this.iterator.next();
                if (!address2.okOrFailed()) continue;
                temp = address2;
                break;
            }
            if (temp != null) {
                ESAddress eSAddress = temp;
                return eSAddress;
            }
            for (ESAddress address2 : this.elements) {
                if (!address2.okOrFailed()) continue;
                temp = address2;
                break;
            }
            if (temp == null) {
                throw new NoServerElasticSearchException(this.message);
            }
            ESAddress eSAddress = temp;
            return eSAddress;
        }
        finally {
            this.lock.unlock();
        }
    }

    public ESAddress get(boolean failAllContinue) {
        ESAddress esAddress = this._get();
        if (esAddress != null || !failAllContinue) {
            return esAddress;
        }
        return this._getOkOrFailed();
    }

    public int size() {
        return this.elements.size();
    }
}

