/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.elasticsearch.handler;

import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.frameworkset.elasticsearch.ElasticSearchException;
import org.frameworkset.elasticsearch.entity.MapRestResponse;
import org.frameworkset.elasticsearch.handler.BaseExceptionResponseHandler;
import org.frameworkset.spi.remote.http.URLResponseHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticSearchMapResponseHandler
extends BaseExceptionResponseHandler
implements URLResponseHandler<MapRestResponse> {
    private static Logger logger = LoggerFactory.getLogger(ElasticSearchMapResponseHandler.class);

    public MapRestResponse handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
        int status = this.initStatus(response);
        if (status >= 200 && status < 300) {
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                try {
                    return (MapRestResponse)super.converJson(entity, MapRestResponse.class);
                }
                catch (Exception e) {
                    throw new ElasticSearchException("Request url:" + this.url, e, status);
                }
            }
            return null;
        }
        HttpEntity entity = response.getEntity();
        return (MapRestResponse)super.handleException(this.url, entity, status);
    }
}

