/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.elasticsearch.serial;

import com.fasterxml.jackson.core.io.CharTypes;
import java.io.IOException;
import java.io.Writer;
import org.frameworkset.elasticsearch.serial.CharEscapeUtil;

public class CustomCharEscapeUtil
extends CharEscapeUtil {
    private static final int[] _customOutputEscapes;
    private boolean esEncode;

    public CustomCharEscapeUtil(Writer w, int features, boolean esEncode) {
        super(w, features);
        this.esEncode = esEncode;
    }

    public CustomCharEscapeUtil(boolean esEncode) {
        this.esEncode = esEncode;
    }

    public CustomCharEscapeUtil(Writer w, boolean esEncode) {
        super(w);
        this.esEncode = esEncode;
    }

    @Override
    public void _writeString(String text) throws IOException {
        if (this.esEncode) {
            text = CustomCharEscapeUtil.escape(text);
        }
        super._writeString(text);
    }

    static {
        int[] temp = new int[128];
        int[] sOutputEscapes = CharTypes.get7BitOutputEscapes();
        for (int i = 0; i < sOutputEscapes.length; ++i) {
            temp[i] = sOutputEscapes[i];
        }
        temp[43] = 43;
        temp[45] = 45;
        temp[33] = 33;
        temp[40] = 40;
        temp[41] = 41;
        temp[58] = 58;
        temp[94] = 94;
        temp[91] = 91;
        temp[93] = 93;
        temp[123] = 123;
        temp[125] = 125;
        temp[126] = 126;
        temp[42] = 42;
        temp[63] = 63;
        temp[124] = 124;
        temp[38] = 38;
        temp[47] = 47;
        _customOutputEscapes = temp;
    }
}

