/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.elasticsearch.template;

import com.frameworkset.util.DaemonThread;
import com.frameworkset.util.ResourceInitial;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.frameworkset.elasticsearch.template.AOPTemplateMeta;
import org.frameworkset.elasticsearch.template.BaseTemplateMeta;
import org.frameworkset.elasticsearch.template.ESSOAFileApplicationContext;
import org.frameworkset.elasticsearch.template.ESUtil;
import org.frameworkset.elasticsearch.template.TemplateContainer;
import org.frameworkset.elasticsearch.template.TemplateMeta;
import org.frameworkset.spi.BaseApplicationContext;
import org.frameworkset.spi.assemble.Pro;
import org.frameworkset.spi.runtime.BaseStarter;
import org.frameworkset.spi.runtime.Starter;
import org.frameworkset.util.ResourceUtils;

public class AOPTemplateContainerImpl
implements TemplateContainer {
    private BaseApplicationContext templatecontext;
    private String baseDir;

    public AOPTemplateContainerImpl(String baseDir, BaseApplicationContext templatecontext) {
        this.templatecontext = templatecontext;
        this.baseDir = baseDir;
    }

    public AOPTemplateContainerImpl(BaseApplicationContext templatecontext) {
        this.templatecontext = templatecontext;
    }

    @Override
    public String getNamespace() {
        return this.templatecontext.getConfigfile();
    }

    @Override
    public Set<String> getTempalteNames() {
        return this.templatecontext.getPropertyKeys();
    }

    @Override
    public TemplateMeta getProBean(String templateName) {
        return new AOPTemplateMeta(this.templatecontext.getProBean(templateName));
    }

    @Override
    public void destroy(boolean clearContext) {
        this.templatecontext.destroy(clearContext);
    }

    @Override
    public int getPerKeyDSLStructionCacheSize() {
        return this.templatecontext.getIntProperty("perKeyDSLStructionCacheSize", 2000);
    }

    @Override
    public boolean isAlwaysCacheDslStruction() {
        return this.templatecontext.getBooleanProperty("alwaysCacheDslStruction", false);
    }

    @Override
    public synchronized void reinit(ESUtil esUtil) {
        String file = this.templatecontext.getConfigfile();
        this.templatecontext.removeCacheContext();
        ESSOAFileApplicationContext essoaFileApplicationContext = new ESSOAFileApplicationContext(this.baseDir, file);
        if (essoaFileApplicationContext.getParserError() == null) {
            this.templatecontext.destroy(false);
            this.templatecontext = essoaFileApplicationContext;
            esUtil.buildTemplateDatas(this);
        } else {
            this.templatecontext.restoreCacheContext();
        }
    }

    @Override
    public void monitor(DaemonThread daemonThread, ResourceInitial resourceTempateRefresh) {
        if (this.baseDir == null) {
            daemonThread.addFile(this.templatecontext.getConfigFileURL(), this.getNamespace(), resourceTempateRefresh);
        } else {
            daemonThread.addFile(this.templatecontext.getConfigFileURL(), ResourceUtils.getRealPath((String)this.baseDir, (String)this.getNamespace()), resourceTempateRefresh);
        }
    }

    public List<TemplateMeta> getTemplateMetas(final String namespace) {
        final ArrayList<TemplateMeta> templateMetaList = new ArrayList<TemplateMeta>();
        this.templatecontext.start((Starter)new BaseStarter(){

            public void start(Pro pro, BaseApplicationContext ioc) {
                Object _service = ioc.getBeanObject(pro.getName());
                if (_service == null || pro.getName().equals("perKeyDSLStructionCacheSize") || pro.getName().equals("alwaysCacheDslStruction")) {
                    return;
                }
                BaseTemplateMeta baseTemplateMeta = new BaseTemplateMeta();
                baseTemplateMeta.setName(pro.getName());
                baseTemplateMeta.setNamespace(namespace);
                String templateFile = (String)pro.getExtendAttribute("templateFile");
                if (templateFile == null) {
                    Object o = pro.getObject();
                    if (o != null && o instanceof String) {
                        String value = (String)o;
                        baseTemplateMeta.setDslTemplate(value);
                        baseTemplateMeta.setVtpl(pro.getBooleanExtendAttribute("istpl", true));
                        baseTemplateMeta.setMultiparser(pro.getBooleanExtendAttribute("multiparser", baseTemplateMeta.getVtpl().booleanValue()));
                        templateMetaList.add(baseTemplateMeta);
                    }
                } else {
                    String templateName = (String)pro.getExtendAttribute("templateName");
                    if (templateName == null) {
                        this.logger.warn("Ignore this DSL template " + pro.getName() + " in the DSl file " + AOPTemplateContainerImpl.this.getNamespace() + " is defined as a reference to the DSL template in another configuration file " + templateFile + ", but the name of the DSL template statement to be referenced is not specified by the templateName attribute, for example:\r\n" + "<property name= \"querySqlTraces\"\r\n" + "templateFile= \"esmapper/estrace/ESTracesMapper.xml\"\r\n" + "templateName= \"queryTracesByCriteria\"/>");
                    } else {
                        baseTemplateMeta.setReferenceNamespace(templateFile);
                        baseTemplateMeta.setReferenceTemplateName(templateName);
                        baseTemplateMeta.setVtpl(false);
                        baseTemplateMeta.setMultiparser(false);
                        templateMetaList.add(baseTemplateMeta);
                    }
                }
            }
        });
        return templateMetaList;
    }
}

