/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.elasticsearch.template;

import bboss.org.apache.velocity.VelocityContext;
import bboss.org.apache.velocity.context.Context;
import bboss.org.apache.velocity.runtime.resource.Resource;
import com.frameworkset.util.ColumnEditorInf;
import com.frameworkset.util.ColumnToFieldEditor;
import com.frameworkset.util.ColumnType;
import com.frameworkset.util.DaemonThread;
import com.frameworkset.util.ResourceInitial;
import com.frameworkset.util.VariableHandler;
import com.frameworkset.velocity.BBossVelocityUtil;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.frameworkset.elasticsearch.ElasticSearchException;
import org.frameworkset.elasticsearch.ElasticSearchHelper;
import org.frameworkset.elasticsearch.ElasticsearchParseException;
import org.frameworkset.elasticsearch.serial.CustomCharEscapeUtil;
import org.frameworkset.elasticsearch.serial.SerialUtil;
import org.frameworkset.elasticsearch.template.AOPTemplateContainerImpl;
import org.frameworkset.elasticsearch.template.ESInfo;
import org.frameworkset.elasticsearch.template.ESSOAFileApplicationContext;
import org.frameworkset.elasticsearch.template.ESTemplate;
import org.frameworkset.elasticsearch.template.ESTemplateCache;
import org.frameworkset.elasticsearch.template.TemplateContainer;
import org.frameworkset.elasticsearch.template.TemplateMeta;
import org.frameworkset.soa.BBossStringWriter;
import org.frameworkset.spi.BaseApplicationContext;
import org.frameworkset.util.ClassUtil;
import org.frameworkset.util.annotations.DateFormateMeta;
import org.frameworkset.util.annotations.wraper.ColumnWraper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ESUtil {
    protected TemplateContainer templatecontext;
    private static Logger log = LoggerFactory.getLogger(ESUtil.class);
    protected static Map<String, ESUtil> esutils = new HashMap<String, ESUtil>();
    protected static long refresh_interval = 5000L;
    public static final int defaultPerKeyDSLStructionCacheSize = 2000;
    public static final boolean defaultAlwaysCacheDslStruction = false;
    protected int perKeyDSLStructionCacheSize;
    protected boolean alwaysCacheDslStruction;
    protected ESTemplateCache templateCache;
    protected Map<String, ESInfo> esInfos;
    protected Map<String, ESRef> esrefs;
    protected boolean hasrefs;
    protected String templateFile;
    protected String dslMappingDir;
    protected String realTemplateFile;
    protected boolean destroyed = false;
    static DaemonThread damon = null;
    private static Object lock;

    public VariableHandler.URLStruction getTempateStruction(ESInfo esInfo, String template) {
        return this.templateCache.getTemplateStruction(esInfo, template);
    }

    public TemplateContainer getTemplatecontext() {
        return this.templatecontext;
    }

    public VelocityContext buildVelocityContext(Object bean) {
        VelocityContext context_ = new VelocityContext();
        ClassUtil.ClassInfo beanInfo = ClassUtil.getClassInfo(bean.getClass());
        String name = null;
        DateFormateMeta dataformat = null;
        Object value = null;
        List attributes = beanInfo.getPropertyDescriptors();
        for (int i = 0; attributes != null && i < attributes.size(); ++i) {
            ClassUtil.PropertieDescription property = (ClassUtil.PropertieDescription)attributes.get(i);
            ColumnWraper column = property.getColumn();
            if (column != null && (column.ignoreCUDbind() || column.ignorebind())) continue;
            try {
                if (property.canread()) {
                    try {
                        value = property.getValue(bean);
                    }
                    catch (InvocationTargetException e1) {
                        log.error("Failed to get attribute[" + beanInfo.getClazz().getName() + "." + property.getName() + "] value:", e1.getTargetException());
                    }
                    catch (Exception e1) {
                        log.error("Failed to get attribute[" + beanInfo.getClazz().getName() + "." + property.getName() + "] value:", (Throwable)e1);
                    }
                    name = property.getName();
                    if (column != null) {
                        ColumnEditorInf editor = column.editor();
                        if (editor == null || editor instanceof ColumnToFieldEditor) {
                            dataformat = column.getDateFormateMeta();
                        } else {
                            Object cv = editor.toColumnValue(column, value);
                            if (cv == null) {
                                throw new ElasticSearchException("\u8f6c\u6362\u5c5e\u6027[" + beanInfo.getClazz().getName() + "." + property.getName() + "]\u503c\u5931\u8d25\uff1a\u503c\u4e3anull\u65f6\uff0c\u8f6c\u6362\u5668\u5fc5\u987b\u8fd4\u56deColumnType\u7c7b\u578b\u7684\u5bf9\u8c61,\u7528\u6765\u6307\u793a\u8868\u5b57\u6bb5\u5bf9\u5e94\u7684java\u7c7b\u578b\u3002");
                            }
                            if (!(cv instanceof ColumnType)) {
                                value = cv;
                            }
                        }
                    }
                    context_.put(name, value);
                }
                name = null;
                value = null;
                dataformat = null;
                continue;
            }
            catch (SecurityException e) {
                throw new ElasticSearchException(e);
            }
            catch (IllegalArgumentException e) {
                throw new ElasticSearchException(e);
            }
            catch (Exception e) {
                throw new ElasticSearchException(e);
            }
        }
        return context_;
    }

    public VelocityContext buildVelocityContext(Map data) {
        VelocityContext context_ = new VelocityContext();
        Iterator it = data.entrySet().iterator();
        Object temp = null;
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            temp = entry.getValue();
            context_.put((String)entry.getKey(), temp);
        }
        return context_;
    }

    public VelocityContext buildVelocityContext() {
        VelocityContext context_ = new VelocityContext();
        return context_;
    }

    public static String getDate(Date date) {
        return ESUtil.getDate(date, (DateFormateMeta)null);
    }

    public static String getDate(Date date, DateFormateMeta dateFormateMeta) {
        Object format = null;
        DateFormat f = null;
        if (dateFormateMeta == null) {
            dateFormateMeta = SerialUtil.getDateFormateMeta();
        }
        f = dateFormateMeta.toDateFormat();
        try {
            String _date = f.format(date);
            return _date;
        }
        catch (Exception e) {
            throw new ElasticSearchException(e);
        }
    }

    public static String getDate(Date date, DateFormat f) {
        try {
            String _date = f.format(date);
            return _date;
        }
        catch (Exception e) {
            throw new ElasticSearchException(e);
        }
    }

    public void handleVaribleValue(StringBuilder builder, ESTemplateCache.TempateVariable variable, String value, boolean escape) {
        int escapeCount = variable.getEscapeCount();
        if (variable.isQuoted()) {
            if (escapeCount <= 1) {
                builder.append("\"");
            } else {
                for (int i = 0; i < escapeCount - 1; ++i) {
                    builder.append("\\");
                }
                builder.append("\"");
            }
        }
        if (variable.getLpad() != null || variable.getRpad() != null) {
            StringBuilder innerValue = new StringBuilder();
            if (variable.getLpad() != null) {
                innerValue.append(variable.getLpad());
            }
            innerValue.append(value);
            if (variable.getRpad() != null) {
                innerValue.append(variable.getRpad());
            }
            if (!escape) {
                builder.append(innerValue.toString());
            } else if (escapeCount <= 1) {
                CustomCharEscapeUtil charEscapeUtil = new CustomCharEscapeUtil((Writer)new BBossStringWriter(builder), variable.getEsEncode());
                charEscapeUtil.writeString(innerValue.toString(), true);
            } else {
                String innerValueString = innerValue.toString();
                innerValue.setLength(0);
                for (int i = 0; i < escapeCount; ++i) {
                    CustomCharEscapeUtil charEscapeUtil = new CustomCharEscapeUtil((Writer)new BBossStringWriter(innerValue), variable.getEsEncode());
                    charEscapeUtil.writeString(innerValueString, true);
                    innerValueString = innerValue.toString();
                    innerValue.setLength(0);
                }
                builder.append(innerValueString);
            }
        } else if (!escape) {
            builder.append(value);
        } else if (escapeCount <= 1) {
            CustomCharEscapeUtil charEscapeUtil = new CustomCharEscapeUtil((Writer)new BBossStringWriter(builder), variable.getEsEncode());
            charEscapeUtil.writeString(value, true);
        } else {
            StringBuilder innerValue = new StringBuilder();
            for (int i = 0; i < escapeCount; ++i) {
                CustomCharEscapeUtil charEscapeUtil = new CustomCharEscapeUtil((Writer)new BBossStringWriter(innerValue), variable.getEsEncode());
                charEscapeUtil.writeString(value, true);
                value = innerValue.toString();
                innerValue.setLength(0);
            }
            builder.append(value);
        }
        if (variable.isQuoted()) {
            if (escapeCount <= 1) {
                builder.append("\"");
            } else {
                for (int i = 0; i < escapeCount - 1; ++i) {
                    builder.append("\\");
                }
                builder.append("\"");
            }
        }
    }

    public void getVariableValue(StringBuilder builder, ESTemplateCache.TempateVariable variable, Object bean, List<ClassUtil.PropertieDescription> attributes, ClassUtil.ClassInfo beanInfo, String template) {
        String name = null;
        DateFormateMeta dataformat = variable.getDateFormateMeta();
        Boolean escape = variable.getEscape();
        Object value = null;
        Class<?> type = null;
        for (int i = 0; attributes != null && i < attributes.size(); ++i) {
            ColumnWraper column;
            ClassUtil.PropertieDescription property = attributes.get(i);
            if (!property.getName().equals(variable.getVariableName()) || (column = property.getColumn()) != null && (column.ignoreCUDbind() || column.ignorebind())) continue;
            type = property.getPropertyType();
            try {
                if (property.canread()) {
                    String value_;
                    try {
                        value = property.getValue(bean);
                    }
                    catch (InvocationTargetException e1) {
                        log.error("Failed to get attribute[" + beanInfo.getClazz().getName() + ("." + property.getName()) + "] value:Check the template definition" + "[" + template + "]@" + this.templatecontext.getNamespace(), e1.getTargetException());
                    }
                    catch (Exception e1) {
                        log.error("Failed to get attribute[" + beanInfo.getClazz().getName() + ("." + property.getName()) + "] value:Check the template definition" + "[" + template + "]@" + this.templatecontext.getNamespace(), (Throwable)e1);
                    }
                    name = property.getName();
                    if (column != null) {
                        ColumnEditorInf editor;
                        if (escape == null) {
                            escape = column.isEscape();
                        }
                        if ((editor = column.editor()) == null || editor instanceof ColumnToFieldEditor) {
                            if (dataformat == null) {
                                dataformat = column.getDateFormateMeta();
                            }
                        } else {
                            Object cv = editor.toColumnValue(column, value);
                            if (cv == null) {
                                throw new ElasticSearchException("Transform property[" + beanInfo.getClazz().getName() + "." + property.getName() + "] value failed: When the value is null, the converter must return an object of ColumnType type to indicate the Java type corresponding to the table field. Check the template definition" + "[" + template + "]@" + this.templatecontext.getNamespace());
                            }
                            if (!(cv instanceof ColumnType)) {
                                value = cv;
                                type = value.getClass();
                            } else {
                                type = ((ColumnType)cv).getType();
                            }
                        }
                    }
                    if (value == null) {
                        builder.append("null");
                    } else if (value instanceof Date) {
                        value_ = ESUtil.getDate((Date)value, dataformat);
                        this.handleVaribleValue(builder, variable, value_, false);
                    } else if ((value = VariableHandler.evaluateVariableValue((VariableHandler.Variable)variable, (Object)value)) == null) {
                        builder.append("null");
                    } else if (value instanceof String) {
                        if (escape == null) {
                            this.handleVaribleValue(builder, variable, (String)value, true);
                        } else {
                            this.handleVaribleValue(builder, variable, (String)value, escape);
                        }
                    } else if (value instanceof Date) {
                        value_ = ESUtil.getDate((Date)value, dataformat);
                        this.handleVaribleValue(builder, variable, value_, false);
                    } else {
                        this.handleObject(variable, builder, value);
                    }
                }
                name = null;
                value = null;
                dataformat = null;
                return;
            }
            catch (SecurityException e) {
                throw new ElasticSearchException("Failed to convert attribute values: Check template definitions" + "[" + template + "]@" + this.templatecontext.getNamespace(), e);
            }
            catch (IllegalArgumentException e) {
                throw new ElasticSearchException("Failed to convert attribute values: Check template definitions" + "[" + template + "]@" + this.templatecontext.getNamespace(), e);
            }
            catch (Exception e) {
                throw new ElasticSearchException(e);
            }
        }
        throw new ElasticsearchParseException(beanInfo.getClazz().getName() + "No value are specified for variable" + "[" + variable.getVariableName() + "] of the elasticsearch dsl template[" + template + "]@" + this.templatecontext.getNamespace());
    }

    public void evalStruction(StringBuilder builder, VariableHandler.URLStruction templateStruction, Object bean, String template) {
        List tokens = templateStruction.getTokens();
        List variables = templateStruction.getVariables();
        ClassUtil.ClassInfo beanInfo = ClassUtil.getClassInfo(bean.getClass());
        List attributes = beanInfo.getPropertyDescriptors();
        for (int i = 0; i < tokens.size(); ++i) {
            builder.append((String)tokens.get(i));
            if (i >= variables.size()) continue;
            ESTemplateCache.TempateVariable variable = (ESTemplateCache.TempateVariable)((Object)variables.get(i));
            this.getVariableValue(builder, variable, bean, attributes, beanInfo, template);
        }
    }

    public void evalStruction(StringBuilder builder, VariableHandler.URLStruction templateStruction, Map bean, String template) {
        List tokens = templateStruction.getTokens();
        List variables = templateStruction.getVariables();
        for (int i = 0; i < tokens.size(); ++i) {
            String value_;
            builder.append((String)tokens.get(i));
            if (i >= variables.size()) continue;
            ESTemplateCache.TempateVariable variable = (ESTemplateCache.TempateVariable)((Object)variables.get(i));
            Boolean escape = variable.getEscape();
            Object data = bean.get(variable.getVariableName());
            if (data == null) {
                if (bean.containsKey(variable.getVariableName())) {
                    builder.append("null");
                    continue;
                }
                throw new ElasticsearchParseException("No value are specified for variable" + "[" + variable.getVariableName() + "] of the elasticsearch dsl template[" + template + "]@" + this.templatecontext.getNamespace() + " Error dsl:\r\n" + builder.toString() + "\r\n Dsl from config file:\r\n" + templateStruction.getUrl());
            }
            Object value = data;
            if (value instanceof Date) {
                value_ = ESUtil.getDate((Date)value, variable.getDateFormateMeta());
                this.handleVaribleValue(builder, variable, value_, false);
                continue;
            }
            if ((value = VariableHandler.evaluateVariableValue((VariableHandler.Variable)variable, value)) == null) {
                builder.append("null");
                continue;
            }
            if (value instanceof Date) {
                value_ = ESUtil.getDate((Date)value, variable.getDateFormateMeta());
                this.handleVaribleValue(builder, variable, value_, false);
                continue;
            }
            if (value instanceof String) {
                if (escape == null) {
                    this.handleVaribleValue(builder, variable, (String)value, true);
                    continue;
                }
                this.handleVaribleValue(builder, variable, (String)value, escape);
                continue;
            }
            this.handleObject(variable, builder, value);
        }
    }

    private void handleObject(ESTemplateCache.TempateVariable variable, StringBuilder builder, Object value) {
        if (variable.getSerialJson() == null || !variable.getSerialJson().booleanValue()) {
            if (variable.getLpad() != null) {
                builder.append(variable.getLpad());
            }
            builder.append(value.toString());
            if (variable.getRpad() != null) {
                builder.append(variable.getRpad());
            }
        } else {
            int escapeCount = variable.getEscapeCount();
            if (escapeCount <= 1) {
                builder.append(SerialUtil.object2json(value));
            } else {
                String _value = SerialUtil.object2json(value);
                StringBuilder innerValue = new StringBuilder();
                for (int i = 0; i < escapeCount - 1; ++i) {
                    CustomCharEscapeUtil charEscapeUtil = new CustomCharEscapeUtil((Writer)new BBossStringWriter(innerValue), variable.getEsEncode());
                    charEscapeUtil.writeString(_value, true);
                    _value = innerValue.toString();
                    innerValue.setLength(0);
                }
                builder.append(_value);
            }
        }
    }

    public Map<String, ESRef> getESRefers() {
        return this.esrefs;
    }

    public static String ltrim(String value) {
        int st;
        int len = value.length();
        for (st = 0; st < len && value.charAt(st) <= ' '; ++st) {
        }
        return st > 0 ? value.substring(st, len) : value;
    }

    public static String rtrim(String value) {
        int len;
        int st = 0;
        for (len = value.length(); st < len && value.charAt(len - 1) <= ' '; --len) {
        }
        return len < value.length() ? value.substring(st, len) : value;
    }

    private void trimValues() {
        if (this.templatecontext == null) {
            return;
        }
        HashMap<String, ESInfo> esInfos = new HashMap<String, ESInfo>();
        HashMap<String, ESRef> esrefs = new HashMap<String, ESRef>();
        Set<String> keys = this.templatecontext.getTempalteNames();
        if (keys != null && keys.size() > 0) {
            for (String key : keys) {
                TemplateMeta pro = this.templatecontext.getProBean(key);
                String templateFile = pro.getReferenceNamespace();
                if (templateFile == null) {
                    String value;
                    Object o = pro.getDslTemplate();
                    if (!(o instanceof String) || (value = (String)o) == null) continue;
                    boolean cache = pro.getCache() != null ? pro.getCache() : true;
                    boolean istpl = pro.getVtpl() != null ? pro.getVtpl() : true;
                    boolean multiparser = pro.getMultiparser() != null ? pro.getMultiparser() : istpl;
                    ESTemplate sqltpl = null;
                    value = ESUtil.ltrim(value);
                    ESInfo sqlinfo = new ESInfo(key, value, istpl, multiparser, pro, cache);
                    sqlinfo.setEsUtil(this);
                    if (istpl) {
                        sqltpl = new ESTemplate(sqlinfo);
                        sqlinfo.setEstpl(sqltpl);
                        BBossVelocityUtil.initElasticTemplate((Resource)sqltpl);
                        try {
                            sqltpl.process();
                        }
                        catch (Exception e) {
                            log.error(sqlinfo.getTemplate(), (Throwable)e);
                        }
                    }
                    esInfos.put(key, sqlinfo);
                    continue;
                }
                String templateName = pro.getReferenceTemplateName();
                if (templateName == null) {
                    log.warn("The DSL template " + key + " in the DSl file " + this.templatecontext.getNamespace() + " is defined as a reference to the DSL template in another configuration file " + templateFile + ", but the name of the DSL template statement to be referenced is not specified by the templateName attribute, for example:\r\n" + "<property name= \"querySqlTraces\"\r\n" + "templateFile= \"esmapper/estrace/ESTracesMapper.xml\"\r\n" + "templateName= \"queryTracesByCriteria\"/>");
                    continue;
                }
                esrefs.put(key, new ESRef(templateName, templateFile, key, this.dslMappingDir));
                this.hasrefs = true;
            }
        }
        this.esInfos = esInfos;
        this.esrefs = esrefs;
    }

    public boolean hasrefs() {
        return this.hasrefs;
    }

    void _destroy() {
        this.destroyed = true;
        if (this.esInfos != null) {
            this.esInfos.clear();
            this.esInfos = null;
        }
        if (this.esrefs != null) {
            this.esrefs.clear();
            this.esrefs = null;
        }
        this.templateCache.clear();
        if (this.templatecontext != null) {
            this.templatecontext.destroy(true);
        }
    }

    void buildTemplateDatas(TemplateContainer newTemplateContainer) {
        this.templatecontext = newTemplateContainer;
        this.trimValues();
        this.perKeyDSLStructionCacheSize = this.templatecontext.getPerKeyDSLStructionCacheSize();
        this.alwaysCacheDslStruction = this.templatecontext.isAlwaysCacheDslStruction();
        this.templateCache = new ESTemplateCache(this.perKeyDSLStructionCacheSize, this.alwaysCacheDslStruction);
        this.destroyed = false;
    }

    void reinit() {
        this.templatecontext.reinit(this);
    }

    public static void stopmonitor() {
        try {
            if (damon != null) {
                damon.stopped();
                damon = null;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public String getTemplateFile() {
        return this.templatecontext.getNamespace();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkESUtil() {
        refresh_interval = ElasticSearchHelper.getDslfileRefreshInterval();
        if (refresh_interval > 0L) {
            if (damon == null) {
                Object object = lock;
                synchronized (object) {
                    if (damon == null) {
                        damon = new DaemonThread(refresh_interval, "ElasticSearch DSL Template Refresh Worker");
                        damon.start();
                    }
                }
            }
            this.templatecontext.monitor(damon, new ResourceTempateRefresh(this));
        } else {
            log.debug("ElasticSearch DSL Template Refresh Interval:" + refresh_interval + ",ignore hotload DSL Template[" + this.templatecontext.getNamespace() + "]");
        }
    }

    private ESUtil(String dslMappingDir, String templatefile) {
        this.templateFile = templatefile;
        this.dslMappingDir = dslMappingDir;
        this.templatecontext = new AOPTemplateContainerImpl(dslMappingDir, (BaseApplicationContext)new ESSOAFileApplicationContext(dslMappingDir, templatefile));
        this.perKeyDSLStructionCacheSize = this.templatecontext.getPerKeyDSLStructionCacheSize();
        this.alwaysCacheDslStruction = this.templatecontext.isAlwaysCacheDslStruction();
        this.templateCache = new ESTemplateCache(this.perKeyDSLStructionCacheSize, this.alwaysCacheDslStruction);
        this.realTemplateFile = this.templatecontext.getNamespace();
        this.trimValues();
        this.checkESUtil();
    }

    private ESUtil(TemplateContainer templateContainer) {
        this.templatecontext = templateContainer;
        this.perKeyDSLStructionCacheSize = this.templatecontext.getPerKeyDSLStructionCacheSize();
        this.alwaysCacheDslStruction = this.templatecontext.isAlwaysCacheDslStruction();
        this.templateCache = new ESTemplateCache(this.perKeyDSLStructionCacheSize, this.alwaysCacheDslStruction);
        this.realTemplateFile = this.templatecontext.getNamespace();
        this.trimValues();
        this.checkESUtil();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ESUtil getInstance(TemplateContainer templateContainer) {
        String namespace = templateContainer.getNamespace();
        ESUtil sqlUtil = esutils.get(namespace);
        if (sqlUtil != null) {
            return sqlUtil;
        }
        Map<String, ESUtil> map = esutils;
        synchronized (map) {
            sqlUtil = esutils.get(namespace);
            if (sqlUtil != null) {
                return sqlUtil;
            }
            sqlUtil = new ESUtil(templateContainer);
            esutils.put(namespace, sqlUtil);
        }
        return sqlUtil;
    }

    public static ESUtil getInstance(String templateFile) {
        return ESUtil.getInstance(ElasticSearchHelper.getDslfileMappingDir(), templateFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ESUtil getInstance(String dslMappingDir, String templateFile) {
        ESUtil sqlUtil = esutils.get(templateFile);
        if (sqlUtil != null) {
            return sqlUtil;
        }
        Map<String, ESUtil> map = esutils;
        synchronized (map) {
            sqlUtil = esutils.get(templateFile);
            if (sqlUtil != null) {
                return sqlUtil;
            }
            sqlUtil = new ESUtil(dslMappingDir, templateFile);
            esutils.put(templateFile, sqlUtil);
        }
        return sqlUtil;
    }

    static void destory() {
        if (esutils != null) {
            for (Map.Entry<String, ESUtil> entry : esutils.entrySet()) {
                entry.getValue()._destroy();
            }
            esutils.clear();
            esutils = null;
        }
    }

    private ESInfo getReferESInfo(String templateName) {
        ESRef ref;
        if (this.assertDestoried()) {
            return null;
        }
        ESRef eSRef = ref = this.esrefs != null ? this.esrefs.get(templateName) : null;
        if (ref != null) {
            return ref.getESInfo();
        }
        return null;
    }

    public ESInfo getESInfo(String templateName) {
        if (templateName == null || templateName.equals("")) {
            throw new ElasticsearchParseException("Dsl templateName cann't been empty or null.");
        }
        if (this.assertDestoried()) {
            return null;
        }
        ESInfo sql = null;
        if (this.hasrefs && (sql = this.getReferESInfo(templateName)) != null) {
            return sql;
        }
        if (this.esInfos != null) {
            sql = this.esInfos.get(templateName);
        }
        return sql;
    }

    public String getPlainTemplate(String templateName) {
        if (this.assertDestoried()) {
            return null;
        }
        ESInfo sql = null;
        if (this.hasrefs && (sql = this.getReferESInfo(templateName)) != null) {
            return sql.getTemplate();
        }
        if (this.esInfos != null) {
            sql = this.esInfos.get(templateName);
        }
        if (sql != null) {
            return sql.getTemplate();
        }
        return null;
    }

    private String getReferTemplate(String templateName) {
        ESRef ref;
        if (this.assertDestoried()) {
            return null;
        }
        ESRef eSRef = ref = this.esrefs != null ? this.esrefs.get(templateName) : null;
        if (ref != null) {
            return ref.getTemplate();
        }
        return null;
    }

    private boolean assertDestoried() {
        return this.destroyed;
    }

    public String getTemplate(String templateName) {
        String sql;
        if (this.assertDestoried()) {
            return null;
        }
        if (this.hasrefs && (sql = this.getReferTemplate(templateName)) != null) {
            return sql;
        }
        ESInfo esInfo = this.esInfos != null ? this.esInfos.get(templateName) : null;
        return esInfo != null ? esInfo.getTemplate() : null;
    }

    private String getReferTemplate(String templateName, Map variablevalues) {
        ESRef ref;
        if (this.assertDestoried()) {
            return null;
        }
        ESRef eSRef = ref = this.esrefs != null ? this.esrefs.get(templateName) : null;
        if (ref != null) {
            return ref.getTemplate(variablevalues);
        }
        return null;
    }

    public String getTemplate(String templateName, Map variablevalues) {
        ESInfo sql;
        String sql2;
        if (this.assertDestoried()) {
            return null;
        }
        if (this.hasrefs && (sql2 = this.getReferTemplate(templateName, variablevalues)) != null) {
            return sql2;
        }
        String newsql = null;
        ESInfo eSInfo = sql = this.esInfos != null ? this.esInfos.get(templateName) : null;
        if (sql != null) {
            newsql = ESUtil._getTemplate(sql, variablevalues);
        }
        return newsql;
    }

    public static String _getTemplate(ESInfo sqlinfo, Map variablevalues) {
        String sql = null;
        VelocityContext vcontext = null;
        if (sqlinfo.isTpl()) {
            sqlinfo.getEstpl().process();
            if (sqlinfo.isTpl()) {
                vcontext = BBossVelocityUtil.buildVelocityContext((Map)variablevalues);
                StringWriter sw = new StringWriter();
                sqlinfo.getEstpl().merge((Context)vcontext, sw);
                sql = sw.toString();
            } else {
                sql = sqlinfo.getTemplate();
            }
        } else {
            sql = sqlinfo.getTemplate();
        }
        return sql;
    }

    public String evaluateSQL(String name, String sql, Map variablevalues) {
        if (sql != null && variablevalues != null && variablevalues.size() > 0) {
            sql = BBossVelocityUtil.evaluate((Map)variablevalues, (String)(this.templatecontext.getNamespace() + "|" + name), (String)sql);
        }
        return sql;
    }

    public String[] getPropertyKeys() {
        Set<String> keys = this.templatecontext.getTempalteNames();
        if (keys == null) {
            return new String[0];
        }
        String[] rets = new String[keys.size()];
        Iterator<String> its = keys.iterator();
        int i = 0;
        while (its.hasNext()) {
            rets[i] = its.next();
            ++i;
        }
        return rets;
    }

    public TemplateContainer getTemplateContext() {
        return this.templatecontext;
    }

    public long getRefresh_interval() {
        return refresh_interval;
    }

    public static List<String> getTemplateFiles() {
        Iterator<String> it = esutils.keySet().iterator();
        ArrayList<String> files = new ArrayList<String>();
        while (it.hasNext()) {
            files.add(it.next());
        }
        return files;
    }

    public boolean fromConfig() {
        return this.templatecontext != null;
    }

    public String getRealTemplateFile() {
        return this.realTemplateFile;
    }

    static {
        BaseApplicationContext.addShutdownHook((Runnable)new Runnable(){

            @Override
            public void run() {
                ESUtil.stopmonitor();
                ESUtil.destory();
            }
        });
        lock = new Object();
    }

    static class ResourceTempateRefresh
    implements ResourceInitial {
        private ESUtil sqlutil;

        public ResourceTempateRefresh(ESUtil sqlutil) {
            this.sqlutil = sqlutil;
        }

        public void reinit() {
            this.sqlutil.reinit();
        }
    }

    public static class ESRef {
        private String dslMappingDir;
        private ESUtil esutil;
        private String esname;
        private String templatefile;
        private String name;

        public ESRef(String esname, String templatefile, String name, String dslMappingDir) {
            this.esname = esname;
            this.templatefile = templatefile;
            this.name = name;
            this.dslMappingDir = dslMappingDir;
        }

        public String getESname() {
            return this.esname;
        }

        public String getTemplatefile() {
            return this.templatefile;
        }

        public String getName() {
            return this.name;
        }

        public ESInfo getESInfo() {
            if (this.esutil == null) {
                this.init();
            }
            return this.esutil.getESInfo(this.esname);
        }

        private synchronized void init() {
            if (this.esutil == null) {
                this.esutil = ESUtil.getInstance(this.dslMappingDir, this.templatefile);
            }
        }

        public String getTemplate() {
            if (this.esutil == null) {
                this.init();
            }
            return this.esutil.getTemplate(this.esname);
        }

        public String getTemplate(Map variablevalues) {
            if (this.esutil == null) {
                this.init();
            }
            return this.esutil.getTemplate(this.esname, variablevalues);
        }
    }
}

