/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.elasticsearch.client;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.ResponseHandler;
import org.frameworkset.elasticsearch.ElasticSearchHelper;
import org.frameworkset.elasticsearch.client.ClientInterface;
import org.frameworkset.spi.assemble.GetProperties;
import org.frameworkset.spi.remote.http.ClientConfiguration;
import org.frameworkset.spi.remote.http.HttpHost;
import org.frameworkset.spi.remote.http.ResponseUtil;
import org.frameworkset.spi.remote.http.proxy.HttpHostDiscover;
import org.frameworkset.spi.remote.http.proxy.HttpServiceHostsConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticsearchHostNodeDiscover
extends HttpHostDiscover {
    private final JsonFactory jsonFactory = new JsonFactory();
    private static Logger logger = LoggerFactory.getLogger(ElasticsearchHostNodeDiscover.class);
    private long discoverInterval = 10000L;

    protected List<HttpHost> discover(HttpServiceHostsConfig httpServiceHostsConfig, final ClientConfiguration configuration, GetProperties context) {
        try {
            final ArrayList<HttpHost> hosts = new ArrayList<HttpHost>();
            ClientInterface clientInterface = ElasticSearchHelper.getRestClientUtil(configuration.getBeanName());
            clientInterface.executeHttp("_nodes/http", "get", new ResponseHandler<Void>(){

                public Void handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
                    List hostsNew;
                    int status = response.getStatusLine().getStatusCode();
                    if (ResponseUtil.isHttpStatusOK((int)status) && (hostsNew = ElasticsearchHostNodeDiscover.this.readHosts(response.getEntity(), configuration)) != null && hostsNew.size() > 0) {
                        hosts.addAll(hostsNew);
                    }
                    return null;
                }
            });
            return hosts;
        }
        catch (Exception e) {
            if (logger.isInfoEnabled()) {
                logger.info("Discovery elasticsearch[" + configuration.getBeanName() + "] node failed:", (Throwable)e);
            }
            return null;
        }
    }

    /*
     * Loose catch block
     */
    private List<HttpHost> readHosts(HttpEntity entity, ClientConfiguration configuration) throws IOException {
        InputStream inputStream = null;
        IOException var3 = null;
        try {
            inputStream = entity.getContent();
            if (ResponseUtil.entityEmpty((HttpEntity)entity, (InputStream)inputStream)) {
                throw new IOException("Read Hosts from http entity for elasticsearch[" + configuration.getBeanName() + "] failed: entity contentLength = 0 ");
            }
            JsonParser parser = this.jsonFactory.createParser(inputStream);
            if (parser.nextToken() != JsonToken.START_OBJECT) {
                throw new IOException("expected data to start with an object for elasticsearch[" + configuration.getBeanName() + "]");
            }
            ArrayList<HttpHost> hosts = new ArrayList<HttpHost>();
            block10: while (true) {
                if (parser.nextToken() == JsonToken.END_OBJECT) {
                    ArrayList<HttpHost> var18;
                    ArrayList<HttpHost> arrayList = var18 = hosts;
                    return arrayList;
                }
                if (parser.getCurrentToken() != JsonToken.START_OBJECT) continue;
                if ("nodes".equals(parser.getCurrentName())) {
                    while (true) {
                        if (parser.nextToken() == JsonToken.END_OBJECT) continue block10;
                        JsonToken token = parser.nextToken();
                        assert (token == JsonToken.START_OBJECT);
                        String nodeId = parser.getCurrentName();
                        HttpHost sniffedHost = this.readHost(nodeId, parser, configuration);
                        if (sniffedHost == null) continue;
                        if (logger.isTraceEnabled()) {
                            logger.trace("Adding node [" + nodeId + "] for elasticsearch[" + configuration.getBeanName() + "]");
                        }
                        hosts.add(sniffedHost);
                    }
                }
                parser.skipChildren();
                continue;
                break;
            }
            catch (IOException var16) {
                var3 = var16;
                throw var16;
            }
        }
        finally {
            if (inputStream != null) {
                if (var3 != null) {
                    try {
                        inputStream.close();
                    }
                    catch (Throwable throwable) {}
                } else {
                    inputStream.close();
                }
            }
        }
    }

    private HttpHost readHost(String nodeId, JsonParser parser, ClientConfiguration configuration) throws IOException {
        HttpHost httpHost = null;
        String fieldName = null;
        while (parser.nextToken() != JsonToken.END_OBJECT) {
            if (parser.getCurrentToken() == JsonToken.FIELD_NAME) {
                fieldName = parser.getCurrentName();
                continue;
            }
            if (parser.getCurrentToken() != JsonToken.START_OBJECT) continue;
            if (!"http".equals(fieldName)) {
                parser.skipChildren();
                continue;
            }
            while (parser.nextToken() != JsonToken.END_OBJECT) {
                if (parser.getCurrentToken() == JsonToken.VALUE_STRING && "publish_address".equals(parser.getCurrentName())) {
                    httpHost = new HttpHost(ElasticsearchHostNodeDiscover.publishAddressHandle(parser.getValueAsString()));
                    continue;
                }
                if (parser.getCurrentToken() != JsonToken.START_OBJECT) continue;
                parser.skipChildren();
            }
        }
        if (httpHost == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("skipping node [" + nodeId + "] with http disabled  for elasticsearch[" + configuration.getBeanName() + "]");
            }
            return null;
        }
        return httpHost;
    }

    public static String publishAddressHandle(String publishAddress) {
        int i = publishAddress.indexOf("/");
        if (i >= 0) {
            return publishAddress.substring(i + 1);
        }
        return publishAddress;
    }
}

