/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.elasticsearch.scroll;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.frameworkset.elasticsearch.entity.ESDatas;
import org.frameworkset.elasticsearch.scroll.BreakableScrollHandler;
import org.frameworkset.elasticsearch.scroll.BreakableSliceScrollResult;
import org.frameworkset.elasticsearch.scroll.DefualtScrollHandler;
import org.frameworkset.elasticsearch.scroll.HandlerInfo;
import org.frameworkset.elasticsearch.scroll.ParallelSliceScrollHandler;
import org.frameworkset.elasticsearch.scroll.ScrollHandler;
import org.frameworkset.elasticsearch.scroll.SliceScrollResultInf;

public class ParallelSliceScrollResult<T>
extends BreakableSliceScrollResult
implements SliceScrollResultInf<T> {
    private volatile long realTotalSize = 0L;
    private ESDatas<T> sliceResponse;
    private Lock lockIncrementSize = new ReentrantLock();
    private Lock lockSetSliceResponse = new ReentrantLock();
    private ScrollHandler<T> scrollHandler;
    private boolean useDefaultScrollHandler = false;

    @Override
    public void incrementSize(int size) {
        this.lockIncrementSize.lock();
        try {
            this.realTotalSize += (long)size;
        }
        finally {
            this.lockIncrementSize.unlock();
        }
    }

    @Override
    public ESDatas<T> getSliceResponse() {
        return this.sliceResponse;
    }

    @Override
    public void complete() {
        if (this.sliceResponse == null) {
            return;
        }
        this.sliceResponse.setTotalSize(this.realTotalSize);
        if (!this.useDefaultScrollHandler) {
            this.sliceResponse.setDatas(null);
        }
    }

    @Override
    public void setSliceResponse(ESDatas<T> sliceResponse) {
        if (this.sliceResponse != null) {
            return;
        }
        this.lockSetSliceResponse.lock();
        try {
            if (this.sliceResponse != null) {
                return;
            }
            this.sliceResponse = sliceResponse;
        }
        finally {
            this.lockSetSliceResponse.unlock();
        }
    }

    @Override
    public long getRealTotalSize() {
        return this.realTotalSize;
    }

    @Override
    public ScrollHandler<T> getScrollHandler() {
        return this.scrollHandler;
    }

    @Override
    public ScrollHandler<T> setScrollHandler(ScrollHandler<T> scrollHandler) {
        this.scrollHandler = scrollHandler;
        if (scrollHandler instanceof DefualtScrollHandler) {
            this.useDefaultScrollHandler = true;
        } else if (scrollHandler instanceof BreakableScrollHandler) {
            this.breakableScrollHandler = (BreakableScrollHandler)((Object)scrollHandler);
        }
        return this.scrollHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ScrollHandler<T> setScrollHandler(ESDatas<T> sliceResponse, HandlerInfo handlerInfo) throws Exception {
        boolean inited;
        block6: {
            if (this.scrollHandler != null) {
                this.scrollHandler.handle(sliceResponse, handlerInfo);
                return this.scrollHandler;
            }
            inited = false;
            this.lockSetSliceResponse.lock();
            try {
                if (this.scrollHandler != null) {
                    inited = true;
                    break block6;
                }
                this.useDefaultScrollHandler = true;
                this.sliceResponse = sliceResponse;
                ScrollHandler<T> scrollHandler = this.scrollHandler = new ParallelSliceScrollHandler<T>(sliceResponse);
                return scrollHandler;
            }
            finally {
                this.lockSetSliceResponse.unlock();
            }
        }
        if (inited) {
            this.scrollHandler.handle(sliceResponse, handlerInfo);
        }
        return this.scrollHandler;
    }
}

