/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.elasticsearch.scroll.thread;

import org.frameworkset.elasticsearch.ElasticSearchException;
import org.frameworkset.elasticsearch.entity.ESDatas;
import org.frameworkset.elasticsearch.scroll.HandlerInfo;
import org.frameworkset.elasticsearch.scroll.ScrollHandler;
import org.frameworkset.elasticsearch.scroll.SliceScrollResultInf;

public class ScrollTask<T>
implements Runnable {
    private ScrollHandler<T> scrollHandler;
    private ESDatas<T> response;
    private HandlerInfo handlerInfo;
    private SliceScrollResultInf<T> sliceScrollResult;

    public ScrollTask(ScrollHandler<T> scrollHandler, ESDatas<T> response, HandlerInfo handlerInfo) {
        this.scrollHandler = scrollHandler;
        this.response = response;
        this.handlerInfo = handlerInfo;
    }

    public ScrollTask(ScrollHandler<T> scrollHandler, ESDatas<T> response, HandlerInfo handlerInfo, SliceScrollResultInf<T> sliceScrollResult) {
        this.scrollHandler = scrollHandler;
        this.response = response;
        this.handlerInfo = handlerInfo;
        this.sliceScrollResult = sliceScrollResult;
    }

    @Override
    public void run() {
        try {
            this.scrollHandler.handle(this.response, this.handlerInfo);
            if (this.sliceScrollResult != null) {
                this.sliceScrollResult.incrementSize(this.response.getDatas().size());
            }
        }
        catch (ElasticSearchException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ElasticSearchException("scroll result handle task[" + this.handlerInfo.getTaskId() + "] failed:", e);
        }
        catch (Throwable e) {
            throw new ElasticSearchException("scroll result handle task[" + this.handlerInfo.getTaskId() + "] failed:", e);
        }
    }
}

