/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.agreement.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.agreement.ability.api.AgrQryKTwoApprovalListAbilityService;
import com.tydic.agreement.ability.bo.AgrK2ProcessLogBO;
import com.tydic.agreement.ability.bo.AgrK2RspBO;
import com.tydic.agreement.ability.bo.AgrKTwoApprovalBO;
import com.tydic.agreement.ability.bo.AgrQryKTwoApprovalListAbilityReqBO;
import com.tydic.agreement.ability.bo.AgrQryKTwoApprovalListAbilityRspBO;
import com.tydic.agreement.exceptions.BusinessException;
import com.tydic.agreement.utils.HSHttpHelper;
import com.tydic.agreement.utils.HSNHttpHeader;
import com.tydic.agreement.utils.HttpRetBean;
import com.tydic.agreement.utils.PropertiesUtil;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"AGREEMENT_GROUP_DEV/2.1.0/com.tydic.agreement.ability.api.AgrQryKTwoApprovalListAbilityService"})
public class AgrQryKTwoApprovalListAbilityServiceImpl
implements AgrQryKTwoApprovalListAbilityService {
    private static final Logger log = LogManager.getLogger(AgrQryKTwoApprovalListAbilityServiceImpl.class);

    @PostMapping(value={"AgrQryKTwoApprovalList"})
    public AgrQryKTwoApprovalListAbilityRspBO AgrQryKTwoApprovalList(@RequestBody AgrQryKTwoApprovalListAbilityReqBO reqBO) {
        AgrQryKTwoApprovalListAbilityRspBO rspBO = new AgrQryKTwoApprovalListAbilityRspBO();
        if (StringUtils.isEmpty((Object)reqBO.getK2Id())) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("K2Id\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBO;
        }
        try {
            String reqStr = this.initReqStr(reqBO.getK2Id());
            log.info("reqStr\u5165\u53c2{}->" + reqStr);
            HttpRetBean httpRetBean = HSHttpHelper.doUrlPostRequest(new URI(PropertiesUtil.getProperty("K2_QRY_HISTORY_FLOW_URL")), HSNHttpHeader.getRequestHeaders("json"), reqStr.getBytes("UTF-8"), "UTF-8", false);
            if (httpRetBean.getStatus() != 200) {
                log.error("\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1-\u63a5\u53e3\u8fd4\u56de\u5931\u8d25[http_status=" + httpRetBean.getStatus() + "], [http_url=" + PropertiesUtil.getProperty("K2_QRY_HISTORY_FLOW_URL") + "]");
                throw new ZTBusinessException("K2\u83b7\u53d6\u5ba1\u6279\u4fe1\u606f\u63a5\u53e3\u51fa\u9519\uff0chttp_status = " + httpRetBean.getStatus());
            }
            log.info("K2\u83b7\u53d6\u5ba1\u6279\u4fe1\u606f\u63a5\u53e3\u8fd4\u56de\u54cd\u5e94\u62a5\u6587\uff1a" + httpRetBean.getStr());
            String returnString = httpRetBean.getStr();
            if (StringUtils.isEmpty((Object)returnString)) {
                log.error("K2\u7cfb\u7edf\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\uff01");
                throw new ZTBusinessException("K2\u7cfb\u7edf\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\uff01");
            }
            AgrK2RspBO k2RspBO = this.resolveRsp(returnString);
            log.info("k2\u54cd\u5e94\u6570\u636e\uff1a" + k2RspBO.toString());
            ArrayList<AgrKTwoApprovalBO> kTwoApprovalList = new ArrayList<AgrKTwoApprovalBO>();
            if (!CollectionUtils.isEmpty((Collection)k2RspBO.getResultInfo().getProcessLogs())) {
                for (AgrK2ProcessLogBO each : k2RspBO.getResultInfo().getProcessLogs()) {
                    AgrKTwoApprovalBO agrKTwoApprovalBO = new AgrKTwoApprovalBO();
                    agrKTwoApprovalBO.setActivityName(each.getActivityName());
                    agrKTwoApprovalBO.setApproverUserName(each.getApproverUserName());
                    agrKTwoApprovalBO.setApproveTime(each.getApproveTime());
                    agrKTwoApprovalBO.setApproveActionName(each.getApproveActionName());
                    agrKTwoApprovalBO.setApproveComment(each.getApproveComment());
                    kTwoApprovalList.add(agrKTwoApprovalBO);
                }
            }
            rspBO.setKTwoApprovalList(kTwoApprovalList);
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
            return rspBO;
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new BusinessException("8888", "\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    private String initReqStr(String k2Id) {
        JSONObject esbInfo = new JSONObject();
        esbInfo.put("instId", (Object)"");
        esbInfo.put("requestTime", (Object)new SimpleDateFormat("yyyy-MM-dd HH24:mm:ss:SSS").format(new Date(System.currentTimeMillis())));
        JSONObject queryInfo = new JSONObject();
        queryInfo.put("pageSize", (Object)10000);
        queryInfo.put("currentPage", (Object)1);
        JSONObject requestInfo = new JSONObject();
        requestInfo.put("k2Id", (Object)k2Id);
        requestInfo.put("sourceId", (Object)PropertiesUtil.getProperty("K2_SOURCE_ID"));
        JSONObject reqJson = new JSONObject();
        reqJson.put("requestInfo", (Object)requestInfo);
        reqJson.put("queryInfo", (Object)queryInfo);
        reqJson.put("esbInfo", (Object)esbInfo);
        return reqJson.toString();
    }

    private AgrK2RspBO resolveRsp(String returnString) {
        try {
            JSONObject rspJsonObject = JSONObject.parseObject((String)returnString);
            AgrK2RspBO k2RspBO = (AgrK2RspBO)JSON.toJavaObject((JSON)rspJsonObject, AgrK2RspBO.class);
            if (!"S".equals(k2RspBO.getEsbInfo().getReturnStatus())) {
                throw new ZTBusinessException("K2\u63a5\u53e3\u8fd4\u56de\u72b6\u6001\u5f02\u5e38\uff1a[" + k2RspBO.getEsbInfo().getReturnStatus() + "]" + k2RspBO.getEsbInfo().getReturnMsg());
            }
            return k2RspBO;
        }
        catch (Exception e) {
            log.error("\u8f6c\u6362K2\u7cfb\u7edf\u54cd\u5e94\u62a5\u6587\u51fa\u9519\uff1a" + e.getMessage());
            throw new RuntimeException("\u8f6c\u6362K2\u7cfb\u7edf\u54cd\u5e94\u62a5\u6587\u51fa\u9519\uff1a" + e.getMessage());
        }
    }
}

