/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.agreement.busi.impl;

import com.ohaotian.plugin.common.util.MoneyUtils;
import com.ohaotian.plugin.db.Page;
import com.tydic.agreement.ability.bo.AgrAgreementSkuBO;
import com.tydic.agreement.atom.api.AgrDicDictionaryAtomService;
import com.tydic.agreement.busi.api.AgrQryAgreementSkuByPageBusiService;
import com.tydic.agreement.busi.bo.AgrQryAgreementSkuByPageBusiReqBO;
import com.tydic.agreement.busi.bo.AgrQryAgreementSkuByPageBusiRspBO;
import com.tydic.agreement.dao.AgreementSkuLogMapper;
import com.tydic.agreement.dao.AgreementSkuMapper;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class AgrQryAgreementSkuByPageBusiServiceImpl
implements AgrQryAgreementSkuByPageBusiService {
    private static final Logger log = LoggerFactory.getLogger(AgrQryAgreementSkuByPageBusiServiceImpl.class);
    @Autowired
    private AgreementSkuMapper agreementSkuMapper;
    @Autowired
    private AgreementSkuLogMapper agreementSkuLogMapper;
    @Autowired
    private AgrDicDictionaryAtomService agrDicDictionaryAtomService;

    @Override
    public AgrQryAgreementSkuByPageBusiRspBO qryAgreementSkuByPage(AgrQryAgreementSkuByPageBusiReqBO busiReqBO) {
        List<AgrAgreementSkuBO> rows;
        AgrQryAgreementSkuByPageBusiRspBO rsp = new AgrQryAgreementSkuByPageBusiRspBO();
        if (busiReqBO.getPageQueryFlag().booleanValue()) {
            Page page = new Page(busiReqBO.getPageNo().intValue(), busiReqBO.getPageSize().intValue());
            rows = this.agreementSkuMapper.getListPageByCondition(busiReqBO, (Page<AgrAgreementSkuBO>)page);
            rsp.setTotal(page.getTotalPages());
            rsp.setRecordsTotal(page.getTotalCount());
            rsp.setPageNo(page.getPageNo());
        } else {
            rows = this.agreementSkuMapper.getListByCondition(busiReqBO);
        }
        if (!CollectionUtils.isEmpty(rows)) {
            Map<String, String> isOilStrMap = this.agrDicDictionaryAtomService.queryDictBySysCodeAndPcode("AGR", "IS_OIL_PCODE");
            Map<String, String> isDispatchStr = this.agrDicDictionaryAtomService.queryDictBySysCodeAndPcode("AGR", "IS_DISPATCH_PCODE");
            Map<String, String> agreementStatusStr = this.agrDicDictionaryAtomService.queryDictBySysCodeAndPcode("AGR", "AGREEMENT_STATUS_PCODE");
            Map<String, String> adjustPriceStr = this.agrDicDictionaryAtomService.queryDictBySysCodeAndPcode("AGR", "ADJUST_PRICE_PCODE");
            for (AgrAgreementSkuBO agrAgreementSkuBO : rows) {
                if (agrAgreementSkuBO.getIsOil() != null) {
                    agrAgreementSkuBO.setIsOilStr(isOilStrMap.get(agrAgreementSkuBO.getIsOil().toString()));
                }
                if (null != agrAgreementSkuBO.getIsDispatch()) {
                    agrAgreementSkuBO.setIsDispatchStr(isDispatchStr.get(agrAgreementSkuBO.getIsDispatch().toString()));
                }
                if (null != agrAgreementSkuBO.getAgreementStatus()) {
                    agrAgreementSkuBO.setAgreementStatusStr(agreementStatusStr.get(agrAgreementSkuBO.getAgreementStatus().toString()));
                }
                if (null != agrAgreementSkuBO.getAdjustPrice()) {
                    agrAgreementSkuBO.setAdjustPriceStr(adjustPriceStr.get(agrAgreementSkuBO.getAdjustPrice().toString()));
                }
                try {
                    agrAgreementSkuBO.setBuyPriceStr(agrAgreementSkuBO.getBuyPrice().toString());
                    agrAgreementSkuBO.setBuyPriceSumStr(MoneyUtils.Long2BigDecimal((Long)agrAgreementSkuBO.getBuyPriceSum()).toString());
                    agrAgreementSkuBO.setSalePriceStr(agrAgreementSkuBO.getSalePrice().toString());
                    agrAgreementSkuBO.setSalePriceSumStr(MoneyUtils.Long2BigDecimal((Long)agrAgreementSkuBO.getSalePriceSum()).toString());
                }
                catch (Exception e) {
                    log.error("\u5355\u4f4d\u8f6c\u6362\u5f02\u5e38", (Throwable)e);
                }
            }
        }
        if (CollectionUtils.isEmpty(rows)) {
            rsp.setRespCode("0000");
            rsp.setRespDesc("\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a\uff01");
            return rsp;
        }
        rsp.setRespCode("0000");
        rsp.setRespDesc("\u534f\u8bae\u660e\u7ec6\u4fe1\u606f\u5206\u9875\u67e5\u8be2\u6210\u529f\uff01");
        rsp.setRows(rows);
        return rsp;
    }
}

