/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.agreement.busi.impl;

import com.tydic.agreement.ability.bo.AgrAgreementAttachBO;
import com.tydic.agreement.ability.bo.AgrAgreementBO;
import com.tydic.agreement.ability.bo.AgrAgreementScopeBO;
import com.tydic.agreement.ability.bo.AgreementSettlementBO;
import com.tydic.agreement.atom.api.AgrDicDictionaryAtomService;
import com.tydic.agreement.busi.api.AgrQryAgreementSubjectDetailsBusiService;
import com.tydic.agreement.busi.bo.AgrQryAgreementSubjectDetailsBusiReqBO;
import com.tydic.agreement.busi.bo.AgrQryAgreementSubjectDetailsBusiRspBO;
import com.tydic.agreement.constants.AgrCommConstant;
import com.tydic.agreement.dao.AgrAgreementAttachLogMapper;
import com.tydic.agreement.dao.AgreementAttachMapper;
import com.tydic.agreement.dao.AgreementLogMapper;
import com.tydic.agreement.dao.AgreementMapper;
import com.tydic.agreement.dao.AgreementScopeLogMapper;
import com.tydic.agreement.dao.AgreementScopeMapper;
import com.tydic.agreement.dao.AgreementSettlementLogMapper;
import com.tydic.agreement.dao.AgreementSettlementMapper;
import com.tydic.agreement.po.AgreementAttachPO;
import com.tydic.agreement.po.AgreementPO;
import com.tydic.agreement.po.AgreementScopePO;
import com.tydic.agreement.po.AgreementSettlementPO;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class AgrQryAgreementSubjectDetailsBusiServiceImpl
implements AgrQryAgreementSubjectDetailsBusiService {
    private static final Logger log = LoggerFactory.getLogger(AgrQryAgreementSubjectDetailsBusiServiceImpl.class);
    @Autowired
    private AgreementMapper agreementMapper;
    @Autowired
    private AgreementLogMapper agreementLogMapper;
    @Autowired
    private AgreementScopeLogMapper agreementScopeLogMapper;
    @Autowired
    private AgrAgreementAttachLogMapper agrAgreementAttachLogMapper;
    @Autowired
    private AgreementSettlementLogMapper agreementSettlementLogMapper;
    @Autowired
    private AgreementSettlementMapper agreementSettlementMapper;
    @Autowired
    private AgreementAttachMapper agreementAttachMapper;
    @Autowired
    private AgreementScopeMapper agreementScopeMapper;
    @Autowired
    private AgrDicDictionaryAtomService agrDicDictionaryAtomService;

    @Override
    public AgrQryAgreementSubjectDetailsBusiRspBO qryAgreementSubjectDetails(AgrQryAgreementSubjectDetailsBusiReqBO busiReqBO) {
        AgrQryAgreementSubjectDetailsBusiRspBO rsp = new AgrQryAgreementSubjectDetailsBusiRspBO();
        AgrAgreementBO agrAgreementBO = new AgrAgreementBO();
        ArrayList<AgrAgreementAttachBO> agrAgreementAttachBOs = new ArrayList<AgrAgreementAttachBO>();
        AgreementPO agreementPO = new AgreementPO();
        agreementPO.setAgreementId(busiReqBO.getAgreementId());
        agreementPO.setSupplierId(busiReqBO.getSupplierId());
        agreementPO.setAgreementVersion(busiReqBO.getAgreementVersion());
        agreementPO.setIsDelete(AgrCommConstant.IsDelete.NORMAL);
        AgreementPO agreement = this.agreementMapper.getModelBy(agreementPO);
        if (null == agreement) {
            rsp.setRespCode("0000");
            rsp.setRespDesc("\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a\uff01");
            return rsp;
        }
        BeanUtils.copyProperties((Object)agreement, (Object)agrAgreementBO);
        if (agreement.getAuditResult() != null) {
            if (agreement.getAuditResult().equals(0)) {
                agrAgreementBO.setAuditResultStr("\u901a\u8fc7");
            } else {
                agrAgreementBO.setAuditResultStr("\u672a\u901a\u8fc7");
            }
        }
        if (AgrCommConstant.QueryScopeFlag.YES.equals(busiReqBO.getQueryScopeFlag())) {
            AgreementScopePO agreementScopePO = new AgreementScopePO();
            agreementScopePO.setAgreementId(busiReqBO.getAgreementId());
            agreementScopePO.setSupplierId(agreement.getSupplierId());
            agreementScopePO.setAgreementVersion(agreement.getAgreementVersion());
            agreementScopePO.setIsDelete(AgrCommConstant.IsDelete.NORMAL);
            List<AgreementScopePO> agreementScopePOs = this.agreementScopeMapper.getList(agreementScopePO);
            if (!CollectionUtils.isEmpty(agreementScopePOs)) {
                ArrayList agrAgreementScopeBOs = new ArrayList();
                for (AgreementScopePO po : agreementScopePOs) {
                    AgrAgreementScopeBO agrAgreementScopeBO = new AgrAgreementScopeBO();
                    BeanUtils.copyProperties((Object)po, (Object)agrAgreementScopeBO);
                    agrAgreementScopeBOs.add(agrAgreementScopeBO);
                }
                agrAgreementBO.setAgrAgreementScopeBOs(agrAgreementScopeBOs);
            }
        }
        if (AgrCommConstant.QueryAttachFlag.YES.equals(busiReqBO.getQueryAttachmentFlag())) {
            AgreementAttachPO agreementAttachPO = new AgreementAttachPO();
            agreementAttachPO.setAgreementId(busiReqBO.getAgreementId());
            agreementAttachPO.setSupplierId(agreement.getSupplierId());
            agreementAttachPO.setAgreementVersion(agreement.getAgreementVersion());
            agreementAttachPO.setAttachmentTypes(busiReqBO.getAttachmentTypes());
            agreementAttachPO.setIsDelete(AgrCommConstant.IsDelete.NORMAL);
            List<AgreementAttachPO> agreementAttachPOs = this.agreementAttachMapper.getList(agreementAttachPO);
            if (!CollectionUtils.isEmpty(agreementAttachPOs)) {
                for (AgreementAttachPO po : agreementAttachPOs) {
                    AgrAgreementAttachBO agrAgreementAttachBO = new AgrAgreementAttachBO();
                    BeanUtils.copyProperties((Object)po, (Object)agrAgreementAttachBO);
                    agrAgreementAttachBOs.add(agrAgreementAttachBO);
                }
            }
        }
        ArrayList<AgreementSettlementBO> agreementSettlementBOS = new ArrayList<AgreementSettlementBO>();
        AgreementSettlementPO agreementSettlementPO = new AgreementSettlementPO();
        agreementSettlementPO.setAgreementId(busiReqBO.getAgreementId());
        List<AgreementSettlementPO> agreementSettlementPOList = this.agreementSettlementMapper.queryList(agreementSettlementPO);
        if (agreementSettlementPOList != null && agreementSettlementPOList.size() > 0) {
            for (AgreementSettlementPO apo : agreementSettlementPOList) {
                AgreementSettlementBO agreementSettlementBO = new AgreementSettlementBO();
                BeanUtils.copyProperties((Object)apo, (Object)agreementSettlementBO);
                if (apo.getSettlementObject().equals("1")) {
                    agreementSettlementBO.setSettlementObjectName("\u4f9b\u5e94\u5546");
                } else {
                    agreementSettlementBO.setSettlementObjectName("\u91c7\u8d2d\u5546");
                }
                agreementSettlementBOS.add(agreementSettlementBO);
            }
        }
        agrAgreementBO.setPaymentMethod(agreementSettlementBOS);
        if (AgrCommConstant.TranslateFlag.YES.equals(busiReqBO.getTranslateFlag())) {
            this.tanslate(agrAgreementBO);
        }
        rsp.setAgrAgreementBO(agrAgreementBO);
        rsp.setAgrAgreementAttachBOs(agrAgreementAttachBOs);
        rsp.setRespCode("0000");
        rsp.setRespDesc("\u534f\u8bae\u4e3b\u4f53\u8be6\u60c5\u67e5\u8be2\u6210\u529f\uff01");
        return rsp;
    }

    private void tanslate(AgrAgreementBO agrAgreementBO) {
        if (null != agrAgreementBO.getAgreementMode()) {
            String agreementModeStr = this.agrDicDictionaryAtomService.queryDictBySysCodeAndPcodeAndCode("AGR", "AGREEMENT_MODE_PCODE", agrAgreementBO.getAgreementMode().toString());
            agrAgreementBO.setAgreementModeStr(agreementModeStr);
        }
        if (null != agrAgreementBO.getPriceType()) {
            String priceTypeStr = this.agrDicDictionaryAtomService.queryDictBySysCodeAndPcodeAndCode("AGR", "PRICE_TYPE_PCODE", agrAgreementBO.getPriceType().toString());
            agrAgreementBO.setPriceTypeStr(priceTypeStr);
        }
        if (null != agrAgreementBO.getAgreementType()) {
            String agreementTypeStr = this.agrDicDictionaryAtomService.queryDictBySysCodeAndPcodeAndCode("AGR", "AGREEMENT_TYPE_PCODE", agrAgreementBO.getAgreementType().toString());
            agrAgreementBO.setAgreementTypeStr(agreementTypeStr);
        }
        if (null != agrAgreementBO.getAgreementSrc()) {
            String agreementSrcStr = this.agrDicDictionaryAtomService.queryDictBySysCodeAndPcodeAndCode("AGR", "AGREEMENT_SRC_PCODE", agrAgreementBO.getAgreementSrc().toString());
            log.error("agreementSrcStr\u7684\u503c=" + agreementSrcStr);
            agrAgreementBO.setAgreementSrcStr(agreementSrcStr);
        }
        if (null != agrAgreementBO.getAgreementVariety()) {
            String agreementVarietyStr = this.agrDicDictionaryAtomService.queryDictBySysCodeAndPcodeAndCode("AGR", "AGREEMENT_VARIETY_PCODE", agrAgreementBO.getAgreementVariety().toString());
            agrAgreementBO.setAgreementVarietyStr(agreementVarietyStr);
        }
        if (null != agrAgreementBO.getCurrency()) {
            String currencyStr = this.agrDicDictionaryAtomService.queryDictBySysCodeAndPcodeAndCode("AGR", "CURRENCY_PCODE", agrAgreementBO.getCurrency().toString());
            agrAgreementBO.setCurrencyStr(currencyStr);
        }
        if (null != agrAgreementBO.getIsDispatch()) {
            String isDispatchStr = this.agrDicDictionaryAtomService.queryDictBySysCodeAndPcodeAndCode("AGR", "IS_DISPATCH_PCODE", agrAgreementBO.getIsDispatch().toString());
            agrAgreementBO.setIsDispatchStr(isDispatchStr);
        }
        if (null != agrAgreementBO.getAdjustPrice()) {
            String adjustPriceStr = this.agrDicDictionaryAtomService.queryDictBySysCodeAndPcodeAndCode("AGR", "ADJUST_PRICE_PCODE", agrAgreementBO.getAdjustPrice().toString());
            agrAgreementBO.setAdjustPriceStr(adjustPriceStr);
        }
        if (null != agrAgreementBO.getIsAdjustPriceFormula()) {
            String isAdjustPriceFormulaStr = this.agrDicDictionaryAtomService.queryDictBySysCodeAndPcodeAndCode("AGR", "IS_ADJUST_PRICE_FORMULA_PCODE", agrAgreementBO.getIsAdjustPriceFormula().toString());
            agrAgreementBO.setIsAdjustPriceFormulaStr(isAdjustPriceFormulaStr);
        }
        if (null != agrAgreementBO.getIsModifyBuyPrice()) {
            String isModifyBuyPriceStr = this.agrDicDictionaryAtomService.queryDictBySysCodeAndPcodeAndCode("AGR", "IS_MODIFY_BUY_PRICE_PCODE", agrAgreementBO.getIsModifyBuyPrice().toString());
            agrAgreementBO.setIsModifyBuyPriceStr(isModifyBuyPriceStr);
        }
        if (null != agrAgreementBO.getIsAddPrice()) {
            String isAddPriceStr = this.agrDicDictionaryAtomService.queryDictBySysCodeAndPcodeAndCode("AGR", "IS_ADD_PRICE_PCODE", agrAgreementBO.getIsAddPrice().toString());
            agrAgreementBO.setIsAddPriceStr(isAddPriceStr);
        }
        if (null != agrAgreementBO.getAgrLocation()) {
            String agrLocationStr = this.agrDicDictionaryAtomService.queryDictBySysCodeAndPcodeAndCode("AGR", "AGR_LOCATION_PCODE", agrAgreementBO.getAgrLocation().toString());
            agrAgreementBO.setAgrLocationStr(agrLocationStr);
        }
        if (null != agrAgreementBO.getAgreementStatus()) {
            String agreementStatusStr = this.agrDicDictionaryAtomService.queryDictBySysCodeAndPcodeAndCode("AGR", "AGREEMENT_STATUS_PCODE", agrAgreementBO.getAgreementStatus().toString());
            agrAgreementBO.setAgreementStatusStr(agreementStatusStr);
        }
        if (null != agrAgreementBO.getAssignStatus()) {
            String assignStatusStr = this.agrDicDictionaryAtomService.queryDictBySysCodeAndPcodeAndCode("AGR", "ASSIGN_STATUS_PCODE", agrAgreementBO.getAssignStatus().toString());
            agrAgreementBO.setAssignStatusStr(assignStatusStr);
        }
        if (null != agrAgreementBO.getSupplierMode()) {
            String supplierModeStr = this.agrDicDictionaryAtomService.queryDictBySysCodeAndPcodeAndCode("AGR", "SUPPLIER_MODE_PCODE", agrAgreementBO.getSupplierMode().toString());
            agrAgreementBO.setSupplierModeStr(supplierModeStr);
        }
        if (null != agrAgreementBO.getTradeMode()) {
            String tradeModeStr = this.agrDicDictionaryAtomService.queryDictBySysCodeAndPcodeAndCode("AGR", "TRADE_MODE_PCODE", agrAgreementBO.getTradeMode().toString());
            agrAgreementBO.setTradeModeStr(tradeModeStr);
        }
        if (null != agrAgreementBO.getScopeType()) {
            String scopeTypeStr = this.agrDicDictionaryAtomService.queryDictBySysCodeAndPcodeAndCode("AGR", "SCOPE_TYPE_PCODE", agrAgreementBO.getScopeType().toString());
            agrAgreementBO.setScopeTypeStr(scopeTypeStr);
        }
        if (StringUtils.hasText((String)agrAgreementBO.getExtField1())) {
            String extField1Str = this.agrDicDictionaryAtomService.queryDictBySysCodeAndPcodeAndCode("AGR", "EXT_FIELD1_PCODE", agrAgreementBO.getExtField1());
            agrAgreementBO.setExtField1Str(extField1Str);
        }
        if (StringUtils.hasText((String)agrAgreementBO.getExtField3())) {
            String extField3Str = this.agrDicDictionaryAtomService.queryDictBySysCodeAndPcodeAndCode("AGR", "EXT_FIELD3_PCODE", agrAgreementBO.getExtField3());
            agrAgreementBO.setExtField3Str(extField3Str);
        }
    }
}

