/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.agreement.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.agreement.ability.bo.AgrK2RspBO;
import com.tydic.agreement.ability.bo.AgrSubmitAgreementApprovalBO;
import com.tydic.agreement.atom.bo.AgrAgreementStatusChangeAtomReqBO;
import com.tydic.agreement.busi.api.AgrSubmitAgreementApprovalBusiService;
import com.tydic.agreement.busi.bo.AgrSubmitAgreementApprovalBusiReqBO;
import com.tydic.agreement.busi.bo.AgrSubmitAgreementApprovalBusiRspBO;
import com.tydic.agreement.dao.AgrAgreementAuditLogMapper;
import com.tydic.agreement.dao.AgreementMapper;
import com.tydic.agreement.exceptions.BusinessException;
import com.tydic.agreement.po.AgrAgreementAuditLogPO;
import com.tydic.agreement.po.AgreementPO;
import com.tydic.agreement.utils.HSHttpHelper;
import com.tydic.agreement.utils.HSNHttpHeader;
import com.tydic.agreement.utils.HttpRetBean;
import com.tydic.agreement.utils.PropertiesUtil;
import java.net.URI;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class AgrSubmitAgreementApprovalBusiServiceImpl
implements AgrSubmitAgreementApprovalBusiService {
    private static final Logger log = LogManager.getLogger(AgrSubmitAgreementApprovalBusiServiceImpl.class);
    @Autowired
    private AgreementMapper agreementMapper;
    @Autowired
    private AgrAgreementAuditLogMapper agreementAuditLogMapper;
    private Sequence sequence = Sequence.getInstance();

    @Override
    public AgrSubmitAgreementApprovalBusiRspBO submitAgreementApproval(AgrSubmitAgreementApprovalBusiReqBO busiReqBO) {
        AgrSubmitAgreementApprovalBusiRspBO rspBO = new AgrSubmitAgreementApprovalBusiRspBO();
        if (CollectionUtils.isEmpty(busiReqBO.getAgreementInfoList())) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u62a5\u4ef7\u5355\u4fe1\u606f\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBO;
        }
        HashMap<Long, String> k2IdList = new HashMap<Long, String>();
        AgreementPO agreementPO = new AgreementPO();
        for (AgrSubmitAgreementApprovalBO each : busiReqBO.getAgreementInfoList()) {
            if (each.getAgreementId() == null) {
                rspBO.setRespCode("8888");
                rspBO.setRespDesc("\u62a5\u4ef7\u5355Id\u4e0d\u80fd\u4e3a\u7a7a");
                return rspBO;
            }
            if (StringUtils.isEmpty((Object)each.getFormUrl())) {
                rspBO.setRespCode("8888");
                rspBO.setRespDesc("\u8868\u5355url\u4e0d\u80fd\u4e3a\u7a7a");
                return rspBO;
            }
            agreementPO.setAgreementId(each.getAgreementId());
            List<AgreementPO> agreementList = this.agreementMapper.getList(agreementPO);
            if (CollectionUtils.isEmpty(agreementList)) {
                rspBO.setRespCode("8888");
                rspBO.setRespDesc("\u62a5\u4ef7\u5355Id" + each.getAgreementId() + "\u4e0d\u5b58\u5728");
                return rspBO;
            }
            if (!CollectionUtils.isEmpty(agreementList = agreementList.stream().filter(e -> e.getAgreementStatus() == 0 || e.getAgreementStatus() == 1).collect(Collectors.toList()))) continue;
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u62a5\u4ef7\u5355Id" + each.getAgreementId() + "\u72b6\u6001\u4e0d\u4e3a\u8349\u7a3f\u6216\u9a73\u56de\u72b6\u6001");
            return rspBO;
        }
        for (AgrSubmitAgreementApprovalBO each : busiReqBO.getAgreementInfoList()) {
            Date dealTime;
            AgrAgreementStatusChangeAtomReqBO atomReqBO = new AgrAgreementStatusChangeAtomReqBO();
            AgreementPO agreementPO1 = new AgreementPO();
            agreementPO1.setAgreementId(each.getAgreementId());
            agreementPO1.setAgreementStatus((byte)2);
            this.agreementMapper.updateBy(agreementPO1);
            agreementPO.setAgreementId(each.getAgreementId());
            List<AgreementPO> agreementList = this.agreementMapper.getList(agreementPO);
            AgrAgreementAuditLogPO agrAgreementAuditLogPO = new AgrAgreementAuditLogPO();
            agrAgreementAuditLogPO.setAgreementId(each.getAgreementId());
            List<AgrAgreementAuditLogPO> logList = this.agreementAuditLogMapper.getList(agrAgreementAuditLogPO);
            if (CollectionUtils.isEmpty(logList)) {
                Date dealTime2;
                AgrK2RspBO k2RspBO = this.submit(busiReqBO, each);
                AgrAgreementAuditLogPO agreementAuditLogPO = new AgrAgreementAuditLogPO();
                agreementAuditLogPO.setAuditLogId(this.sequence.nextId());
                agreementAuditLogPO.setAgreementId(each.getAgreementId());
                agreementAuditLogPO.setAuditOperId(busiReqBO.getUserId());
                agreementAuditLogPO.setAuditOperName(busiReqBO.getUserName());
                agreementAuditLogPO.setTurn(1);
                agreementAuditLogPO.setOperType(1);
                agreementAuditLogPO.setAuditResult(1);
                agreementAuditLogPO.setReceiveTime(agreementList.get(0).getProduceTime());
                try {
                    dealTime2 = new SimpleDateFormat("yyyy-MM-dd HH24:mm:ss:SSS").parse(k2RspBO.getEsbInfo().getRequestTime());
                }
                catch (ParseException e2) {
                    log.error("\u65f6\u95f4\u8f6c\u6362\u5f02\u5e38:" + e2.getMessage());
                    throw new ZTBusinessException("\u65f6\u95f4\u8f6c\u6362\u5f02\u5e38");
                }
                agreementAuditLogPO.setDealTime(dealTime2);
                agreementAuditLogPO.setK2Id(k2RspBO.getResultInfo().getK2Id());
                agreementAuditLogPO.setFormUrl(k2RspBO.getResultInfo().getFormUrl());
                this.agreementAuditLogMapper.insert(agreementAuditLogPO);
                continue;
            }
            String k2Id = null;
            for (AgrAgreementAuditLogPO every : logList) {
                if (StringUtils.isEmpty((Object)every.getK2Id())) continue;
                k2Id = every.getK2Id();
                break;
            }
            AgrK2RspBO k2RspBO = this.secondSubmit(busiReqBO, each, k2Id);
            AgrAgreementAuditLogPO agreementAuditLogPO = new AgrAgreementAuditLogPO();
            agreementAuditLogPO.setAuditLogId(this.sequence.nextId());
            agreementAuditLogPO.setAgreementId(each.getAgreementId());
            agreementAuditLogPO.setAuditOperId(busiReqBO.getUserId());
            agreementAuditLogPO.setAuditOperName(busiReqBO.getUserName());
            logList.sort(Comparator.comparing(AgrAgreementAuditLogPO::getTurn));
            Integer turn = logList.get(logList.size() - 1).getTurn();
            agreementAuditLogPO.setTurn(turn);
            agreementAuditLogPO.setOperType(1);
            agreementAuditLogPO.setAuditResult(1);
            agreementAuditLogPO.setReceiveTime(agreementList.get(0).getProduceTime());
            try {
                dealTime = new SimpleDateFormat("yyyy-MM-dd HH24:mm:ss:SSS").parse(k2RspBO.getEsbInfo().getRequestTime());
            }
            catch (ParseException e3) {
                log.error("\u65f6\u95f4\u8f6c\u6362\u5f02\u5e38:" + e3.getMessage());
                throw new ZTBusinessException("\u65f6\u95f4\u8f6c\u6362\u5f02\u5e38");
            }
            agreementAuditLogPO.setDealTime(dealTime);
            agreementAuditLogPO.setK2Id(k2RspBO.getResultInfo().getK2Id());
            agreementAuditLogPO.setFormUrl(k2RspBO.getResultInfo().getFormUrl());
            this.agreementAuditLogMapper.insert(agreementAuditLogPO);
            k2IdList.put(each.getAgreementId(), k2Id);
        }
        rspBO.setK2IdList(k2IdList);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    public AgrK2RspBO submit(AgrSubmitAgreementApprovalBusiReqBO reqBO, AgrSubmitAgreementApprovalBO each) {
        try {
            String reqStr = this.initReqStr(reqBO, each, null);
            log.info("reqStr\u5165\u53c2{}->" + reqStr);
            HttpRetBean httpRetBean = HSHttpHelper.doUrlPostRequest(new URI(PropertiesUtil.getProperty("K2_SUBMIT_FLOW_URL")), HSNHttpHeader.getRequestHeaders("json"), reqStr.getBytes("UTF-8"), "UTF-8", false);
            if (httpRetBean.getStatus() != 200) {
                log.error("\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1-\u63a5\u53e3\u8fd4\u56de\u5931\u8d25[http_status=" + httpRetBean.getStatus() + "], [http_url=" + PropertiesUtil.getProperty("K2_SUBMIT_FLOW_URL") + "]");
                throw new ZTBusinessException("K2\u53d1\u8d77\u5ba1\u6279\u63a5\u53e3\u51fa\u9519\uff0chttp_status = " + httpRetBean.getStatus());
            }
            log.info("K2\u53d1\u8d77\u5ba1\u6279\u63a5\u53e3\u8fd4\u56de\u54cd\u5e94\u62a5\u6587\uff1a" + httpRetBean.getStr());
            String returnString = httpRetBean.getStr();
            if (StringUtils.isEmpty((Object)returnString)) {
                log.error("K2\u7cfb\u7edf\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\uff01");
                throw new ZTBusinessException("K2\u7cfb\u7edf\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\uff01");
            }
            AgrK2RspBO k2RspBO = this.resolveRsp(returnString);
            log.info("k2\u54cd\u5e94\u6570\u636e\uff1a" + k2RspBO.toString());
            return k2RspBO;
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new BusinessException("8888", "\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    public AgrK2RspBO secondSubmit(AgrSubmitAgreementApprovalBusiReqBO reqBO, AgrSubmitAgreementApprovalBO each, String k2Id) {
        try {
            String reqStr = this.initReqStr(reqBO, each, k2Id);
            HttpRetBean httpRetBean = HSHttpHelper.doUrlPostRequest(new URI(PropertiesUtil.getProperty("K2_SECOND_SUBMIT_FLOW_URL")), HSNHttpHeader.getRequestHeaders("json"), reqStr.getBytes("UTF-8"), "UTF-8", false);
            if (httpRetBean.getStatus() != 200) {
                log.error("\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1-\u63a5\u53e3\u8fd4\u56de\u5931\u8d25[http_status=" + httpRetBean.getStatus() + "], [http_url=" + PropertiesUtil.getProperty("K2_SUBMIT_FLOW_URL") + "]");
                throw new ZTBusinessException("K2\u91cd\u65b0\u53d1\u8d77\u5ba1\u6279\u63a5\u53e3\u51fa\u9519\uff0chttp_status = " + httpRetBean.getStatus());
            }
            log.info("K2\u91cd\u65b0\u53d1\u8d77\u5ba1\u6279\u63a5\u53e3\u8fd4\u56de\u54cd\u5e94\u62a5\u6587\uff1a" + httpRetBean.getStr());
            String returnString = httpRetBean.getStr();
            if (StringUtils.isEmpty((Object)returnString)) {
                log.error("K2\u7cfb\u7edf\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\uff01");
                throw new ZTBusinessException("K2\u7cfb\u7edf\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\uff01");
            }
            AgrK2RspBO k2RspBO = this.resolveRsp(returnString);
            log.info("k2\u54cd\u5e94\u6570\u636e\uff1a" + k2RspBO.toString());
            return k2RspBO;
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new BusinessException("8888", "\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    private String initReqStr(AgrSubmitAgreementApprovalBusiReqBO reqBO, AgrSubmitAgreementApprovalBO each, String k2Id) {
        JSONObject esbInfo = new JSONObject();
        esbInfo.put("instId", (Object)"");
        esbInfo.put("requestTime", (Object)new SimpleDateFormat("yyyy-MM-dd HH24:mm:ss:SSS").format(new Date(System.currentTimeMillis())));
        JSONObject requestInfo = new JSONObject();
        if (!StringUtils.isEmpty((Object)k2Id)) {
            requestInfo.put("k2Id", (Object)k2Id);
        }
        requestInfo.put("processCode", (Object)"TEST20210416");
        requestInfo.put("sourceId", (Object)PropertiesUtil.getProperty("K2_SOURCE_ID"));
        requestInfo.put("bizId", (Object)PropertiesUtil.getProperty("K2_SOURCE_ID"));
        requestInfo.put("folio", (Object)"\u62a5\u4ef7\u5355\u5b8c\u5584\u4fe1\u606f\u5ba1\u6279\u6d41\u7a0b");
        requestInfo.put("verifyData", (Object)1);
        requestInfo.put("applyUserCode", (Object)reqBO.getUserId().toString());
        requestInfo.put("startUserCode", (Object)reqBO.getUserId().toString());
        requestInfo.put("bizFormUrl", (Object)each.getFormUrl());
        JSONObject reqJson = new JSONObject();
        reqJson.put("requestInfo", (Object)requestInfo);
        reqJson.put("esbInfo", (Object)esbInfo);
        return reqJson.toString();
    }

    private AgrK2RspBO resolveRsp(String returnString) {
        try {
            JSONObject rspJsonObject = JSONObject.parseObject((String)returnString);
            AgrK2RspBO k2RspBO = (AgrK2RspBO)JSON.toJavaObject((JSON)rspJsonObject, AgrK2RspBO.class);
            if (!"S".equals(k2RspBO.getEsbInfo().getReturnStatus())) {
                throw new ZTBusinessException("K2\u63a5\u53e3\u8fd4\u56de\u72b6\u6001\u5f02\u5e38\uff1a[" + k2RspBO.getEsbInfo().getReturnStatus() + "]" + k2RspBO.getEsbInfo().getReturnMsg());
            }
            return k2RspBO;
        }
        catch (Exception e) {
            log.error("\u8f6c\u6362K2\u7cfb\u7edf\u54cd\u5e94\u62a5\u6587\u51fa\u9519\uff1a" + e.getMessage());
            throw new RuntimeException("\u8f6c\u6362K2\u7cfb\u7edf\u54cd\u5e94\u62a5\u6587\u51fa\u9519\uff1a" + e.getMessage());
        }
    }
}

