/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.agreement.busi.impl;

import com.tydic.agreement.atom.bo.AgrAgreementStatusChangeAtomReqBO;
import com.tydic.agreement.busi.api.AgrSynAgreementApprovalResultBusiService;
import com.tydic.agreement.busi.bo.AgrSynAgreementApprovalResultBusiReqBO;
import com.tydic.agreement.busi.bo.AgrSynAgreementApprovalResultBusiRspBO;
import com.tydic.agreement.dao.AgreementMapper;
import com.tydic.agreement.po.AgreementPO;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class AgrSynAgreementApprovalResultBusiServiceImpl
implements AgrSynAgreementApprovalResultBusiService {
    private static final Logger log = LoggerFactory.getLogger(AgrSynAgreementApprovalResultBusiServiceImpl.class);
    @Autowired
    private AgreementMapper agreementMapper;
    private static final Date now = new Date();

    @Override
    public AgrSynAgreementApprovalResultBusiRspBO synAgreementApprovalResult(AgrSynAgreementApprovalResultBusiReqBO busiReqBO) {
        AgrSynAgreementApprovalResultBusiRspBO rspBO = this.verifyParam(busiReqBO);
        if (rspBO != null) {
            return rspBO;
        }
        rspBO = new AgrSynAgreementApprovalResultBusiRspBO();
        int rowSum = 0;
        if (busiReqBO.getPlaAgreementCodeList() != null && busiReqBO.getPlaAgreementCodeList().size() > 0) {
            for (String code : busiReqBO.getPlaAgreementCodeList()) {
                if (Objects.equals("", code)) continue;
                AgreementPO agreementPO = new AgreementPO();
                agreementPO.setPlaAgreementCode(code);
                List<AgreementPO> agreementPOS = this.agreementMapper.getList(agreementPO);
                if (CollectionUtils.isEmpty(agreementPOS)) continue;
                for (AgreementPO po : agreementPOS) {
                    AgrAgreementStatusChangeAtomReqBO agrStatusReqBO = new AgrAgreementStatusChangeAtomReqBO();
                    agrStatusReqBO.setAgreementStatusPost((byte)(busiReqBO.getApprovalResult() == 1 ? 4 : 1));
                    if (po.getEffDate().after(now)) {
                        agrStatusReqBO.setAgreementStatusPost((byte)10);
                    }
                    if (po.getEffDate().before(now)) {
                        agrStatusReqBO.setAgreementStatusPost((byte)6);
                    }
                    agrStatusReqBO.setUpdateTime(new Date());
                    agrStatusReqBO.setSupplierId(po.getSupplierId());
                    agrStatusReqBO.setAgreementStatusPre(po.getAgreementStatus());
                    agrStatusReqBO.setAgreementIds(Arrays.asList(po.getAgreementId()).stream().collect(Collectors.toSet()));
                    int row = this.agreementMapper.updateAgreementStatus(agrStatusReqBO);
                    rowSum += row;
                }
            }
        }
        if (rowSum > 0) {
            rspBO.setRespCode("0000");
            if (rowSum >= busiReqBO.getPlaAgreementCodeList().size()) {
                rspBO.setRespDesc("\u6210\u529f");
                return rspBO;
            }
            rspBO.setRespDesc("\u540c\u6b65\u6570\u91cf\u5c11\u4e8e\u62a5\u4ef7\u5355\u7f16\u53f7\u5217\u8868\u603b\u6570");
            return rspBO;
        }
        rspBO.setRespCode("8888");
        rspBO.setRespDesc("\u5931\u8d25");
        return rspBO;
    }

    private AgrSynAgreementApprovalResultBusiRspBO verifyParam(AgrSynAgreementApprovalResultBusiReqBO busiReqBO) {
        AgrSynAgreementApprovalResultBusiRspBO rspBO = new AgrSynAgreementApprovalResultBusiRspBO();
        if (busiReqBO == null) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBO;
        }
        if (CollectionUtils.isEmpty(busiReqBO.getPlaAgreementCodeList())) {
            rspBO.setRespCode("0001");
            rspBO.setRespDesc("\u62a5\u4ef7\u5355\u7f16\u53f7\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBO;
        }
        return null;
    }
}

