/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.agreement.utils;

import com.tydic.agreement.utils.MD5Util;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;

public class ESBSignUtil {
    private static final String _key = "KEY";
    private static final String _app_key = "APP_KEY";
    private static final String _serialnumber = "SERIALNUMBER";
    private static final String _timestamp = "TIMESTAMP";
    private static final String _token = "TOKEN";

    public static String getESBToken(String characterEncoding, String key, String appkey, String serialnumber, String timesTamp) {
        TreeMap<Object, Object> parameters = new TreeMap<Object, Object>();
        parameters.put(_key, key);
        parameters.put(_app_key, appkey);
        parameters.put(_serialnumber, serialnumber);
        parameters.put(_timestamp, timesTamp);
        return ESBSignUtil.createToken(characterEncoding, parameters);
    }

    private static String createToken(String characterEncoding, SortedMap<Object, Object> parameters) {
        StringBuffer sb = new StringBuffer();
        Set<Map.Entry<Object, Object>> es = parameters.entrySet();
        for (Map.Entry<Object, Object> entry : es) {
            String k = (String)entry.getKey();
            Object v = entry.getValue();
            if (v instanceof String[]) {
                v = ((String[])v)[0];
            }
            if (null == v || "".equals(v) || _token.equals(k) || _key.equals(k)) continue;
            sb.append(k).append(v);
        }
        sb.append(parameters.get(_key));
        return ESBSignUtil.getMD5Encode(characterEncoding, sb.toString());
    }

    private static String getMD5Encode(String characterEncoding, String md5Code) {
        return MD5Util.MD5Encode(md5Code, characterEncoding);
    }

    public static void main(String[] args) {
        String characterEncoding = "UTF-8";
        String key = "efuxyS3jRnmxrFUO8MNuoiHdbErqdWV4";
        String appid = "gd";
        String transId = "20170817101001522685751";
        String timesTamp = "20170817101001522";
        System.out.println(ESBSignUtil.getESBToken(characterEncoding, key, appid, transId, timesTamp));
    }
}

