/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.busibase.atom.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.fsc.busibase.atom.api.FscOrderFailLogUpdateAtomService;
import com.tydic.fsc.busibase.atom.api.FscUocOrderRelUpdateAtomService;
import com.tydic.fsc.busibase.atom.bo.FscOrderFailLogUpdateAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscUocOrderRelUpdateAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscUocOrderRelUpdateAtomRspBO;
import com.tydic.fsc.busibase.external.api.bo.FscUocOrderRelUpdateReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscUocOrderRelUpdateRspBO;
import com.tydic.fsc.busibase.external.api.uoc.FscUocOrderRelUpdateAbilityService;
import com.tydic.fsc.constants.FscBillStatus;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderRelationMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscOrderRelationPO;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscUocOrderRelUpdateAtomServiceImpl
implements FscUocOrderRelUpdateAtomService {
    private static final Logger log = LoggerFactory.getLogger(FscUocOrderRelUpdateAtomServiceImpl.class);
    @Autowired
    private FscUocOrderRelUpdateAbilityService fscUocOrderRelUpdateAbilityService;
    @Autowired
    private FscOrderRelationMapper fscOrderRelationMapper;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscOrderFailLogUpdateAtomService fscOrderFailLogUpdateAtomService;

    @Override
    public FscUocOrderRelUpdateAtomRspBO dealRelUpdate(FscUocOrderRelUpdateAtomReqBO reqBO) {
        this.val(reqBO);
        FscOrderPO fscOrderPO = new FscOrderPO();
        fscOrderPO.setFscOrderId(reqBO.getFscOrderId());
        fscOrderPO = this.fscOrderMapper.getModelBy(fscOrderPO);
        if (null == fscOrderPO) {
            throw new FscBusinessException("194313", "\u67e5\u8be2\u7ed3\u7b97\u5355\u4e3a\u7a7a");
        }
        if (FscConstants.OrderFlow.PL_SERVICE_FEE.equals(fscOrderPO.getOrderFlow())) {
            return new FscUocOrderRelUpdateAtomRspBO();
        }
        if (FscConstants.FscRelUpdateAtomOperType.FSC_ORDER.equals(reqBO.getOperType())) {
            FscOrderRelationPO fscOrderRelation = new FscOrderRelationPO();
            fscOrderRelation.setFscOrderId(reqBO.getFscOrderId());
            List<FscOrderRelationPO> fscOrderRelationPOS = this.fscOrderRelationMapper.getList(fscOrderRelation);
            if (!CollectionUtils.isEmpty(fscOrderRelationPOS)) {
                FscOrderPO finalFscOrderPO = fscOrderPO;
                fscOrderRelationPOS.forEach(fscOrderRelationPO -> {
                    FscUocOrderRelUpdateRspBO fscUocOrderRelUpdateRspBO;
                    FscUocOrderRelUpdateReqBO fscUocOrderRelUpdateReqBO = new FscUocOrderRelUpdateReqBO();
                    fscUocOrderRelUpdateReqBO.setInspectionVoucherId(fscOrderRelationPO.getAcceptOrderId());
                    fscUocOrderRelUpdateReqBO.setOrderId(fscOrderRelationPO.getOrderId());
                    fscUocOrderRelUpdateReqBO.setRelId(reqBO.getFscOrderId());
                    fscUocOrderRelUpdateReqBO.setRelState(reqBO.getRelState());
                    if (null == reqBO.getRelState()) {
                        fscUocOrderRelUpdateReqBO.setRelState(this.getRelStatus(finalFscOrderPO.getOrderState()));
                    }
                    if (FscConstants.OrderFlow.YEAR_ORDER_SERVICE_FEE.equals(finalFscOrderPO.getOrderFlow()) || FscConstants.OrderFlow.YEAR_ACCEPT_SERVICE_FEE.equals(finalFscOrderPO.getOrderFlow()) || FscConstants.OrderFlow.MONTH_SERVICE_FEE.equals(finalFscOrderPO.getOrderFlow())) {
                        fscUocOrderRelUpdateReqBO.setRelType(FscConstants.FscRelType.SERVICE_INVOICE);
                    }
                    if (FscConstants.OrderFlow.INVOICE.equals(finalFscOrderPO.getOrderFlow())) {
                        if (FscConstants.FscOrderReceiveType.OPERATION.equals(finalFscOrderPO.getReceiveType())) {
                            fscUocOrderRelUpdateReqBO.setRelType(FscConstants.FscRelType.PRO_INVOICE);
                        }
                        if (FscConstants.FscOrderReceiveType.PURCHASE.equals(finalFscOrderPO.getReceiveType()) && FscConstants.FscOrderMakeType.OPERTION.equals(finalFscOrderPO.getMakeType())) {
                            fscUocOrderRelUpdateReqBO.setRelType(FscConstants.FscRelType.TRADE_INVOICE);
                        }
                        if (FscConstants.FscOrderReceiveType.PURCHASE.equals(finalFscOrderPO.getReceiveType()) && !FscConstants.FscOrderMakeType.OPERTION.equals(finalFscOrderPO.getMakeType())) {
                            fscUocOrderRelUpdateReqBO.setRelType(FscConstants.FscRelType.MATCH_INVOICE);
                        }
                    }
                    if (!"0000".equals((fscUocOrderRelUpdateRspBO = this.fscUocOrderRelUpdateAbilityService.dealRelUpdate(fscUocOrderRelUpdateReqBO)).getRespCode())) {
                        if (log.isDebugEnabled()) {
                            log.debug("\u540c\u6b65\u8ba2\u5355\u4e2d\u5fc3\u5931\u8d25:{}", (Object)JSON.toJSONString((Object)((Object)fscUocOrderRelUpdateRspBO)));
                        }
                        if (FscConstants.FscOrderFailRetansFlag.YES.equals(reqBO.getSyncOrderFlag())) {
                            throw new FscBusinessException("194313", JSON.toJSONString((Object)((Object)fscUocOrderRelUpdateRspBO)));
                        }
                        FscOrderFailLogUpdateAtomReqBO fscOrderFailLogUpdateAtomReqBO = new FscOrderFailLogUpdateAtomReqBO();
                        fscOrderFailLogUpdateAtomReqBO.setObjId(reqBO.getFscOrderId());
                        fscOrderFailLogUpdateAtomReqBO.setBusiType(FscConstants.FscOrderFailRetansBusiType.FSC_ORDER_SYNC_ORD);
                        fscOrderFailLogUpdateAtomReqBO.setBusiFailDesc(fscUocOrderRelUpdateRspBO.getRespDesc());
                        this.fscOrderFailLogUpdateAtomService.dealInsert(fscOrderFailLogUpdateAtomReqBO);
                    }
                });
            }
        }
        if (FscConstants.FscRelUpdateAtomOperType.ORDER.equals(reqBO.getOperType())) {
            reqBO.getFscOrderRelUpdateBOS().forEach(fscOrderRelUpdateBO -> {
                FscUocOrderRelUpdateReqBO fscUocOrderRelUpdateReqBO = (FscUocOrderRelUpdateReqBO)((Object)((Object)JSON.parseObject((String)JSON.toJSONString((Object)fscOrderRelUpdateBO), FscUocOrderRelUpdateReqBO.class)));
                FscUocOrderRelUpdateRspBO fscUocOrderRelUpdateRspBO = this.fscUocOrderRelUpdateAbilityService.dealRelUpdate(fscUocOrderRelUpdateReqBO);
                if (!"0000".equals(fscUocOrderRelUpdateRspBO.getRespCode())) {
                    if (log.isDebugEnabled()) {
                        log.debug("\u540c\u6b65\u8ba2\u5355\u4e2d\u5fc3\u5931\u8d25:{}", (Object)JSON.toJSONString((Object)((Object)fscUocOrderRelUpdateRspBO)));
                    }
                    if (FscConstants.FscOrderFailRetansFlag.YES.equals(reqBO.getSyncOrderFlag())) {
                        throw new FscBusinessException("194313", JSON.toJSONString((Object)((Object)fscUocOrderRelUpdateRspBO)));
                    }
                }
            });
        }
        return new FscUocOrderRelUpdateAtomRspBO();
    }

    private void val(FscUocOrderRelUpdateAtomReqBO reqBO) {
        if (null == reqBO) {
            throw new FscBusinessException("191000", "\u66f4\u65b0\u8ba2\u5355\u72b6\u6001\u539f\u5b50\u670d\u52a1\u5165\u53c2\u5bf9\u8c61\u4e3a\u7a7a");
        }
        if (null == reqBO.getOperType()) {
            throw new FscBusinessException("191000", "\u66f4\u65b0\u8ba2\u5355\u72b6\u6001\u539f\u5b50\u670d\u52a1\u5165\u53c2\u64cd\u4f5c\u7c7b\u578b\u4e3a\u7a7a");
        }
        if (FscConstants.FscRelUpdateAtomOperType.FSC_ORDER.equals(reqBO.getOperType())) {
            if (null == reqBO.getFscOrderId()) {
                throw new FscBusinessException("191000", "\u66f4\u65b0\u8ba2\u5355\u72b6\u6001\u539f\u5b50\u670d\u52a1\u5165\u53c2\u7ed3\u7b97\u5355ID\u4e3a\u7a7a");
            }
        } else if (FscConstants.FscRelUpdateAtomOperType.ORDER.equals(reqBO.getOperType())) {
            if (!CollectionUtils.isEmpty(reqBO.getFscOrderRelUpdateBOS())) {
                throw new FscBusinessException("191000", "\u66f4\u65b0\u8ba2\u5355\u72b6\u6001\u539f\u5b50\u670d\u52a1\u5165\u53c2\u8ba2\u5355\u5bf9\u8c61\u4e3a\u7a7a");
            }
        } else {
            throw new FscBusinessException("191000", "\u66f4\u65b0\u8ba2\u5355\u72b6\u6001\u539f\u5b50\u670d\u52a1\u5165\u53c2\u64cd\u4f5c\u7c7b\u578b\u672a\u5b9a\u4e49");
        }
    }

    private Integer getRelStatus(Integer orderState) {
        if (FscBillStatus.SIGNED_SUCCEED.getCode().equals(orderState)) {
            return FscConstants.FscRelStatus.SIGN;
        }
        if (FscBillStatus.INVOICED.getCode().equals(orderState)) {
            return FscConstants.FscRelStatus.BILLED;
        }
        if (FscBillStatus.MAIN_ORDER_CANCELLATION.getCode().equals(orderState)) {
            return FscConstants.FscRelStatus.UNCOMMITTED;
        }
        return FscConstants.FscRelStatus.COMMITTED;
    }
}

