/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.mmc.busi.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.mmc.ability.bo.MmcShopAccessoryBO;
import com.tydic.mmc.ability.bo.MmcShopContactsBO;
import com.tydic.mmc.atom.api.MmcStartApprovalProcessAtomService;
import com.tydic.mmc.atom.bo.MmcStartApprovalProcessAtomReqBO;
import com.tydic.mmc.atom.bo.MmcStartApprovalProcessAtomRspBO;
import com.tydic.mmc.busi.api.MmcCreateShopAuditBusiService;
import com.tydic.mmc.busi.bo.MmcCreateShopAuditBusiReqBO;
import com.tydic.mmc.busi.bo.MmcCreateShopAuditBusiRspBO;
import com.tydic.mmc.dao.MmcAuditRecordMapper;
import com.tydic.mmc.dao.MmcShopAccessoryMapper;
import com.tydic.mmc.dao.MmcShopChangeMapper;
import com.tydic.mmc.dao.MmcShopContactsMapper;
import com.tydic.mmc.dao.MmcShopMapper;
import com.tydic.mmc.po.MmcAuditRecordPo;
import com.tydic.mmc.po.MmcShopAccessoryPo;
import com.tydic.mmc.po.MmcShopChangePo;
import com.tydic.mmc.po.MmcShopContactsPo;
import com.tydic.mmc.po.MmcShopPo;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class MmcCreateShopAuditBusiServiceImpl
implements MmcCreateShopAuditBusiService {
    @Autowired
    private MmcStartApprovalProcessAtomService mmcStartApprovalProcessAtomService;
    @Autowired
    private MmcAuditRecordMapper mmcAuditRecordMapper;
    @Autowired
    private MmcShopMapper mmcShopMapper;
    @Autowired
    private MmcShopAccessoryMapper mmcShopAccessoryMapper;
    @Autowired
    private MmcShopContactsMapper mmcShopContactsMapper;
    @Autowired
    private MmcShopChangeMapper mmcShopChangeMapper;

    @Override
    public MmcCreateShopAuditBusiRspBO createShopAudit(MmcCreateShopAuditBusiReqBO reqBO) {
        MmcStartApprovalProcessAtomRspBO mmcStartApprovalProcessAtomRspBO;
        if ("1".equals(reqBO.getAuditType())) {
            mmcStartApprovalProcessAtomRspBO = this.startApprovalProcess(reqBO, "mmc_shop_create", Integer.valueOf("1"));
            this.addShopCreateAuditRecord(mmcStartApprovalProcessAtomRspBO, reqBO);
            this.updateShopInfo(reqBO);
            this.updateShopAccessoryInfo(reqBO);
            this.updateShopContactInfo(reqBO);
        } else if ("2".equals(reqBO.getAuditType())) {
            mmcStartApprovalProcessAtomRspBO = this.startApprovalProcess(reqBO, "mmc_shop_change", Integer.valueOf("2"));
            this.addShopChangeAuditRecord(mmcStartApprovalProcessAtomRspBO, reqBO);
            Long shopChangeId = this.updateShopChangeInfo(reqBO);
            this.updateShopStatus(reqBO.getShopId(), "2", null);
            this.updateShopChangeAccessoryInfo(reqBO, shopChangeId);
            this.updateShopChangeContactInfo(reqBO, shopChangeId);
        } else if ("3".equals(reqBO.getAuditType())) {
            mmcStartApprovalProcessAtomRspBO = this.startApprovalProcess(reqBO, "mmc_shop_freeze", Integer.valueOf("3"));
            this.addShopFreezeAuditRecord(mmcStartApprovalProcessAtomRspBO, reqBO);
            this.updateShopStatus(reqBO.getShopId(), "4", reqBO.getOffSkuFlag());
        } else if ("4".equals(reqBO.getAuditType())) {
            mmcStartApprovalProcessAtomRspBO = this.startApprovalProcess(reqBO, "mmc_shop_thaw", Integer.valueOf("4"));
            this.addShopThawAuditRecord(mmcStartApprovalProcessAtomRspBO, reqBO);
            this.updateShopStatus(reqBO.getShopId(), "6", null);
        } else {
            throw new ZTBusinessException("\u9519\u8bef\u7684\u5ba1\u6279\u7c7b\u578b");
        }
        MmcCreateShopAuditBusiRspBO rspBO = new MmcCreateShopAuditBusiRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u63d0\u4ea4\u5ba1\u6838\u6210\u529f");
        return rspBO;
    }

    private void updateShopContactInfo(MmcCreateShopAuditBusiReqBO reqBO) {
        MmcShopContactsPo deleteMmcShopContactsPo = new MmcShopContactsPo();
        deleteMmcShopContactsPo.setShopId(reqBO.getShopId());
        deleteMmcShopContactsPo.setRelativeType("1");
        this.mmcShopContactsMapper.deleteByCondition(deleteMmcShopContactsPo);
        if (!CollectionUtils.isEmpty(reqBO.getMmcShopContactsBOs())) {
            ArrayList<MmcShopContactsPo> newShopContactsPos = new ArrayList<MmcShopContactsPo>();
            for (MmcShopContactsBO mmcShopContactsBO : reqBO.getMmcShopContactsBOs()) {
                MmcShopContactsPo newShopContactPo = new MmcShopContactsPo();
                newShopContactPo.setContractId(Sequence.getInstance().nextId());
                newShopContactPo.setShopId(reqBO.getShopId());
                newShopContactPo.setRelativeId(reqBO.getShopId());
                newShopContactPo.setRelativeType("1");
                newShopContactPo.setContactPhone(mmcShopContactsBO.getContactPhone());
                newShopContactPo.setContractName(mmcShopContactsBO.getContractName());
                newShopContactPo.setPosition(mmcShopContactsBO.getPosition());
                newShopContactPo.setRemark(mmcShopContactsBO.getRemark());
                newShopContactsPos.add(newShopContactPo);
            }
            this.mmcShopContactsMapper.insertBatch(newShopContactsPos);
        }
    }

    private void updateShopChangeContactInfo(MmcCreateShopAuditBusiReqBO reqBO, Long shopChangeId) {
        MmcShopContactsPo deleteShopChangeContactsPo = new MmcShopContactsPo();
        deleteShopChangeContactsPo.setShopId(reqBO.getShopId());
        deleteShopChangeContactsPo.setRelativeType("2");
        this.mmcShopContactsMapper.deleteByCondition(deleteShopChangeContactsPo);
        if (!CollectionUtils.isEmpty(reqBO.getMmcShopContactsBOs())) {
            ArrayList<MmcShopContactsPo> newShopChangeContactsPos = new ArrayList<MmcShopContactsPo>();
            for (MmcShopContactsBO mmcShopContactsBO : reqBO.getMmcShopContactsBOs()) {
                MmcShopContactsPo newShopChangeContactPo = new MmcShopContactsPo();
                newShopChangeContactPo.setContractId(Sequence.getInstance().nextId());
                newShopChangeContactPo.setShopId(reqBO.getShopId());
                newShopChangeContactPo.setRelativeId(shopChangeId);
                newShopChangeContactPo.setRelativeType("2");
                newShopChangeContactPo.setContactPhone(mmcShopContactsBO.getContactPhone());
                newShopChangeContactPo.setContractName(mmcShopContactsBO.getContractName());
                newShopChangeContactPo.setPosition(mmcShopContactsBO.getPosition());
                newShopChangeContactPo.setRemark(mmcShopContactsBO.getRemark());
                newShopChangeContactsPos.add(newShopChangeContactPo);
            }
            this.mmcShopContactsMapper.insertBatch(newShopChangeContactsPos);
        }
    }

    private void updateShopChangeAccessoryInfo(MmcCreateShopAuditBusiReqBO reqBO, Long shopChangeId) {
        MmcShopAccessoryPo deleteMmcShopAccessoryPo = new MmcShopAccessoryPo();
        deleteMmcShopAccessoryPo.setShopId(reqBO.getShopId());
        deleteMmcShopAccessoryPo.setRelativeType("2");
        this.mmcShopAccessoryMapper.deleteByCondition(deleteMmcShopAccessoryPo);
        if (!CollectionUtils.isEmpty(reqBO.getMmcShopAccessoryBOs())) {
            ArrayList<MmcShopAccessoryPo> newShopChangeAccessoryPos = new ArrayList<MmcShopAccessoryPo>();
            for (MmcShopAccessoryBO mmcShopAccessoryBO : reqBO.getMmcShopAccessoryBOs()) {
                MmcShopAccessoryPo newShopChangeAccessoryPo = new MmcShopAccessoryPo();
                newShopChangeAccessoryPo.setAccessoryId(Sequence.getInstance().nextId());
                newShopChangeAccessoryPo.setShopId(reqBO.getShopId());
                newShopChangeAccessoryPo.setRelativeId(shopChangeId);
                newShopChangeAccessoryPo.setRelativeType("2");
                newShopChangeAccessoryPo.setAccessoryUrl(mmcShopAccessoryBO.getAccessoryUrl());
                newShopChangeAccessoryPo.setAccessoryName(mmcShopAccessoryBO.getAccessoryName());
                newShopChangeAccessoryPo.setAccessorySerial(mmcShopAccessoryBO.getAccessorySerial());
                newShopChangeAccessoryPos.add(newShopChangeAccessoryPo);
            }
            this.mmcShopAccessoryMapper.insertBatch(newShopChangeAccessoryPos);
        }
    }

    private void updateShopAccessoryInfo(MmcCreateShopAuditBusiReqBO reqBO) {
        MmcShopAccessoryPo deleteMmcShopAccessoryPo = new MmcShopAccessoryPo();
        deleteMmcShopAccessoryPo.setShopId(reqBO.getShopId());
        deleteMmcShopAccessoryPo.setRelativeType("1");
        this.mmcShopAccessoryMapper.deleteByCondition(deleteMmcShopAccessoryPo);
        if (!CollectionUtils.isEmpty(reqBO.getMmcShopAccessoryBOs())) {
            ArrayList<MmcShopAccessoryPo> newShopAccessoryPos = new ArrayList<MmcShopAccessoryPo>();
            for (MmcShopAccessoryBO mmcShopAccessoryBO : reqBO.getMmcShopAccessoryBOs()) {
                MmcShopAccessoryPo newShopAccessoryPo = new MmcShopAccessoryPo();
                newShopAccessoryPo.setAccessoryId(Sequence.getInstance().nextId());
                newShopAccessoryPo.setShopId(reqBO.getShopId());
                newShopAccessoryPo.setRelativeId(reqBO.getShopId());
                newShopAccessoryPo.setRelativeType("1");
                newShopAccessoryPo.setAccessoryUrl(mmcShopAccessoryBO.getAccessoryUrl());
                newShopAccessoryPo.setAccessoryName(mmcShopAccessoryBO.getAccessoryName());
                newShopAccessoryPo.setAccessorySerial(mmcShopAccessoryBO.getAccessorySerial());
                newShopAccessoryPos.add(newShopAccessoryPo);
            }
            this.mmcShopAccessoryMapper.insertBatch(newShopAccessoryPos);
        }
    }

    private void updateShopStatus(Long shopId, String status, String offSkuFlag) {
        MmcShopPo shopInfo = this.mmcShopMapper.selectByPrimaryKey(shopId);
        if (null != shopInfo) {
            shopInfo.setStatus(status);
            shopInfo.setOffSkuFlag(offSkuFlag);
            int result = this.mmcShopMapper.updateByPrimaryKeySelective(shopInfo);
            if (1 != result) {
                throw new ZTBusinessException("\u66f4\u65b0\u5e97\u94fa\u4fe1\u606f\u5931\u8d25");
            }
        } else {
            throw new ZTBusinessException("\u5e97\u94fa\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
    }

    private void updateShopInfo(MmcCreateShopAuditBusiReqBO reqBO) {
        MmcShopPo shopInfo = this.mmcShopMapper.selectByPrimaryKey(reqBO.getShopId());
        if (null != shopInfo) {
            BeanUtils.copyProperties((Object)reqBO.getMmcShopBO(), (Object)shopInfo);
            shopInfo.setShopId(reqBO.getShopId());
            shopInfo.setStatus("2");
            shopInfo.setUpdateUserId(reqBO.getUserId());
            shopInfo.setUpdateUserName(reqBO.getUserName());
            shopInfo.setUpdateTime(new Date());
            int result = this.mmcShopMapper.updateByPrimaryKeySelective(shopInfo);
            if (1 != result) {
                throw new ZTBusinessException("\u66f4\u65b0\u5e97\u94fa\u4fe1\u606f\u5931\u8d25");
            }
        } else {
            throw new ZTBusinessException("\u5e97\u94fa\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
    }

    private Long updateShopChangeInfo(MmcCreateShopAuditBusiReqBO reqBO) {
        MmcShopChangePo queryMmcShopChangePo = new MmcShopChangePo();
        queryMmcShopChangePo.setShopId(reqBO.getShopId());
        List<MmcShopChangePo> mmcShopChangePos = this.mmcShopChangeMapper.selectByCondition(queryMmcShopChangePo);
        if (!CollectionUtils.isEmpty(mmcShopChangePos) && mmcShopChangePos.size() == 1) {
            MmcShopChangePo updateMmcShopChangePo = new MmcShopChangePo();
            BeanUtils.copyProperties((Object)mmcShopChangePos.get(0), (Object)updateMmcShopChangePo);
            BeanUtils.copyProperties((Object)reqBO.getMmcShopBO(), (Object)updateMmcShopChangePo);
            updateMmcShopChangePo.setShopId(reqBO.getShopId());
            updateMmcShopChangePo.setUpdateUserId(reqBO.getUserId());
            updateMmcShopChangePo.setUpdateUserName(reqBO.getUserName());
            updateMmcShopChangePo.setUpdateTime(new Date());
            int result = this.mmcShopChangeMapper.updateByPrimaryKey(updateMmcShopChangePo);
            if (1 != result) {
                throw new ZTBusinessException("\u66f4\u65b0\u5e97\u94fa\u53d8\u66f4\u4fe1\u606f\u5931\u8d25");
            }
            return updateMmcShopChangePo.getShopChangeId();
        }
        if (!CollectionUtils.isEmpty(mmcShopChangePos) && mmcShopChangePos.size() > 1) {
            throw new ZTBusinessException("\u5b58\u5728\u591a\u6761\u5e97\u94fa\u53d8\u66f4\u6570\u636e");
        }
        MmcShopChangePo insertMmcShopChangePo = new MmcShopChangePo();
        BeanUtils.copyProperties((Object)reqBO.getMmcShopBO(), (Object)insertMmcShopChangePo);
        insertMmcShopChangePo.setShopId(reqBO.getShopId());
        insertMmcShopChangePo.setShopChangeId(Sequence.getInstance().nextId());
        insertMmcShopChangePo.setUpdateUserId(reqBO.getUserId());
        insertMmcShopChangePo.setUpdateUserName(reqBO.getUserName());
        insertMmcShopChangePo.setUpdateTime(new Date());
        int result = this.mmcShopChangeMapper.insert(insertMmcShopChangePo);
        if (1 != result) {
            throw new ZTBusinessException("\u65b0\u589e\u5e97\u94fa\u53d8\u66f4\u4fe1\u606f\u5931\u8d25");
        }
        return insertMmcShopChangePo.getShopChangeId();
    }

    private void addShopCreateAuditRecord(MmcStartApprovalProcessAtomRspBO mmcStartApprovalProcessAtomRspBO, MmcCreateShopAuditBusiReqBO reqBO) {
        MmcAuditRecordPo deleteMmcAuditRecordPo = new MmcAuditRecordPo();
        deleteMmcAuditRecordPo.setShopId(reqBO.getShopId());
        deleteMmcAuditRecordPo.setAuditType("1");
        this.mmcAuditRecordMapper.deleteByCondition(deleteMmcAuditRecordPo);
        this.addAuditRecord(mmcStartApprovalProcessAtomRspBO, reqBO);
    }

    private void addShopFreezeAuditRecord(MmcStartApprovalProcessAtomRspBO mmcStartApprovalProcessAtomRspBO, MmcCreateShopAuditBusiReqBO reqBO) {
        MmcAuditRecordPo deleteMmcAuditRecordPo = new MmcAuditRecordPo();
        deleteMmcAuditRecordPo.setShopId(reqBO.getShopId());
        deleteMmcAuditRecordPo.setAuditType("3");
        this.mmcAuditRecordMapper.deleteByCondition(deleteMmcAuditRecordPo);
        this.addAuditRecord(mmcStartApprovalProcessAtomRspBO, reqBO);
    }

    private void addShopThawAuditRecord(MmcStartApprovalProcessAtomRspBO mmcStartApprovalProcessAtomRspBO, MmcCreateShopAuditBusiReqBO reqBO) {
        MmcAuditRecordPo deleteMmcAuditRecordPo = new MmcAuditRecordPo();
        deleteMmcAuditRecordPo.setShopId(reqBO.getShopId());
        deleteMmcAuditRecordPo.setAuditType("4");
        this.mmcAuditRecordMapper.deleteByCondition(deleteMmcAuditRecordPo);
        this.addAuditRecord(mmcStartApprovalProcessAtomRspBO, reqBO);
    }

    private void addShopChangeAuditRecord(MmcStartApprovalProcessAtomRspBO mmcStartApprovalProcessAtomRspBO, MmcCreateShopAuditBusiReqBO reqBO) {
        MmcAuditRecordPo deleteShopCreateAuditRecordPo = new MmcAuditRecordPo();
        deleteShopCreateAuditRecordPo.setShopId(reqBO.getShopId());
        deleteShopCreateAuditRecordPo.setAuditType("1");
        this.mmcAuditRecordMapper.deleteByCondition(deleteShopCreateAuditRecordPo);
        MmcAuditRecordPo deleteShopChangeAuditRecordPo = new MmcAuditRecordPo();
        deleteShopChangeAuditRecordPo.setShopId(reqBO.getShopId());
        deleteShopChangeAuditRecordPo.setAuditType("2");
        this.mmcAuditRecordMapper.deleteByCondition(deleteShopChangeAuditRecordPo);
        this.addAuditRecord(mmcStartApprovalProcessAtomRspBO, reqBO);
    }

    private void addAuditRecord(MmcStartApprovalProcessAtomRspBO mmcStartApprovalProcessAtomRspBO, MmcCreateShopAuditBusiReqBO reqBO) {
        MmcAuditRecordPo insertMmcAuditRecordPo = new MmcAuditRecordPo();
        insertMmcAuditRecordPo.setAuditRecordId(Sequence.getInstance().nextId());
        insertMmcAuditRecordPo.setShopId(reqBO.getShopId());
        insertMmcAuditRecordPo.setAuditType(reqBO.getAuditType());
        insertMmcAuditRecordPo.setAuditStatus("1");
        insertMmcAuditRecordPo.setAuditOrderId(mmcStartApprovalProcessAtomRspBO.getAuditOrderId());
        insertMmcAuditRecordPo.setStepId(mmcStartApprovalProcessAtomRspBO.getStepId());
        insertMmcAuditRecordPo.setNextApprovalId(mmcStartApprovalProcessAtomRspBO.getNextApprovalId());
        insertMmcAuditRecordPo.setOperRemark(reqBO.getOperRemark());
        int result = this.mmcAuditRecordMapper.insertSelective(insertMmcAuditRecordPo);
        if (1 != result) {
            throw new ZTBusinessException("\u751f\u6210\u5e97\u94fa\u5ba1\u6279\u8bb0\u5f55\u5931\u8d25");
        }
    }

    private MmcStartApprovalProcessAtomRspBO startApprovalProcess(MmcCreateShopAuditBusiReqBO reqBO, String procDefKey, Integer objType) {
        MmcStartApprovalProcessAtomReqBO mmcStartApprovalProcessAtomReqBO = new MmcStartApprovalProcessAtomReqBO();
        mmcStartApprovalProcessAtomReqBO.setProcDefKey(procDefKey);
        mmcStartApprovalProcessAtomReqBO.setShopId(reqBO.getShopId());
        mmcStartApprovalProcessAtomReqBO.setMenuId(procDefKey);
        mmcStartApprovalProcessAtomReqBO.setObjType(objType);
        mmcStartApprovalProcessAtomReqBO.setUserId(reqBO.getUserId());
        mmcStartApprovalProcessAtomReqBO.setUserName(reqBO.getUserName());
        mmcStartApprovalProcessAtomReqBO.setOrgId(reqBO.getOrgId());
        MmcStartApprovalProcessAtomRspBO mmcStartApprovalProcessAtomRspBO = this.mmcStartApprovalProcessAtomService.startApprovalProcess(mmcStartApprovalProcessAtomReqBO);
        if ("0000".equals(mmcStartApprovalProcessAtomRspBO.getRespCode())) {
            return mmcStartApprovalProcessAtomRspBO;
        }
        throw new ZTBusinessException(mmcStartApprovalProcessAtomRspBO.getRespDesc());
    }
}

