/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.busibase.atom.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.base.constant.RspConstantEnums;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.busibase.atom.api.UccApproveCreationAtomService;
import com.tydic.commodity.busibase.atom.bo.UccApproveCreationAtomReqBO;
import com.tydic.commodity.busibase.atom.bo.UccApproveCreationAtomRspBO;
import com.tydic.commodity.busibase.atom.bo.UccK2RspBO;
import com.tydic.commodity.dao.UccApproveK2DetailMapper;
import com.tydic.commodity.dao.UccApproveK2Mapper;
import com.tydic.commodity.po.UccApproveK2DetailPO;
import com.tydic.commodity.po.UccApproveK2PO;
import com.tydic.commodity.utils.HSHttpHelper;
import com.tydic.commodity.utils.HSNHttpHeader;
import com.tydic.commodity.utils.HttpRetBean;
import com.tydic.commodity.utils.PropertiesUtil;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class UccApproveCreationAtomServiceImpl
implements UccApproveCreationAtomService {
    private static final Logger log = LoggerFactory.getLogger(UccApproveCreationAtomServiceImpl.class);
    private Sequence sequence = Sequence.getInstance();
    private Long Id = this.sequence.nextId();
    @Autowired
    private UccApproveK2Mapper uccApproveK2Mapper;
    @Autowired
    private UccApproveK2DetailMapper uccApproveK2DetailMapper;

    @Override
    public UccApproveCreationAtomRspBO createApprove(UccApproveCreationAtomReqBO reqBO) {
        UccApproveCreationAtomRspBO rspBO = new UccApproveCreationAtomRspBO();
        if (StringUtils.isEmpty((Object)reqBO.getFormUrl())) {
            throw new BusinessException(RspConstantEnums.UAC_NOTASK_AUDIT_CREATE_FAIL.code(), "\u8868\u5355url\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBO.getWorkNo())) {
            throw new BusinessException(RspConstantEnums.UAC_NOTASK_AUDIT_CREATE_FAIL.code(), "\u5de5\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getObjType() == null) {
            throw new BusinessException(RspConstantEnums.UAC_NOTASK_AUDIT_CREATE_FAIL.code(), "\u5ba1\u6279\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBO.getMenuId())) {
            throw new BusinessException(RspConstantEnums.UAC_NOTASK_AUDIT_CREATE_FAIL.code(), "\u6d41\u7a0b\u5b9e\u4f8b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty(reqBO.getObjId())) {
            throw new BusinessException(RspConstantEnums.UAC_NOTASK_AUDIT_CREATE_FAIL.code(), "\u8bf7\u4f20\u5165\u5ba1\u6279\u5bf9\u8c61\u96c6\u5408");
        }
        UccK2RspBO k2RspBO = this.submit(reqBO);
        UccApproveK2PO uccApproveK2PO = new UccApproveK2PO();
        uccApproveK2PO.setId(this.Id);
        uccApproveK2PO.setK2Id(k2RspBO.getResultInfo().getK2Id());
        uccApproveK2PO.setApproveCode(reqBO.getMenuId());
        uccApproveK2PO.setApproveStatus(1);
        uccApproveK2PO.setApproveType(reqBO.getObjType());
        uccApproveK2PO.setCreateTime(new Date(System.currentTimeMillis()));
        this.uccApproveK2Mapper.insert(uccApproveK2PO);
        ArrayList<UccApproveK2DetailPO> list = new ArrayList<UccApproveK2DetailPO>();
        for (Long each : reqBO.getObjId()) {
            UccApproveK2DetailPO uccApproveK2DetailPO = new UccApproveK2DetailPO();
            uccApproveK2DetailPO.setId(this.Id);
            uccApproveK2DetailPO.setObjId(each);
            if (reqBO.getObjType() == 2) {
                uccApproveK2DetailPO.setObjType(1);
            } else {
                uccApproveK2DetailPO.setObjType(2);
            }
            list.add(uccApproveK2DetailPO);
        }
        this.uccApproveK2DetailMapper.insertBatch(list);
        rspBO.setFinish(false);
        rspBO.setNotFindFlag(false);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    public UccK2RspBO submit(UccApproveCreationAtomReqBO reqBO) {
        try {
            String reqStr = this.initReqStr(reqBO);
            log.info("reqStr\u5165\u53c2{}->" + reqStr);
            HttpRetBean httpRetBean = HSHttpHelper.doUrlPostRequest(new URI(PropertiesUtil.getProperty("K2_SUBMIT_FLOW_URL")), HSNHttpHeader.getRequestHeaders("json"), reqStr.getBytes("UTF-8"), "UTF-8", false);
            if (httpRetBean.getStatus() != 200) {
                log.error("\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1-\u63a5\u53e3\u8fd4\u56de\u5931\u8d25[http_status=" + httpRetBean.getStatus() + "], [http_url=" + PropertiesUtil.getProperty("K2_SUBMIT_FLOW_URL") + "]");
                throw new ZTBusinessException("K2\u53d1\u8d77\u5ba1\u6279\u63a5\u53e3\u51fa\u9519\uff0chttp_status = " + httpRetBean.getStatus());
            }
            log.info("K2\u53d1\u8d77\u5ba1\u6279\u63a5\u53e3\u8fd4\u56de\u54cd\u5e94\u62a5\u6587\uff1a" + httpRetBean.getStr());
            String returnString = httpRetBean.getStr();
            if (StringUtils.isEmpty((Object)returnString)) {
                log.error("K2\u7cfb\u7edf\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\uff01");
                throw new ZTBusinessException("K2\u7cfb\u7edf\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\uff01");
            }
            UccK2RspBO k2RspBO = this.resolveRsp(returnString);
            log.info("k2\u54cd\u5e94\u6570\u636e\uff1a" + k2RspBO.toString());
            return k2RspBO;
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new BusinessException("8888", "\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    private String initReqStr(UccApproveCreationAtomReqBO reqBO) {
        JSONObject esbInfo = new JSONObject();
        esbInfo.put("instId", (Object)"");
        esbInfo.put("requestTime", (Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS").format(new Date(System.currentTimeMillis())));
        JSONObject requestInfo = new JSONObject();
        requestInfo.put("bizId", (Object)this.Id.toString());
        requestInfo.put("processCode", (Object)"TEST20210416");
        requestInfo.put("sourceId", (Object)PropertiesUtil.getProperty("K2_SOURCE_ID"));
        requestInfo.put("folio", (Object)reqBO.getAuditAdvice());
        requestInfo.put("verifyData", (Object)0);
        requestInfo.put("applyUserCode", (Object)"201907057023");
        requestInfo.put("startUserCode", (Object)"201907057023");
        requestInfo.put("bizFormUrl", (Object)reqBO.getFormUrl());
        JSONObject reqJson = new JSONObject();
        reqJson.put("requestInfo", (Object)requestInfo);
        reqJson.put("esbInfo", (Object)esbInfo);
        return reqJson.toString();
    }

    private UccK2RspBO resolveRsp(String returnString) {
        try {
            JSONObject rspJsonObject = JSONObject.parseObject((String)returnString);
            UccK2RspBO k2RspBO = (UccK2RspBO)JSON.toJavaObject((JSON)rspJsonObject, UccK2RspBO.class);
            if (!"S".equals(k2RspBO.getEsbInfo().getReturnStatus())) {
                throw new ZTBusinessException("K2\u63a5\u53e3\u8fd4\u56de\u72b6\u6001\u5f02\u5e38\uff1a[" + k2RspBO.getEsbInfo().getReturnStatus() + "]" + k2RspBO.getEsbInfo().getReturnMsg());
            }
            return k2RspBO;
        }
        catch (Exception e) {
            log.error("\u8f6c\u6362K2\u7cfb\u7edf\u54cd\u5e94\u62a5\u6587\u51fa\u9519\uff1a" + e.getMessage());
            throw new RuntimeException("\u8f6c\u6362K2\u7cfb\u7edf\u54cd\u5e94\u62a5\u6587\u51fa\u9519\uff1a" + e.getMessage());
        }
    }
}

