/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.ability.impl;

import com.alibaba.fastjson.JSONObject;
import com.tydic.commodity.common.ability.api.UccSupplierAttrRecordQryAbilityService;
import com.tydic.commodity.common.ability.bo.UccPropHistoryRecordBo;
import com.tydic.commodity.common.ability.bo.UccPropValueHistoryRecordBo;
import com.tydic.commodity.common.ability.bo.UccSupplierAttrRecordQryAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccSupplierAttrRecordQryAbilityRspBO;
import com.tydic.commodity.dao.UccCommodityPropDefMapper;
import com.tydic.commodity.dao.UccPropValueListMapper;
import com.tydic.commodity.po.UccPropHistoryRecordPo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.common.ability.api.UccSupplierAttrRecordQryAbilityService"})
public class UccSupplierAttrRecordQryAbilityServiceImpl
implements UccSupplierAttrRecordQryAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccSupplierAttrRecordQryAbilityServiceImpl.class);
    @Autowired
    private UccCommodityPropDefMapper uccCommodityPropDefMapper;
    @Autowired
    private UccPropValueListMapper uccPropValueListMapper;

    @PostMapping(value={"getSupplierAttrRecord"})
    public UccSupplierAttrRecordQryAbilityRspBO getSupplierAttrRecord(@RequestBody UccSupplierAttrRecordQryAbilityReqBO reqBO) {
        UccSupplierAttrRecordQryAbilityRspBO rspBO = new UccSupplierAttrRecordQryAbilityRspBO();
        if (reqBO == null || reqBO.getCommodityTypeId() == null) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u5165\u53c2\u6216\u5546\u54c1\u7c7b\u578bID\u4e3a\u7a7a");
            return rspBO;
        }
        List uccPropHistoryRecordPoList = this.uccCommodityPropDefMapper.qeryVendorDefRecords(reqBO.getUserId(), reqBO.getCommodityTypeId(), reqBO.getPropTag(), reqBO.getCommodityPropGrpId());
        ArrayList<UccPropHistoryRecordBo> uccPropHistoryRecordBoList = new ArrayList<UccPropHistoryRecordBo>();
        for (UccPropHistoryRecordPo each : uccPropHistoryRecordPoList) {
            UccPropHistoryRecordBo uccPropHistoryRecordBo = new UccPropHistoryRecordBo();
            BeanUtils.copyProperties((Object)each, (Object)uccPropHistoryRecordBo);
            uccPropHistoryRecordBoList.add(uccPropHistoryRecordBo);
        }
        List defIds = uccPropHistoryRecordBoList.stream().map(UccPropHistoryRecordBo::getCommodityPropDefId).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(defIds)) {
            rspBO.setPropHistoryRecord(new ArrayList());
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
            return rspBO;
        }
        List uccPropValueListPoList = this.uccPropValueListMapper.queryVendorScope(defIds);
        List queryVendorScope = new ArrayList();
        if (!CollectionUtils.isEmpty((Collection)uccPropValueListPoList)) {
            queryVendorScope = JSONObject.parseArray((String)JSONObject.toJSONString((Object)uccPropValueListPoList), UccPropValueHistoryRecordBo.class);
        }
        if (!CollectionUtils.isEmpty(queryVendorScope)) {
            Map<Long, List<UccPropValueHistoryRecordBo>> valueMap = queryVendorScope.stream().collect(Collectors.groupingBy(UccPropValueHistoryRecordBo::getCommodityPropDefId));
            for (UccPropHistoryRecordBo each : uccPropHistoryRecordBoList) {
                if (!valueMap.containsKey(each.getCommodityPropDefId())) continue;
                each.setPropValueList(valueMap.get(each.getCommodityPropDefId()));
                each.setPropValueCount(Integer.valueOf(each.getPropValueList().size()));
            }
        }
        rspBO.setPropHistoryRecord(uccPropHistoryRecordBoList);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

