/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.ability.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.commodity.base.constant.ExcelNewUtils;
import com.tydic.commodity.common.ability.api.UccApplyForSaleTemplateImportAbilityService;
import com.tydic.commodity.common.ability.bo.ApplyForSaleImportBO;
import com.tydic.commodity.common.ability.bo.ApplyForSaleSkuInfoBO;
import com.tydic.commodity.common.ability.bo.UccApplyForSaleTemplateImportAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccApplyForSaleTemplateImportAbilityRspBO;
import com.tydic.commodity.dao.UccCommodityTypeMapper;
import com.tydic.commodity.po.UccCommodityTypePo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.common.ability.api.UccApplyForSaleTemplateImportAbilityService"})
public class UccApplyForSaleTemplateImportAbilityServiceImpl
implements UccApplyForSaleTemplateImportAbilityService {
    private static final Logger log = LogManager.getLogger(UccApplyForSaleTemplateImportAbilityServiceImpl.class);
    @Autowired
    private UccCommodityTypeMapper uccCommodityTypeMapper;

    @PostMapping(value={"dealApplyForSaleImport"})
    public UccApplyForSaleTemplateImportAbilityRspBO dealApplyForSaleImport(@RequestBody UccApplyForSaleTemplateImportAbilityReqBO reqBO) {
        UccApplyForSaleTemplateImportAbilityRspBO rspBO = new UccApplyForSaleTemplateImportAbilityRspBO();
        if (StringUtils.isEmpty((Object)reqBO.getUrl())) {
            rspBO.setRespCode("0001");
            rspBO.setRespDesc("\u6a21\u677f\u5bfc\u5165URL\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBO;
        }
        ApplyForSaleImportBO applyForSaleImportBO = this.getApplyForSaleSkuInfoBOList(reqBO.getUrl());
        if (!StringUtils.isEmpty((Object)applyForSaleImportBO.getErrorStr())) {
            rspBO.setImportList(applyForSaleImportBO.getImportList());
            rspBO.setRespCode("0002");
            rspBO.setRespDesc(applyForSaleImportBO.getErrorStr());
            return rspBO;
        }
        if (CollectionUtils.isNotEmpty((Collection)applyForSaleImportBO.getImportList())) {
            for (ApplyForSaleSkuInfoBO each : applyForSaleImportBO.getImportList()) {
                double v = Double.parseDouble(each.getCode());
                Long commodityTypeId = (long)v;
                UccCommodityTypePo uccCommodityTypePo = this.uccCommodityTypeMapper.queryPoByCommodityTypeId(commodityTypeId);
                if (uccCommodityTypePo == null) {
                    rspBO.setRespCode("0002");
                    rspBO.setRespDesc("\u5546\u54c1\u540d\u79f0\u4e3a\u201c" + each.getName() + "\u201c\u7684\u6570\u636e\u5217\u7684\u5546\u54c1\u7c7b\u578b\u7f16\u7801\u4e0d\u5b58\u5728");
                    return rspBO;
                }
                each.setType(uccCommodityTypePo.getCommodityTypeName());
                each.setCode(commodityTypeId.toString());
            }
        }
        rspBO.setImportList(applyForSaleImportBO.getImportList());
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private ApplyForSaleImportBO getApplyForSaleSkuInfoBOList(String url) {
        ApplyForSaleImportBO applyForSaleImportBO = new ApplyForSaleImportBO();
        List<Object> data = new ArrayList();
        try {
            data = this.dealEcxel(url, 3, 0);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ZTBusinessException(e.getMessage());
        }
        int rowNum = 2;
        ArrayList<ApplyForSaleSkuInfoBO> applyForSaleSkuInfoBOList = new ArrayList<ApplyForSaleSkuInfoBO>();
        try {
            if (CollectionUtils.isNotEmpty(data)) {
                for (List list : data) {
                    ++rowNum;
                    ApplyForSaleSkuInfoBO applyForSaleSkuInfoBO = new ApplyForSaleSkuInfoBO();
                    int i = 0;
                    String errorStr = null;
                    if (!StringUtils.isEmpty(list.get(i))) {
                        String name = (String)list.get(i++);
                        applyForSaleSkuInfoBO.setName(name);
                    } else {
                        errorStr = "\u7b2c" + rowNum + "\u884c\u6570\u636e\u51fa\u73b0\u95ee\u9898,\u8bf7\u68c0\u67e5\u683c\u5f0f!";
                    }
                    if (!StringUtils.isEmpty(list.get(i))) {
                        String code = (String)list.get(i++);
                        applyForSaleSkuInfoBO.setCode(new BigDecimal(code).toPlainString());
                    } else {
                        errorStr = "\u7b2c" + rowNum + "\u884c\u6570\u636e\u51fa\u73b0\u95ee\u9898,\u8bf7\u68c0\u67e5\u683c\u5f0f!";
                    }
                    if (!StringUtils.isEmpty(list.get(i))) {
                        String spec = (String)list.get(i++);
                        applyForSaleSkuInfoBO.setSpec(spec);
                    } else {
                        errorStr = "\u7b2c" + rowNum + "\u884c\u6570\u636e\u51fa\u73b0\u95ee\u9898,\u8bf7\u68c0\u67e5\u683c\u5f0f!";
                    }
                    if (!StringUtils.isEmpty(list.get(i))) {
                        String model = (String)list.get(i++);
                        applyForSaleSkuInfoBO.setModel(model);
                    } else {
                        errorStr = "\u7b2c" + rowNum + "\u884c\u6570\u636e\u51fa\u73b0\u95ee\u9898,\u8bf7\u68c0\u67e5\u683c\u5f0f!";
                    }
                    if (!StringUtils.isEmpty(list.get(i))) {
                        String numStr = (String)list.get(i++);
                        double temp = Double.parseDouble(new BigDecimal(numStr).toPlainString());
                        Integer num = (int)temp;
                        applyForSaleSkuInfoBO.setNum(num);
                    } else {
                        errorStr = "\u7b2c" + rowNum + "\u884c\u6570\u636e\u51fa\u73b0\u95ee\u9898,\u8bf7\u68c0\u67e5\u683c\u5f0f!";
                    }
                    if (!StringUtils.isEmpty(list.get(i))) {
                        Date date = HSSFDateUtil.getJavaDate((double)Double.parseDouble((String)list.get(i++)));
                        applyForSaleSkuInfoBO.setDate(date);
                    } else {
                        errorStr = "\u7b2c" + rowNum + "\u884c\u6570\u636e\u51fa\u73b0\u95ee\u9898,\u8bf7\u68c0\u67e5\u683c\u5f0f!";
                    }
                    if (i < list.size()) {
                        String remark = (String)list.get(i);
                        applyForSaleSkuInfoBO.setRemark(remark);
                    }
                    if (!StringUtils.isEmpty((Object)errorStr)) {
                        applyForSaleImportBO.setErrorStr(errorStr);
                    }
                    applyForSaleSkuInfoBOList.add(applyForSaleSkuInfoBO);
                }
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
            e.printStackTrace();
            throw new ZTBusinessException("\u7b2c" + rowNum + "\u884c\u6570\u636e\u51fa\u73b0\u95ee\u9898,\u8bf7\u68c0\u67e5\u683c\u5f0f!" + e.getMessage());
        }
        applyForSaleImportBO.setImportList(applyForSaleSkuInfoBOList);
        return applyForSaleImportBO;
    }

    private List<List<String>> dealEcxel(String url, Integer startReadLine, Integer sheetAt) {
        if (StringUtils.isEmpty((Object)url)) {
            return new ArrayList<List<String>>();
        }
        ArrayList<List<String>> lines = new ArrayList<List<String>>();
        try {
            ExcelNewUtils.getExcelDate((String)url, lines, (Integer)startReadLine, (Integer)sheetAt);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            e.printStackTrace();
            throw new ZTBusinessException("\u5904\u7406Excel\u5931\u8d25");
        }
        log.info("\u8bfb\u53d6\u5230\u7684\u6570\u636e\uff1a" + JSONObject.toJSONString(lines));
        return lines;
    }
}

