/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.busi.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.base.constant.UccConstants;
import com.tydic.commodity.common.ability.bo.UccSpuCombinedInfoBO;
import com.tydic.commodity.common.busi.api.UccCombSpuCreateBusiService;
import com.tydic.commodity.common.busi.bo.UccCombSpuCreateBusiReqBO;
import com.tydic.commodity.common.busi.bo.UccCombSpuCreateBusiRspBO;
import com.tydic.commodity.common.busi.impl.UccAddPropGroupBusiServiceImpl;
import com.tydic.commodity.dao.UccCombSpuMapper;
import com.tydic.commodity.po.UccCombSkuPo;
import com.tydic.commodity.po.UccCombSpuPo;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UccCombSpuCreateBusiServiceImpl
implements UccCombSpuCreateBusiService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UccAddPropGroupBusiServiceImpl.class);
    private Sequence sequence = Sequence.getInstance();
    @Autowired
    private UccCombSpuMapper uccCombSpuMapper;

    @Override
    public UccCombSpuCreateBusiRspBO delCombSpuCreate(UccCombSpuCreateBusiReqBO reqBO) {
        ArrayList<UccCombSkuPo> skuPoList = new ArrayList<UccCombSkuPo>();
        UccCombSpuCreateBusiRspBO rspBO = new UccCombSpuCreateBusiRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        if (CollectionUtils.isEmpty(reqBO.getSpuList())) {
            rspBO.setRespCode("0001");
            rspBO.setRespDesc("\u5546\u54c1\u6e05\u5355\u4e3a\u7a7a");
            return rspBO;
        }
        UccCombSpuPo spuPo = new UccCombSpuPo();
        BeanUtils.copyProperties((Object)((Object)reqBO), (Object)spuPo);
        for (UccSpuCombinedInfoBO infoBO : reqBO.getSpuList()) {
            if (!UccConstants.CombSpuConstant.MAIN_SKU.equals(infoBO.getCombinedInfoType())) continue;
            spuPo.setCommodityId(infoBO.getCommodityId());
            spuPo.setSkuId(infoBO.getSkuId());
            spuPo.setSupplierShopId(infoBO.getSupplierShopId());
        }
        Integer integer = null;
        try {
            integer = this.uccCombSpuMapper.insertSpu(spuPo);
        }
        catch (Exception e) {
            LOGGER.error("\u7ec4\u5408\u5546\u54c1\u65b0\u589e\u5931\u8d25\uff1a" + e.getMessage());
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u7ec4\u5408\u5546\u54c1\u65b0\u589e\u5931\u8d25");
            return rspBO;
        }
        if (integer == null || integer <= 0) {
            throw new ZTBusinessException("\u63d2\u5165\u6570\u636e\u5931\u8d25");
        }
        for (UccSpuCombinedInfoBO infoBO : reqBO.getSpuList()) {
            UccCombSkuPo skuPo = new UccCombSkuPo();
            BeanUtils.copyProperties((Object)infoBO, (Object)skuPo);
            skuPo.setCombinedId(spuPo.getCombinedId());
            skuPo.setRemark(spuPo.getRemark());
            skuPo.setCombinedInfoId(Long.valueOf(this.sequence.nextId()));
            skuPoList.add(skuPo);
        }
        Integer rspInt = null;
        try {
            rspInt = this.uccCombSpuMapper.insertSku(skuPoList);
        }
        catch (Exception e) {
            LOGGER.error("\u7ec4\u5408\u5546\u54c1list\u65b0\u589e\u5931\u8d25\uff1a" + e.getMessage());
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u7ec4\u5408\u5546\u54c1list\u65b0\u589e\u5931\u8d25");
            return rspBO;
        }
        if (rspInt == null || rspInt == 0) {
            throw new ZTBusinessException("\u63d2\u5165\u6570\u636e\u5931\u8d25");
        }
        return rspBO;
    }
}

