/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.commodity.common.ability.api.UccApprovalprocessListRealQryAbilityService;
import com.tydic.commodity.common.ability.bo.UccApprovalprocessListRealBO;
import com.tydic.commodity.common.ability.bo.UccApprovalprocessListRealQryAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccApprovalprocessListRealQryAbilityRspBO;
import com.tydic.commodity.common.ability.bo.UccK2ProcessLogBO;
import com.tydic.commodity.common.ability.bo.UccK2RspBO;
import com.tydic.commodity.dao.UccApproveK2Mapper;
import com.tydic.commodity.dao.UccCommodityMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.po.UccApprovalprocessListRealQryPo;
import com.tydic.commodity.po.UccCommodityPo;
import com.tydic.commodity.po.UccSkuPo;
import com.tydic.commodity.utils.HSHttpHelper;
import com.tydic.commodity.utils.HSNHttpHeader;
import com.tydic.commodity.utils.HttpRetBean;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.http.Header;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.common.ability.api.UccApprovalprocessListRealQryAbilityService"})
public class UccApprovalprocessListRealQryAbilityServiceImpl
implements UccApprovalprocessListRealQryAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccApprovalprocessListRealQryAbilityServiceImpl.class);
    @Autowired
    private UccApproveK2Mapper uccApproveK2Mapper;
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private UccCommodityMapper uccCommodityMapper;
    private static final String K2_SOURCE_ID = "BU00149";
    private static final String K2_QRY_HISTORY_FLOW_URL = "http://10.10.178.49:8001/json/GetProcessLog/v1";

    @PostMapping(value={"getApprovalprocessList"})
    public UccApprovalprocessListRealQryAbilityRspBO getApprovalprocessList(@RequestBody UccApprovalprocessListRealQryAbilityReqBO reqBo) {
        UccCommodityPo rspPo;
        UccApprovalprocessListRealQryAbilityRspBO rspBO = new UccApprovalprocessListRealQryAbilityRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        String str = this.verify(reqBo);
        if (!StringUtils.isEmpty((Object)str)) {
            rspBO.setRespCode("0001");
            rspBO.setRespDesc(str);
            return rspBO;
        }
        if (reqBo.getSkuId() == null) {
            UccCommodityPo uccCommodityPo = new UccCommodityPo();
            uccCommodityPo.setCommodityId(reqBo.getCommodityId());
            if (reqBo.getSupplierShopId() != null) {
                uccCommodityPo.setSupplierShopId(reqBo.getSupplierShopId());
            }
            if ((rspPo = this.uccCommodityMapper.qryCommdByCommdId(uccCommodityPo.getCommodityId(), uccCommodityPo.getSupplierShopId())) == null) {
                rspBO.setRespCode("8888");
                rspBO.setRespDesc("\u5546\u54c1\u8868\u67e5\u8be2\u4e0d\u5230\u8be5\u5546\u54c1\u6570\u636e");
                return rspBO;
            }
        } else {
            List uccSkuPos;
            UccSkuPo uccSkuPo = new UccSkuPo();
            uccSkuPo.setSkuId(reqBo.getSkuId());
            if (reqBo.getSupplierShopId() != null) {
                uccSkuPo.setSupplierShopId(reqBo.getSupplierShopId());
            }
            if (CollectionUtils.isEmpty((Collection)(uccSkuPos = this.uccSkuMapper.qerySku(uccSkuPo)))) {
                rspBO.setRespCode("8888");
                rspBO.setRespDesc("\u5355\u54c1\u8868\u67e5\u8be2\u4e0d\u5230\u8be5\u5546\u54c1\u6570\u636e");
                return rspBO;
            }
        }
        UccApprovalprocessListRealQryPo qryPo = new UccApprovalprocessListRealQryPo();
        if (reqBo.getSkuId() == null) {
            qryPo.setObjType(Integer.valueOf(1));
            qryPo.setObjId(reqBo.getCommodityId());
        } else {
            qryPo.setObjType(Integer.valueOf(2));
            qryPo.setObjId(reqBo.getSkuId());
        }
        rspPo = this.uccApproveK2Mapper.queryByObjId(qryPo);
        if (rspPo == null || rspPo.getK2Id() == null) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u5546\u54c1k2\u5ba1\u6279\u6d41\u8868\u67e5\u8be2\u4e0d\u5230\u8be5\u5546\u54c1\u5ba1\u6279\u6570\u636e");
            return rspBO;
        }
        try {
            String reqStr = this.initReqStr(rspPo.getK2Id(), reqBo.getPageSize(), reqBo.getPageNo());
            log.info("reqStr\u5165\u53c2{}->" + reqStr);
            HttpRetBean httpRetBean = HSHttpHelper.doUrlPostRequest((URI)new URI(K2_QRY_HISTORY_FLOW_URL), (Header[])HSNHttpHeader.getRequestHeaders((String)"json"), (byte[])reqStr.getBytes("UTF-8"), (String)"UTF-8", (Boolean)false);
            if (httpRetBean.getStatus() != 200) {
                log.error("\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1-\u63a5\u53e3\u8fd4\u56de\u5931\u8d25[http_status=" + httpRetBean.getStatus() + "]");
                throw new ZTBusinessException("K2\u83b7\u53d6\u5ba1\u6279\u4fe1\u606f\u63a5\u53e3\u51fa\u9519\uff0chttp_status = " + httpRetBean.getStatus());
            }
            log.info("K2\u83b7\u53d6\u5ba1\u6279\u4fe1\u606f\u63a5\u53e3\u8fd4\u56de\u54cd\u5e94\u62a5\u6587\uff1a" + httpRetBean.getStr());
            String returnString = httpRetBean.getStr();
            if (StringUtils.isEmpty((Object)returnString)) {
                log.error("K2\u7cfb\u7edf\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\uff01");
                throw new ZTBusinessException("K2\u7cfb\u7edf\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\uff01");
            }
            UccK2RspBO k2RspBO = this.resolveRsp(returnString);
            log.info("k2\u54cd\u5e94\u6570\u636e\uff1a" + k2RspBO.toString());
            ArrayList<UccApprovalprocessListRealBO> kTwoApprovalList = new ArrayList<UccApprovalprocessListRealBO>();
            if (!CollectionUtils.isEmpty((Collection)k2RspBO.getResultInfo().getProcessLogs())) {
                for (UccK2ProcessLogBO each : k2RspBO.getResultInfo().getProcessLogs()) {
                    UccApprovalprocessListRealBO agrKTwoApprovalBO = new UccApprovalprocessListRealBO();
                    agrKTwoApprovalBO.setActivityName(each.getActivityName());
                    agrKTwoApprovalBO.setApproverUserName(each.getApproverUserName());
                    agrKTwoApprovalBO.setApproveTime(each.getApproveTime());
                    agrKTwoApprovalBO.setApproveComment(each.getApproveComment());
                    agrKTwoApprovalBO.setApproveActionName(each.getApproveActionName());
                    agrKTwoApprovalBO.setK2Id(each.getK2Id());
                    kTwoApprovalList.add(agrKTwoApprovalBO);
                }
            }
            rspBO.setRows(kTwoApprovalList);
            rspBO.setPageNo(k2RspBO.getQueryInfo().getCurrentPage().intValue());
            rspBO.setRecordsTotal(k2RspBO.getQueryInfo().getTotalRecord().intValue());
            rspBO.setTotal(k2RspBO.getQueryInfo().getTotalPage().intValue());
            return rspBO;
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new ZTBusinessException("\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    private String verify(UccApprovalprocessListRealQryAbilityReqBO reqBO) {
        if (reqBO.getCommodityId() == null && reqBO.getSkuId() == null) {
            return "\u5546\u54c1/\u5355\u54c1ID\u540c\u65f6\u4e3a\u7a7a";
        }
        return null;
    }

    private String initReqStr(String k2Id, Integer pageSize, Integer currentPage) {
        JSONObject esbInfo = new JSONObject();
        esbInfo.put("instId", (Object)"");
        esbInfo.put("requestTime", (Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS").format(new Date(System.currentTimeMillis())));
        JSONObject queryInfo = new JSONObject();
        queryInfo.put("pageSize", (Object)pageSize);
        queryInfo.put("currentPage", (Object)currentPage);
        JSONObject requestInfo = new JSONObject();
        requestInfo.put("k2Id", (Object)k2Id);
        requestInfo.put("sourceId", (Object)K2_SOURCE_ID);
        JSONObject reqJson = new JSONObject();
        reqJson.put("requestInfo", (Object)requestInfo);
        reqJson.put("queryInfo", (Object)queryInfo);
        reqJson.put("esbInfo", (Object)esbInfo);
        return reqJson.toString();
    }

    private UccK2RspBO resolveRsp(String returnString) {
        try {
            JSONObject rspJsonObject = JSONObject.parseObject((String)returnString);
            UccK2RspBO k2RspBO = (UccK2RspBO)JSON.toJavaObject((JSON)rspJsonObject, UccK2RspBO.class);
            if (!"S".equals(k2RspBO.getEsbInfo().getReturnStatus())) {
                throw new ZTBusinessException("K2\u63a5\u53e3\u8fd4\u56de\u72b6\u6001\u5f02\u5e38\uff1a[" + k2RspBO.getEsbInfo().getReturnStatus() + "]" + k2RspBO.getEsbInfo().getReturnMsg());
            }
            return k2RspBO;
        }
        catch (Exception e) {
            log.error("\u8f6c\u6362K2\u7cfb\u7edf\u54cd\u5e94\u62a5\u6587\u51fa\u9519\uff1a" + e.getMessage());
            throw new RuntimeException("\u8f6c\u6362K2\u7cfb\u7edf\u54cd\u5e94\u62a5\u6587\u51fa\u9519\uff1a" + e.getMessage());
        }
    }
}

