/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.busi.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Page;
import com.tydic.commodity.common.ability.bo.UccCombinedSpuInfoBO;
import com.tydic.commodity.common.busi.api.UccCombSpuListQryBusiService;
import com.tydic.commodity.common.busi.bo.UccCombSpuListQryBusiReqBO;
import com.tydic.commodity.common.busi.bo.UccCombSpuListQryBusiRspBO;
import com.tydic.commodity.dao.UccCombSpuMapper;
import com.tydic.commodity.dao.UccEMdmMaterialMapper;
import com.tydic.commodity.po.UccCombSpuListQryPo;
import com.tydic.commodity.po.UccEMdmMaterialPO;
import com.tydic.commodity.po.UcccombinedDateInfoPO;
import com.tydic.commodity.utils.MoneyUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class UccCombSpuListQryBusiServiceImpl
implements UccCombSpuListQryBusiService {
    private static final Logger log = LoggerFactory.getLogger(UccCombSpuListQryBusiServiceImpl.class);
    @Autowired
    private UccCombSpuMapper uccCombSpuMapper;
    @Autowired
    private UccEMdmMaterialMapper uccEMdmMaterialMapper;

    @Override
    public UccCombSpuListQryBusiRspBO getCombSpuListQry(UccCombSpuListQryBusiReqBO reqBO) {
        UccCombSpuListQryBusiRspBO rspBO = new UccCombSpuListQryBusiRspBO();
        UccCombSpuListQryPo uccCombSpuListQryPo = new UccCombSpuListQryPo();
        BeanUtils.copyProperties((Object)((Object)reqBO), (Object)uccCombSpuListQryPo);
        Page page = new Page();
        page.setPageSize(reqBO.getPageSize());
        page.setPageNo(reqBO.getPageNo());
        List spuList = null;
        try {
            spuList = this.uccCombSpuMapper.queryCombSpus(uccCombSpuListQryPo, page);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("mapper\u7ec4\u5408\u5546\u54c1\u67e5\u8be2\u5931\u8d25\uff1a" + e.getMessage());
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u7ec4\u5408\u5546\u54c1\u67e5\u8be2\u5f02\u5e38");
            return rspBO;
        }
        if (CollectionUtils.isEmpty((Collection)spuList)) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a");
            return rspBO;
        }
        ArrayList<UccCombinedSpuInfoBO> rows = new ArrayList<UccCombinedSpuInfoBO>();
        for (UccCombSpuListQryPo po : spuList) {
            System.out.println(po);
            if (null != po.getScope() && po.getScope() == 1) {
                po.setScopeDesc("\u6309\u7ec4\u7ec7");
            } else {
                po.setScopeDesc("\u5168\u90e8");
            }
            BigDecimal total = new BigDecimal("0");
            for (UcccombinedDateInfoPO dateInfoPO : po.getCombinedDateInfo()) {
                if (dateInfoPO.getSkuPrice() != null) {
                    dateInfoPO.setSalePrice(MoneyUtils.haoToYuan((Long)dateInfoPO.getSkuPrice()));
                    total = total.add(MoneyUtils.haoToYuan((Long)dateInfoPO.getSkuPrice()).multiply(new BigDecimal(dateInfoPO.getCount())));
                }
                if (StringUtils.isEmpty((Object)dateInfoPO.getMaterialCode())) continue;
                Long l = 0L;
                try {
                    l = Long.parseLong(dateInfoPO.getMaterialCode());
                }
                catch (NumberFormatException e) {
                    throw new ZTBusinessException("\u5546\u54c1\u8868\u7269\u6599\u7f16\u7801\u683c\u5f0f\u9519\u8bef");
                }
                UccEMdmMaterialPO uccEMdmMaterialPO = this.uccEMdmMaterialMapper.selectByPrimaryKey(l);
                if (uccEMdmMaterialPO == null) continue;
                dateInfoPO.setMaterialCode(uccEMdmMaterialPO.getMaterialCode());
            }
            po.setSalePrice(total);
            UccCombinedSpuInfoBO uccCombinedSpuInfoBO = new UccCombinedSpuInfoBO();
            BeanUtils.copyProperties((Object)po, (Object)uccCombinedSpuInfoBO);
            rows.add(uccCombinedSpuInfoBO);
        }
        rspBO.setRows(rows);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setPageNo(reqBO.getPageNo());
        rspBO.setRecordsTotal(page.getTotalCount());
        rspBO.setTotal(page.getTotalPages());
        return rspBO;
    }
}

