/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.busi.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.cache.CacheClient;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.common.ability.bo.MaterialCharactRequestInfo;
import com.tydic.commodity.common.busi.api.UccSnySiCharactBusiService;
import com.tydic.commodity.common.busi.bo.UccSnySiCharactBusiReqBO;
import com.tydic.commodity.common.busi.bo.UccSnySiCharactBusiRspBO;
import com.tydic.commodity.dao.UccEMdmMaterialMapper;
import com.tydic.commodity.dao.UccEMdmMaterialPropDefMapper;
import com.tydic.commodity.po.UccEMdmMaterialPO;
import com.tydic.commodity.po.UccEMdmMaterialPropDefPO;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UccSnySiCharactBusiServiceImpl
implements UccSnySiCharactBusiService {
    private static final Logger log = LoggerFactory.getLogger(UccSnySiCharactBusiServiceImpl.class);
    @Autowired
    private UccEMdmMaterialPropDefMapper uccEMdmMaterialPropDefMapper;
    @Autowired
    private UccEMdmMaterialMapper uccEMdmMaterialMapper;
    @Autowired
    private CacheClient cacheClient;
    private Sequence sequence = Sequence.getInstance();
    private SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");

    @Override
    public UccSnySiCharactBusiRspBO snySiCharact(UccSnySiCharactBusiReqBO reqBo) {
        UccSnySiCharactBusiRspBO rspBO = new UccSnySiCharactBusiRspBO();
        List<MaterialCharactRequestInfo> requestinfos = reqBo.getREQUESTINFO();
        ArrayList<UccEMdmMaterialPropDefPO> list = new ArrayList<UccEMdmMaterialPropDefPO>();
        int rows = 0;
        if (!CollectionUtils.isEmpty(requestinfos)) {
            try {
                for (int i = 0; i < requestinfos.size(); ++i) {
                    MaterialCharactRequestInfo info = requestinfos.get(i);
                    UccEMdmMaterialPropDefPO po = new UccEMdmMaterialPropDefPO();
                    List uccEMdmMaterialPropDefPOS = null;
                    if (StringUtils.isNotBlank((CharSequence)info.getZATNAM1())) {
                        po.setPropCode(info.getZATNAM1());
                        uccEMdmMaterialPropDefPOS = this.uccEMdmMaterialPropDefMapper.selectByPropCode(po.getPropCode());
                    }
                    if (!CollectionUtils.isEmpty(uccEMdmMaterialPropDefPOS)) continue;
                    long propDefId = this.sequence.nextId();
                    this.synAssociateMaterialData(info, po);
                    if (Objects.isNull(po.getMaterialCode())) {
                        po.setMaterialCode("NULL");
                    }
                    if (Objects.isNull(po.getMaterialId())) {
                        po.setMaterialId(Long.valueOf(propDefId));
                    }
                    if (Objects.isNull(po.getCatalogId())) {
                        po.setCatalogId(Long.valueOf(propDefId));
                    }
                    po.setPropDefId(Long.valueOf(propDefId));
                    po.setPropName(info.getZATBEZ1());
                    po.setCreateLoginId(info.getZCREATE_USER());
                    po.setCreateTime(StringUtils.isNotBlank((CharSequence)info.getZCREATE_TIME()) ? this.sdf.parse(info.getZCREATE_TIME()) : new Date());
                    po.setUpdateLoginId(info.getZUPDATE_USER());
                    po.setUpdateTime(StringUtils.isNotBlank((CharSequence)info.getZUPDATE_TIME()) ? this.sdf.parse(info.getZUPDATE_TIME()) : null);
                    po.setIsDelete(Integer.valueOf(StringUtils.isNotBlank((CharSequence)info.getZDELTED_TAG()) ? Integer.parseInt(info.getZDELTED_TAG()) : 0));
                    po.setRemark("\u6570\u636e\u4e2d\u53f0\u7269\u6599\u5c5e\u6027\u540c\u6b65");
                    list.add(po);
                }
                if (!CollectionUtils.isEmpty(list)) {
                    rows = this.uccEMdmMaterialPropDefMapper.insertBatch(list);
                }
            }
            catch (Exception e) {
                log.error("UccSnySiCharactBusiService , message : {}", (Object)e.getMessage());
                throw new ZTBusinessException("8888: \u540c\u6b65\u7269\u6599\u5c5e\u6027\u6570\u636e\u5f02\u5e38");
            }
        }
        if (rows == list.size()) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
        } else {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u5931\u8d25");
        }
        return rspBO;
    }

    private void synAssociateMaterialData(MaterialCharactRequestInfo info, UccEMdmMaterialPropDefPO po) {
        String materialCode = (String)this.cacheClient.get(info.getZATNAM1());
        if (StringUtils.isNotBlank((CharSequence)materialCode)) {
            po.setMaterialCode(materialCode);
            UccEMdmMaterialPO materialPO = new UccEMdmMaterialPO();
            materialPO.setMaterialCode(materialCode);
            List materialPOS = this.uccEMdmMaterialMapper.selectMaterialPrecisely(materialPO);
            if (!CollectionUtils.isEmpty((Collection)materialPOS)) {
                UccEMdmMaterialPO uccEMdmMaterialPO = (UccEMdmMaterialPO)materialPOS.get(0);
                po.setMaterialId(uccEMdmMaterialPO.getMaterialId());
                po.setCatalogId(uccEMdmMaterialPO.getCatalogId());
            }
        }
    }
}

