/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.busi.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.cache.CacheClient;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.common.ability.bo.FILE;
import com.tydic.commodity.common.ability.bo.MaterialRequestInfo;
import com.tydic.commodity.common.busi.api.UccSnySiMaterialSavedataBusiService;
import com.tydic.commodity.common.busi.bo.UccSnySiMaterialSavedataBusiReqBO;
import com.tydic.commodity.common.busi.bo.UccSnySiMaterialSavedataBusiRspBO;
import com.tydic.commodity.dao.UccCommodityMeasureMapper;
import com.tydic.commodity.dao.UccEMdmCatalogMapper;
import com.tydic.commodity.dao.UccEMdmMaterialMapper;
import com.tydic.commodity.dao.UccEMdmMaterialPicMapper;
import com.tydic.commodity.po.UccCommodityMeasurePo;
import com.tydic.commodity.po.UccEMdmCatalogPO;
import com.tydic.commodity.po.UccEMdmMaterialPO;
import com.tydic.commodity.po.UccEMdmMaterialPicPO;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UccSnySiMaterialSavedataBusiServiceImpl
implements UccSnySiMaterialSavedataBusiService {
    private static final Logger log = LoggerFactory.getLogger(UccSnySiMaterialSavedataBusiServiceImpl.class);
    @Autowired
    private UccEMdmMaterialMapper uccEMdmMaterialMapper;
    @Autowired
    private UccEMdmCatalogMapper uccEMdmCatalogMapper;
    @Autowired
    private UccEMdmMaterialPicMapper uccEMdmMaterialPicMapper;
    @Autowired
    private UccCommodityMeasureMapper uccCommodityMeasureMapper;
    @Autowired
    private CacheClient cacheClient;
    private Sequence sequence = Sequence.getInstance();
    private SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");

    @Override
    public UccSnySiMaterialSavedataBusiRspBO snySiMaterialSavedata(UccSnySiMaterialSavedataBusiReqBO reqBo) {
        UccSnySiMaterialSavedataBusiRspBO rspBO = new UccSnySiMaterialSavedataBusiRspBO();
        List<Object> requestinfos = reqBo.getREQUESTINFO();
        ArrayList<UccEMdmMaterialPO> list = new ArrayList<UccEMdmMaterialPO>();
        ArrayList<String> propCodes = new ArrayList<String>();
        ArrayList<String> materialCodes = new ArrayList<String>();
        int rows = 0;
        if (!CollectionUtils.isEmpty(requestinfos)) {
            requestinfos = requestinfos.stream().filter(each -> StringUtils.isNotBlank((CharSequence)each.getMATNR())).collect(Collectors.toList());
            try {
                for (int i = 0; i < requestinfos.size(); ++i) {
                    MaterialRequestInfo info = (MaterialRequestInfo)requestinfos.get(i);
                    UccEMdmMaterialPO po = new UccEMdmMaterialPO();
                    po.setMaterialCode(info.getMATNR());
                    List uccEMdmMaterialPOS = this.uccEMdmMaterialMapper.selectMaterialPrecisely(po);
                    if (!CollectionUtils.isEmpty((Collection)uccEMdmMaterialPOS)) continue;
                    long materialId = this.sequence.nextId();
                    po.setMaterialId(Long.valueOf(materialId));
                    po.setMaterialName(info.getMAKTX());
                    po.setShortDesc(info.getMAKTX());
                    po.setLongDesc(info.getMAKTX());
                    this.associateCatalog(info, po);
                    if (Objects.isNull(po.getCatalogId())) {
                        po.setCatalogId(po.getMaterialId());
                    }
                    po.setCatalogCode(info.getCLASS());
                    po.setCatalogName(info.getKLBEZ());
                    List charactList = info.getCHARACT();
                    if (!CollectionUtils.isEmpty((Collection)charactList)) {
                        StringBuilder sb = new StringBuilder();
                        for (Object charact : charactList) {
                            if ("GUIGECHICUN_CHANG".equals(charact.getATNAM())) {
                                sb.append(" " + charact.getATWRT());
                            } else if ("GUIGECHICUN_KUAN".equals(charact.getATNAM())) {
                                sb.append(" " + charact.getATWRT());
                            } else if ("GUIGECHICUN_HOU".equals(charact.getATNAM())) {
                                sb.append(" " + charact.getATWRT());
                            }
                            if ("PINPAI".equals(charact.getATNAM())) {
                                po.setBrandName(charact.getATWRT());
                            }
                            if ("XINGHAO".equals(charact.getATNAM())) {
                                po.setModel(charact.getATWRT());
                            }
                            if ("SHENGCHANGONGYI".equals(charact.getATNAM())) {
                                po.setTexture(charact.getATWRT());
                            }
                            this.cacheClient.setnx(charact.getATNAM(), (Object)info.getMATNR());
                            propCodes.add(charact.getATNAM());
                        }
                        po.setSpec(StringUtils.isNotBlank((CharSequence)sb.toString()) ? sb.toString().substring(1) : null);
                    }
                    po.setCreateTime(StringUtils.isNotBlank((CharSequence)info.getCREATE_TIME()) ? this.sdf.parse(info.getCREATE_TIME()) : new Date());
                    po.setUpdateTime(StringUtils.isNotBlank((CharSequence)info.getUPDATE_TIME()) ? this.sdf.parse(info.getUPDATE_TIME()) : null);
                    po.setIsDelete(Integer.valueOf(StringUtils.isNotBlank((CharSequence)info.getDELETE_TAG()) ? Integer.parseInt(info.getDELETE_TAG()) : 0));
                    ArrayList<UccEMdmMaterialPicPO> uccEMdmMaterialPicPOS = new ArrayList<UccEMdmMaterialPicPO>();
                    List files = info.getFILE();
                    if (!CollectionUtils.isEmpty((Collection)files)) {
                        Object charact;
                        charact = files.iterator();
                        while (charact.hasNext()) {
                            FILE file = (FILE)charact.next();
                            UccEMdmMaterialPicPO picPO = new UccEMdmMaterialPicPO();
                            long materialPicId = this.sequence.nextId();
                            picPO.setMaterialPicId(Long.valueOf(materialPicId));
                            picPO.setMaterialId(Long.valueOf(materialId));
                            picPO.setMaterialPicType(Integer.valueOf(StringUtils.isNotBlank((CharSequence)file.getSORT()) ? Integer.parseInt(file.getSORT()) : 1));
                            picPO.setMaterialPicUrl(file.getURL());
                            uccEMdmMaterialPicPOS.add(picPO);
                        }
                        po.setPicUrl(((FILE)files.get(0)).getURL());
                        this.uccEMdmMaterialPicMapper.insertBatch(uccEMdmMaterialPicPOS);
                    }
                    if (StringUtils.isNotBlank((CharSequence)info.getSTATUS())) {
                        if ("1".equals(info.getSTATUS())) {
                            po.setFreezeFlag(Integer.valueOf(0));
                        } else if ("2".equals(info.getSTATUS())) {
                            po.setFreezeFlag(Integer.valueOf(1));
                        }
                    }
                    po.setUuid(UUID.randomUUID().toString().replace("-", ""));
                    po.setMeasure(info.getMEINS());
                    this.associateMeasure(info, po);
                    po.setSource(Integer.valueOf(1));
                    po.setIndicate(Integer.valueOf(1));
                    po.setRemark("\u6570\u636e\u4e2d\u53f0\u7269\u6599\u540c\u6b65: {ZCREATE_USER: " + info.getCREATE_USER() + ",ZUPDATE_USER: " + info.getUPDATE_USER() + "}");
                    list.add(po);
                    HashMap<String, String> materialAssociateMap = new HashMap<String, String>();
                    materialAssociateMap.put("catalogCode", po.getCatalogCode());
                    materialAssociateMap.put("measureName", po.getMeasure());
                    this.cacheClient.setnx(po.getMaterialCode(), materialAssociateMap);
                    materialCodes.add(po.getMaterialCode());
                }
                this.cacheClient.set("propCodes", propCodes);
                if (!CollectionUtils.isEmpty(list)) {
                    rows = this.uccEMdmMaterialMapper.insertBatch(list);
                }
            }
            catch (Exception e) {
                log.error("UccSnySiMaterialSavedataBusiService , message : {}", (Object)e.getMessage());
                throw new ZTBusinessException("8888: \u540c\u6b65\u7269\u6599\u4e3b\u4f53\u6570\u636e\u5f02\u5e38");
            }
        }
        if (rows == list.size()) {
            this.cacheClient.set("materialCodes", materialCodes);
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
        } else {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u5931\u8d25");
        }
        return rspBO;
    }

    private void associateCatalog(MaterialRequestInfo info, UccEMdmMaterialPO po) {
        if (StringUtils.isNotBlank((CharSequence)info.getCLASS())) {
            UccEMdmCatalogPO uccEMdmCatalogPO = new UccEMdmCatalogPO();
            uccEMdmCatalogPO.setCatalogCode(info.getCLASS());
            List uccEMdmCatalogPOS = this.uccEMdmCatalogMapper.qryUccEMdmCatalog(uccEMdmCatalogPO);
            if (!CollectionUtils.isEmpty((Collection)uccEMdmCatalogPOS)) {
                po.setCatalogId(((UccEMdmCatalogPO)uccEMdmCatalogPOS.get(0)).getCatalogId());
            }
        }
    }

    private void associateMeasure(MaterialRequestInfo info, UccEMdmMaterialPO po) {
        List uccCommodityMeasurePos;
        if (StringUtils.isNotBlank((CharSequence)info.getMEINS()) && !CollectionUtils.isEmpty((Collection)(uccCommodityMeasurePos = this.uccCommodityMeasureMapper.queryMeasureByMeasureName(info.getMEINS())))) {
            po.setMeasureId(((UccCommodityMeasurePo)uccCommodityMeasurePos.get(0)).getMeasureId());
        }
    }
}

