/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.commodity.base.bo.SyncSceneCommodityToEsReqBO;
import com.tydic.commodity.base.bo.UccBatchSpuBO;
import com.tydic.commodity.base.constant.ModelRuleConstant;
import com.tydic.commodity.base.constant.RspConstantEnums;
import com.tydic.commodity.base.constant.UccConstants;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.busibase.atom.api.UccCommodityeditorsupdateAtomService;
import com.tydic.commodity.busibase.atom.api.UccSendBIPAlreadyDoneAtomService;
import com.tydic.commodity.busibase.atom.bo.UccCommodityeditorsupdateAtomReqBO;
import com.tydic.commodity.busibase.atom.bo.UccCommodityeditorsupdateAtomRspBO;
import com.tydic.commodity.busibase.atom.bo.UccK2RspBO;
import com.tydic.commodity.busibase.atom.bo.UccSendBIPAlreadyDoneAtomReqBO;
import com.tydic.commodity.busibase.atom.bo.UccSendBIPAlreadyDoneAtomRspBO;
import com.tydic.commodity.common.busi.api.UccSynAgreementApprovalResultBusiService;
import com.tydic.commodity.common.busi.bo.UccSynAgreementApprovalResultBusiReqBO;
import com.tydic.commodity.common.busi.bo.UccSynAgreementApprovalResultBusiRspBO;
import com.tydic.commodity.dao.UccApproveK2Mapper;
import com.tydic.commodity.dao.UccCommodityMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.po.UccApprovalprocessListRealQryPo;
import com.tydic.commodity.po.UccApproveK2PO;
import com.tydic.commodity.po.UccCommodityPo;
import com.tydic.commodity.po.UccSkuPo;
import com.tydic.commodity.utils.HSHttpHelper;
import com.tydic.commodity.utils.HSNHttpHeader;
import com.tydic.commodity.utils.HttpRetBean;
import com.tydic.commodity.utils.PropertiesUtil;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Resource;
import org.apache.http.Header;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class UccSynAgreementApprovalResultBusiServiceImpl
implements UccSynAgreementApprovalResultBusiService {
    private static final Logger log = LoggerFactory.getLogger(UccSynAgreementApprovalResultBusiServiceImpl.class);
    @Autowired
    private UccApproveK2Mapper uccApproveK2Mapper;
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private UccCommodityMapper uccCommodityMapper;
    @Autowired
    private UccSendBIPAlreadyDoneAtomService uccSendBIPAlreadyDoneAtomService;
    @Autowired
    private UccCommodityeditorsupdateAtomService uccCommodityeditorsupdateAtomService;
    @Value(value="${K2_SOURCE_ID}")
    private String K2_SOURCE_ID;
    @Value(value="${K2_PROCESS_ABANDONED_URL:http://10.10.178.49:8001/json/ProcessDelete/v1}")
    private String K2_PROCESS_ABANDONED_URL;
    @Value(value="${ARG_ON_SHELF_PROCESS}")
    private String ARG_ON_SHELF_PROCESS;
    @Value(value="${ARG_OFF_SHELF_PROCESS}")
    private String ARG_OFF_SHELF_PROCESS;
    @Resource(name="lmSyncCommodityMqServiceProvider")
    private ProxyMessageProducer lmSyncCommodityMqServiceProvider;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public UccSynAgreementApprovalResultBusiRspBO onShelfProcessApprovalResult(UccSynAgreementApprovalResultBusiReqBO reqBO) {
        UccSynAgreementApprovalResultBusiRspBO rspBO = new UccSynAgreementApprovalResultBusiRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        UccApprovalprocessListRealQryPo qryPo = new UccApprovalprocessListRealQryPo();
        qryPo.setK2Id(reqBO.getRequestInfo().getK2Id());
        qryPo.setApproveCode(this.ARG_ON_SHELF_PROCESS);
        List rspPos = this.uccApproveK2Mapper.queryObj(qryPo);
        if (CollectionUtils.isEmpty((Collection)rspPos)) {
            rspBO.setRespDesc("\u5ba1\u6279\u8bb0\u5f55\u8868\u4e2d\u672a\u67e5\u5230\u6570\u636e");
            rspBO.setRespCode("8888");
            return rspBO;
        }
        Integer status = reqBO.getRequestInfo().getStatus();
        ArrayList<Long> commodityIds = new ArrayList<Long>();
        ArrayList<UccSkuPo> esPos = new ArrayList<UccSkuPo>();
        for (UccApprovalprocessListRealQryPo rspPo : rspPos) {
            UccCommodityPo commodityPo;
            int i;
            if (rspPo.getObjType() != null && rspPo.getObjType() == 1) {
                rspBO.setRespDesc("\u5ba1\u6279\u8bb0\u5f55\u8868\u4e2d\u672a\u67e5\u5230\u6570\u636e");
                rspBO.setRespCode("8888");
                return rspBO;
            }
            if (rspPo.getObjType() == null || rspPo.getObjType() != 2) continue;
            UccSkuPo uccSkuPo = new UccSkuPo();
            uccSkuPo.setSkuId(rspPo.getObjId());
            List uccSkuPos = this.uccSkuMapper.qerySku(uccSkuPo);
            if (CollectionUtils.isEmpty((Collection)uccSkuPos)) {
                rspBO.setRespDesc("\u5355\u54c1\u8868\u4e2d\u672a\u67e5\u5230\u6570\u636e");
                rspBO.setRespCode("8888");
                return rspBO;
            }
            UccSkuPo skuPo = (UccSkuPo)uccSkuPos.get(0);
            if (UccConstants.Ucc_K2_APPROVAL_RESULT.PASS.equals(status)) {
                skuPo.setApprovalStatus(null);
                skuPo.setApprovalStatu("0");
                skuPo.setSkuStatus(Integer.valueOf(3));
                i = this.uccSkuMapper.modifySku(skuPo);
                if (i == 0) {
                    rspBO.setRespDesc("\u4fee\u6539\u5355\u54c1\u72b6\u6001\u5931\u8d25");
                    rspBO.setRespCode("8888");
                    return rspBO;
                }
                commodityPo = new UccCommodityPo();
                commodityPo.setCommodityId(skuPo.getCommodityId());
                commodityPo.setCommodityStatus(Integer.valueOf(3));
                int i1 = this.uccCommodityMapper.updateCommodity(commodityPo);
                if (i1 == 0) {
                    rspBO.setRespDesc("\u4fee\u6539\u5546\u54c1\u72b6\u6001\u5931\u8d25");
                    rspBO.setRespCode("8888");
                    return rspBO;
                }
                if (!CollectionUtils.isEmpty(commodityIds) && commodityIds.contains(skuPo.getCommodityId())) continue;
                commodityIds.add(skuPo.getCommodityId());
                UccSkuPo esPo = new UccSkuPo();
                esPo.setCommodityId(skuPo.getCommodityId());
                esPo.setSupplierShopId(skuPo.getSupplierShopId());
                esPos.add(esPo);
                continue;
            }
            if (UccConstants.Ucc_K2_APPROVAL_RESULT.REJECT.equals(status)) {
                skuPo.setApprovalStatu("23");
                skuPo.setApprovalStatus(null);
                if (skuPo.getSkuSource() != null && skuPo.getSkuSource() == 3) {
                    skuPo.setSkuStatus(Integer.valueOf(0));
                } else {
                    skuPo.setSkuStatus(Integer.valueOf(1));
                }
                i = this.uccSkuMapper.modifySku(skuPo);
                if (i == 0) {
                    rspBO.setRespDesc("\u4fee\u6539\u5355\u54c1\u72b6\u6001\u5931\u8d25");
                    rspBO.setRespCode("8888");
                    return rspBO;
                }
                commodityPo = new UccSkuPo();
                commodityPo.setCommodityId(skuPo.getCommodityId());
                List SkusOfCommodity = this.uccSkuMapper.qerySku((UccSkuPo)commodityPo);
                if (!CollectionUtils.isEmpty((Collection)SkusOfCommodity)) {
                    UccCommodityPo commodity;
                    if (skuPo.getSkuSource() != null && skuPo.getSkuSource() == 3) {
                        boolean i2 = false;
                        for (UccSkuPo po : SkusOfCommodity) {
                            if (po.getSkuStatus() == null || po.getSkuStatus() == 0) continue;
                            i2 = true;
                        }
                        if (!i2) {
                            commodity = new UccCommodityPo();
                            commodity.setCommodityId(skuPo.getCommodityId());
                            commodity.setCommodityStatus(Integer.valueOf(0));
                            int i1 = this.uccCommodityMapper.updateCommodity(commodity);
                            if (i == 0) {
                                rspBO.setRespDesc("\u4fee\u6539\u5546\u54c1\u72b6\u6001\u5931\u8d25");
                                rspBO.setRespCode("8888");
                                return rspBO;
                            }
                        }
                    } else {
                        boolean i2 = false;
                        for (UccSkuPo po : SkusOfCommodity) {
                            if (po.getSkuStatus() == null || po.getSkuStatus() == 1) continue;
                            i2 = true;
                        }
                        if (!i2) {
                            commodity = new UccCommodityPo();
                            commodity.setCommodityId(skuPo.getCommodityId());
                            commodity.setCommodityStatus(Integer.valueOf(1));
                            int i1 = this.uccCommodityMapper.updateCommodity(commodity);
                            if (i == 0) {
                                rspBO.setRespDesc("\u4fee\u6539\u5546\u54c1\u72b6\u6001\u5931\u8d25");
                                rspBO.setRespCode("8888");
                                return rspBO;
                            }
                        }
                    }
                }
                if (!CollectionUtils.isEmpty(commodityIds) && commodityIds.contains(skuPo.getCommodityId())) continue;
                commodityIds.add(skuPo.getCommodityId());
                UccSkuPo esPo = new UccSkuPo();
                esPo.setCommodityId(skuPo.getCommodityId());
                esPo.setSupplierShopId(skuPo.getSupplierShopId());
                esPos.add(esPo);
                continue;
            }
            if (status <= 5) continue;
            rspBO.setRespDesc("\u5ba1\u6838\u72b6\u6001\u9519\u8bef");
            rspBO.setRespCode("8888");
            return rspBO;
        }
        if (UccConstants.Ucc_K2_APPROVAL_RESULT.APPROVAL.equals(status)) {
            UccApproveK2PO set = new UccApproveK2PO();
            set.setApproveStatus(Integer.valueOf(3));
            if ("\u5f00\u59cb".equals(reqBO.getRequestInfo().getActivityName())) {
                set.setApproverUserCode(reqBO.getRequestInfo().getApproverUserCode());
            }
            set.setUpdateTime(new Date(System.currentTimeMillis()));
            UccApproveK2PO where = new UccApproveK2PO();
            where.setK2Id(reqBO.getRequestInfo().getK2Id());
            this.uccApproveK2Mapper.updateBy(set, where);
            UccSendBIPAlreadyDoneAtomReqBO atomReqBO = new UccSendBIPAlreadyDoneAtomReqBO();
            atomReqBO.setModelId(reqBO.getRequestInfo().getK2Id());
            atomReqBO.setType("1");
            atomReqBO.setBipType(Long.valueOf(2L));
            UccSendBIPAlreadyDoneAtomRspBO atomRspBO = null;
            try {
                atomRspBO = this.uccSendBIPAlreadyDoneAtomService.SendBIPAlreadyDone(atomReqBO);
            }
            catch (Exception e) {
                log.error("\u53d1\u9001BIP\u5df2\u529e\u4fe1\u606f\u62a5\u9519\uff1a{}", (Object)e.getMessage());
            }
            if (!"0000".equals(atomRspBO.getRespCode())) {
                log.error("\u53d1\u9001BIP\u5df2\u529e\u4fe1\u606f\u5f02\u5e38\uff1a{}", (Object)atomRspBO.getRespDesc());
            }
        } else {
            UccApproveK2PO uccApproveK2SetPO = new UccApproveK2PO();
            UccApproveK2PO uccApproveK2WherePO = new UccApproveK2PO();
            uccApproveK2WherePO.setId(((UccApprovalprocessListRealQryPo)rspPos.get(0)).getId());
            if (UccConstants.Ucc_K2_APPROVAL_RESULT.PASS.equals(status)) {
                uccApproveK2SetPO.setApproveStatus(Integer.valueOf(0));
            } else if (UccConstants.Ucc_K2_APPROVAL_RESULT.REJECT.equals(status)) {
                uccApproveK2SetPO.setApproveStatus(Integer.valueOf(2));
            }
            uccApproveK2SetPO.setFinshTime(new Date());
            int i2 = this.uccApproveK2Mapper.updateBy(uccApproveK2SetPO, uccApproveK2WherePO);
            if (i2 == 0) {
                rspBO.setRespDesc("\u4fee\u6539K2\u5ba1\u6279\u6d41\u7a0b\u8868\u5931\u8d25");
                rspBO.setRespCode("8888");
                return rspBO;
            }
            rspBO.setEsPos(esPos);
        }
        if (UccConstants.Ucc_K2_APPROVAL_RESULT.REJECT.equals(status)) {
            UccK2RspBO uccK2RspBO = this.submit(reqBO);
        }
        return rspBO;
    }

    @Override
    public UccSynAgreementApprovalResultBusiRspBO offShelfProcessApprovalResult(UccSynAgreementApprovalResultBusiReqBO reqBO) {
        UccSynAgreementApprovalResultBusiRspBO rspBO = new UccSynAgreementApprovalResultBusiRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        UccApprovalprocessListRealQryPo qryPo = new UccApprovalprocessListRealQryPo();
        qryPo.setK2Id(reqBO.getRequestInfo().getK2Id());
        qryPo.setApproveCode(this.ARG_OFF_SHELF_PROCESS);
        List rspPos = this.uccApproveK2Mapper.queryObj(qryPo);
        if (CollectionUtils.isEmpty((Collection)rspPos)) {
            rspBO.setRespDesc("\u5ba1\u6279\u8bb0\u5f55\u8868\u4e2d\u672a\u67e5\u5230\u6570\u636e");
            rspBO.setRespCode("8888");
            return rspBO;
        }
        Integer status = reqBO.getRequestInfo().getStatus();
        ArrayList<Long> commodityIds = new ArrayList<Long>();
        ArrayList<UccSkuPo> esPos = new ArrayList<UccSkuPo>();
        for (UccApprovalprocessListRealQryPo rspPo : rspPos) {
            UccSkuPo esPo;
            UccSkuPo commodityPo;
            int i;
            if (rspPo.getObjType() != null && rspPo.getObjType() == 1) {
                rspBO.setRespDesc("\u5ba1\u6279\u8bb0\u5f55\u8868\u4e2d\u672a\u67e5\u5230\u6570\u636e");
                rspBO.setRespCode("8888");
                return rspBO;
            }
            if (rspPo.getObjType() == null || rspPo.getObjType() != 2) continue;
            UccSkuPo uccSkuPo = new UccSkuPo();
            uccSkuPo.setSkuId(rspPo.getObjId());
            List uccSkuPos = this.uccSkuMapper.qerySku(uccSkuPo);
            if (CollectionUtils.isEmpty((Collection)uccSkuPos)) {
                rspBO.setRespDesc("\u5355\u54c1\u8868\u4e2d\u672a\u67e5\u5230\u6570\u636e");
                rspBO.setRespCode("8888");
                return rspBO;
            }
            UccSkuPo skuPo = (UccSkuPo)uccSkuPos.get(0);
            if (UccConstants.Ucc_K2_APPROVAL_RESULT.PASS.equals(status)) {
                skuPo.setApprovalStatu("0");
                skuPo.setApprovalStatus(null);
                skuPo.setSkuStatus(Integer.valueOf(5));
                i = this.uccSkuMapper.modifySku(skuPo);
                if (i == 0) {
                    rspBO.setRespDesc("\u4fee\u6539\u5355\u54c1\u72b6\u6001\u5931\u8d25");
                    rspBO.setRespCode("8888");
                    return rspBO;
                }
                commodityPo = new UccSkuPo();
                commodityPo.setCommodityId(skuPo.getCommodityId());
                commodityPo.setSkuStatus(Integer.valueOf(3));
                List SkusOfCommodity = this.uccSkuMapper.qerySku(commodityPo);
                if (CollectionUtils.isEmpty((Collection)SkusOfCommodity)) {
                    UccCommodityPo commodity = new UccCommodityPo();
                    commodity.setCommodityId(skuPo.getCommodityId());
                    commodity.setCommodityStatus(Integer.valueOf(5));
                    int i1 = this.uccCommodityMapper.updateCommodity(commodity);
                    if (i == 0) {
                        rspBO.setRespDesc("\u4fee\u6539\u5546\u54c1\u72b6\u6001\u5931\u8d25");
                        rspBO.setRespCode("8888");
                        return rspBO;
                    }
                }
                if (!CollectionUtils.isEmpty(commodityIds) && commodityIds.contains(skuPo.getCommodityId())) continue;
                commodityIds.add(skuPo.getCommodityId());
                esPo = new UccSkuPo();
                esPo.setCommodityId(skuPo.getCommodityId());
                esPo.setSupplierShopId(skuPo.getSupplierShopId());
                esPos.add(esPo);
                continue;
            }
            if (UccConstants.Ucc_K2_APPROVAL_RESULT.REJECT.equals(status)) {
                skuPo.setApprovalStatu("43");
                skuPo.setApprovalStatus(null);
                skuPo.setSkuStatus(Integer.valueOf(3));
                i = this.uccSkuMapper.modifySku(skuPo);
                if (i == 0) {
                    rspBO.setRespDesc("\u4fee\u6539\u5355\u54c1\u72b6\u6001\u5931\u8d25");
                    rspBO.setRespCode("8888");
                    return rspBO;
                }
                commodityPo = new UccCommodityPo();
                commodityPo.setCommodityId(skuPo.getCommodityId());
                commodityPo.setCommodityStatus(Integer.valueOf(3));
                int i1 = this.uccCommodityMapper.updateCommodity((UccCommodityPo)commodityPo);
                if (i1 == 0) {
                    rspBO.setRespDesc("\u4fee\u6539\u5546\u54c1\u72b6\u6001\u5931\u8d25");
                    rspBO.setRespCode("8888");
                    return rspBO;
                }
                if (!CollectionUtils.isEmpty(commodityIds) && commodityIds.contains(skuPo.getCommodityId())) continue;
                commodityIds.add(skuPo.getCommodityId());
                esPo = new UccSkuPo();
                esPo.setCommodityId(skuPo.getCommodityId());
                esPo.setSupplierShopId(skuPo.getSupplierShopId());
                esPos.add(esPo);
                continue;
            }
            if (status <= 5) continue;
            rspBO.setRespDesc("\u5ba1\u6838\u72b6\u6001\u9519\u8bef");
            rspBO.setRespCode("8888");
            return rspBO;
        }
        if (UccConstants.Ucc_K2_APPROVAL_RESULT.APPROVAL.equals(status)) {
            UccApproveK2PO set = new UccApproveK2PO();
            set.setApproveStatus(Integer.valueOf(3));
            if ("\u5f00\u59cb".equals(reqBO.getRequestInfo().getActivityName())) {
                set.setApproverUserCode(reqBO.getRequestInfo().getApproverUserCode());
            }
            UccApproveK2PO where = new UccApproveK2PO();
            where.setK2Id(reqBO.getRequestInfo().getK2Id());
            this.uccApproveK2Mapper.updateBy(set, where);
            UccSendBIPAlreadyDoneAtomReqBO atomReqBO = new UccSendBIPAlreadyDoneAtomReqBO();
            atomReqBO.setModelId(reqBO.getRequestInfo().getK2Id());
            atomReqBO.setType("1");
            atomReqBO.setBipType(Long.valueOf(2L));
            UccSendBIPAlreadyDoneAtomRspBO atomRspBO = null;
            try {
                atomRspBO = this.uccSendBIPAlreadyDoneAtomService.SendBIPAlreadyDone(atomReqBO);
            }
            catch (Exception e) {
                log.error("\u53d1\u9001BIP\u5df2\u529e\u4fe1\u606f\u62a5\u9519\uff1a{}", (Object)e.getMessage());
            }
            if (!"0000".equals(atomRspBO.getRespCode())) {
                log.error("\u53d1\u9001BIP\u5df2\u529e\u4fe1\u606f\u5f02\u5e38\uff1a{}", (Object)atomRspBO.getRespDesc());
            }
        } else {
            UccApproveK2PO uccApproveK2SetPO = new UccApproveK2PO();
            UccApproveK2PO uccApproveK2WherePO = new UccApproveK2PO();
            uccApproveK2WherePO.setId(((UccApprovalprocessListRealQryPo)rspPos.get(0)).getId());
            if (UccConstants.Ucc_K2_APPROVAL_RESULT.PASS.equals(status)) {
                uccApproveK2SetPO.setApproveStatus(Integer.valueOf(0));
            } else if (UccConstants.Ucc_K2_APPROVAL_RESULT.REJECT.equals(status)) {
                uccApproveK2SetPO.setApproveStatus(Integer.valueOf(2));
            }
            uccApproveK2SetPO.setFinshTime(new Date());
            int i2 = this.uccApproveK2Mapper.updateBy(uccApproveK2SetPO, uccApproveK2WherePO);
            if (i2 == 0) {
                rspBO.setRespDesc("\u4fee\u6539K2\u5ba1\u6279\u6d41\u7a0b\u8868\u5931\u8d25");
                rspBO.setRespCode("8888");
                return rspBO;
            }
            rspBO.setEsPos(esPos);
        }
        if (UccConstants.Ucc_K2_APPROVAL_RESULT.REJECT.equals(status)) {
            UccK2RspBO uccK2RspBO = this.submit(reqBO);
        }
        return rspBO;
    }

    @Override
    public UccSynAgreementApprovalResultBusiRspBO argReinstateProcessApprovalResult(UccSynAgreementApprovalResultBusiReqBO reqBO) {
        UccSynAgreementApprovalResultBusiRspBO rspBO = new UccSynAgreementApprovalResultBusiRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        UccApprovalprocessListRealQryPo qryPo = new UccApprovalprocessListRealQryPo();
        qryPo.setK2Id(reqBO.getRequestInfo().getK2Id());
        qryPo.setApproveCode(this.ARG_ON_SHELF_PROCESS);
        List rspPos = this.uccApproveK2Mapper.queryObj(qryPo);
        if (CollectionUtils.isEmpty((Collection)rspPos)) {
            rspBO.setRespDesc("\u5ba1\u6279\u8bb0\u5f55\u8868\u4e2d\u672a\u67e5\u5230\u6570\u636e");
            rspBO.setRespCode("8888");
            return rspBO;
        }
        Integer status = reqBO.getRequestInfo().getStatus();
        ArrayList<Long> commodityIds = new ArrayList<Long>();
        ArrayList<UccSkuPo> esPos = new ArrayList<UccSkuPo>();
        for (UccApprovalprocessListRealQryPo rspPo : rspPos) {
            int i;
            if (rspPo.getObjType() != null && rspPo.getObjType() == 1) {
                rspBO.setRespDesc("\u5ba1\u6279\u8bb0\u5f55\u8868\u4e2d\u672a\u67e5\u5230\u6570\u636e");
                rspBO.setRespCode("8888");
                return rspBO;
            }
            if (rspPo.getObjType() != 2) continue;
            UccSkuPo uccSkuPo = new UccSkuPo();
            uccSkuPo.setSkuId(rspPo.getObjId());
            List uccSkuPos = this.uccSkuMapper.qerySku(uccSkuPo);
            if (CollectionUtils.isEmpty((Collection)uccSkuPos)) {
                rspBO.setRespDesc("\u5355\u54c1\u8868\u4e2d\u672a\u67e5\u5230\u6570\u636e");
                rspBO.setRespCode("8888");
                return rspBO;
            }
            UccSkuPo skuPo = (UccSkuPo)uccSkuPos.get(0);
            if (UccConstants.Ucc_K2_APPROVAL_RESULT.PASS.equals(status)) {
                skuPo.setApprovalStatu("0");
                skuPo.setApprovalStatus(null);
                skuPo.setSkuStatus(Integer.valueOf(3));
                i = this.uccSkuMapper.modifySku(skuPo);
                if (i == 0) {
                    rspBO.setRespDesc("\u4fee\u6539\u5355\u54c1\u72b6\u6001\u5931\u8d25");
                    rspBO.setRespCode("8888");
                    return rspBO;
                }
                UccCommodityPo commodityPo = new UccCommodityPo();
                commodityPo.setCommodityId(skuPo.getCommodityId());
                commodityPo.setCommodityStatus(Integer.valueOf(3));
                int i1 = this.uccCommodityMapper.updateCommodity(commodityPo);
                if (i1 == 0) {
                    rspBO.setRespDesc("\u4fee\u6539\u5546\u54c1\u72b6\u6001\u5931\u8d25");
                    rspBO.setRespCode("8888");
                    return rspBO;
                }
                if (!CollectionUtils.isEmpty(commodityIds) && commodityIds.contains(skuPo.getCommodityId())) continue;
                commodityIds.add(skuPo.getCommodityId());
                UccSkuPo esPo = new UccSkuPo();
                esPo.setCommodityId(skuPo.getCommodityId());
                esPo.setSupplierShopId(skuPo.getSupplierShopId());
                esPos.add(esPo);
                continue;
            }
            if (UccConstants.Ucc_K2_APPROVAL_RESULT.REJECT.equals(status)) {
                skuPo.setApprovalStatu("53");
                skuPo.setApprovalStatus(null);
                i = this.uccSkuMapper.modifySku(skuPo);
                if (i == 0) {
                    rspBO.setRespDesc("\u4fee\u6539\u5355\u54c1\u5ba1\u6279\u72b6\u6001\u5931\u8d25");
                    rspBO.setRespCode("8888");
                    return rspBO;
                }
                if (!CollectionUtils.isEmpty(commodityIds) && commodityIds.contains(skuPo.getCommodityId())) continue;
                commodityIds.add(skuPo.getCommodityId());
                UccSkuPo esPo = new UccSkuPo();
                esPo.setCommodityId(skuPo.getCommodityId());
                esPo.setSupplierShopId(skuPo.getSupplierShopId());
                esPos.add(esPo);
                continue;
            }
            if (status <= 5) continue;
            rspBO.setRespDesc("\u5ba1\u6838\u72b6\u6001\u9519\u8bef");
            rspBO.setRespCode("8888");
            return rspBO;
        }
        if (UccConstants.Ucc_K2_APPROVAL_RESULT.APPROVAL.equals(status)) {
            UccApproveK2PO set = new UccApproveK2PO();
            set.setApproveStatus(Integer.valueOf(3));
            if ("\u5f00\u59cb".equals(reqBO.getRequestInfo().getActivityName())) {
                set.setApproverUserCode(reqBO.getRequestInfo().getApproverUserCode());
            }
            UccApproveK2PO where = new UccApproveK2PO();
            where.setK2Id(reqBO.getRequestInfo().getK2Id());
            this.uccApproveK2Mapper.updateBy(set, where);
            UccSendBIPAlreadyDoneAtomReqBO atomReqBO = new UccSendBIPAlreadyDoneAtomReqBO();
            atomReqBO.setModelId(reqBO.getRequestInfo().getK2Id());
            atomReqBO.setType("1");
            atomReqBO.setBipType(Long.valueOf(2L));
            UccSendBIPAlreadyDoneAtomRspBO atomRspBO = null;
            try {
                atomRspBO = this.uccSendBIPAlreadyDoneAtomService.SendBIPAlreadyDone(atomReqBO);
            }
            catch (Exception e) {
                log.error("\u53d1\u9001BIP\u5df2\u529e\u4fe1\u606f\u62a5\u9519\uff1a{}", (Object)e.getMessage());
            }
            if (!"0000".equals(atomRspBO.getRespCode())) {
                log.error("\u53d1\u9001BIP\u5df2\u529e\u4fe1\u606f\u5f02\u5e38\uff1a{}", (Object)atomRspBO.getRespDesc());
            }
        } else {
            UccApproveK2PO uccApproveK2SetPO = new UccApproveK2PO();
            UccApproveK2PO uccApproveK2WherePO = new UccApproveK2PO();
            uccApproveK2WherePO.setId(((UccApprovalprocessListRealQryPo)rspPos.get(0)).getId());
            if (UccConstants.Ucc_K2_APPROVAL_RESULT.PASS.equals(status)) {
                uccApproveK2SetPO.setApproveStatus(Integer.valueOf(0));
            } else if (UccConstants.Ucc_K2_APPROVAL_RESULT.REJECT.equals(status)) {
                uccApproveK2SetPO.setApproveStatus(Integer.valueOf(2));
            }
            uccApproveK2SetPO.setFinshTime(new Date());
            int i2 = this.uccApproveK2Mapper.updateBy(uccApproveK2SetPO, uccApproveK2WherePO);
            if (i2 == 0) {
                rspBO.setRespDesc("\u4fee\u6539K2\u5ba1\u6279\u6d41\u7a0b\u8868\u5931\u8d25");
                rspBO.setRespCode("8888");
                return rspBO;
            }
            rspBO.setEsPos(esPos);
        }
        if (UccConstants.Ucc_K2_APPROVAL_RESULT.REJECT.equals(status)) {
            UccK2RspBO uccK2RspBO = this.submit(reqBO);
        }
        return rspBO;
    }

    @Override
    public UccSynAgreementApprovalResultBusiRspBO argEditProcessDefIdApprovalResult(UccSynAgreementApprovalResultBusiReqBO reqBO) {
        UccSynAgreementApprovalResultBusiRspBO rspBO = new UccSynAgreementApprovalResultBusiRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        UccApprovalprocessListRealQryPo qryPo = new UccApprovalprocessListRealQryPo();
        qryPo.setK2Id(reqBO.getRequestInfo().getK2Id());
        qryPo.setApproveCode(this.ARG_ON_SHELF_PROCESS);
        List rspPos = this.uccApproveK2Mapper.queryObj(qryPo);
        if (CollectionUtils.isEmpty((Collection)rspPos)) {
            rspBO.setRespDesc("\u5ba1\u6279\u8bb0\u5f55\u8868\u4e2d\u672a\u67e5\u5230\u6570\u636e");
            rspBO.setRespCode("8888");
            return rspBO;
        }
        UccApprovalprocessListRealQryPo rspPo = (UccApprovalprocessListRealQryPo)rspPos.get(0);
        if (rspPo == null && rspPo.getObjType() == null && rspPo.getObjId() == null) {
            rspBO.setRespDesc("\u5ba1\u6279\u8bb0\u5f55\u8868\u4e2d\u672a\u67e5\u5230\u6570\u636e");
            rspBO.setRespCode("8888");
            return rspBO;
        }
        Integer status = reqBO.getRequestInfo().getStatus();
        if (rspPo.getObjType() == 2) {
            rspBO.setRespDesc("\u5ba1\u6279\u8bb0\u5f55\u8868\u4e2d\u672a\u67e5\u5230\u6570\u636e");
            rspBO.setRespCode("8888");
            return rspBO;
        }
        if (rspPo.getObjType() == 1) {
            UccCommodityeditorsupdateAtomRspBO atomRspBO;
            List spuBOS;
            UccBatchSpuBO uccBatchSpuBO;
            UccCommodityeditorsupdateAtomReqBO atomReqBO;
            int i;
            UccCommodityPo commodity = this.uccCommodityMapper.getCommodityById(rspPo.getObjId());
            if (commodity == null) {
                rspBO.setRespDesc("\u5546\u54c1\u8868\u4e2d\u672a\u67e5\u5230\u6570\u636e");
                rspBO.setRespCode("8888");
                return rspBO;
            }
            if (UccConstants.Ucc_K2_APPROVAL_RESULT.PASS.equals(status)) {
                commodity.setApprovalStatu("0");
                commodity.setApprovalStatus(null);
                i = this.uccCommodityMapper.updateCommodity(commodity);
                if (i == 0) {
                    rspBO.setRespDesc("\u4fee\u6539\u5546\u54c1\u5ba1\u6279\u72b6\u6001\u5931\u8d25");
                    rspBO.setRespCode("8888");
                    return rspBO;
                }
                this.uccSkuMapper.updateApprovalStatus(commodity.getCommodityId(), commodity.getSupplierShopId(), "0");
                atomReqBO = new UccCommodityeditorsupdateAtomReqBO();
                atomReqBO.setOperType(Integer.valueOf(0));
                uccBatchSpuBO = new UccBatchSpuBO();
                uccBatchSpuBO.setCommodityId(commodity.getCommodityId());
                uccBatchSpuBO.setSupplierShopId(commodity.getSupplierShopId());
                spuBOS = Stream.of(uccBatchSpuBO).collect(Collectors.toList());
                atomReqBO.setBatchSpuList(spuBOS);
                atomRspBO = this.uccCommodityeditorsupdateAtomService.dealcommodityeditorsupdate(atomReqBO);
                if (!"0000".equals(atomRspBO.getRespCode())) {
                    rspBO.setRespDesc(atomRspBO.getRespDesc());
                    rspBO.setRespCode(atomRspBO.getRespCode());
                    return rspBO;
                }
                SyncSceneCommodityToEsReqBO syncSceneCommodityToEsReqBO = new SyncSceneCommodityToEsReqBO();
                syncSceneCommodityToEsReqBO.setCommodityIds(Arrays.asList(commodity.getCommodityId()));
                syncSceneCommodityToEsReqBO.setSupplierId(commodity.getSupplierShopId());
                syncSceneCommodityToEsReqBO.setOperType(ModelRuleConstant.SYNC_ES_SINGLETYPE_ALL);
                syncSceneCommodityToEsReqBO.setSyncType(ModelRuleConstant.SYNC_ES_BY_COMMODITY_ID);
                syncSceneCommodityToEsReqBO.setSingleType(ModelRuleConstant.SYNC_ES_SINGLETYPE_ALL.intValue());
                try {
                    this.lmSyncCommodityMqServiceProvider.send(new ProxyMessage(PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TOPIC"), PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TAG"), JSON.toJSONString((Object)syncSceneCommodityToEsReqBO)));
                }
                catch (Exception e) {
                    log.error("\u540c\u6b65ES MQ\u53d1\u9001\u4fe1\u606f\u5931\u8d25:" + e.getMessage());
                }
                UccSendBIPAlreadyDoneAtomReqBO bipatomReqBO = new UccSendBIPAlreadyDoneAtomReqBO();
                bipatomReqBO.setModelId(reqBO.getRequestInfo().getK2Id());
                bipatomReqBO.setType("1");
                bipatomReqBO.setBipType(Long.valueOf(2L));
                UccSendBIPAlreadyDoneAtomRspBO bipatomRspBO = null;
                try {
                    bipatomRspBO = this.uccSendBIPAlreadyDoneAtomService.SendBIPAlreadyDone(bipatomReqBO);
                }
                catch (Exception e) {
                    log.error("\u53d1\u9001BIP\u5df2\u529e\u4fe1\u606f\u62a5\u9519\uff1a{}", (Object)e.getMessage());
                }
                if (!"0000".equals(bipatomRspBO.getRespCode())) {
                    throw new BusinessException(RspConstantEnums.UAC_NOTASK_AUDIT_CREATE_FAIL.code(), "\u53d1\u9001BIP\u5df2\u529e\u4fe1\u606f\u5f02\u5e38\uff1a" + bipatomRspBO.getRespDesc());
                }
                UccApproveK2PO uccApproveK2SetPO = new UccApproveK2PO();
                UccApproveK2PO uccApproveK2WherePO = new UccApproveK2PO();
                uccApproveK2WherePO.setId(rspPo.getId());
                uccApproveK2SetPO.setApproveStatus(Integer.valueOf(0));
                uccApproveK2SetPO.setFinshTime(new Date());
                int i2 = this.uccApproveK2Mapper.updateBy(uccApproveK2SetPO, uccApproveK2WherePO);
                if (i2 == 0) {
                    rspBO.setRespDesc("\u4fee\u6539K2\u5ba1\u6279\u6d41\u7a0b\u8868\u5931\u8d25");
                    rspBO.setRespCode("8888");
                    return rspBO;
                }
            } else if (UccConstants.Ucc_K2_APPROVAL_RESULT.REJECT.equals(status)) {
                commodity.setApprovalStatu("33");
                commodity.setApprovalStatus(null);
                i = this.uccCommodityMapper.updateCommodity(commodity);
                if (i == 0) {
                    rspBO.setRespDesc("\u4fee\u6539\u5546\u54c1\u5ba1\u6279\u72b6\u6001\u5931\u8d25");
                    rspBO.setRespCode("8888");
                    return rspBO;
                }
                this.uccSkuMapper.updateApprovalStatus(commodity.getCommodityId(), commodity.getSupplierShopId(), "33");
                atomReqBO = new UccCommodityeditorsupdateAtomReqBO();
                atomReqBO.setOperType(Integer.valueOf(1));
                uccBatchSpuBO = new UccBatchSpuBO();
                uccBatchSpuBO.setCommodityId(commodity.getCommodityId());
                uccBatchSpuBO.setSupplierShopId(commodity.getSupplierShopId());
                spuBOS = Stream.of(uccBatchSpuBO).collect(Collectors.toList());
                atomReqBO.setBatchSpuList(spuBOS);
                atomRspBO = this.uccCommodityeditorsupdateAtomService.dealcommodityeditorsupdate(atomReqBO);
                if (!"0000".equals(atomRspBO.getRespCode())) {
                    rspBO.setRespDesc(atomRspBO.getRespDesc());
                    rspBO.setRespCode(atomRspBO.getRespCode());
                    return rspBO;
                }
                SyncSceneCommodityToEsReqBO syncSceneCommodityToEsReqBO = new SyncSceneCommodityToEsReqBO();
                syncSceneCommodityToEsReqBO.setCommodityIds(Arrays.asList(commodity.getCommodityId()));
                syncSceneCommodityToEsReqBO.setSupplierId(commodity.getSupplierShopId());
                syncSceneCommodityToEsReqBO.setOperType(ModelRuleConstant.SYNC_ES_SINGLETYPE_ALL);
                syncSceneCommodityToEsReqBO.setSyncType(ModelRuleConstant.SYNC_ES_BY_COMMODITY_ID);
                syncSceneCommodityToEsReqBO.setSingleType(ModelRuleConstant.SYNC_ES_SINGLETYPE_ALL.intValue());
                try {
                    this.lmSyncCommodityMqServiceProvider.send(new ProxyMessage(PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TOPIC"), PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TAG"), JSON.toJSONString((Object)syncSceneCommodityToEsReqBO)));
                }
                catch (Exception e) {
                    log.error("\u540c\u6b65ES MQ\u53d1\u9001\u4fe1\u606f\u5931\u8d25:" + e.getMessage());
                }
                UccSendBIPAlreadyDoneAtomReqBO bipatomReqBO = new UccSendBIPAlreadyDoneAtomReqBO();
                bipatomReqBO.setModelId(reqBO.getRequestInfo().getK2Id());
                bipatomReqBO.setType("1");
                bipatomReqBO.setBipType(Long.valueOf(2L));
                UccSendBIPAlreadyDoneAtomRspBO bipatomRspBO = null;
                try {
                    bipatomRspBO = this.uccSendBIPAlreadyDoneAtomService.SendBIPAlreadyDone(bipatomReqBO);
                }
                catch (Exception e) {
                    log.error("\u53d1\u9001BIP\u5df2\u529e\u4fe1\u606f\u62a5\u9519\uff1a{}", (Object)e.getMessage());
                }
                if (!"0000".equals(bipatomRspBO.getRespCode())) {
                    throw new BusinessException(RspConstantEnums.UAC_NOTASK_AUDIT_CREATE_FAIL.code(), "\u53d1\u9001BIP\u5df2\u529e\u4fe1\u606f\u5f02\u5e38\uff1a" + bipatomRspBO.getRespDesc());
                }
                UccApproveK2PO uccApproveK2SetPO = new UccApproveK2PO();
                UccApproveK2PO uccApproveK2WherePO = new UccApproveK2PO();
                uccApproveK2WherePO.setId(rspPo.getId());
                uccApproveK2SetPO.setApproveStatus(Integer.valueOf(2));
                uccApproveK2SetPO.setFinshTime(new Date());
                int i2 = this.uccApproveK2Mapper.updateBy(uccApproveK2SetPO, uccApproveK2WherePO);
                if (i2 == 0) {
                    rspBO.setRespDesc("\u4fee\u6539K2\u5ba1\u6279\u6d41\u7a0b\u8868\u5931\u8d25");
                    rspBO.setRespCode("8888");
                    return rspBO;
                }
            } else if (status > 5) {
                rspBO.setRespDesc("\u5ba1\u6838\u72b6\u6001\u9519\u8bef");
                rspBO.setRespCode("8888");
                return rspBO;
            }
            if (UccConstants.Ucc_K2_APPROVAL_RESULT.APPROVAL.equals(status)) {
                UccApproveK2PO set = new UccApproveK2PO();
                set.setApproveStatus(Integer.valueOf(3));
                if ("\u5f00\u59cb".equals(reqBO.getRequestInfo().getActivityName())) {
                    set.setApproverUserCode(reqBO.getRequestInfo().getApproverUserCode());
                }
                UccApproveK2PO where = new UccApproveK2PO();
                where.setK2Id(reqBO.getRequestInfo().getK2Id());
                this.uccApproveK2Mapper.updateBy(set, where);
                UccSendBIPAlreadyDoneAtomReqBO atomReqBO2 = new UccSendBIPAlreadyDoneAtomReqBO();
                atomReqBO2.setModelId(reqBO.getRequestInfo().getK2Id());
                atomReqBO2.setType("1");
                atomReqBO2.setBipType(Long.valueOf(2L));
                UccSendBIPAlreadyDoneAtomRspBO atomRspBO2 = null;
                try {
                    atomRspBO2 = this.uccSendBIPAlreadyDoneAtomService.SendBIPAlreadyDone(atomReqBO2);
                }
                catch (Exception e) {
                    log.error("\u53d1\u9001BIP\u5df2\u529e\u4fe1\u606f\u62a5\u9519\uff1a{}", (Object)e.getMessage());
                }
                if (!"0000".equals(atomRspBO2.getRespCode())) {
                    log.error("\u53d1\u9001BIP\u5df2\u529e\u4fe1\u606f\u5f02\u5e38\uff1a{}", (Object)atomRspBO2.getRespDesc());
                }
            }
        }
        if (UccConstants.Ucc_K2_APPROVAL_RESULT.REJECT.equals(status)) {
            UccK2RspBO uccK2RspBO = this.submit(reqBO);
        }
        return rspBO;
    }

    public UccK2RspBO submit(UccSynAgreementApprovalResultBusiReqBO reqBO) {
        String reqStr = this.initReqStr(reqBO);
        log.info("reqStr\u5165\u53c2{}->" + reqStr);
        HttpRetBean httpRetBean = null;
        try {
            httpRetBean = HSHttpHelper.doUrlPostRequest((URI)new URI(this.K2_PROCESS_ABANDONED_URL), (Header[])HSNHttpHeader.getRequestHeaders((String)"json"), (byte[])reqStr.getBytes("UTF-8"), (String)"UTF-8", (Boolean)false);
        }
        catch (Exception e) {
            log.error("K2\u53d1\u8d77\u5ba1\u6279\u63a5\u53e3\u51fa\u9519\uff1a" + e.getMessage());
            throw new ZTBusinessException("K2\u53d1\u8d77\u5ba1\u6279\u63a5\u53e3\u51fa\u9519");
        }
        if (httpRetBean.getStatus() != 200) {
            log.error("\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1-\u63a5\u53e3\u8fd4\u56de\u5931\u8d25[http_status=" + httpRetBean.getStatus() + "], [http_url=" + PropertiesUtil.getProperty((String)"K2_SUBMIT_FLOW_URL") + "]");
            throw new ZTBusinessException("K2\u53d1\u8d77\u5ba1\u6279\u63a5\u53e3\u51fa\u9519\uff0chttp_status = " + httpRetBean.getStatus());
        }
        log.info("K2\u53d1\u8d77\u5ba1\u6279\u63a5\u53e3\u8fd4\u56de\u54cd\u5e94\u62a5\u6587\uff1a" + httpRetBean.getStr());
        String returnString = httpRetBean.getStr();
        if (StringUtils.isEmpty((Object)returnString)) {
            log.error("K2\u7cfb\u7edf\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\uff01");
            throw new ZTBusinessException("K2\u7cfb\u7edf\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\uff01");
        }
        UccK2RspBO k2RspBO = this.resolveRsp(returnString);
        log.info("k2\u54cd\u5e94\u6570\u636e\uff1a" + k2RspBO.toString());
        return k2RspBO;
    }

    private String initReqStr(UccSynAgreementApprovalResultBusiReqBO reqBO) {
        JSONObject esbInfo = new JSONObject();
        esbInfo.put("instId", (Object)"");
        esbInfo.put("requestTime", (Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS").format(new Date(System.currentTimeMillis())));
        JSONObject requestInfo = new JSONObject();
        requestInfo.put("k2Id", (Object)reqBO.getRequestInfo().getK2Id());
        requestInfo.put("sourceId", (Object)this.K2_SOURCE_ID);
        requestInfo.put("comment", (Object)"\u5ba1\u6279\u9a73\u56de\u6d41\u7a0b\u5e9f\u5f03");
        requestInfo.put("approveDate", (Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS").format(new Date(System.currentTimeMillis())));
        UccApproveK2PO uccApproveK2PO = new UccApproveK2PO();
        uccApproveK2PO.setK2Id(reqBO.getRequestInfo().getK2Id());
        UccApproveK2PO modelBy = this.uccApproveK2Mapper.getModelBy(uccApproveK2PO);
        if (modelBy != null && !StringUtils.isEmpty((Object)modelBy.getApproverUserCode())) {
            requestInfo.put("operateUserCode", (Object)modelBy.getApproverUserCode());
        } else {
            requestInfo.put("operateUserCode", (Object)"201907057023");
        }
        requestInfo.put("activityName", (Object)reqBO.getRequestInfo().getActivityName());
        requestInfo.put("commentType", (Object)"");
        JSONObject reqJson = new JSONObject();
        reqJson.put("requestInfo", (Object)requestInfo);
        reqJson.put("esbInfo", (Object)esbInfo);
        return reqJson.toString();
    }

    private UccK2RspBO resolveRsp(String returnString) {
        try {
            JSONObject rspJsonObject = JSONObject.parseObject((String)returnString);
            UccK2RspBO k2RspBO = (UccK2RspBO)JSON.toJavaObject((JSON)rspJsonObject, UccK2RspBO.class);
            if (!"S".equals(k2RspBO.getEsbInfo().getReturnStatus())) {
                throw new ZTBusinessException("K2\u63a5\u53e3\u8fd4\u56de\u72b6\u6001\u5f02\u5e38\uff1a[" + k2RspBO.getEsbInfo().getReturnStatus() + "]" + k2RspBO.getEsbInfo().getReturnMsg());
            }
            return k2RspBO;
        }
        catch (Exception e) {
            log.error("\u8f6c\u6362K2\u7cfb\u7edf\u54cd\u5e94\u62a5\u6587\u51fa\u9519\uff1a" + e.getMessage());
            throw new RuntimeException("\u8f6c\u6362K2\u7cfb\u7edf\u54cd\u5e94\u62a5\u6587\u51fa\u9519\uff1a" + e.getMessage());
        }
    }
}

