/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.busi.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.commodity.common.busi.api.UccTaskSynAssociateMaterialInfoBusiService;
import com.tydic.commodity.common.busi.bo.UccTaskSynAssociateMaterialInfoBusiReqBO;
import com.tydic.commodity.common.busi.bo.UccTaskSynAssociateMaterialInfoBusiRspBO;
import com.tydic.commodity.dao.UccCommodityMeasureMapper;
import com.tydic.commodity.dao.UccEMdmCatalogMapper;
import com.tydic.commodity.dao.UccEMdmMaterialMapper;
import com.tydic.commodity.dao.UccEMdmMaterialPropDefMapper;
import com.tydic.commodity.po.UccCommodityMeasurePo;
import com.tydic.commodity.po.UccEMdmCatalogPO;
import com.tydic.commodity.po.UccEMdmMaterialPO;
import com.tydic.commodity.po.UccEMdmMaterialPropDefPO;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UccTaskSynAssociateMaterialInfoBusiServiceImpl
implements UccTaskSynAssociateMaterialInfoBusiService {
    private static final Logger log = LoggerFactory.getLogger(UccTaskSynAssociateMaterialInfoBusiServiceImpl.class);
    @Autowired
    private UccEMdmMaterialMapper uccEMdmMaterialMapper;
    @Autowired
    private UccEMdmCatalogMapper uccEMdmCatalogMapper;
    @Autowired
    private UccCommodityMeasureMapper uccCommodityMeasureMapper;
    @Autowired
    private UccEMdmMaterialPropDefMapper uccEMdmMaterialPropDefMapper;
    @Autowired
    private CacheClient cacheClient;

    @Override
    public UccTaskSynAssociateMaterialInfoBusiRspBO synAssociateInfo(UccTaskSynAssociateMaterialInfoBusiReqBO reqBO) {
        List catalogIds;
        UccEMdmMaterialPO record;
        List propCodes;
        UccEMdmMaterialPO materialPO;
        Iterator iterator;
        UccTaskSynAssociateMaterialInfoBusiRspBO rspBO = new UccTaskSynAssociateMaterialInfoBusiRspBO();
        List materialCodes = (List)this.cacheClient.get("materialCodes", List.class);
        if (!CollectionUtils.isEmpty((Collection)materialCodes)) {
            int intialSize = materialCodes.size();
            List uccEMdmMaterialPOS = this.uccEMdmMaterialMapper.batchQryByCode(materialCodes);
            if (!CollectionUtils.isEmpty((Collection)uccEMdmMaterialPOS)) {
                Map materialPOMap = uccEMdmMaterialPOS.stream().collect(Collectors.toMap(UccEMdmMaterialPO::getMaterialCode, Function.identity()));
                iterator = materialCodes.iterator();
                while (iterator.hasNext()) {
                    List uccCommodityMeasurePos;
                    String materialCode = (String)iterator.next();
                    if (materialPOMap.isEmpty() || !materialPOMap.containsKey(materialCode) || (materialPO = (UccEMdmMaterialPO)materialPOMap.get(materialCode)) == null) continue;
                    if (!Objects.equals(materialPO.getCatalogId(), materialPO.getMaterialId()) && materialPO.getMeasureId() != null) {
                        this.cacheClient.delete(materialCode);
                        iterator.remove();
                        continue;
                    }
                    Map materialAssociateMap = (Map)this.cacheClient.get(materialPO.getMaterialCode(), Map.class);
                    if (materialAssociateMap.isEmpty()) continue;
                    String catalogCode = (String)materialAssociateMap.get("catalogCode");
                    String measureName = (String)materialAssociateMap.get("measureName");
                    if (Objects.equals(materialPO.getCatalogId(), materialPO.getMaterialId()) && StringUtils.isNotBlank((CharSequence)catalogCode)) {
                        UccEMdmCatalogPO uccEMdmCatalogPO = new UccEMdmCatalogPO();
                        uccEMdmCatalogPO.setCatalogCode(catalogCode);
                        List uccEMdmCatalogPOS = this.uccEMdmCatalogMapper.qryUccEMdmCatalog(uccEMdmCatalogPO);
                        if (!CollectionUtils.isEmpty((Collection)uccEMdmCatalogPOS)) {
                            try {
                                UccEMdmMaterialPO record2 = new UccEMdmMaterialPO();
                                record2.setMaterialId(materialPO.getMaterialId());
                                record2.setCatalogId(((UccEMdmCatalogPO)uccEMdmCatalogPOS.get(0)).getCatalogId());
                                this.uccEMdmMaterialMapper.updateByPrimaryKeySelective(record2);
                            }
                            catch (Exception e) {
                                log.error("UccTaskSynAssociateMaterialInfoBusiService , failure : {}", (Object)e.getMessage());
                                throw new ZTBusinessException("8888: \u540c\u6b65\u7269\u6599\u4e3b\u4f53\u6570\u636e\u5206\u7c7bID\u5f02\u5e38");
                            }
                        }
                    }
                    if (!Objects.isNull(materialPO.getMeasureId()) || !StringUtils.isNotBlank((CharSequence)measureName) || CollectionUtils.isEmpty((Collection)(uccCommodityMeasurePos = this.uccCommodityMeasureMapper.queryMeasureByMeasureName(measureName)))) continue;
                    try {
                        UccEMdmMaterialPO record3 = new UccEMdmMaterialPO();
                        record3.setMaterialId(materialPO.getMaterialId());
                        record3.setMeasureId(((UccCommodityMeasurePo)uccCommodityMeasurePos.get(0)).getMeasureId());
                        this.uccEMdmMaterialMapper.updateByPrimaryKeySelective(record3);
                    }
                    catch (Exception e) {
                        log.error("UccTaskSynAssociateMaterialInfoBusiService , failure : {}", (Object)e.getMessage());
                        throw new ZTBusinessException("8888: \u540c\u6b65\u7269\u6599\u4e3b\u4f53\u6570\u636e\u8ba1\u91cf\u5355\u4f4d\u5f02\u5e38");
                    }
                }
            } else {
                this.cacheClient.delete("materialCodes");
            }
            if (materialCodes.isEmpty()) {
                this.cacheClient.delete("materialCodes");
            } else if (!materialCodes.isEmpty() && materialCodes.size() < intialSize) {
                this.cacheClient.set("materialCodes", (Object)materialCodes);
            }
        }
        if (!CollectionUtils.isEmpty((Collection)(propCodes = (List)this.cacheClient.get("propCodes", List.class)))) {
            int intialSize = propCodes.size();
            Iterator iterator2 = propCodes.iterator();
            while (iterator2.hasNext()) {
                String propCode = (String)iterator2.next();
                if (!StringUtils.isNotBlank((CharSequence)propCode)) continue;
                List propDefPOS = this.uccEMdmMaterialPropDefMapper.selectByPropCode(propCode);
                if (!CollectionUtils.isEmpty((Collection)propDefPOS)) {
                    UccEMdmMaterialPropDefPO propDefPO = (UccEMdmMaterialPropDefPO)propDefPOS.get(0);
                    if (Objects.equals(propDefPO.getPropDefId(), propDefPO.getMaterialId()) || Objects.equals(propDefPO.getPropDefId(), propDefPO.getCatalogId()) || Objects.equals(propDefPO.getMaterialId(), propDefPO.getCatalogId()) || Objects.equals("NULL", propDefPO.getMaterialCode())) {
                        try {
                            String materialCode = (String)this.cacheClient.get(propCode);
                            if (!StringUtils.isNotBlank((CharSequence)materialCode)) continue;
                            record = new UccEMdmMaterialPropDefPO();
                            if (Objects.equals(propDefPO.getMaterialCode(), "NULL")) {
                                record.setMaterialCode(materialCode);
                            }
                            UccEMdmMaterialPO materialPO2 = new UccEMdmMaterialPO();
                            materialPO2.setMaterialCode(materialCode);
                            List materialPOS = this.uccEMdmMaterialMapper.selectMaterialPrecisely(materialPO2);
                            if (CollectionUtils.isEmpty((Collection)materialPOS)) continue;
                            UccEMdmMaterialPO uccEMdmMaterialPO = (UccEMdmMaterialPO)materialPOS.get(0);
                            if (Objects.equals(propDefPO.getPropDefId(), propDefPO.getMaterialId())) {
                                record.setMaterialId(uccEMdmMaterialPO.getMaterialId());
                            }
                            if (Objects.equals(propDefPO.getPropDefId(), propDefPO.getCatalogId()) || Objects.equals(propDefPO.getMaterialId(), propDefPO.getCatalogId())) {
                                record.setCatalogId(uccEMdmMaterialPO.getCatalogId());
                            }
                            record.setPropDefId(propDefPO.getPropDefId());
                            this.uccEMdmMaterialPropDefMapper.updateByPrimaryKeySelective((UccEMdmMaterialPropDefPO)record);
                            continue;
                        }
                        catch (Exception e) {
                            log.error("UccTaskSynAssociateMaterialInfoBusiService , failure : {}", (Object)e.getMessage());
                            throw new ZTBusinessException("8888: \u540c\u6b65\u7269\u6599\u4e3b\u4f53\u6570\u636e\u5c5e\u6027\u5f02\u5e38");
                        }
                    }
                    if (Objects.equals(propDefPO.getPropDefId(), propDefPO.getMaterialId()) || Objects.equals(propDefPO.getPropDefId(), propDefPO.getCatalogId()) || Objects.equals(propDefPO.getMaterialId(), propDefPO.getCatalogId()) || Objects.equals("NULL", propDefPO.getMaterialCode())) continue;
                    this.cacheClient.delete(propCode);
                    iterator2.remove();
                    continue;
                }
                iterator2.remove();
            }
            if (propCodes.isEmpty()) {
                this.cacheClient.delete("propCodes");
            } else if (!propCodes.isEmpty() && propCodes.size() < intialSize) {
                this.cacheClient.set("propCodes", (Object)propCodes);
            }
        }
        if (!CollectionUtils.isEmpty((Collection)(catalogIds = (List)this.cacheClient.get("catalogIds", List.class)))) {
            int intialSize = catalogIds.size();
            iterator = catalogIds.iterator();
            while (iterator.hasNext()) {
                Long catalogId = (Long)iterator.next();
                if (catalogId == null) continue;
                materialPO = new UccEMdmMaterialPO();
                materialPO.setCatalogId(catalogId);
                List materialPOS = this.uccEMdmMaterialMapper.selectMaterialPrecisely(materialPO);
                if (CollectionUtils.isEmpty((Collection)materialPOS)) continue;
                try {
                    record = new UccEMdmMaterialPO();
                    record.setCatalogId(catalogId);
                    this.uccEMdmCatalogMapper.updateCatalogLastLevel(catalogId, Integer.valueOf(1), null);
                    iterator.remove();
                }
                catch (Exception e) {
                    log.error("UccTaskSynAssociateMaterialInfoBusiService , failure : {}", (Object)e.getMessage());
                    throw new ZTBusinessException("8888: \u540c\u6b65\u7269\u6599\u5206\u7c7b\u7b49\u7ea7\u5f02\u5e38");
                }
            }
            if (catalogIds.isEmpty()) {
                this.cacheClient.delete("catalogIds");
            } else if (!catalogIds.isEmpty() && catalogIds.size() < intialSize) {
                this.cacheClient.set("catalogIds", (Object)catalogIds);
            }
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

