/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.busi.impl;

import com.tydic.commodity.base.bo.UccBatchSpuBO;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.busibase.atom.api.UccCommodityeditorsupdateAtomService;
import com.tydic.commodity.busibase.atom.api.UccSendISPBacklogAtomService;
import com.tydic.commodity.busibase.atom.bo.UccCommodityeditorsupdateAtomReqBO;
import com.tydic.commodity.busibase.atom.bo.UccCommodityeditorsupdateAtomRspBO;
import com.tydic.commodity.busibase.atom.bo.UccSendISPBacklogAtomReqBO;
import com.tydic.commodity.busibase.busi.api.UccAddApproveLogBusiService;
import com.tydic.commodity.busibase.busi.bo.UccAddApproveLogBusiReqBO;
import com.tydic.commodity.common.busi.api.UccApproveRejectBusiService;
import com.tydic.commodity.common.busi.bo.UccApproveRejectBusiReqBO;
import com.tydic.commodity.common.busi.bo.UccApproveRejectBusiRspBO;
import com.tydic.commodity.dao.UccCommodityExpandMapper;
import com.tydic.commodity.dao.UccCommodityMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.po.UccCommodityExpandPO;
import com.tydic.commodity.po.UccCommodityPo;
import com.tydic.commodity.po.UccSkuPo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UccApproveRejectBusiServiceImpl
implements UccApproveRejectBusiService {
    private static final Logger log = LoggerFactory.getLogger(UccApproveRejectBusiServiceImpl.class);
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private UccCommodityMapper uccCommodityMapper;
    @Autowired
    private UccCommodityExpandMapper uccCommodityExpandMapper;
    @Autowired
    private UccAddApproveLogBusiService uccAddApproveLogBusiService;
    @Autowired
    private UccSendISPBacklogAtomService uccSendISPBacklogAtomService;
    @Autowired
    private UccCommodityeditorsupdateAtomService uccCommodityeditorsupdateAtomService;
    @Value(value="${ISP_SINGLE_POINT_LOGIN_URL}")
    private String ISP_SINGLE_POINT_LOGIN_URL;
    @Value(value="${UCC_MALL_LOGIN_URL}")
    private String UCC_MALL_LOGIN_URL;
    @Value(value="${UCC_AGR_SPU_VENDOR_MANAGE_LIST_ROUTE}")
    private String UCC_AGR_SPU_VENDOR_MANAGE_LIST_ROUTE;
    @Value(value="${UCC_EST_SPU_VENDOR_MANAGE_LIST_ROUTE}")
    private String UCC_EST_SPU_VENDOR_MANAGE_LIST_ROUTE;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public UccApproveRejectBusiRspBO ApproveReject(UccApproveRejectBusiReqBO reqBO) {
        UccApproveRejectBusiRspBO rspBO = new UccApproveRejectBusiRspBO();
        if (reqBO.getSourceType() == 1) {
            List uccCommodityPos = this.uccCommodityMapper.qeryBatchCommdity(reqBO.getSourceIds());
            if (CollectionUtils.isEmpty((Collection)uccCommodityPos) || uccCommodityPos.size() != reqBO.getSourceIds().size()) throw new BusinessException("8888", "\u5165\u53c2\u6709\u4e0d\u5b58\u5728\u7684\u5546\u54c1");
            Set commodityStatusSet = uccCommodityPos.stream().map(UccCommodityPo::getCommodityStatus).collect(Collectors.toSet());
            if (commodityStatusSet.size() != 1) {
                throw new BusinessException("8888", "\u5546\u54c1\u72b6\u6001\u4e0d\u7edf\u4e00");
            }
            Set commodityApprovalStatusSet = uccCommodityPos.stream().map(UccCommodityPo::getApprovalStatus).collect(Collectors.toSet());
            if (commodityApprovalStatusSet.size() != 1) {
                throw new BusinessException("8888", "\u5546\u54c1\u5ba1\u6279\u72b6\u6001\u4e0d\u7edf\u4e00");
            }
            if (commodityStatusSet.contains(0) && commodityApprovalStatusSet.contains(24) && ((UccCommodityPo)uccCommodityPos.get(0)).getCommoditySource() != 2) {
                List<Long> commodityIds = uccCommodityPos.stream().map(UccCommodityPo::getCommodityId).collect(Collectors.toList());
                List uccSkuPoList = this.uccSkuMapper.batchQrySkuByCommodityIds(commodityIds);
                List<Long> skuIds = uccSkuPoList.stream().map(UccSkuPo::getSkuId).collect(Collectors.toList());
                this.uccCommodityMapper.batchUpdateCommodityStatus(commodityIds, Integer.valueOf(0), null);
                this.uccSkuMapper.batchUpdateSkuStatusByIds(skuIds, Integer.valueOf(0), null);
                this.uccCommodityMapper.batchUpdateSpuApprovalStatus(commodityIds, "23", null);
                this.uccSkuMapper.batchUpdateSpuApprovalStatusBySkuId(skuIds, "23", null);
                UccCommodityExpandPO uccCommodityExpandPO = new UccCommodityExpandPO();
                uccCommodityExpandPO.setCommodityIds(commodityIds);
                uccCommodityExpandPO.setExpand19(Long.valueOf(new Date(System.currentTimeMillis()).getTime()));
                this.uccCommodityExpandMapper.batchUpdateCommodityExpand(uccCommodityExpandPO);
                this.addApproveLog(reqBO.getSourceIds(), 1, 3, 2, 4, reqBO);
                this.addApproveLog(skuIds, 2, 3, 2, 4, reqBO);
                this.onShelfRejectSendISP(commodityIds);
            } else {
                if (!commodityStatusSet.contains(3) || !commodityApprovalStatusSet.contains(34) || ((UccCommodityPo)uccCommodityPos.get(0)).getCommoditySource() == 2) throw new BusinessException("8888", "\u4e0d\u652f\u6301\u6b64\u72b6\u6001\u7684\u5546\u54c1\u9a73\u56de");
                for (UccCommodityPo each : uccCommodityPos) {
                    UccCommodityeditorsupdateAtomReqBO atomReqBO = new UccCommodityeditorsupdateAtomReqBO();
                    atomReqBO.setOperType(Integer.valueOf(1));
                    UccBatchSpuBO uccBatchSpuBO = new UccBatchSpuBO();
                    uccBatchSpuBO.setCommodityId(each.getCommodityId());
                    uccBatchSpuBO.setSupplierShopId(each.getSupplierShopId());
                    List spuBOS = Stream.of(uccBatchSpuBO).collect(Collectors.toList());
                    atomReqBO.setBatchSpuList(spuBOS);
                    UccCommodityeditorsupdateAtomRspBO atomRspBO = this.uccCommodityeditorsupdateAtomService.dealcommodityeditorsupdate(atomReqBO);
                    if ("0000".equals(atomRspBO.getRespCode())) continue;
                    throw new BusinessException("8888", "\u5546\u54c1\u7f16\u8f91\u66f4\u65b0\u62a5\u9519\uff1a" + atomRspBO.getRespDesc());
                }
                List commodityIds = uccCommodityPos.stream().map(UccCommodityPo::getCommodityId).collect(Collectors.toList());
                List uccSkuPoList = this.uccSkuMapper.batchQrySkuByCommodityIds(commodityIds);
                List<Long> skuIds = uccSkuPoList.stream().map(UccSkuPo::getSkuId).collect(Collectors.toList());
                this.uccCommodityMapper.batchUpdateSpuApprovalStatus(commodityIds, "33", null);
                this.uccSkuMapper.batchUpdateSpuApprovalStatusBySkuId(skuIds, "33", null);
                UccCommodityExpandPO uccCommodityExpandPO = new UccCommodityExpandPO();
                uccCommodityExpandPO.setCommodityIds(commodityIds);
                uccCommodityExpandPO.setExpand19(Long.valueOf(new Date(System.currentTimeMillis()).getTime()));
                this.uccCommodityExpandMapper.batchUpdateCommodityExpand(uccCommodityExpandPO);
                this.addApproveLog(reqBO.getSourceIds(), 1, 2, 2, 4, reqBO);
                this.addApproveLog(skuIds, 2, 2, 2, 4, reqBO);
                this.editRejectSendISP(commodityIds);
            }
        } else if (reqBO.getSourceType() == 2) {
            List uccSkuPoList = this.uccSkuMapper.qeryBatchSkus(reqBO.getSourceIds());
            if (CollectionUtils.isEmpty((Collection)uccSkuPoList) || uccSkuPoList.size() != reqBO.getSourceIds().size()) throw new BusinessException("8888", "\u5165\u53c2\u6709\u4e0d\u5b58\u5728\u7684\u5546\u54c1");
            Set skuStatusSet = uccSkuPoList.stream().map(UccSkuPo::getSkuStatus).collect(Collectors.toSet());
            if (skuStatusSet.size() != 1) {
                throw new BusinessException("8888", "\u5355\u54c1\u72b6\u6001\u4e0d\u7edf\u4e00");
            }
            Set skuApprovalStatusSet = uccSkuPoList.stream().map(UccSkuPo::getApprovalStatus).collect(Collectors.toSet());
            if (skuApprovalStatusSet.size() != 1) {
                throw new BusinessException("8888", "\u5546\u54c1\u5ba1\u6279\u72b6\u6001\u4e0d\u7edf\u4e00");
            }
            if (skuStatusSet.contains(2) && skuApprovalStatusSet.contains(24) && ((UccSkuPo)uccSkuPoList.get(0)).getSkuSource() == 2) {
                List<Long> skuIds = uccSkuPoList.stream().map(UccSkuPo::getSkuId).collect(Collectors.toList());
                ArrayList<Long> commodityIds = new ArrayList<Long>(uccSkuPoList.stream().map(UccSkuPo::getCommodityId).collect(Collectors.toSet()));
                this.uccCommodityMapper.batchUpdateCommodityStatus(commodityIds, Integer.valueOf(1), null);
                this.uccSkuMapper.batchUpdateSkuStatusByIds(skuIds, Integer.valueOf(1), null);
                this.uccCommodityMapper.batchUpdateSpuApprovalStatus(commodityIds, "23", null);
                this.uccSkuMapper.batchUpdateSpuApprovalStatusBySkuId(skuIds, "23", null);
                UccCommodityExpandPO uccCommodityExpandPO = new UccCommodityExpandPO();
                uccCommodityExpandPO.setCommodityIds(commodityIds);
                uccCommodityExpandPO.setExpand19(Long.valueOf(new Date(System.currentTimeMillis()).getTime()));
                this.uccCommodityExpandMapper.batchUpdateCommodityExpand(uccCommodityExpandPO);
                this.addApproveLog(reqBO.getSourceIds(), 1, 3, 2, 4, reqBO);
                this.addApproveLog(skuIds, 2, 3, 2, 4, reqBO);
                this.onShelfRejectSendISP(commodityIds);
            } else if (skuStatusSet.contains(3) && skuApprovalStatusSet.contains(44)) {
                List<Long> skuIds = uccSkuPoList.stream().map(UccSkuPo::getSkuId).collect(Collectors.toList());
                this.uccSkuMapper.batchUpdateSpuApprovalStatusBySkuId(skuIds, "43", null);
                this.addApproveLog(skuIds, 2, 4, 2, 4, reqBO);
                this.offShelfRejectSendISP(skuIds);
            } else {
                if (!skuStatusSet.contains(5) || !skuApprovalStatusSet.contains(54)) throw new BusinessException("8888", "\u4e0d\u652f\u6301\u6b64\u72b6\u6001\u7684\u5546\u54c1\u9a73\u56de");
                List<Long> skuIds = uccSkuPoList.stream().map(UccSkuPo::getSkuId).collect(Collectors.toList());
                this.uccSkuMapper.batchUpdateSpuApprovalStatusBySkuId(skuIds, "53", null);
                this.addApproveLog(skuIds, 2, 5, 2, 4, reqBO);
                this.ReinstateOnShelfRejectSendISP(skuIds);
            }
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    void addApproveLog(List<Long> sourceIds, Integer sourceType, Integer approveType, Integer approveNode, Integer operType, UccApproveRejectBusiReqBO reqBO) {
        UccAddApproveLogBusiReqBO uccAddApproveLogBusiReqBO = new UccAddApproveLogBusiReqBO();
        BeanUtils.copyProperties((Object)((Object)reqBO), (Object)uccAddApproveLogBusiReqBO);
        uccAddApproveLogBusiReqBO.setSourceIds(sourceIds);
        uccAddApproveLogBusiReqBO.setSourceType(sourceType);
        uccAddApproveLogBusiReqBO.setApproveType(approveType);
        uccAddApproveLogBusiReqBO.setApproveNode(approveNode);
        uccAddApproveLogBusiReqBO.setOperType(operType);
        uccAddApproveLogBusiReqBO.setApproverName(reqBO.getName());
        this.uccAddApproveLogBusiService.addApproveLog(uccAddApproveLogBusiReqBO);
    }

    void onShelfRejectSendISP(List<Long> commodityIds) {
        try {
            List uccCommodityPos = this.uccCommodityMapper.queryByCommodityIdLists(commodityIds);
            Set vendorIds = uccCommodityPos.stream().map(UccCommodityPo::getVendorId).collect(Collectors.toSet());
            Map<Long, List<UccCommodityPo>> collect = uccCommodityPos.stream().collect(Collectors.groupingBy(UccCommodityPo::getVendorId));
            for (Long vendorId : vendorIds) {
                List<UccCommodityPo> tempSpuList = collect.get(vendorId);
                UccSendISPBacklogAtomReqBO uccSendISPBacklogAtomReqBO = new UccSendISPBacklogAtomReqBO();
                uccSendISPBacklogAtomReqBO.setIspSource(Integer.valueOf(1));
                uccSendISPBacklogAtomReqBO.setVendorId(vendorId);
                uccSendISPBacklogAtomReqBO.setType(Integer.valueOf(1));
                StringBuilder spuIdListStr = new StringBuilder();
                StringBuilder skuIdListStr = new StringBuilder();
                for (int i = 0; i < tempSpuList.size(); ++i) {
                    if (i != tempSpuList.size() - 1) {
                        spuIdListStr.append(tempSpuList.get(i).getCommodityId()).append(",");
                    } else {
                        spuIdListStr.append(tempSpuList.get(i).getCommodityId());
                    }
                    List uccSkuPos = this.uccSkuMapper.batchQrySkuByCommodityIds(Arrays.asList(tempSpuList.get(i).getCommodityId()));
                    for (int j = 0; j < uccSkuPos.size(); ++j) {
                        if (i != tempSpuList.size() - 1 && j != uccSkuPos.size() - 1) {
                            skuIdListStr.append(((UccSkuPo)uccSkuPos.get(i)).getSkuId()).append(",");
                            continue;
                        }
                        skuIdListStr.append(((UccSkuPo)uccSkuPos.get(i)).getSkuId());
                    }
                }
                if (tempSpuList.get(0).getCommoditySource() == 2) {
                    uccSendISPBacklogAtomReqBO.setTitle("\u5546\u54c1\u5ba1\u6838\u7ed3\u679c\uff08\u7535\u5546\uff09");
                    uccSendISPBacklogAtomReqBO.setContent("\u3010\u4e0a\u67b6\u9a73\u56de\u3011\u60a8\u63d0\u4ea4\u7684\u5546\u54c1\u4e0a\u67b6\u5ba1\u6279\uff08" + tempSpuList.size() + "\u4e2a\uff09\u5df2\u88ab\u9a73\u56de\uff0c\u8bf7\u77e5\u6089");
                    uccSendISPBacklogAtomReqBO.setTodoUrl(this.ISP_SINGLE_POINT_LOGIN_URL + "/idp/oauth2/authorize?client_id=cgsc&redirect_uri=" + this.UCC_MALL_LOGIN_URL + "/%23/loginNew?routerUrl=" + this.UCC_EST_SPU_VENDOR_MANAGE_LIST_ROUTE + "%26exportSkuIds=%5B" + skuIdListStr + "%5D%26tabId=1%26type=2&response_type=code&state=123");
                } else {
                    uccSendISPBacklogAtomReqBO.setTitle("\u5546\u54c1\u5ba1\u6838\u7ed3\u679c\uff08\u81ea\u6709\u4f9b\u5e94\u5546\uff09");
                    uccSendISPBacklogAtomReqBO.setContent("\u3010\u4e0a\u67b6\u9a73\u56de\u3011\u60a8\u63d0\u4ea4\u7684\u5546\u54c1\u4e0a\u67b6\u5ba1\u6279\uff08" + tempSpuList.size() + "\u4e2a\uff09\u5df2\u88ab\u9a73\u56de\uff0c\u8bf7\u77e5\u6089");
                    uccSendISPBacklogAtomReqBO.setTodoUrl(this.ISP_SINGLE_POINT_LOGIN_URL + "/idp/oauth2/authorize?client_id=cgsc&redirect_uri=" + this.UCC_MALL_LOGIN_URL + "/%23/loginNew?routerUrl=" + this.UCC_AGR_SPU_VENDOR_MANAGE_LIST_ROUTE + "%26exportCommodityIds=%5B" + spuIdListStr + "%5D%26tabId=1%26type=2&response_type=code&state=123");
                }
                this.uccSendISPBacklogAtomService.sendBIPBacklog(uccSendISPBacklogAtomReqBO);
            }
        }
        catch (Exception e) {
            log.error("\u7ad9\u5185\u4e0a\u67b6\u5ba1\u6279\u9a73\u56de\u65f6isp\u5f85\u529e\u53d1\u9001\u62a5\u9519:{}", (Object)e.getMessage());
        }
    }

    void offShelfRejectSendISP(List<Long> skuIds) {
        try {
            List uccSkuPoList = this.uccSkuMapper.qeryBatchSkus(skuIds);
            Map<Long, List<UccSkuPo>> skuCollect = uccSkuPoList.stream().collect(Collectors.groupingBy(UccSkuPo::getCommodityId));
            List uccCommodityPos = this.uccCommodityMapper.queryByCommodityIdLists(uccSkuPoList.stream().map(UccSkuPo::getCommodityId).collect(Collectors.toList()));
            Set vendorIds = uccCommodityPos.stream().map(UccCommodityPo::getVendorId).collect(Collectors.toSet());
            Map<Long, List<UccCommodityPo>> collect = uccCommodityPos.stream().collect(Collectors.groupingBy(UccCommodityPo::getVendorId));
            for (Long vendorId : vendorIds) {
                List<UccCommodityPo> tempSpuList = collect.get(vendorId);
                ArrayList tempSkuList = new ArrayList();
                for (UccCommodityPo each : tempSpuList) {
                    tempSkuList.addAll(skuCollect.get(each.getCommodityId()));
                }
                UccSendISPBacklogAtomReqBO uccSendISPBacklogAtomReqBO = new UccSendISPBacklogAtomReqBO();
                uccSendISPBacklogAtomReqBO.setIspSource(Integer.valueOf(1));
                uccSendISPBacklogAtomReqBO.setVendorId(vendorId);
                uccSendISPBacklogAtomReqBO.setType(Integer.valueOf(1));
                StringBuilder skuIdListStr = new StringBuilder();
                for (int i = 0; i < tempSkuList.size(); ++i) {
                    if (i != tempSkuList.size() - 1) {
                        skuIdListStr.append(((UccSkuPo)tempSkuList.get(i)).getCommodityId()).append(",");
                        continue;
                    }
                    skuIdListStr.append(((UccSkuPo)tempSkuList.get(i)).getCommodityId());
                }
                if (((UccSkuPo)tempSkuList.get(0)).getSkuSource() == 2) continue;
                uccSendISPBacklogAtomReqBO.setTitle("\u5546\u54c1\u5ba1\u6838\u7ed3\u679c\uff08\u81ea\u6709\u4f9b\u5e94\u5546\uff09");
                uccSendISPBacklogAtomReqBO.setContent("\u3010\u4e0b\u67b6\u9a73\u56de\u3011\u60a8\u63d0\u4ea4\u7684\u5546\u54c1\u4e0b\u67b6\u5ba1\u6279\uff08" + tempSpuList.size() + "\u4e2a\uff09\u5df2\u88ab\u9a73\u56de\uff0c\u8bf7\u77e5\u6089");
                uccSendISPBacklogAtomReqBO.setTodoUrl(this.ISP_SINGLE_POINT_LOGIN_URL + "/idp/oauth2/authorize?client_id=cgsc&redirect_uri=" + this.UCC_MALL_LOGIN_URL + "/%23/loginNew?routerUrl=" + this.UCC_AGR_SPU_VENDOR_MANAGE_LIST_ROUTE + "%26exportSkuIds=%5B" + skuIdListStr + "%5D%26tabId=3%26type=2&response_type=code&state=123");
                this.uccSendISPBacklogAtomService.sendBIPBacklog(uccSendISPBacklogAtomReqBO);
            }
        }
        catch (Exception e) {
            log.error("\u7ad9\u5185\u4e0b\u67b6\u5ba1\u6279\u9a73\u56de\u65f6isp\u5f85\u529e\u53d1\u9001\u62a5\u9519:{}", (Object)e.getMessage());
        }
    }

    void editRejectSendISP(List<Long> commodityIds) {
        try {
            List uccCommodityPos = this.uccCommodityMapper.queryByCommodityIdLists(commodityIds);
            Set vendorIds = uccCommodityPos.stream().map(UccCommodityPo::getVendorId).collect(Collectors.toSet());
            Map<Long, List<UccCommodityPo>> collect = uccCommodityPos.stream().collect(Collectors.groupingBy(UccCommodityPo::getVendorId));
            for (Long vendorId : vendorIds) {
                List<UccCommodityPo> tempSpuList = collect.get(vendorId);
                UccSendISPBacklogAtomReqBO uccSendISPBacklogAtomReqBO = new UccSendISPBacklogAtomReqBO();
                uccSendISPBacklogAtomReqBO.setIspSource(Integer.valueOf(1));
                uccSendISPBacklogAtomReqBO.setVendorId(vendorId);
                uccSendISPBacklogAtomReqBO.setType(Integer.valueOf(1));
                StringBuilder spuIdListStr = new StringBuilder();
                StringBuilder skuIdListStr = new StringBuilder();
                for (int i = 0; i < tempSpuList.size(); ++i) {
                    if (i != tempSpuList.size() - 1) {
                        spuIdListStr.append(tempSpuList.get(i).getCommodityId()).append(",");
                    } else {
                        spuIdListStr.append(tempSpuList.get(i).getCommodityId());
                    }
                    List uccSkuPos = this.uccSkuMapper.batchQrySkuByCommodityIds(Arrays.asList(tempSpuList.get(i).getCommodityId()));
                    for (int j = 0; j < uccSkuPos.size(); ++j) {
                        if (i != tempSpuList.size() - 1 && j != uccSkuPos.size() - 1) {
                            skuIdListStr.append(((UccSkuPo)uccSkuPos.get(i)).getSkuId()).append(",");
                            continue;
                        }
                        skuIdListStr.append(((UccSkuPo)uccSkuPos.get(i)).getSkuId());
                    }
                }
                uccSendISPBacklogAtomReqBO.setTitle("\u5546\u54c1\u5ba1\u6838\u7ed3\u679c\uff08\u81ea\u6709\u4f9b\u5e94\u5546\uff09");
                uccSendISPBacklogAtomReqBO.setContent("\u3010\u4e0a\u67b6\u9a73\u56de\u3011\u60a8\u63d0\u4ea4\u7684\u5546\u54c1\u4e0a\u67b6\u5ba1\u6279\uff08" + tempSpuList.size() + "\u4e2a\uff09\u5df2\u88ab\u9a73\u56de\uff0c\u8bf7\u77e5\u6089");
                uccSendISPBacklogAtomReqBO.setTodoUrl(this.ISP_SINGLE_POINT_LOGIN_URL + "/idp/oauth2/authorize?client_id=cgsc&redirect_uri=" + this.UCC_MALL_LOGIN_URL + "/%23/loginNew?routerUrl=" + this.UCC_AGR_SPU_VENDOR_MANAGE_LIST_ROUTE + "%26exportCommodityIds=%5B" + spuIdListStr + "%5D%26tabId=6%26type=2&response_type=code&state=123");
                this.uccSendISPBacklogAtomService.sendBIPBacklog(uccSendISPBacklogAtomReqBO);
            }
        }
        catch (Exception e) {
            log.error("\u7ad9\u5185\u7f16\u8f91\u5ba1\u6279\u9a73\u56de\u65f6isp\u5f85\u529e\u53d1\u9001\u62a5\u9519:{}", (Object)e.getMessage());
        }
    }

    void ReinstateOnShelfRejectSendISP(List<Long> skuIds) {
        try {
            List uccSkuPoList = this.uccSkuMapper.qeryBatchSkus(skuIds);
            Map<Long, List<UccSkuPo>> skuCollect = uccSkuPoList.stream().collect(Collectors.groupingBy(UccSkuPo::getCommodityId));
            List uccCommodityPos = this.uccCommodityMapper.queryByCommodityIdLists(uccSkuPoList.stream().map(UccSkuPo::getCommodityId).collect(Collectors.toList()));
            Set vendorIds = uccCommodityPos.stream().map(UccCommodityPo::getVendorId).collect(Collectors.toSet());
            Map<Long, List<UccCommodityPo>> collect = uccCommodityPos.stream().collect(Collectors.groupingBy(UccCommodityPo::getVendorId));
            for (Long vendorId : vendorIds) {
                List<UccCommodityPo> tempSpuList = collect.get(vendorId);
                ArrayList tempSkuList = new ArrayList();
                for (UccCommodityPo each : tempSpuList) {
                    tempSkuList.addAll(skuCollect.get(each.getCommodityId()));
                }
                UccSendISPBacklogAtomReqBO uccSendISPBacklogAtomReqBO = new UccSendISPBacklogAtomReqBO();
                uccSendISPBacklogAtomReqBO.setIspSource(Integer.valueOf(1));
                uccSendISPBacklogAtomReqBO.setVendorId(vendorId);
                uccSendISPBacklogAtomReqBO.setType(Integer.valueOf(1));
                StringBuilder skuIdListStr = new StringBuilder();
                for (int i = 0; i < tempSkuList.size(); ++i) {
                    if (i != tempSkuList.size() - 1) {
                        skuIdListStr.append(((UccSkuPo)tempSkuList.get(i)).getCommodityId()).append(",");
                        continue;
                    }
                    skuIdListStr.append(((UccSkuPo)tempSkuList.get(i)).getCommodityId());
                }
                if (((UccSkuPo)tempSkuList.get(0)).getSkuSource() == 2) continue;
                uccSendISPBacklogAtomReqBO.setTitle("\u5546\u54c1\u5ba1\u6838\u7ed3\u679c\uff08\u81ea\u6709\u4f9b\u5e94\u5546\uff09");
                uccSendISPBacklogAtomReqBO.setContent("\u3010\u6062\u590d\u4e0a\u67b6\u9a73\u56de\u3011\u60a8\u63d0\u4ea4\u7684\u5546\u54c1\u6062\u590d\u4e0a\u67b6\u5ba1\u6279\uff08" + tempSpuList.size() + "\u4e2a\uff09\u5df2\u88ab\u9a73\u56de\uff0c\u8bf7\u77e5\u6089");
                uccSendISPBacklogAtomReqBO.setTodoUrl(this.ISP_SINGLE_POINT_LOGIN_URL + "/idp/oauth2/authorize?client_id=cgsc&redirect_uri=" + this.UCC_MALL_LOGIN_URL + "/%23/loginNew?routerUrl=" + this.UCC_AGR_SPU_VENDOR_MANAGE_LIST_ROUTE + "%26exportSkuIds=%5B" + skuIdListStr + "%5D%26tabId=4%26type=2&response_type=code&state=123");
                this.uccSendISPBacklogAtomService.sendBIPBacklog(uccSendISPBacklogAtomReqBO);
            }
        }
        catch (Exception e) {
            log.error("\u7ad9\u5185\u6062\u590d\u4e0a\u67b6\u5ba1\u6279\u9a73\u56de\u65f6isp\u5f85\u529e\u53d1\u9001\u62a5\u9519:{}", (Object)e.getMessage());
        }
    }
}

