/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.ability.impl;

import com.alibaba.fastjson.JSONObject;
import com.tydic.commodity.base.constant.RspConstantEnums;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.busibase.busi.api.QueryDBDateBusiService;
import com.tydic.commodity.common.ability.api.DycUccMemWaitDoneDetailListQryAbilityService;
import com.tydic.commodity.common.ability.bo.DycUccMemWaitDoneDetailListQryAbilityReqBO;
import com.tydic.commodity.common.ability.bo.DycUccMemWaitDoneDetailListQryAbilityRspBO;
import com.tydic.commodity.common.ability.bo.DycUccWaitDoneDetailBO;
import com.tydic.commodity.common.ability.bo.UccMemWatiDoneRuleBO;
import com.tydic.commodity.common.busi.api.UccMsearchEsService;
import com.tydic.commodity.common.busi.bo.UccMsearchEsReqBO;
import com.tydic.commodity.common.busi.bo.UccMsearchEsRspBO;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.common.ability.api.DycUccMemWaitDoneDetailListQryAbilityService"})
public class DycUccMemWaitDoneDetailListQryAbilityServiceImpl
implements DycUccMemWaitDoneDetailListQryAbilityService {
    private static final Logger log = LoggerFactory.getLogger(DycUccMemWaitDoneDetailListQryAbilityServiceImpl.class);
    private static final Map<String, UccMemWatiDoneRuleBO> menuInfoMap = new HashMap<String, UccMemWatiDoneRuleBO>();
    @Autowired
    private UccMsearchEsService uccMsearchEsService;
    @Autowired
    private QueryDBDateBusiService queryDBDateBusiService;

    @PostMapping(value={"qryWaitDoneDetailList"})
    public DycUccMemWaitDoneDetailListQryAbilityRspBO qryWaitDoneDetailList(@RequestBody DycUccMemWaitDoneDetailListQryAbilityReqBO reqBO) {
        DycUccMemWaitDoneDetailListQryAbilityRspBO rspBO = new DycUccMemWaitDoneDetailListQryAbilityRspBO();
        if (reqBO == null || CollectionUtils.isEmpty((Collection)reqBO.getMenuCode())) {
            throw new BusinessException(RspConstantEnums.REQUIRED_NON_EMPTY.code(), RspConstantEnums.REQUIRED_NON_EMPTY.message());
        }
        if (reqBO.getOrgIdIn() == null) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
            return rspBO;
        }
        Date date = this.queryDBDateBusiService.getDBDate();
        TimeZone tz = TimeZone.getTimeZone("GMT");
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.setTimeZone(tz);
        Long today = calendar.getTimeInMillis();
        ArrayList<String> query = new ArrayList<String>();
        UccMsearchEsReqBO uccMsearchEsNormalReqBO = new UccMsearchEsReqBO();
        uccMsearchEsNormalReqBO.setTotal(true);
        uccMsearchEsNormalReqBO.setFrom(1);
        uccMsearchEsNormalReqBO.setSize(1);
        uccMsearchEsNormalReqBO.setQuery(query);
        ArrayList<String> msearch = new ArrayList<String>();
        for (String each : reqBO.getMenuCode()) {
            if (menuInfoMap.containsKey(each)) {
                msearch.add(each);
                BoolQueryBuilder extBoolQueryBuilder = QueryBuilders.boolQuery();
                extBoolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"sku_source", (Object)menuInfoMap.get(each).getSkuSource()));
                if (!CollectionUtils.isEmpty((Collection)menuInfoMap.get(each).getApprovalStatus())) {
                    if (menuInfoMap.get(each).getApprovalStatus() != null && menuInfoMap.get(each).getType() == 1) {
                        extBoolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"sku_approval_status", (Collection)menuInfoMap.get(each).getApprovalStatus()));
                    } else {
                        extBoolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"spu_approval_status", (Collection)menuInfoMap.get(each).getApprovalStatus()));
                    }
                }
                extBoolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"sku_status", (Collection)menuInfoMap.get(each).getSkuStaus()));
                extBoolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"vendor_id", (Object)reqBO.getOrgIdIn()));
                JSONObject queryJson = new JSONObject();
                JSONObject aggs = new JSONObject();
                JSONObject cardinality = new JSONObject();
                JSONObject field = new JSONObject();
                if (menuInfoMap.get(each).getType() == 0) {
                    field.put("field", (Object)"commodity_id");
                } else {
                    field.put("field", (Object)"sku_id");
                }
                cardinality.put("cardinality", (Object)field);
                aggs.put("cardinality_count", (Object)cardinality);
                queryJson.put("aggs", (Object)aggs);
                queryJson.put("query", (Object)JSONObject.parseObject((String)extBoolQueryBuilder.toString().replace("\\n", "").replace(" ", "")));
                queryJson.put("size", (Object)1);
                queryJson.put("from", (Object)1);
                query.add(queryJson.toString());
                continue;
            }
            throw new BusinessException(RspConstantEnums.MEM_WAIT_DONE_EXIST.code(), RspConstantEnums.MEM_WAIT_DONE_EXIST.message());
        }
        ArrayList<String> queryDay = new ArrayList<String>();
        UccMsearchEsReqBO uccMsearchEsDayReqBO = new UccMsearchEsReqBO();
        uccMsearchEsDayReqBO.setTotal(false);
        uccMsearchEsDayReqBO.setQuery(queryDay);
        for (String each : reqBO.getMenuCode()) {
            if (menuInfoMap.containsKey(each)) {
                BoolQueryBuilder extBoolQueryBuilder = QueryBuilders.boolQuery();
                extBoolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"sku_source", (Object)menuInfoMap.get(each).getSkuSource()));
                if (!CollectionUtils.isEmpty((Collection)menuInfoMap.get(each).getApprovalStatus())) {
                    if (menuInfoMap.get(each).getApprovalStatus() != null && menuInfoMap.get(each).getType() == 1) {
                        extBoolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"sku_approval_status", (Collection)menuInfoMap.get(each).getApprovalStatus()));
                    } else {
                        extBoolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"spu_approval_status", (Collection)menuInfoMap.get(each).getApprovalStatus()));
                    }
                }
                extBoolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"sku_status", (Collection)menuInfoMap.get(each).getSkuStaus()));
                extBoolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"vendor_id", (Object)reqBO.getOrgIdIn()));
                if ("2000".equals(each)) {
                    extBoolQueryBuilder.must((QueryBuilder)QueryBuilders.rangeQuery((String)"create_time").gte((Object)today));
                } else if ("2001".equals(each) || "2002".equals(each) || "2003".equals(each) || "2004".equals(each) || "2005".equals(each) || "2006".equals(each) || "2007".equals(each)) {
                    extBoolQueryBuilder.must((QueryBuilder)QueryBuilders.rangeQuery((String)"newest_commit_time").gte((Object)today));
                } else if ("2012".equals(each) || "2013".equals(each) || "2014".equals(each) || "2015".equals(each) || "2016".equals(each)) {
                    extBoolQueryBuilder.must((QueryBuilder)QueryBuilders.rangeQuery((String)"newestRejectTime").gte((Object)today));
                }
                JSONObject queryJson = new JSONObject();
                JSONObject aggs = new JSONObject();
                JSONObject cardinality = new JSONObject();
                JSONObject field = new JSONObject();
                if (menuInfoMap.get(each).getType() == 0) {
                    field.put("field", (Object)"commodity_id");
                } else {
                    field.put("field", (Object)"sku_id");
                }
                cardinality.put("cardinality", (Object)field);
                aggs.put("cardinality_count", (Object)cardinality);
                queryJson.put("aggs", (Object)aggs);
                queryJson.put("query", (Object)JSONObject.parseObject((String)extBoolQueryBuilder.toString().replace("\\n", "").replace(" ", "")));
                queryJson.put("size", (Object)1);
                queryJson.put("from", (Object)1);
                queryDay.add(queryJson.toString());
                continue;
            }
            throw new BusinessException(RspConstantEnums.MEM_WAIT_DONE_EXIST.code(), RspConstantEnums.MEM_WAIT_DONE_EXIST.message());
        }
        UccMsearchEsRspBO uccMsearchEsRspBONormal = this.uccMsearchEsService.mSearch(uccMsearchEsNormalReqBO);
        UccMsearchEsRspBO uccMsearchEsRspBODay = this.uccMsearchEsService.mSearch(uccMsearchEsDayReqBO);
        if (!"0000".equals(uccMsearchEsRspBONormal.getRespCode())) {
            BeanUtils.copyProperties((Object)((Object)uccMsearchEsRspBONormal), (Object)rspBO);
            return rspBO;
        }
        if (!"0000".equals(uccMsearchEsRspBODay.getRespCode())) {
            BeanUtils.copyProperties((Object)((Object)uccMsearchEsRspBONormal), (Object)rspBO);
            return rspBO;
        }
        if (CollectionUtils.isEmpty(uccMsearchEsRspBONormal.getRows()) && CollectionUtils.isEmpty(uccMsearchEsRspBODay.getRows())) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
            return rspBO;
        }
        Integer count = 0;
        Integer dayCout = 0;
        ArrayList<DycUccWaitDoneDetailBO> waitDoneDetailBOS = new ArrayList<DycUccWaitDoneDetailBO>();
        for (int i = 0; i < msearch.size(); ++i) {
            DycUccWaitDoneDetailBO uccWaitDoneDetailBO = new DycUccWaitDoneDetailBO();
            uccWaitDoneDetailBO.setMenuCode((String)msearch.get(i));
            if (!CollectionUtils.isEmpty(uccMsearchEsRspBONormal.getRows()) && uccMsearchEsRspBONormal.getRows().get(i) != null) {
                if (uccMsearchEsRspBONormal.getRows().get(i).getTotal() < 1) continue;
                count = count + uccMsearchEsRspBONormal.getRows().get(i).getTotal();
                uccWaitDoneDetailBO.setItemDetailTotal(uccMsearchEsRspBONormal.getRows().get(i).getTotal());
            }
            if (!CollectionUtils.isEmpty(uccMsearchEsRspBODay.getRows()) && uccMsearchEsRspBODay.getRows().get(i) != null) {
                dayCout = dayCout + uccMsearchEsRspBODay.getRows().get(i).getTotal();
                uccWaitDoneDetailBO.setTodayItemDetailTotal(uccMsearchEsRspBODay.getRows().get(i).getTotal());
            }
            uccWaitDoneDetailBO.setItemDetailName(menuInfoMap.get(msearch.get(i)).getMeunName());
            uccWaitDoneDetailBO.setUrl(menuInfoMap.get(msearch.get(i)).getMeunCode());
            waitDoneDetailBOS.add(uccWaitDoneDetailBO);
        }
        rspBO.setItemDetailTotal(count);
        rspBO.setTodayItemDetailTotal(dayCout);
        rspBO.setRows(waitDoneDetailBOS);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private static void initialize() {
        UccMemWatiDoneRuleBO eCommerce2000 = new UccMemWatiDoneRuleBO();
        eCommerce2000.setSkuStaus(new ArrayList<Integer>(Arrays.asList(1)));
        eCommerce2000.setApprovalStatus(null);
        eCommerce2000.setSkuSource(Integer.valueOf(2));
        eCommerce2000.setType(Integer.valueOf(1));
        eCommerce2000.setMeunCode("commodityManagementList?tabId=1");
        eCommerce2000.setMeunName("\u5f85\u7ef4\u62a4\u7269\u6599\u7f16\u7801\u5546\u54c1\uff08\u7535\u5546\uff09");
        menuInfoMap.put("2000", eCommerce2000);
        UccMemWatiDoneRuleBO eCommerce2001 = new UccMemWatiDoneRuleBO();
        eCommerce2001.setSkuStaus(new ArrayList<Integer>(Arrays.asList(2)));
        eCommerce2001.setApprovalStatus(new ArrayList<Integer>(Arrays.asList(24)));
        eCommerce2001.setSkuSource(Integer.valueOf(2));
        eCommerce2001.setType(Integer.valueOf(1));
        eCommerce2001.setMeunCode("ecCommodityAuditList?tabId=1");
        eCommerce2001.setMeunName("\u5f85\u63d0\u4ea4\u4e0a\u67b6\u5ba1\u6279\u5546\u54c1\uff08\u7535\u5546\uff09");
        menuInfoMap.put("2001", eCommerce2001);
        UccMemWatiDoneRuleBO eCommerce2002 = new UccMemWatiDoneRuleBO();
        eCommerce2002.setSkuStaus(new ArrayList<Integer>(Arrays.asList(8)));
        eCommerce2002.setApprovalStatus(new ArrayList<Integer>(Arrays.asList(44)));
        eCommerce2002.setSkuSource(Integer.valueOf(2));
        eCommerce2002.setType(Integer.valueOf(1));
        eCommerce2002.setMeunCode("ecCommodityAuditList?tabId=2");
        eCommerce2002.setMeunName("\u5f85\u63d0\u4ea4\u4e0b\u67b6\u5ba1\u6279\u5546\u54c1\uff08\u7535\u5546\uff09");
        menuInfoMap.put("2002", eCommerce2002);
        UccMemWatiDoneRuleBO eCommerce2003 = new UccMemWatiDoneRuleBO();
        eCommerce2003.setSkuStaus(new ArrayList<Integer>(Arrays.asList(10, 5)));
        eCommerce2003.setApprovalStatus(new ArrayList<Integer>(Arrays.asList(54)));
        eCommerce2003.setSkuSource(Integer.valueOf(2));
        eCommerce2003.setType(Integer.valueOf(1));
        eCommerce2003.setMeunCode("ecCommodityAuditList?tabId=3");
        eCommerce2003.setMeunName("\u5f85\u63d0\u4ea4\u6062\u590d\u4e0a\u67b6\u5ba1\u6279\u5546\u54c1\uff08\u7535\u5546\uff09");
        menuInfoMap.put("2003", eCommerce2003);
        UccMemWatiDoneRuleBO agr2004 = new UccMemWatiDoneRuleBO();
        agr2004.setSkuStaus(new ArrayList<Integer>(Arrays.asList(3)));
        agr2004.setApprovalStatus(new ArrayList<Integer>(Arrays.asList(34)));
        agr2004.setSkuSource(Integer.valueOf(3));
        agr2004.setType(Integer.valueOf(1));
        agr2004.setMeunCode("agrCommodityAuditList?tabId=2");
        agr2004.setMeunName("\u5f85\u63d0\u4ea4\u4e0a\u67b6\uff0c\u7f16\u8f91\u5ba1\u6279\u5546\u54c1\uff08\u81ea\u6709\u4f9b\u5e94\u5546\uff09");
        menuInfoMap.put("2004", agr2004);
        UccMemWatiDoneRuleBO agr2005 = new UccMemWatiDoneRuleBO();
        agr2005.setSkuStaus(new ArrayList<Integer>(Arrays.asList(0)));
        agr2005.setApprovalStatus(new ArrayList<Integer>(Arrays.asList(24)));
        agr2005.setSkuSource(Integer.valueOf(3));
        agr2005.setType(Integer.valueOf(0));
        agr2005.setMeunCode("agrCommodityAuditList?tabId=1");
        agr2005.setMeunName("\u5f85\u63d0\u4ea4\u4e0a\u67b6\u5ba1\u6279\u5546\u54c1\uff08\u81ea\u6709\u4f9b\u5e94\u5546\uff09");
        menuInfoMap.put("2005", agr2005);
        UccMemWatiDoneRuleBO agr2006 = new UccMemWatiDoneRuleBO();
        agr2006.setSkuStaus(new ArrayList<Integer>(Arrays.asList(8, 9)));
        agr2006.setApprovalStatus(new ArrayList<Integer>(Arrays.asList(44)));
        agr2006.setSkuSource(Integer.valueOf(3));
        agr2006.setType(Integer.valueOf(1));
        agr2006.setMeunCode("agrCommodityAuditList?tabId=2");
        agr2006.setMeunName("\u5f85\u63d0\u4ea4\u4e0b\u67b6\u5ba1\u6279\u5546\u54c1\uff08\u81ea\u6709\u4f9b\u5e94\u5546\uff09");
        menuInfoMap.put("2006", agr2006);
        UccMemWatiDoneRuleBO agr2007 = new UccMemWatiDoneRuleBO();
        agr2007.setSkuStaus(new ArrayList<Integer>(Arrays.asList(10, 5)));
        agr2007.setApprovalStatus(new ArrayList<Integer>(Arrays.asList(55)));
        agr2007.setSkuSource(Integer.valueOf(3));
        agr2007.setType(Integer.valueOf(1));
        agr2007.setMeunCode("agrCommodityAuditList?tabId=3");
        agr2007.setMeunName("\u5f85\u63d0\u4ea4\u6062\u590d\u4e0a\u67b6\u5ba1\u6279\u5546\u54c1\uff08\u81ea\u6709\u4f9b\u5e94\u5546\uff09");
        menuInfoMap.put("2007", agr2007);
        UccMemWatiDoneRuleBO eCommerce2012 = new UccMemWatiDoneRuleBO();
        eCommerce2012.setSkuStaus(new ArrayList<Integer>(Arrays.asList(2)));
        eCommerce2012.setApprovalStatus(new ArrayList<Integer>(Arrays.asList(23)));
        eCommerce2012.setSkuSource(Integer.valueOf(2));
        eCommerce2012.setType(Integer.valueOf(1));
        eCommerce2012.setMeunCode("commodityManagementList?tabId=1");
        eCommerce2012.setMeunName("\u5546\u54c1\u5ba1\u6838\u7ed3\u679c\uff08\u7535\u5546\uff09");
        menuInfoMap.put("2012", eCommerce2012);
        UccMemWatiDoneRuleBO agr2013 = new UccMemWatiDoneRuleBO();
        agr2013.setSkuStaus(new ArrayList<Integer>(Arrays.asList(0)));
        agr2013.setApprovalStatus(new ArrayList<Integer>(Arrays.asList(23)));
        agr2013.setSkuSource(Integer.valueOf(3));
        agr2013.setType(Integer.valueOf(0));
        agr2013.setMeunCode("agrCommodityList?tabId=1");
        agr2013.setMeunName("\u5546\u54c1\u5ba1\u6838\u7ed3\u679c\uff08\u81ea\u6709\u4f9b\u5e94\u5546\uff09");
        menuInfoMap.put("2013", agr2013);
        UccMemWatiDoneRuleBO agr2014 = new UccMemWatiDoneRuleBO();
        agr2014.setSkuStaus(new ArrayList<Integer>(Arrays.asList(3)));
        agr2014.setApprovalStatus(new ArrayList<Integer>(Arrays.asList(43)));
        agr2014.setSkuSource(Integer.valueOf(3));
        agr2014.setType(Integer.valueOf(1));
        agr2014.setMeunCode("agrCommodityList?tabId=3");
        agr2014.setMeunName("\u5546\u54c1\u5ba1\u6838\u7ed3\u679c\uff08\u81ea\u6709\u4f9b\u5e94\u5546\uff09");
        menuInfoMap.put("2014", agr2014);
        UccMemWatiDoneRuleBO agr2015 = new UccMemWatiDoneRuleBO();
        agr2015.setSkuStaus(new ArrayList<Integer>(Arrays.asList(3)));
        agr2015.setApprovalStatus(new ArrayList<Integer>(Arrays.asList(33)));
        agr2015.setSkuSource(Integer.valueOf(3));
        agr2015.setType(Integer.valueOf(0));
        agr2015.setMeunCode("agrCommodityList?tabId=6");
        agr2015.setMeunName("\u5546\u54c1\u5ba1\u6838\u7ed3\u679c\uff08\u81ea\u6709\u4f9b\u5e94\u5546\uff09");
        menuInfoMap.put("2015", agr2015);
        UccMemWatiDoneRuleBO agr2016 = new UccMemWatiDoneRuleBO();
        agr2016.setSkuStaus(new ArrayList<Integer>(Arrays.asList(5)));
        agr2016.setApprovalStatus(new ArrayList<Integer>(Arrays.asList(53)));
        agr2016.setSkuSource(Integer.valueOf(3));
        agr2016.setType(Integer.valueOf(1));
        agr2016.setMeunCode("agrCommodityList?tabId=4");
        agr2016.setMeunName("\u5546\u54c1\u5ba1\u6838\u7ed3\u679c\uff08\u81ea\u6709\u4f9b\u5e94\u5546\uff09");
        menuInfoMap.put("2016", agr2016);
    }

    static {
        DycUccMemWaitDoneDetailListQryAbilityServiceImpl.initialize();
    }
}

