/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.commodity.base.bo.SyncSceneCommodityToEsReqBO;
import com.tydic.commodity.base.constant.ModelRuleConstant;
import com.tydic.commodity.common.ability.api.UccApproveRejectAbilityService;
import com.tydic.commodity.common.ability.bo.UccApproveRejectAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccApproveRejectAbilityRspBO;
import com.tydic.commodity.common.busi.api.UccApproveRejectBusiService;
import com.tydic.commodity.common.busi.bo.UccApproveRejectBusiReqBO;
import com.tydic.commodity.common.busi.bo.UccApproveRejectBusiRspBO;
import com.tydic.commodity.dao.UccCommodityMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.po.UccCommodityPo;
import com.tydic.commodity.po.UccSkuPo;
import com.tydic.commodity.utils.PropertiesUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.common.ability.api.UccApproveRejectAbilityService"})
public class UccApproveRejectAbilityServiceImpl
implements UccApproveRejectAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccApproveRejectAbilityServiceImpl.class);
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private UccCommodityMapper uccCommodityMapper;
    @Autowired
    private UccApproveRejectBusiService uccApproveRejectBusiService;
    @Resource(name="lmSyncCommodityMqServiceProvider")
    private ProxyMessageProducer lmSyncCommodityMqServiceProvider;

    @PostMapping(value={"ApproveReject"})
    public UccApproveRejectAbilityRspBO ApproveReject(@RequestBody UccApproveRejectAbilityReqBO reqBO) {
        UccApproveRejectAbilityRspBO rspBO = new UccApproveRejectAbilityRspBO();
        if (CollectionUtils.isEmpty((Collection)reqBO.getSourceIds())) {
            rspBO.setRespCode("0001");
            rspBO.setRespDesc("sourceIds\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBO;
        }
        if (reqBO.getSourceType() == null) {
            rspBO.setRespCode("0001");
            rspBO.setRespDesc("sourceType\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBO;
        }
        if (StringUtils.isEmpty((Object)reqBO.getAdvice())) {
            rspBO.setRespCode("0001");
            rspBO.setRespDesc("\u5ba1\u6279\u610f\u89c1\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBO;
        }
        UccApproveRejectBusiReqBO busiReqBO = new UccApproveRejectBusiReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)((Object)busiReqBO));
        UccApproveRejectBusiRspBO busiRspBO = this.uccApproveRejectBusiService.ApproveReject(busiReqBO);
        BeanUtils.copyProperties((Object)((Object)busiRspBO), (Object)rspBO);
        List<UccCommodityPo> uccCommodityPos = new ArrayList();
        if (reqBO.getSourceType() == 1) {
            uccCommodityPos = this.uccCommodityMapper.qeryBatchCommdity(reqBO.getSourceIds());
        } else {
            List uccSkuPoList = this.uccSkuMapper.batchQrySku(reqBO.getSourceIds(), null);
            HashSet<Long> commodityIds = new HashSet<Long>();
            for (UccSkuPo each : uccSkuPoList) {
                if (commodityIds.contains(each.getCommodityId())) continue;
                UccCommodityPo uccCommodityPo = new UccCommodityPo();
                BeanUtils.copyProperties((Object)each, (Object)uccCommodityPo);
                uccCommodityPos.add(uccCommodityPo);
                commodityIds.add(each.getCommodityId());
            }
        }
        if (!CollectionUtils.isEmpty(uccCommodityPos)) {
            Map<Long, List<UccCommodityPo>> collect = uccCommodityPos.stream().collect(Collectors.groupingBy(UccCommodityPo::getSupplierShopId));
            for (Long next : collect.keySet()) {
                List commodityIds = collect.get(next).stream().map(UccCommodityPo::getCommodityId).collect(Collectors.toList());
                SyncSceneCommodityToEsReqBO syncSceneCommodityToEsReqBO = new SyncSceneCommodityToEsReqBO();
                syncSceneCommodityToEsReqBO.setCommodityIds(commodityIds);
                syncSceneCommodityToEsReqBO.setSupplierId(next);
                syncSceneCommodityToEsReqBO.setOperType(ModelRuleConstant.SYNC_ES_SINGLETYPE_ALL);
                syncSceneCommodityToEsReqBO.setSyncType(ModelRuleConstant.SYNC_ES_BY_COMMODITY_ID);
                syncSceneCommodityToEsReqBO.setSingleType(ModelRuleConstant.SYNC_ES_SINGLETYPE_ALL.intValue());
                try {
                    this.lmSyncCommodityMqServiceProvider.send(new ProxyMessage(PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TOPIC"), PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TAG"), JSON.toJSONString((Object)syncSceneCommodityToEsReqBO)));
                }
                catch (Exception e) {
                    log.error("\u540c\u6b65ES MQ\u53d1\u9001\u4fe1\u606f\u5931\u8d25:" + e.getMessage());
                }
            }
        }
        return rspBO;
    }
}

