/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.ability.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.commodity.busibase.atom.api.UccBaseDictionaryAtomService;
import com.tydic.commodity.common.ability.api.UccPriceComparisonListQryAbilityService;
import com.tydic.commodity.common.ability.bo.UccPriceComparisonListBo;
import com.tydic.commodity.common.ability.bo.UccPriceComparisonListQryReqBo;
import com.tydic.commodity.common.ability.bo.UccPriceComparisonListQryRspBo;
import com.tydic.commodity.dao.UccApproveLogMapper;
import com.tydic.commodity.dao.UccComparePriceListMapper;
import com.tydic.commodity.po.UccPriceComparisonListPo;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.common.ability.api.UccPriceComparisonListQryAbilityService"})
public class UccPriceComparisonListQryAbilityServiceImpl
implements UccPriceComparisonListQryAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccPriceComparisonListQryAbilityServiceImpl.class);
    @Autowired
    private UccApproveLogMapper uccApproveLogMapper;
    @Autowired
    private UccComparePriceListMapper uccComparePriceListMapper;
    @Autowired
    private UccBaseDictionaryAtomService uccBaseDictionaryAtomService;

    @PostMapping(value={"priceComparisonListQry"})
    public UccPriceComparisonListQryRspBo priceComparisonListQry(@RequestBody UccPriceComparisonListQryReqBo reqBo) {
        UccPriceComparisonListQryRspBo rspBo = new UccPriceComparisonListQryRspBo();
        if (reqBo.getId() == null) {
            rspBo.setRespCode("0001");
            rspBo.setRespDesc("\u5165\u53c2\u5b57\u6bb5id\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBo;
        }
        Long id = reqBo.getId();
        Page page = new Page(reqBo.getPageNo(), reqBo.getPageSize());
        List priceListPage = new ArrayList();
        try {
            priceListPage = this.uccComparePriceListMapper.getPriceListPage(id, page);
        }
        catch (Exception e) {
            rspBo.setRespCode("0002");
            rspBo.setRespDesc("\u7cfb\u7edf\u9519\u8bef:" + e.getMessage());
            log.error("\u7cfb\u7edf\u9519\u8bef:" + e.getMessage());
            return rspBo;
        }
        if (CollectionUtils.isEmpty(priceListPage)) {
            rspBo.setRespCode("0003");
            rspBo.setRespDesc("\u6bd4\u4ef7\u5355\u8bb0\u5f55\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a");
            log.error("\u6bd4\u4ef7\u5355\u8bb0\u5f55\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a");
            return rspBo;
        }
        ArrayList<UccPriceComparisonListBo> rows = new ArrayList<UccPriceComparisonListBo>();
        Map skuSourceAssortDesc = this.uccBaseDictionaryAtomService.queryBypCodeBackMap("SKU_SOURCE_ASSORT_DESC");
        Map agrPriceSkuApprovalStatus = this.uccBaseDictionaryAtomService.queryBypCodeBackMap("AGR_PRICE_SKU_APPROVAL_STATUS");
        Map skuApprovalMap = this.uccBaseDictionaryAtomService.queryBypCodeBackMap("SKU_APPROVAL_STATUS");
        Map skuStatus = this.uccBaseDictionaryAtomService.queryBypCodeBackMap("SKU_STATUS");
        for (UccPriceComparisonListPo each : priceListPage) {
            UccPriceComparisonListBo temp = new UccPriceComparisonListBo();
            BeanUtils.copyProperties((Object)each, (Object)temp);
            if (skuSourceAssortDesc.containsKey(String.valueOf(each.getSourceType()))) {
                temp.setSourceTypeDesc((String)skuSourceAssortDesc.get(String.valueOf(each.getSourceType())));
            } else if (skuApprovalMap.containsKey(String.valueOf(each.getSourceType()))) {
                temp.setSourceTypeDesc((String)skuSourceAssortDesc.get(String.valueOf(each.getSourceType())));
            }
            if (agrPriceSkuApprovalStatus.containsKey(each.getApprovalStatus())) {
                temp.setApprovalStatusDesc((String)agrPriceSkuApprovalStatus.get(each.getApprovalStatus()));
            }
            if (skuStatus.containsKey(String.valueOf(each.getSkuStatus()))) {
                temp.setSkuStatusDesc((String)skuStatus.get(String.valueOf(each.getSkuStatus())));
            }
            rows.add(temp);
        }
        rspBo.setRows(rows);
        rspBo.setPageNo(page.getPageNo());
        rspBo.setTotal(page.getTotalPages());
        rspBo.setRecordsTotal(page.getTotalCount());
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }
}

